/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.test.mock;

import javax.servlet.ServletInputStream;
import org.springframework.mock.web.MockHttpServletRequest;

public class MockHttpServletRequestWrapper
extends MockHttpServletRequest {
    private ServletInputStream inputStream = null;

    public ServletInputStream getInputStream() {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        this.inputStream = super.getInputStream();
        return this.inputStream;
    }

    public void setContentType(String contentType) {
        if (this.getCharacterEncoding() != null && !contentType.contains("charset=")) {
            contentType = contentType + ";charset=" + this.getCharacterEncoding();
        }
        this.addHeader("Content-Type", contentType);
    }

    public void setContent(byte[] content) {
        super.setContent(content);
        if (content != null) {
            this.addHeader("Content-Length", String.valueOf(content.length));
        }
    }
}

