/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.servlet;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.ws.rs.core.Application;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MockServletInvocationTest
extends TestCase {
    private static ThreadLocal<MockServletInvocationTest> tls = new ThreadLocal();
    private HttpServlet servlet;

    protected String getApplicationClassName() {
        return MockApplication.class.getName();
    }

    protected void setUp() throws Exception {
        String deploymentConfigClass;
        super.setUp();
        this.servlet = (HttpServlet)Class.forName("org.apache.wink.server.internal.servlet.RestServlet").newInstance();
        MockServletConfig servletConfig = new MockServletConfig();
        servletConfig.addInitParameter("javax.ws.rs.Application", this.getApplicationClassName());
        String propertiesFile = this.getPropertiesFile();
        if (propertiesFile != null) {
            servletConfig.addInitParameter("propertiesLocation", propertiesFile);
        }
        if ((deploymentConfigClass = this.getDeploymentConfigurationClassName()) != null) {
            servletConfig.addInitParameter("deploymentConfiguration", deploymentConfigClass);
        }
        tls.set(this);
        this.servlet.init((ServletConfig)servletConfig);
    }

    protected String getDeploymentConfigurationClassName() {
        return null;
    }

    protected String getPropertiesFile() {
        return null;
    }

    protected Class<?>[] getClasses() {
        return new Class[0];
    }

    protected Object[] getSingletons() {
        return new Object[0];
    }

    public MockHttpServletResponse invoke(MockHttpServletRequest request) throws ServletException, IOException {
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.servlet.service((ServletRequest)request, (ServletResponse)response);
        return response;
    }

    public HttpServlet getServlet() {
        return this.servlet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MockApplication
    extends Application {
        public Set<Class<?>> getClasses() {
            LinkedHashSet set = new LinkedHashSet();
            for (Class<?> cls : ((MockServletInvocationTest)((Object)tls.get())).getClasses()) {
                set.add(cls);
            }
            return set;
        }

        public Set<Object> getSingletons() {
            LinkedHashSet<Object> set = new LinkedHashSet<Object>();
            for (Object o : ((MockServletInvocationTest)((Object)tls.get())).getSingletons()) {
                set.add(o);
            }
            return set;
        }
    }
}

