/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.provider;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.context.MessageContext;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBindingFactory;
import org.apache.tuscany.sca.binding.ws.axis2.context.WSAxis2BindingContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.assembly.RuntimeAssemblyFactory;
import org.apache.tuscany.sca.core.invocation.AsyncResponseInvoker;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class TuscanyServiceProvider {
    private static final Logger logger = Logger.getLogger(TuscanyServiceProvider.class.getName());
    public static final QName QNAME_WSA_ADDRESS = new QName("http://www.w3.org/2005/08/addressing", "Address");
    public static final QName QNAME_WSA_FROM = new QName("http://www.w3.org/2005/08/addressing", "From");
    public static final QName QNAME_WSA_REPLYTO = new QName("http://www.w3.org/2005/08/addressing", "ReplyTo");
    public static final QName QNAME_WSA_REFERENCE_PARAMETERS = new QName("http://www.w3.org/2005/08/addressing", "ReferenceParameters");
    public static final QName QNAME_WSA_MESSAGEID = new QName("http://www.w3.org/2005/08/addressing", "MessageID");
    public static final QName QNAME_WSA_RELATESTO = new QName("http://www.w3.org/2005/08/addressing", "RelatesTo", "wsa");
    private RuntimeEndpoint endpoint;
    private WebServiceBinding wsBinding;
    private MessageFactory messageFactory;
    private FactoryExtensionPoint modelFactories;
    private RuntimeAssemblyFactory assemblyFactory;
    private WebServiceBindingFactory webServiceBindingFactory;
    private Operation operation;
    private static String WS_ADDR_ANONYMOUS = "http://www.w3.org/2005/08/addressing/anonymous";
    private static String WS_ADDR_NONE = "http://www.w3.org/2005/08/addressing/none";
    private static String WS_REF_PARMS = "WS_REFERENCE_PARAMETERS";

    public TuscanyServiceProvider(ExtensionPointRegistry extensionPoints, RuntimeEndpoint endpoint, WebServiceBinding wsBinding, Operation operation) {
        this.endpoint = endpoint;
        this.wsBinding = wsBinding;
        this.operation = operation;
        this.modelFactories = (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.messageFactory = (MessageFactory)this.modelFactories.getFactory(MessageFactory.class);
        this.assemblyFactory = (RuntimeAssemblyFactory)this.modelFactories.getFactory(AssemblyFactory.class);
        this.webServiceBindingFactory = (WebServiceBindingFactory)this.modelFactories.getFactory(WebServiceBindingFactory.class);
    }

    private void checkCallbackAddress(String callbackAddress, MessageContext inMC) throws AxisFault {
        if (WS_ADDR_ANONYMOUS.equals(callbackAddress) || WS_ADDR_NONE.equals(callbackAddress)) {
            AddressingFaultsHelper.triggerOnlyNonAnonymousAddressSupportedFault((MessageContext)inMC, (String)"wsa:From");
        }
    }

    public OMElement invoke(OMElement requestOM, MessageContext inMC, MessageContext outMC) throws InvocationTargetException, AxisFault {
        String callbackAddress = null;
        Message msg = this.messageFactory.createMessage();
        msg.setOperation(this.operation);
        WSAxis2BindingContext bindingContext = new WSAxis2BindingContext();
        bindingContext.setAxisInMessageContext(inMC);
        bindingContext.setAxisOutMessageContext(outMC);
        msg.setBindingContext((Object)bindingContext);
        if (this.wsBinding.isRpcLiteral()) {
            Iterator iter = requestOM.getChildElements();
            ArrayList<OMNode> list = new ArrayList<OMNode>();
            while (iter.hasNext()) {
                OMNode node = (OMNode)iter.next();
                list.add(node);
            }
            Object[] args = list.toArray();
            msg.setBody((Object)args);
        } else {
            if (this.wsBinding.isRpcEncoded()) {
                throw new ServiceRuntimeException("rpc/encoded WSDL style not supported for endpoint " + this.endpoint);
            }
            if (this.wsBinding.isDocEncoded()) {
                throw new ServiceRuntimeException("doc/encoded WSDL style not supported for endpoint " + this.endpoint);
            }
            if (this.wsBinding.isDocLiteralWrapped() || this.wsBinding.isDocLiteralUnwrapped()) {
                Object[] args = new Object[]{requestOM};
                msg.setBody((Object)args);
            } else {
                throw new ServiceRuntimeException("Unrecognized WSDL style for endpoint " + this.endpoint);
            }
        }
        SOAPHeader header = inMC.getEnvelope().getHeader();
        if (header != null) {
            callbackAddress = this.handleCallbackAddress(header, msg);
            this.handleMessageIDHeader(header, msg);
            this.handleRelatesToHeader(header, msg);
        }
        this.createCallbackEPR(callbackAddress, inMC, msg);
        this.setupAsyncResponse(msg, callbackAddress);
        Message response = this.endpoint.invoke(msg);
        if (response.isFault()) {
            throw new InvocationTargetException((Throwable)response.getBody());
        }
        return null;
    }

    private void setupAsyncResponse(Message msg, String callbackAddress) {
        if (!this.endpoint.isAsyncInvocation()) {
            return;
        }
        this.endpoint.createAsyncServerCallback();
        RuntimeEndpointReference asyncCallback = this.endpoint.getAsyncServerCallback();
        AsyncResponseInvoker respInvoker = new AsyncResponseInvoker(this.endpoint, asyncCallback, (Object)callbackAddress, (String)msg.getHeaders().get("MESSAGE_ID"), msg.getOperation().getName(), this.messageFactory);
        msg.getHeaders().put("ASYNC_RESPONSE_INVOKER", respInvoker);
    }

    private void createCallbackEPR(String callbackAddress, MessageContext inMC, Message msg) throws AxisFault {
        if (callbackAddress != null) {
            this.checkCallbackAddress(callbackAddress, inMC);
            EndpointReference from = this.assemblyFactory.createEndpointReference();
            Endpoint fromEndpoint = this.assemblyFactory.createEndpoint();
            from.setTargetEndpoint(fromEndpoint);
            from.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED);
            msg.setFrom(from);
            RuntimeEndpoint callbackEndpoint = (RuntimeEndpoint)this.assemblyFactory.createEndpoint();
            WebServiceBinding cbBinding = this.webServiceBindingFactory.createWebServiceBinding();
            cbBinding.setURI(callbackAddress);
            callbackEndpoint.setBinding((Binding)cbBinding);
            callbackEndpoint.setURI(callbackAddress);
            callbackEndpoint.setUnresolved(true);
            from.setCallbackEndpoint((Endpoint)callbackEndpoint);
        }
    }

    private String handleCallbackAddress(SOAPHeader header, Message msg) {
        OMElement callbackAddrElement;
        String callbackAddress = null;
        OMElement from = header.getFirstChildWithName(QNAME_WSA_FROM);
        if (from == null) {
            from = header.getFirstChildWithName(QNAME_WSA_REPLYTO);
        }
        if (from != null && (callbackAddrElement = from.getFirstChildWithName(QNAME_WSA_ADDRESS)) != null) {
            callbackAddress = callbackAddrElement.getText();
            OMElement refParms = from.getFirstChildWithName(QNAME_WSA_REFERENCE_PARAMETERS);
            if (refParms != null) {
                msg.getHeaders().put(WS_REF_PARMS, refParms);
            }
        }
        return callbackAddress;
    }

    private void handleMessageIDHeader(SOAPHeader header, Message msg) {
        if (header == null) {
            return;
        }
        OMElement messageID = header.getFirstChildWithName(QNAME_WSA_MESSAGEID);
        if (messageID != null) {
            String idValue = messageID.getText();
            msg.getHeaders().put("MESSAGE_ID", idValue);
        }
    }

    private void handleRelatesToHeader(SOAPHeader header, Message msg) {
        if (header == null) {
            return;
        }
        OMElement messageID = header.getFirstChildWithName(QNAME_WSA_RELATESTO);
        if (messageID != null) {
            String idValue = messageID.getText();
            msg.getHeaders().put("RELATES_TO", idValue);
        }
    }
}

