/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded.junit;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.testing.Application;
import org.apache.openejb.testing.ContainerProperties;
import org.apache.openejb.testing.RandomPort;
import org.apache.openejb.testing.WebResource;
import org.apache.openejb.util.Classes;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.Container;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.archive.FileArchive;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

@Vetoed
public class TomEEEmbeddedSingleRunner
extends BlockJUnit4ClassRunner {
    private static volatile boolean started = false;
    private static final AtomicReference<Object> APP = new AtomicReference();
    private static final AtomicReference<Thread> HOOK = new AtomicReference();

    public static void setApp(Object o) {
        APP.set(o);
    }

    public static void close() {
        Thread hook = HOOK.get();
        if (hook != null) {
            hook.run();
            Runtime.getRuntime().removeShutdownHook(hook);
            HOOK.compareAndSet(hook, null);
            APP.set(null);
        }
    }

    public TomEEEmbeddedSingleRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected List<MethodRule> rules(Object test) {
        List rules = super.rules(test);
        rules.add(new MethodRule(){

            public Statement apply(final Statement base, FrameworkMethod method, final Object target) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        TomEEEmbeddedSingleRunner.start(TomEEEmbeddedSingleRunner.this.getTestClass().getJavaClass());
                        TomEEEmbeddedSingleRunner.composerInject(target);
                        base.evaluate();
                    }
                };
            }
        });
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void start(Class<?> marker) throws Exception {
        if (APP.get() == null) {
            Class type;
            String typeStr = System.getProperty("tomee.application-composer.application");
            if (typeStr != null) {
                try {
                    type = Thread.currentThread().getContextClassLoader().loadClass(typeStr);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            } else {
                if (marker == null) {
                    throw new IllegalArgumentException("set tomee.application-composer.application system property or add a marker to the rule or runner");
                }
                Iterator descriptors = new AnnotationFinder((Archive)new FileArchive(Thread.currentThread().getContextClassLoader(), JarLocation.jarLocation(marker)), false).findAnnotatedClasses(Application.class).iterator();
                if (!descriptors.hasNext()) {
                    throw new IllegalArgumentException("No descriptor class using @Application");
                }
                type = (Class)descriptors.next();
                if (descriptors.hasNext()) {
                    throw new IllegalArgumentException("Ambiguous @Application: " + type + ", " + descriptors.next());
                }
            }
            try {
                APP.compareAndSet(null, type.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        }
        if (started) return;
        Class<TomEEEmbeddedSingleRunner> clazz = TomEEEmbeddedSingleRunner.class;
        synchronized (TomEEEmbeddedSingleRunner.class) {
            org.apache.openejb.testing.Classes classes;
            started = true;
            Class<?> appClass = APP.get().getClass();
            AnnotationFinder finder = new AnnotationFinder((Archive)new ClassesArchive((Iterable)Classes.ancestors(appClass)));
            Configuration configuration = new Configuration();
            ContainerProperties props = appClass.getAnnotation(ContainerProperties.class);
            if (props != null) {
                for (ContainerProperties.Property p : props.value()) {
                    configuration.property(p.name(), p.value());
                }
            }
            Object openejb = null;
            List annotatedMethods = finder.findAnnotatedMethods(org.apache.openejb.testing.Configuration.class);
            if (annotatedMethods.size() > 1) {
                throw new IllegalArgumentException("Only one @Configuration is supported: " + annotatedMethods);
            }
            for (Method m : annotatedMethods) {
                Object o = m.invoke(APP.get(), new Object[0]);
                if (!Properties.class.isInstance(o)) throw new IllegalArgumentException("Unsupported " + o + " for @Configuration");
                Properties properties = (Properties)Properties.class.cast(o);
                if (configuration.getProperties() == null) {
                    configuration.setProperties(new Properties());
                }
                configuration.getProperties().putAll((Map<?, ?>)properties);
            }
            final ArrayList<Closeable> postTasks = new ArrayList<Closeable>();
            LifecycleTasks tasks = appClass.getAnnotation(LifecycleTasks.class);
            if (tasks != null) {
                for (Class<? extends LifecycleTask> type : tasks.value()) {
                    postTasks.add(type.newInstance().beforeContainerStartup());
                }
            }
            HashMap<String, Field> ports = new HashMap<String, Field>();
            for (Class<?> type = appClass; type != null && type != Object.class; type = type.getSuperclass()) {
                for (Field f : type.getDeclaredFields()) {
                    String value;
                    RandomPort annotation = f.getAnnotation(RandomPort.class);
                    String string = value = annotation == null ? null : annotation.value();
                    if (value == null || !value.startsWith("http")) continue;
                    f.setAccessible(true);
                    ports.put(value, f);
                }
            }
            if (ports.containsKey("http")) {
                configuration.randomHttpPort();
            }
            String context = (classes = appClass.getAnnotation(org.apache.openejb.testing.Classes.class)) != null ? classes.context() : "";
            context = !context.isEmpty() && context.startsWith("/") ? context.substring(1) : context;
            WebResource resources = appClass.getAnnotation(WebResource.class);
            if (resources != null && resources.value().length > 1) {
                throw new IllegalArgumentException("Only one docBase is supported for now using @WebResource");
            }
            String webResource = null;
            if (resources != null && resources.value().length > 0) {
                webResource = resources.value()[0];
            } else {
                File webapp = new File("src/main/webapp");
                if (webapp.isFile()) {
                    webResource = "src/main/webapp";
                }
            }
            final Container container = new Container(configuration).deployClasspathAsWebApp(context, webResource != null ? new File(webResource) : null, new String[0]);
            block20: for (Map.Entry f : ports.entrySet()) {
                switch ((String)f.getKey()) {
                    case "http": {
                        TomEEEmbeddedSingleRunner.setPortField((String)f.getKey(), (Field)f.getValue(), configuration, context, APP.get());
                        continue block20;
                    }
                    case "https": {
                        continue block20;
                    }
                }
                throw new IllegalArgumentException("port " + (String)f.getKey() + " not yet supported");
            }
            TomEEEmbeddedSingleRunner.composerInject(APP.get());
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        if (container != null) {
                            container.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    for (Closeable c : postTasks) {
                        try {
                            c.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    postTasks.clear();
                    APP.set(null);
                    try {
                        Runtime.getRuntime().removeShutdownHook(this);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    private static void setPortField(String key, Field value, Configuration configuration, String ctx, Object instance) {
        int port;
        int n = port = "http".equals(key) ? configuration.getHttpPort() : configuration.getHttpsPort();
        if (value.getType() == URL.class) {
            try {
                value.set(instance, new URL(key + "://localhost:" + port + "/" + ctx));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        } else if (value.getType() == Integer.TYPE) {
            try {
                value.set(instance, port);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            throw new IllegalArgumentException("Unsupported " + key);
        }
    }

    private static void composerInject(Object target) throws IllegalAccessException {
        OWBInjector.inject((BeanManager)WebBeansContext.currentInstance().getBeanManagerImpl(), (Object)target, null);
        Object app = APP.get();
        Class<?> aClass = target.getClass();
        block0: for (Field f : aClass.getDeclaredFields()) {
            RandomPort randomPort = f.getAnnotation(RandomPort.class);
            if (randomPort != null) {
                for (Field field : app.getClass().getDeclaredFields()) {
                    RandomPort appPort = field.getAnnotation(RandomPort.class);
                    if (field.getType() != f.getType() || appPort == null || !appPort.value().equals(randomPort.value())) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    Object value = field.get(app);
                    f.set(target, value);
                    continue block0;
                }
                continue;
            }
            if (!f.isAnnotationPresent(Application.class)) continue;
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            f.set(target, app);
        }
        Class<?> superclass = aClass.getSuperclass();
        if (superclass != Object.class) {
            TomEEEmbeddedSingleRunner.composerInject(superclass);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface LifecycleTasks {
        public Class<? extends LifecycleTask>[] value();
    }

    public static interface LifecycleTask {
        public Closeable beforeContainerStartup();
    }

    public static class Start
    extends RunListener {
        public void testStarted(Description description) throws Exception {
            TomEEEmbeddedSingleRunner.start(null);
        }
    }

    public static class Rule
    implements TestRule {
        private final Object test;

        public Rule(Object test) {
            this.test = test;
        }

        public Statement apply(final Statement base, Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    TomEEEmbeddedSingleRunner.start(Rule.this.test.getClass());
                    TomEEEmbeddedSingleRunner.composerInject(Rule.this.test);
                    base.evaluate();
                }
            };
        }
    }
}

