/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.naming.NamingException;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.CatalinaProperties;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.Injector;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.WebAppDeployer;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.config.AnnotationDeployer;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentsResolver;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.FinderFactory;
import org.apache.openejb.config.Module;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.WebappAggregatedArchive;
import org.apache.openejb.javaagent.Agent;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.ManagedBean;
import org.apache.openejb.jee.TransactionType;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.loader.provisining.ProvisioningResolver;
import org.apache.openejb.persistence.PersistenceBootstrap;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.ContainerClassesFilter;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.catalina.TomcatLoader;
import org.apache.tomee.catalina.remote.TomEERemoteWebapp;
import org.apache.tomee.catalina.session.QuickSessionManager;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.internal.StandardContextCustomizer;
import org.apache.tomee.util.QuickServerXmlParser;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.log.NullLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;
import org.apache.xbean.recipe.ObjectRecipe;
import org.codehaus.swizzle.stream.ReplaceStringsInputStream;

public class Container
implements AutoCloseable {
    private final Map<String, String> moduleIds = new HashMap<String, String>();
    private final Map<String, AppContext> appContexts = new HashMap<String, AppContext>();
    private final Map<String, AppInfo> infos = new HashMap<String, AppInfo>();
    protected Configuration configuration;
    private File base;
    private ConfigurationFactory configurationFactory;
    private Assembler assembler;
    private InternalTomcat tomcat;

    public Container(Configuration configuration) {
        this.setup(configuration);
        try {
            this.start();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Container() {
        this.configuration = new Configuration();
        this.configuration.setHttpPort(23880);
        this.configuration.setStopPort(23881);
    }

    public Container deployClasspathAsWebApp() {
        return this.deployClasspathAsWebApp("", null, new String[0]);
    }

    public Container deployClasspathAsWebApp(String context, File docBase, String ... dependencies) {
        return this.deployClasspathAsWebApp(context, docBase, Collections.emptyList(), dependencies);
    }

    public Container deployClasspathAsWebApp(String context, File docBase, boolean singleClassLoader) {
        return this.deployClasspathAsWebApp(context, docBase, Collections.emptyList(), singleClassLoader, new String[0]);
    }

    public Container deployClasspathAsWebApp(String context, File docBase, List<String> callers, String ... dependencies) {
        return this.deployClasspathAsWebApp(context, docBase, callers, false, dependencies);
    }

    public Container deployClasspathAsWebApp(String context, File docBase, List<String> callers, boolean singleLoader, String ... dependencies) {
        List jarList = new DeploymentsResolver.ClasspathSearcher().loadUrls(Thread.currentThread().getContextClassLoader()).getUrls();
        if (dependencies != null) {
            for (String dep : dependencies) {
                Set strings = ((ProvisioningResolver)SystemInstance.get().getComponent(ProvisioningResolver.class)).realLocation(dep);
                for (String path : strings) {
                    try {
                        jarList.add(new File(path).toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
        }
        try {
            return this.deployPathsAsWebapp(context, (List<URL>)NewLoaderLogic.applyBuiltinExcludes((UrlSet)new UrlSet((Collection)jarList), NewLoaderLogic.ADDITIONAL_INCLUDE == null ? null : Filters.prefixes((String[])NewLoaderLogic.ADDITIONAL_INCLUDE.split("[ \t\n\n]*,[ \t\n\n]*"))).getUrls(), docBase, singleLoader, callers == null || callers.isEmpty() ? null : callers.toArray(new String[callers.size()]));
        }
        catch (MalformedURLException e) {
            return this.deployPathsAsWebapp(context, (List<URL>)jarList, docBase, new String[0]);
        }
    }

    public Container deployPathsAsWebapp(File ... jarList) {
        try {
            if (jarList == null || jarList.length < 1) {
                throw new IllegalArgumentException("The file does not have content");
            }
            ArrayList<URL> urls = new ArrayList<URL>(jarList.length);
            for (File jar : jarList) {
                urls.addAll(Arrays.asList(jar.toURI().toURL()));
            }
            return this.deployPathsAsWebapp(null, urls, null, new String[0]);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Container deployPathsAsWebapp(String context, List<URL> jarList, File docBase, String ... additionalCallers) {
        return this.deployPathsAsWebapp(context, jarList, docBase, false, additionalCallers);
    }

    public Container deployPathsAsWebapp(String context, List<URL> jarList, final File docBase, boolean keepClassloader, String ... additionalCallers) {
        String contextRoot;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        SystemInstance systemInstance = SystemInstance.get();
        String string = contextRoot = context == null ? "" : context;
        if (!contextRoot.isEmpty() && !contextRoot.startsWith("/")) {
            contextRoot = "/" + context;
        }
        File jarLocation = docBase == null || !docBase.isDirectory() ? this.fakeRootDir() : docBase;
        WebModule webModule = new WebModule(new WebApp(), contextRoot, loader, jarLocation.getAbsolutePath(), contextRoot.replace("/", ""));
        if (docBase == null) {
            webModule.getProperties().put("fakeJarLocation", "true");
        }
        webModule.setUrls(jarList);
        webModule.setAddedUrls(Collections.emptyList());
        webModule.setRarUrls(Collections.emptyList());
        webModule.setScannableUrls(jarList);
        try {
            String filterContainerClasses = SystemInstance.get().getProperty("tomee.embedded.filter-container-classes");
            webModule.setFinder((IAnnotationFinder)new FinderFactory.OpenEJBAnnotationFinder((Archive)new WebappAggregatedArchive((Module)webModule, jarList, (Filter)(jarList.size() <= 4 || "true".equalsIgnoreCase(filterContainerClasses) ? new ContainerClassesFilter(this.configuration.getProperties()) : null))).link());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        File beansXml = new File(docBase, "WEB-INF/beans.xml");
        if (beansXml.exists()) {
            try {
                webModule.getAltDDs().put("beans.xml", beansXml.toURI().toURL());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        DeploymentLoader.addBeansXmls((WebModule)webModule);
        AppModule app = new AppModule(loader, null);
        app.setStandloneWebModule();
        app.setStandaloneModule(true);
        app.setModuleId(webModule.getModuleId());
        try {
            Map webDescriptors = DeploymentLoader.getWebDescriptors((File)jarLocation);
            webDescriptors.remove("beans.xml");
            webModule.getAltDDs().putAll(webDescriptors);
            DeploymentLoader.addWebModule((WebModule)webModule, (AppModule)app);
            DeploymentLoader.addWebModuleDescriptors((URL)new File(webModule.getJarLocation()).toURI().toURL(), (WebModule)webModule, (AppModule)app);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        Container.addCallersAsEjbModule(loader, app, additionalCallers);
        systemInstance.addObserver((Object)new StandardContextCustomizer(this.configuration, webModule, keepClassloader));
        if (systemInstance.getComponent(AnnotationDeployer.FolderDDMapper.class) == null) {
            systemInstance.setComponent(AnnotationDeployer.FolderDDMapper.class, (Object)new AnnotationDeployer.FolderDDMapper(){

                public File getDDFolder(File dir) {
                    try {
                        return this.isMaven(dir) || this.isGradle(dir) ? new File(docBase, "WEB-INF") : null;
                    }
                    catch (RuntimeException re) {
                        return null;
                    }
                }

                private boolean isGradle(File dir) {
                    return dir.getName().equals("classes") && dir.getParentFile().getName().equals("target");
                }

                private boolean isMaven(File dir) {
                    return dir.getName().equals("main") && dir.getParentFile().getName().equals("classes") && dir.getParentFile().getParentFile().getName().equals("build");
                }
            });
        }
        try {
            AppInfo appInfo = this.configurationFactory.configureApplication(app);
            ((Assembler)systemInstance.getComponent(Assembler.class)).createApplication(appInfo, loader);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    private static void addCallersAsEjbModule(ClassLoader loader, AppModule app, String ... additionalCallers) {
        HashSet<String> callers = new HashSet<String>(NewLoaderLogic.callers((Filter)Filters.classes((String[])new String[]{Container.class.getName(), "org.apache.openejb.maven.plugins.TomEEEmbeddedMojo"})));
        if (additionalCallers != null && additionalCallers.length > 0) {
            callers.addAll(Arrays.asList(additionalCallers));
        }
        if (callers.isEmpty()) {
            return;
        }
        EjbJar ejbJar = new EjbJar();
        OpenejbJar openejbJar = new OpenejbJar();
        for (String caller : callers) {
            try {
                if (!AnnotationDeployer.isInstantiable(loader.loadClass(caller))) {
                }
            }
            catch (ClassNotFoundException e) {}
            continue;
            String name = caller.replace("$", "_");
            ManagedBean bean = (ManagedBean)ejbJar.addEnterpriseBean((EnterpriseBean)new ManagedBean(caller.replace("$", "_"), caller, true));
            bean.localBean();
            bean.setTransactionType(TransactionType.BEAN);
            EjbDeployment ejbDeployment = openejbJar.addEjbDeployment((EnterpriseBean)bean);
            ejbDeployment.setDeploymentId(name);
        }
        EjbModule ejbModule = new EjbModule(ejbJar, openejbJar);
        ejbModule.setBeans(new Beans());
        app.getEjbModules().add(ejbModule);
    }

    private File fakeRootDir() {
        File root = new File(this.configuration.getTempDir());
        Files.mkdirs((File)root);
        Files.deleteOnExit((File)root);
        return root;
    }

    private static boolean sameApplication(File file, WebAppInfo webApp) {
        String filename = file.getName();
        if (filename.endsWith(".war")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        return filename.equals(webApp.moduleId);
    }

    private static String lastPart(String name, String defaultValue) {
        int idx = name.lastIndexOf("/");
        int space = name.lastIndexOf(" ");
        if (idx >= 0 && space < idx) {
            return name.substring(idx);
        }
        if (idx < 0 && space < 0) {
            return name;
        }
        return defaultValue;
    }

    public void setup(Configuration configuration) {
        this.configuration = configuration;
        this.tomcat = configuration.isQuickSession() ? new TomcatWithFastSessionIDs() : new InternalTomcat();
        this.base = new File(this.getBaseDir());
        if (this.base.exists()) {
            Files.delete((File)this.base);
        }
        Files.mkdirs((File)this.base);
        Files.deleteOnExit((File)this.base);
        this.createDirectory(this.base, "conf");
        this.createDirectory(this.base, "lib");
        this.createDirectory(this.base, "logs");
        this.createDirectory(this.base, "temp");
        this.createDirectory(this.base, "work");
        this.createDirectory(this.base, "webapps");
    }

    public File getBase() {
        return this.base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        boolean initialized;
        Properties props;
        if (this.base == null || !this.base.exists()) {
            this.setup(this.configuration);
        }
        if ((props = this.configuration.getProperties()) != null) {
            StrSubstitutor substitutor = null;
            for (String s : props.stringPropertyNames()) {
                String v = props.getProperty(s);
                if (v == null || !v.contains("${")) continue;
                if (substitutor == null) {
                    HashMap<String, String> placeHolders = new HashMap<String, String>();
                    placeHolders.put("tomee.embedded.http", Integer.toString(this.configuration.getHttpPort()));
                    placeHolders.put("tomee.embedded.https", Integer.toString(this.configuration.getHttpsPort()));
                    placeHolders.put("tomee.embedded.stop", Integer.toString(this.configuration.getStopPort()));
                    substitutor = new StrSubstitutor(placeHolders);
                }
                props.put(s, substitutor.replace(v));
            }
            Properties properties = new Properties(System.getProperties());
            properties.putAll((Map<?, ?>)this.configuration.getProperties());
            Logger.configure((Properties)properties);
        } else {
            Logger.configure();
        }
        File conf = new File(this.base, "conf");
        File webapps = new File(this.base, "webapps");
        String catalinaBase = this.base.getAbsolutePath();
        System.setProperty("catalina.base", catalinaBase);
        System.setProperty("openejb.deployments.classpath", "false");
        System.setProperty("catalina.home", catalinaBase);
        System.setProperty("catalina.base", catalinaBase);
        System.setProperty("openejb.home", catalinaBase);
        System.setProperty("openejb.base", catalinaBase);
        System.setProperty("openejb.servicemanager.enabled", "false");
        this.copyFileTo(conf, "catalina.policy");
        this.copyTemplateTo(conf, "catalina.properties");
        this.copyFileTo(conf, "context.xml");
        this.copyFileTo(conf, "openejb.xml");
        this.copyFileTo(conf, "tomcat-users.xml");
        this.copyFileTo(conf, "web.xml");
        if (this.configuration.hasServerXml()) {
            File file = new File(conf, "server.xml");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                IO.copy((File)this.configuration.getServerXmlFile(), (OutputStream)fileOutputStream);
            }
            finally {
                IO.close((Closeable)fileOutputStream);
            }
            QuickServerXmlParser ports = QuickServerXmlParser.parse((File)file);
            if (this.configuration.isKeepServerXmlAsThis()) {
                this.configuration.setHttpPort(Integer.parseInt(ports.http()));
                this.configuration.setStopPort(Integer.parseInt(ports.stop()));
            } else {
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put(ports.http(), String.valueOf(this.configuration.getHttpPort()));
                replacements.put(ports.https(), String.valueOf(this.configuration.getHttpsPort()));
                replacements.put(ports.stop(), String.valueOf(this.configuration.getStopPort()));
                IO.copy((byte[])IO.slurp((InputStream)new ReplaceStringsInputStream(IO.read((File)file), replacements)).getBytes(), (File)file);
            }
            this.tomcat.server(Container.createServer(file.getAbsolutePath()));
            initialized = true;
        } else {
            this.copyFileTo(conf, "server.xml");
            initialized = false;
        }
        if (props != null && !props.isEmpty()) {
            FileWriter systemProperties = new FileWriter(new File(conf, "system.properties"));
            try {
                props.store(systemProperties, "");
            }
            finally {
                IO.close((Closeable)systemProperties);
            }
        }
        CatalinaProperties.getProperty((String)"foo");
        this.tomcat.setBaseDir(this.base.getAbsolutePath());
        this.tomcat.setHostname(this.configuration.getHost());
        if (!initialized) {
            this.tomcat.getHost().setAppBase(webapps.getAbsolutePath());
            this.tomcat.getEngine().setDefaultHost(this.configuration.getHost());
            this.tomcat.setHostname(this.configuration.getHost());
        }
        if (this.configuration.getRealm() != null) {
            this.tomcat.getEngine().setRealm(this.configuration.getRealm());
        }
        if (this.tomcat.getRawConnector() == null && !this.configuration.isSkipHttp()) {
            Connector connector = this.createConnector();
            connector.setPort(this.configuration.getHttpPort());
            if (connector.getAttribute("connectionTimeout") == null) {
                connector.setAttribute("connectionTimeout", (Object)"3000");
            }
            if (this.configuration.isHttp2()) {
                connector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
            }
            this.tomcat.getService().addConnector(connector);
            this.tomcat.setConnector(connector);
        }
        if (this.configuration.isSsl()) {
            Connector httpsConnector = this.createConnector();
            httpsConnector.setPort(this.configuration.getHttpsPort());
            httpsConnector.setSecure(true);
            httpsConnector.setProperty("SSLEnabled", "true");
            httpsConnector.setProperty("sslProtocol", this.configuration.getSslProtocol());
            if (this.configuration.getKeystoreFile() != null) {
                httpsConnector.setAttribute("", (Object)this.configuration.getKeystoreFile());
            }
            if (this.configuration.getKeystorePass() != null) {
                httpsConnector.setAttribute("keystorePass", (Object)this.configuration.getKeystorePass());
            }
            httpsConnector.setAttribute("keystoreType", (Object)this.configuration.getKeystoreType());
            if (this.configuration.getClientAuth() != null) {
                httpsConnector.setAttribute("clientAuth", (Object)this.configuration.getClientAuth());
            }
            if (this.configuration.getKeyAlias() != null) {
                httpsConnector.setAttribute("keyAlias", (Object)this.configuration.getKeyAlias());
            }
            if (this.configuration.isHttp2()) {
                httpsConnector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
            }
            this.tomcat.getService().addConnector(httpsConnector);
            if (this.configuration.isSkipHttp()) {
                this.tomcat.setConnector(httpsConnector);
            }
        }
        for (Connector connector : this.configuration.getConnectors()) {
            this.tomcat.getService().addConnector(connector);
        }
        if (!(this.configuration.isSkipHttp() || this.configuration.isSsl() || this.configuration.getConnectors().isEmpty())) {
            this.tomcat.setConnector(this.configuration.getConnectors().iterator().next());
        }
        Logger.getInstance((LogCategory)LogCategory.OPENEJB_STARTUP, Container.class).info("Starting TomEE from: " + this.base.getAbsolutePath());
        if (this.configuration.getUsers() != null) {
            for (Map.Entry entry : this.configuration.getUsers().entrySet()) {
                this.tomcat.addUser((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.configuration.getRoles() != null) {
            for (Map.Entry entry : this.configuration.getRoles().entrySet()) {
                for (String role : ((String)entry.getValue()).split(" *, *")) {
                    this.tomcat.addRole((String)entry.getKey(), role);
                }
            }
        }
        if (!initialized) {
            this.tomcat.init();
        }
        this.tomcat.start();
        Properties properties = new Properties();
        properties.setProperty("openejb.deployments.classpath", "false");
        properties.setProperty("openejb.loader", "tomcat-system");
        properties.setProperty("openejb.home", catalinaBase);
        properties.setProperty("openejb.base", catalinaBase);
        properties.setProperty("openejb.servicemanager.enabled", "false");
        if (this.configuration.getProperties() != null) {
            properties.putAll((Map<?, ?>)this.configuration.getProperties());
        }
        if (properties.getProperty("openejb.system.apps") == null) {
            properties.setProperty("openejb.system.apps", "false");
        }
        if (this.configuration.isQuickSession()) {
            properties.put("openejb.session.manager", QuickSessionManager.class.getName());
        }
        try {
            String serverBuilt;
            String serverInfo;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Properties tomcatServerInfo = IO.readProperties((InputStream)classLoader.getResourceAsStream("org/apache/catalina/util/ServerInfo.properties"), (Properties)new Properties());
            String serverNumber = tomcatServerInfo.getProperty("server.number");
            if (serverNumber == null && (serverInfo = tomcatServerInfo.getProperty("server.info")) != null) {
                int slash = serverInfo.indexOf(47);
                serverNumber = serverInfo.substring(slash + 1);
            }
            if (serverNumber != null) {
                System.setProperty("tomcat.version", serverNumber);
            }
            if ((serverBuilt = tomcatServerInfo.getProperty("server.built")) != null) {
                System.setProperty("tomcat.built", serverBuilt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        TomcatLoader tomcatLoader = new TomcatLoader();
        tomcatLoader.initDefaults(properties);
        Properties initProps = new Properties();
        initProps.putAll((Map<?, ?>)System.getProperties());
        initProps.putAll((Map<?, ?>)properties);
        if (SystemInstance.isInitialized()) {
            SystemInstance.get().getProperties().putAll((Map<?, ?>)initProps);
        } else {
            SystemInstance.init((Properties)initProps);
        }
        SystemInstance.get().setComponent(StandardServer.class, (Object)((StandardServer)this.tomcat.getServer()));
        SystemInstance.get().setComponent(Server.class, (Object)this.tomcat.getServer());
        tomcatLoader.initialize(properties);
        this.assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
        this.configurationFactory = new ConfigurationFactory();
        if (this.configuration.isWithEjbRemote()) {
            this.tomcat.getHost().addChild((org.apache.catalina.Container)new TomEERemoteWebapp());
        }
    }

    protected Connector createConnector() {
        Connector connector;
        Properties properties = this.configuration.getProperties();
        if (properties != null) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            ObjectRecipe recipe = new ObjectRecipe(Connector.class);
            for (String string : properties.stringPropertyNames()) {
                if (!string.startsWith("connector.")) continue;
                String substring = string.substring("connector.".length());
                if (!substring.startsWith("attributes.")) {
                    recipe.setProperty(substring, (Object)properties.getProperty(string));
                    continue;
                }
                attributes.put(substring.substring("attributes.".length()), properties.getProperty(string));
            }
            connector = recipe.getProperties().isEmpty() ? new Connector() : (Connector)Connector.class.cast(recipe.create());
            for (Map.Entry entry : attributes.entrySet()) {
                connector.setAttribute((String)entry.getKey(), entry.getValue());
            }
        } else {
            connector = new Connector();
        }
        return connector;
    }

    private static Server createServer(String serverXml) {
        Catalina catalina = new Catalina(){

            protected void initDirs() {
            }

            protected void initStreams() {
            }

            protected void initNaming() {
            }
        };
        catalina.setConfigFile(serverXml);
        catalina.load();
        return catalina.getServer();
    }

    public ConfigurationFactory getConfigurationFactory() {
        return this.configurationFactory;
    }

    private String getBaseDir() {
        try {
            File file;
            String dir = this.configuration.getDir();
            if (dir != null) {
                File dirFile = new File(dir);
                if (dirFile.exists()) {
                    return dir;
                }
                return Files.mkdir((File)dirFile).getAbsolutePath();
            }
            try {
                File target = new File("target");
                file = File.createTempFile("apache-tomee", "-home", target.exists() ? target : null);
            }
            catch (Exception e) {
                File tmp = new File(this.configuration.getTempDir());
                if (!tmp.exists() && !tmp.mkdirs()) {
                    throw new IOException("Failed to create local tmp directory: " + tmp.getAbsolutePath());
                }
                file = File.createTempFile("apache-tomee", "-home", tmp);
            }
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new TomEERuntimeException("Failed to get or create base dir: " + this.configuration.getDir(), (Throwable)e);
        }
    }

    public void stop() throws Exception {
        Connector connector = this.tomcat.getConnector();
        if (null != connector) {
            connector.stop();
        }
        try {
            this.tomcat.stop();
        }
        catch (LifecycleException e) {
            e.printStackTrace();
        }
        try {
            this.tomcat.destroy();
        }
        catch (LifecycleException e) {
            e.printStackTrace();
        }
        try {
            this.deleteTree(this.base);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OpenEJB.destroy();
    }

    public AppContext deploy(String name, File file) throws OpenEJBException, IOException, NamingException {
        return this.deploy(name, file, false);
    }

    public AppContext deploy(String name, File file, boolean overrideName) throws OpenEJBException, IOException, NamingException {
        Object context;
        AppInfo appInfo;
        if (WebAppDeployer.Helper.isWebApp((File)file)) {
            String contextRoot = file.getName();
            if (overrideName) {
                contextRoot = name;
            }
            context = (appInfo = ((WebAppDeployer)SystemInstance.get().getComponent(WebAppDeployer.class)).deploy(null, contextRoot, file)) != null ? ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getAppContext((Object)appInfo.appId) : null;
        } else {
            appInfo = this.configurationFactory.configureApplication(file);
            if (overrideName) {
                appInfo.appId = name;
                for (EjbJarInfo ejbJar : appInfo.ejbJars) {
                    if (file.getName().equals(ejbJar.moduleName)) {
                        ejbJar.moduleName = name;
                        ejbJar.moduleId = name;
                    }
                    for (EnterpriseBeanInfo ejb : ejbJar.enterpriseBeans) {
                        if (!BeanContext.Comp.openejbCompName((String)file.getName()).equals(ejb.ejbName)) continue;
                        ejb.ejbName = BeanContext.Comp.openejbCompName((String)name);
                    }
                }
                for (WebAppInfo webApp : appInfo.webApps) {
                    if (!Container.sameApplication(file, webApp)) continue;
                    webApp.moduleId = name;
                    webApp.contextRoot = Container.lastPart(name, webApp.contextRoot);
                    if (!"ROOT".equals(webApp.contextRoot)) continue;
                    webApp.contextRoot = "";
                }
            }
            context = this.assembler.createApplication(appInfo);
        }
        this.moduleIds.put(name, null != appInfo ? appInfo.path : null);
        this.infos.put(name, appInfo);
        this.appContexts.put(name, (AppContext)context);
        return context;
    }

    public AppInfo getInfo(String name) {
        return this.infos.get(name);
    }

    public void undeploy(String name) throws UndeployException, NoSuchApplicationException {
        String moduleId = this.moduleIds.remove(name);
        this.infos.remove(name);
        this.appContexts.remove(name);
        if (moduleId != null) {
            this.assembler.destroyApplication(moduleId);
        }
    }

    public javax.naming.Context getJndiContext() {
        return this.assembler.getContainerSystem().getJNDIContext();
    }

    public AppContext getAppContexts(String moduleId) {
        return this.appContexts.get(moduleId);
    }

    private void deleteTree(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            if (!file.delete()) {
                file.deleteOnExit();
            }
            return;
        }
        if (file.isDirectory()) {
            if ("".equals(file.getName())) {
                return;
            }
            if ("src/main".equals(file.getName())) {
                return;
            }
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.deleteTree(child);
                }
            }
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    private void copyTemplateTo(File targetDir, String filename) throws Exception {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("runtime.log.logsystem", (Object)new NullLogChute());
        engine.setProperty("resource.loader", (Object)"class");
        engine.setProperty("class.resource.loader.description", (Object)"Velocity Classpath Resource Loader");
        engine.setProperty("class.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        engine.init();
        Template template = engine.getTemplate("/org/apache/tomee/configs/" + filename);
        VelocityContext context = new VelocityContext();
        context.put("tomcatHttpPort", (Object)Integer.toString(this.configuration.getHttpPort()));
        context.put("tomcatShutdownPort", (Object)Integer.toString(this.configuration.getStopPort()));
        FileWriter writer = new FileWriter(new File(targetDir, filename));
        template.merge((org.apache.velocity.context.Context)context, (Writer)writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileTo(File targetDir, String filename) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/org/apache/tomee/configs/" + filename);
        if (is != null) {
            try {
                IO.copy((InputStream)is, (File)new File(targetDir, filename));
            }
            finally {
                IO.close((Closeable)is);
            }
        }
    }

    private File createDirectory(File parent, String directory) {
        File dir = new File(parent, directory);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Unable to make dir " + dir.getAbsolutePath());
        }
        return dir;
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }

    public void await() {
        this.tomcat.getServer().await();
    }

    @Override
    public void close() {
        final CountDownLatch end = new CountDownLatch(1);
        final Container container = this;
        new Thread(){
            {
                this.setName("tomee-embedded-await-" + this.hashCode());
            }

            @Override
            public void run() {
                try {
                    container.await();
                    end.countDown();
                }
                catch (Exception e) {
                    end.countDown();
                    throw new IllegalStateException(e);
                }
            }
        }.start();
        try {
            this.stop();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to stop container", e);
        }
        try {
            end.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    public Context addContext(String context, String path) {
        File root = new File(path);
        if (!root.exists()) {
            Files.mkdirs((File)root);
        }
        return this.getTomcat().addContext(context, root.getAbsolutePath());
    }

    public Container inject(Object instance) {
        Injector.inject((Object)instance);
        return this;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    static {
        Assembler.installNaming((String)"org.apache.naming", (boolean)true);
        if (!Boolean.getBoolean("tomee.embedded.javaagent.auto.skip")) {
            try {
                Agent.getInstrumentation();
                PersistenceBootstrap.bootstrap((ClassLoader)Container.class.getClassLoader());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class TomcatWithFastSessionIDs
    extends InternalTomcat {
        private TomcatWithFastSessionIDs() {
        }

        public void start() throws LifecycleException {
            Server server = this.getServer();
            for (Service service : server.findServices()) {
                Engine e = service.getContainer();
                for (org.apache.catalina.Container h : e.findChildren()) {
                    for (org.apache.catalina.Container c : h.findChildren()) {
                        Manager m = ((Context)c).getManager();
                        if (m == null) {
                            m = new StandardManager();
                            ((Context)c).setManager(m);
                        }
                        if (!(m instanceof ManagerBase)) continue;
                        ((ManagerBase)m).setSecureRandomClass("org.apache.catalina.startup.FastNonSecureRandom");
                    }
                }
            }
            super.start();
        }
    }

    private static class InternalTomcat
    extends Tomcat {
        private InternalTomcat() {
        }

        private void server(Server s) {
            this.server = s;
            if (this.service == null) {
                Service[] services = this.server.findServices();
                if (services.length > 0) {
                    this.service = services[0];
                    if (this.service.getContainer() != null) {
                        this.engine = (Engine)Engine.class.cast(this.service.getContainer());
                        org.apache.catalina.Container[] hosts = this.engine.findChildren();
                        if (hosts.length > 0) {
                            this.host = (Host)Host.class.cast(hosts[0]);
                        }
                    }
                }
                if (this.service.findConnectors().length > 0) {
                    this.connector = this.service.findConnectors()[0];
                }
            }
        }

        public Connector getRawConnector() {
            return this.connector;
        }
    }
}

