/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.arquillian.common.ArquillianUtil;
import org.apache.openejb.arquillian.common.ConfigurationOverrides;
import org.apache.openejb.arquillian.common.Files;
import org.apache.openejb.arquillian.common.IO;
import org.apache.openejb.arquillian.common.ObjectMap;
import org.apache.openejb.arquillian.common.Prefixes;
import org.apache.openejb.arquillian.common.Setup;
import org.apache.openejb.arquillian.common.Threads;
import org.apache.openejb.arquillian.common.TomEEConfiguration;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Info;
import org.apache.openejb.assembler.classic.ServletInfo;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.loader.Options;
import org.apache.openejb.util.NetworkUtil;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public abstract class TomEEContainer<Configuration extends TomEEConfiguration>
implements DeployableContainer<Configuration> {
    protected static final Logger LOGGER = Logger.getLogger(TomEEContainer.class.getName());
    protected Configuration configuration;
    protected Map<String, DeployedApp> moduleIds = new HashMap<String, DeployedApp>();
    private final Options options = new Options(System.getProperties());
    @Inject
    private Instance<TestClass> testClass;
    @Inject
    protected Instance<DeploymentDescription> deployment;

    protected TomEEContainer() {
    }

    protected void resetSerialization() {
        if (((TomEEConfiguration)this.configuration).isUnsafeEjbd() && "-".equals(System.getProperty("tomee.serialization.class.blacklist"))) {
            System.clearProperty("tomee.serialization.class.blacklist");
            Setup.reloadClientSerializationConfig();
        }
    }

    protected boolean isTestable(Archive<?> archive, DeploymentDescription deploymentDescription) {
        return deploymentDescription != null && deploymentDescription.isArchiveDeployment() && (deploymentDescription.getArchive() == archive || deploymentDescription.getTestableArchive() == archive) && deploymentDescription.testable();
    }

    protected void handlePrefix() {
        Prefixes prefixes = this.configuration.getClass().getAnnotation(Prefixes.class);
        if (prefixes == null) {
            return;
        }
        Properties systemProperties = System.getProperties();
        ConfigurationOverrides.apply(this.configuration, systemProperties, prefixes.value());
        this.setPorts();
        if (((TomEEConfiguration)this.configuration).getExportConfAsSystemProperty()) {
            ObjectMap map = new ObjectMap(this.configuration);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                for (String prefix : prefixes.value()) {
                    try {
                        String property = prefix + "." + entry.getKey();
                        String value = entry.getValue().toString();
                        LOGGER.log(Level.FINER, String.format("Exporting '%s=%s'", property, value));
                        System.setProperty(property, value);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void setup(Configuration configuration) {
        this.configuration = configuration;
        this.handlePrefix();
        ArquillianUtil.preLoadClassesAsynchronously((String)((TomEEConfiguration)configuration).getPreloadClasses());
    }

    protected void addArquillianServlet(Archive<?> archive, AppInfo appInfo, String archiveName, HTTPContext httpContext) {
        if (archiveName.endsWith(".war")) {
            httpContext.add(new Servlet("ArquillianServletRunner", "/" + this.getArchiveNameWithoutExtension(archive)));
        } else if (archiveName.endsWith(".ear") && appInfo.webApps.size() > 0) {
            String contextRoot = System.getProperty("tomee.arquillian.ear.context", ((TomEEConfiguration)this.configuration).getWebContextToUseWithEars());
            if (contextRoot != null) {
                httpContext.add(new Servlet("ArquillianServletRunner", ("/" + contextRoot).replace("//", "/")));
            } else {
                for (WebAppInfo web : appInfo.webApps) {
                    httpContext.add(new Servlet("ArquillianServletRunner", ("/" + web.contextRoot).replace("//", "/")));
                }
            }
        } else {
            httpContext.add(new Servlet("ArquillianServletRunner", "/arquillian-protocol"));
        }
    }

    protected void setPorts() {
        ArrayList<Integer> randomPorts = new ArrayList<Integer>();
        for (int i : ((TomEEConfiguration)this.configuration).portsAlreadySet()) {
            randomPorts.add(i);
        }
        ObjectMap map = new ObjectMap(this.configuration);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!entry.getKey().toLowerCase().endsWith("port")) continue;
            try {
                Object value = entry.getValue();
                int port = new Integer(String.valueOf(value));
                if (port > 0) continue;
                int retry = 0;
                while (retry++ != Integer.MAX_VALUE && randomPorts.contains(port = this.nextPort(((TomEEConfiguration)this.configuration).getPortRange(), randomPorts))) {
                }
                entry.setValue(port);
                randomPorts.add(port);
            }
            catch (NumberFormatException mustNotBeAPortConfig) {}
        }
        randomPorts.clear();
    }

    private int nextPort(String portRange, Collection<Integer> excluded) {
        if (portRange == null || portRange.isEmpty()) {
            for (int retry = 10; retry > 0; --retry) {
                int port = NetworkUtil.getNextAvailablePort();
                if (excluded.contains(port)) continue;
                return port;
            }
            throw new IllegalArgumentException("can't find a port available excluding " + excluded);
        }
        if (!portRange.contains("-")) {
            int port = Integer.parseInt(portRange.trim());
            return NetworkUtil.getNextAvailablePort((int[])new int[]{port});
        }
        String[] minMax = portRange.trim().split("-");
        int min = Integer.parseInt(minMax[0]);
        int max = Integer.parseInt(minMax[1]);
        return NetworkUtil.getNextAvailablePort((int)min, (int)max, excluded);
    }

    public abstract void start() throws LifecycleException;

    public void stop() throws LifecycleException {
        try {
            Socket socket = new Socket(((TomEEConfiguration)this.configuration).getStopHost(), ((TomEEConfiguration)this.configuration).getStopPort());
            OutputStream out = socket.getOutputStream();
            out.write((((TomEEConfiguration)this.configuration).getStopCommand() + Character.toString('\u0000')).getBytes());
            this.waitForShutdown(socket, 10);
        }
        catch (Exception e) {
            throw new LifecycleException("Unable to stop TomEE", (Throwable)e);
        }
        finally {
            if (((TomEEConfiguration)this.configuration).isUnsafeEjbd() && "-".equals(System.getProperty("tomee.serialization.class.blacklist"))) {
                System.clearProperty("tomee.serialization.class.blacklist");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForShutdown(Socket socket, int tries) {
        try {
            OutputStream out = socket.getOutputStream();
            out.close();
        }
        catch (Exception e) {
            if (tries > 2) {
                Threads.sleep(2000L);
                this.waitForShutdown(socket, --tries);
            }
        }
        finally {
            if (socket != null && !socket.isClosed()) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 2.5");
    }

    public void addServlets(HTTPContext httpContext, AppInfo appInfo) {
        for (WebAppInfo webApps : appInfo.webApps) {
            for (ServletInfo servlet : webApps.servlets) {
                String clazz = servlet.servletClass;
                if (clazz == null && (clazz = servlet.servletName) == null) continue;
                httpContext.add(new Servlet(clazz, webApps.contextRoot));
            }
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            AppInfo appInfo;
            Dump dump = this.dumpFile(archive);
            File file = dump.getFile();
            String fileName = file.getName();
            if (dump.isCreated() && (fileName.endsWith(".war") || fileName.endsWith(".ear"))) {
                Files.deleteOnExit(new File(file.getParentFile(), fileName.substring(0, fileName.length() - 4)));
            }
            String archiveName = archive.getName();
            try {
                if (dump.isCreated() || !((TomEEConfiguration)this.configuration).isSingleDeploymentByArchiveName(archiveName)) {
                    appInfo = this.doDeploy(archive, file);
                    if (appInfo != null) {
                        this.moduleIds.put(archiveName, new DeployedApp(appInfo.path, file));
                        Files.deleteOnExit(file);
                    }
                } else {
                    String path = this.moduleIds.get((Object)archiveName).path;
                    AppInfo selected = null;
                    for (AppInfo info : this.getDeployedApps()) {
                        if (!path.equals(info.path)) continue;
                        selected = info;
                        break;
                    }
                    appInfo = selected;
                }
                if (appInfo == null) {
                    LOGGER.severe("appInfo was not found for " + file.getPath() + ", available are: " + this.apps());
                    throw new OpenEJBException("can't get appInfo");
                }
            }
            catch (OpenEJBException re) {
                this.moduleIds.put(archiveName, new DeployedApp(file.getPath(), file));
                throw re;
            }
            if (this.options.get("tomee.appinfo.output", false)) {
                Info.marshal((AppInfo)appInfo);
            }
            HTTPContext httpContext = new HTTPContext(((TomEEConfiguration)this.configuration).getHost(), ((TomEEConfiguration)this.configuration).getHttpPort());
            this.addArquillianServlet(archive, appInfo, archiveName, httpContext);
            this.addServlets(httpContext, appInfo);
            return new ProtocolMetaData().addContext((Object)httpContext);
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to deploy", (Throwable)e);
        }
    }

    protected Collection<AppInfo> getDeployedApps() throws NamingException {
        return this.deployer().getDeployedApps();
    }

    protected AppInfo doDeploy(Archive<?> archive, File file) throws OpenEJBException, NamingException, IOException {
        AppInfo appInfo;
        Properties deployerProperties = this.getDeployerProperties();
        if (deployerProperties == null) {
            appInfo = this.deployer().deploy(file.getAbsolutePath());
        } else {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)deployerProperties);
            if ("true".equalsIgnoreCase(deployerProperties.getProperty("openejb.deployer.binaries.use", "false"))) {
                byte[] slurpBinaries = IO.slurpBytes(file);
                props.put("openejb.deployer.binaries.value", slurpBinaries);
                props.put("openejb.deployer.binaries.path", archive.getName());
            }
            appInfo = this.deployer().deploy(file.getAbsolutePath(), props);
        }
        return appInfo;
    }

    protected Properties getDeployerProperties() {
        return null;
    }

    protected Dump dumpFile(Archive<?> archive) {
        boolean created;
        File file;
        String tmpDir = ((TomEEConfiguration)this.configuration).getAppWorkingDir();
        Files.deleteOnExit(new File(tmpDir));
        if (((TomEEConfiguration)this.configuration).isSingleDumpByArchiveName()) {
            file = new File(tmpDir + File.separator + archive.getName());
            Files.deleteOnExit(file);
        } else {
            int i = 0;
            while ((file = new File(tmpDir + File.separator + i++ + File.separator + archive.getName())).getParentFile().exists()) {
            }
            Files.deleteOnExit(file.getParentFile());
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            LOGGER.warning("can't create " + file.getParent());
        }
        Assignable finalArchive = this.isTestable((Archive<?>)archive, (DeploymentDescription)this.deployment.get()) ? this.archiveWithTestInfo((Archive<?>)archive) : archive;
        long size = -1L;
        if (file.exists()) {
            size = file.length();
        }
        if (!((TomEEConfiguration)this.configuration).isSingleDumpByArchiveName() || !file.exists()) {
            ((ZipExporter)finalArchive.as(ZipExporter.class)).exportTo(file, true);
            created = true;
        } else {
            created = false;
        }
        if (size > 0L && size != file.length()) {
            LOGGER.warning("\nFile overwritten but size doesn't match: (now) " + file.length() + "/(before) " + size + " name=" + file.getName() + (((TomEEConfiguration)this.configuration).isSingleDumpByArchiveName() ? " maybe set singleDumpByArchiveName to false" : "") + "\n");
        }
        return new Dump(file, created);
    }

    private Collection<String> apps() {
        ArrayList<String> paths = new ArrayList<String>();
        try {
            Collection<AppInfo> appInfos = this.getDeployedApps();
            for (AppInfo info : appInfos) {
                paths.add(info.path);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return paths;
    }

    protected Assignable archiveWithTestInfo(Archive<?> archive) {
        String name = archive.getName();
        if (name.endsWith(".war") || name.endsWith(".ear")) {
            name = name.substring(0, name.length() - ".war".length());
        }
        return archive.add((Asset)new StringAsset(((TestClass)this.testClass.get()).getJavaClass().getName() + '#' + name), ArchivePaths.create((String)"arquillian-tomee-info.txt"));
    }

    protected Deployer deployer() throws NamingException {
        return this.lookupDeployerWithRetry(5);
    }

    protected Deployer lookupDeployerWithRetry(int retry) throws NamingException {
        try {
            Properties properties = new Properties();
            properties.setProperty("java.naming.factory.initial", "org.apache.openejb.client.RemoteInitialContextFactory");
            properties.setProperty("java.naming.provider.url", this.providerUrl());
            return (Deployer)new InitialContext(properties).lookup("openejb/DeployerBusinessRemote");
        }
        catch (RuntimeException ne) {
            if (retry > 1) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                return this.lookupDeployerWithRetry(retry - 1);
            }
            if (Boolean.getBoolean("openejb.arquillian.debug") && retry >= 0) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.lookupDeployerWithRetry(-1);
            }
            throw ne;
        }
    }

    protected String providerUrl() {
        return "http://" + ((TomEEConfiguration)this.configuration).getHost() + ":" + ((TomEEConfiguration)this.configuration).getHttpPort() + "/tomee/ejb";
    }

    protected String getArchiveNameWithoutExtension(Archive<?> archive) {
        String archiveName = archive.getName();
        int extensionOffset = archiveName.lastIndexOf(46);
        if (extensionOffset >= 0) {
            return archiveName.substring(0, extensionOffset);
        }
        return archiveName;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        String archiveName = archive.getName();
        if (((TomEEConfiguration)this.configuration).isSingleDeploymentByArchiveName(archiveName)) {
            return;
        }
        DeployedApp deployed = this.moduleIds.remove(archiveName);
        try {
            if (deployed == null) {
                LOGGER.warning(archiveName + " was not deployed");
                return;
            }
            this.doUndeploy(deployed);
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to undeploy " + archiveName, (Throwable)e);
        }
        finally {
            if (deployed != null && !((TomEEConfiguration)this.configuration).isSingleDumpByArchiveName()) {
                File parentFile;
                File[] parentChildren;
                LOGGER.info("cleaning " + deployed.file.getAbsolutePath());
                Files.delete(deployed.file);
                File pathFile = new File(deployed.path);
                if (!deployed.path.equals(deployed.file.getAbsolutePath()) && pathFile.exists()) {
                    LOGGER.info("cleaning " + pathFile);
                    Files.delete(pathFile);
                }
                if ((parentChildren = (parentFile = deployed.file.getParentFile()).listFiles()) == null || parentChildren.length == 0) {
                    Files.delete(deployed.file.getParentFile());
                }
            }
        }
    }

    protected void doUndeploy(DeployedApp deployed) throws UndeployException, NoSuchApplicationException, NamingException {
        this.deployer().undeploy(deployed.path);
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected final class Dump {
        private final File file;
        private final boolean created;

        public Dump(File file, boolean created) {
            this.file = file;
            this.created = created;
        }

        public File getFile() {
            return this.file;
        }

        public boolean isCreated() {
            return this.created;
        }
    }

    public static class DeployedApp {
        public final File file;
        public final String path;

        public DeployedApp(String path, File file) {
            this.path = path;
            this.file = file;
        }
    }
}

