/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.arquillian.common.ArquillianFilterRunner;
import org.apache.openejb.arquillian.common.BeanDicovererInstaller;
import org.apache.openejb.arquillian.common.Discover;
import org.apache.openejb.arquillian.common.Files;
import org.apache.openejb.arquillian.common.IO;
import org.apache.openejb.arquillian.common.MavenCache;
import org.apache.openejb.arquillian.common.TestClassDiscoverer;
import org.apache.openejb.arquillian.common.TomEEConfiguration;
import org.apache.openejb.arquillian.common.Zips;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.loader.SystemInstance;
import org.apache.tomee.util.QuickServerXmlParser;
import org.codehaus.swizzle.stream.ReplaceStringsInputStream;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class Setup {
    private static final Logger LOGGER = Logger.getLogger(Setup.class.getName());
    public static final String TOMEE_BEAN_DISCOVERER_JAR = "lib" + File.separator + "xx-arquillian-tomee-bean-discoverer.jar";
    private static final String DEFAULT_MEM_CONFIG = (Setup.javaVersion() >= 1.8 ? "" : "-XX:PermSize=64m -XX:MaxPermSize=256m ") + "-Xmx512m -Xms256m -XX:ReservedCodeCacheSize=64m";

    private static double javaVersion() {
        try {
            return Double.parseDouble(System.getProperty("java.version", "1.7").substring(0, 3));
        }
        catch (Exception nfe) {
            return 1.6;
        }
    }

    public static void exportProperties(File tomeeHome, TomEEConfiguration c, boolean defaultMem) {
        int httpPort = c.getHttpPort();
        System.setProperty("java.naming.provider.url", "http://" + c.getHost() + ":" + httpPort + "/tomee/ejb");
        System.setProperty("connect.tries", "90");
        System.setProperty("server.http.port", String.valueOf(httpPort));
        System.setProperty("server.shutdown.port", String.valueOf(c.getStopPort()));
        if (defaultMem) {
            System.setProperty("java.opts", DEFAULT_MEM_CONFIG + " -Dtomee.httpPort=" + httpPort);
        } else {
            System.setProperty("java.opts", "-Dtomee.httpPort=" + httpPort);
        }
        System.setProperty("openejb.home", tomeeHome.getAbsolutePath());
        System.setProperty("tomee.home", tomeeHome.getAbsolutePath());
    }

    public static void updateServerXml(File tomeeHome, TomEEConfiguration configuration) throws IOException {
        File serverXml = Files.path(new File(tomeeHome.getAbsolutePath()), "conf", "server.xml");
        if (!serverXml.exists()) {
            return;
        }
        QuickServerXmlParser ports = QuickServerXmlParser.parse((File)serverXml);
        if (configuration.getKeepServerXmlAsThis()) {
            configuration.setHttpPort(Integer.parseInt(ports.http()));
            configuration.setStopPort(Integer.parseInt(ports.stop()));
            return;
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put(ports.http(), String.valueOf(configuration.getHttpPort()));
        replacements.put(ports.https(), String.valueOf(configuration.getHttpsPort()));
        replacements.put(ports.stop(), String.valueOf(configuration.getStopPort()));
        replacements.put(ports.ajp(), String.valueOf(Setup.ajpPort(configuration)));
        if (configuration.isUnpackWars()) {
            replacements.put("unpackWARs=\"false\"", "unpackWARs=\"true\"");
        } else {
            replacements.put("unpackWARs=\"true\"", "unpackWARs=\"false\"");
        }
        Setup.replace(replacements, serverXml, true);
    }

    public static File findHome(File directory) {
        File f = Setup.findHomeImpl(directory = directory.getAbsoluteFile());
        if (null == f) {
            LOGGER.log(Level.INFO, "Unable to find home in: " + directory);
        }
        return f;
    }

    public static File findHomeImpl(File directory) {
        File conf = new File(directory, "conf").getAbsoluteFile();
        File webapps = new File(directory, "webapps").getAbsoluteFile();
        if (conf.exists() && conf.isDirectory() && webapps.exists() && webapps.isDirectory()) {
            return directory;
        }
        File[] files = directory.listFiles();
        if (null != files) {
            for (File file : files) {
                File found;
                if (".".equals(file.getName()) || "..".equals(file.getName()) || (found = Setup.findHome(file)) == null) continue;
                return found;
            }
        }
        return null;
    }

    public static File downloadAndUnpack(File dir, String artifactID, String defaultTempDir) throws LifecycleException {
        File zipFile = Setup.downloadFile(artifactID, null, defaultTempDir);
        Zips.unzip(zipFile, dir);
        return Setup.findHome(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFile(String artifactName, String altUrl, String defaultTempDir) {
        String cache;
        String string = cache = SystemInstance.isInitialized() ? SystemInstance.get().getOptions().get("openejb.deployer.cache.folder", (String)null) : System.getProperty("openejb.deployer.cache.folder");
        if (cache == null && defaultTempDir != null) {
            System.setProperty("openejb.deployer.cache.folder", defaultTempDir);
        }
        try {
            File artifact = MavenCache.getArtifact(artifactName, altUrl);
            if (artifact == null) {
                throw new NullPointerException(String.format("No such artifact: %s", artifactName));
            }
            File file = artifact.getAbsoluteFile();
            return file;
        }
        finally {
            if (cache == null) {
                System.clearProperty("openejb.deployer.cache.folder");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRunning(String host, int port) {
        Socket socket = null;
        try {
            socket = new Socket(host, port);
            socket.getOutputStream().close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public static void replace(Map<String, String> replacements, File file, boolean escape) throws IOException {
        InputStream in = IO.read(file);
        if (escape) {
            HashMap<String, String> escaped = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : replacements.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key.startsWith("\"") && key.endsWith("\"")) {
                    escaped.put(key, value);
                    continue;
                }
                escaped.put("\"" + key + "\"", "\"" + value + "\"");
            }
            replacements.clear();
            replacements.putAll(escaped);
        }
        in = new ReplaceStringsInputStream(in, replacements);
        String data = IO.slurp(in);
        IO.copy(data.getBytes(), file);
        if (LOGGER.isLoggable(Level.FINE)) {
            IO.copy(data.getBytes(), (OutputStream)System.out);
        }
    }

    public static void removeUselessWebapps(File tomeeHome, String ... exceptions) {
        File[] files;
        File webapps = new File(tomeeHome, "webapps");
        if (webapps.isDirectory() && (files = webapps.listFiles()) != null) {
            for (File webapp : files) {
                boolean delete = true;
                if (exceptions != null) {
                    for (String ignore : exceptions) {
                        if (!webapp.getName().equals(ignore)) continue;
                        delete = false;
                        break;
                    }
                }
                if (!delete) continue;
                org.apache.openejb.loader.Files.delete((File)webapp);
            }
        }
    }

    public static void configureServerXml(File tomeeHome, TomEEConfiguration configuration) throws IOException {
        if (configuration.getServerXml() != null) {
            File serverXml = new File(configuration.getServerXml());
            if (!serverXml.exists()) {
                LOGGER.severe("Provided server.xml doesn't exist: '" + serverXml.getPath() + "'");
            } else {
                String data = IO.slurp(serverXml);
                IO.copy(data.getBytes(), Files.path(tomeeHome, "conf", "server.xml"));
            }
        }
        Setup.updateServerXml(tomeeHome, configuration);
    }

    private static int ajpPort(TomEEConfiguration config) {
        try {
            Method ajbPort = config.getClass().getMethod("getAjpPort", new Class[0]);
            return (Integer)ajbPort.invoke((Object)config, new Object[0]);
        }
        catch (Exception e) {
            return Integer.parseInt("8009");
        }
    }

    public static void configureSystemProperties(File tomeeHome, TomEEConfiguration configuration) {
        File file = Files.path(tomeeHome, "conf", "system.properties");
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                IO.readProperties(file, properties);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Can't read " + file.getAbsolutePath(), e);
            }
        }
        if (configuration.getProperties() != null) {
            try {
                InputStream bytes = IO.read(configuration.getProperties().getBytes());
                IO.readProperties(bytes, properties);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Can't parse <property name=\"properties\"> value '" + configuration.getProperties() + "'", e);
            }
        }
        if (configuration.isQuickSession()) {
            properties.put("openejb.session.manager", "org.apache.tomee.catalina.session.QuickSessionManager");
        }
        if (configuration.isUnsafeEjbd() && "*".equals(properties.getProperty("tomee.serialization.class.blacklist", "-").trim())) {
            properties.remove("tomee.serialization.class.blacklist");
            properties.put("tomee.serialization.class.whitelist", "*");
            System.setProperty("tomee.serialization.class.blacklist", System.getProperty("tomee.serialization.class.blacklist", "-"));
            Setup.reloadClientSerializationConfig();
        }
        try {
            IO.writeProperties(file, properties);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can't save system properties " + file.getAbsolutePath(), e);
        }
    }

    public static void reloadClientSerializationConfig() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.apache.openejb.client.EjbObjectInputStream").getMethod("reloadResolverConfig", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static void synchronizeFolder(File tomeeHome, String src, String dir) {
        if (src != null && !src.isEmpty()) {
            File confSrc = new File(src);
            if (confSrc.exists()) {
                File conf = new File(tomeeHome, dir);
                List files = org.apache.openejb.loader.Files.collect((File)confSrc, (FileFilter)TrueFilter.INSTANCE);
                files.remove(confSrc);
                for (File f : files) {
                    if (f.equals(confSrc) || f.getName().startsWith(".")) continue;
                    String relativize = Setup.relativize(f, confSrc);
                    if (f.isDirectory()) {
                        String path = dir + '/' + relativize;
                        Files.mkdir(new File(tomeeHome, path));
                        Setup.synchronizeFolder(tomeeHome, f.getAbsolutePath(), path);
                        continue;
                    }
                    try {
                        File to = new File(conf, relativize);
                        Files.mkdir(to.getParentFile());
                        org.apache.openejb.loader.IO.copy((File)f, (File)to);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Ignoring copy of " + f.getAbsolutePath(), e);
                    }
                }
            } else {
                LOGGER.warning("Can't find " + confSrc.getAbsolutePath());
            }
        }
    }

    private static String relativize(File f, File base) {
        return f.getAbsolutePath().substring(base.getAbsolutePath().length() + 1);
    }

    public static void installArquillianBeanDiscoverer(File home) {
        File destination = new File(home, TOMEE_BEAN_DISCOVERER_JAR);
        ((ZipExporter)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)destination.getName())).addManifest()).addClasses(new Class[]{BeanDicovererInstaller.class, TestClassDiscoverer.class, ArquillianFilterRunner.class, Discover.class})).addAsManifestResource((Asset)new StringAsset(BeanDicovererInstaller.class.getName()), ArchivePaths.create((String)"org.apache.openejb.extension"))).as(ZipExporter.class)).exportTo(destination, false);
    }

    public static void removeArquillianBeanDiscoverer(File home) {
        File destination = new File(home, TOMEE_BEAN_DISCOVERER_JAR);
        Files.delete(destination);
    }

    public static Map<File, String> addTomEELibraries(File libFolder, String additionalLibs, boolean parseArgs) {
        if (additionalLibs == null) {
            return Collections.emptyMap();
        }
        String libs = additionalLibs.trim();
        if (libs.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            if (!SystemInstance.isInitialized()) {
                SystemInstance.init((Properties)new Properties());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        HashMap<File, String> configs = new HashMap<File, String>();
        for (String lib : libs.split("\n")) {
            String args;
            String trim = lib.trim();
            if (trim.isEmpty() || trim.startsWith("#")) continue;
            if (parseArgs) {
                int argsIdx = trim.indexOf(61);
                if (argsIdx < 0) {
                    argsIdx = trim.indexOf(63);
                }
                args = argsIdx > 0 ? trim.substring(argsIdx) : "";
            } else {
                args = null;
            }
            if (trim.startsWith("remove:")) {
                final String prefix = trim.substring("remove:".length());
                File[] children = libFolder.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(prefix);
                    }
                });
                if (children == null || children.length <= 0) continue;
                for (File child : children) {
                    if (IO.delete(child) || !child.getName().endsWith(".jar")) continue;
                    child.renameTo(new File(child.getParentFile(), child.getName() + "_renamed"));
                }
                continue;
            }
            Set locations = ProvisioningUtil.realLocation((String)trim);
            for (String location : locations) {
                File from = new File(location);
                try {
                    File to = new File(libFolder, from.getName());
                    org.apache.openejb.loader.IO.copy((File)from, (File)to);
                    if (args == null) continue;
                    configs.put(to, args);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return configs;
    }

    private static class TrueFilter
    implements FileFilter {
        private static final TrueFilter INSTANCE = new TrueFilter();

        private TrueFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return true;
        }
    }
}

