/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.tika.exception.CorruptedFileException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.metadata.Database;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.jdbc.JDBCTableReader;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

abstract class AbstractDBParser
extends AbstractParser {
    private static final byte[] EMPTY_BYTE_ARR = new byte[0];
    private Connection connection;

    AbstractDBParser() {
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        this.connection = this.getConnection(stream, metadata, context);
        XHTMLContentHandler xHandler = null;
        List<String> tableNames = null;
        EmbeddedDocumentUtil embeddedDocumentUtil = new EmbeddedDocumentUtil(context);
        try {
            tableNames = this.getTableNames(this.connection, metadata, context);
        }
        catch (SQLException e) {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (e.getClass().toString().contains("SQLiteException") && e.getMessage() != null && (e.getMessage().contains("[SQLITE_ERROR]") || e.getMessage().contains("[SQLITE_CORRUPT]"))) {
                throw new CorruptedFileException("Corrupt SQLITE", (Throwable)e);
            }
            throw new IOExceptionWithCause((Throwable)e);
        }
        for (String tableName : tableNames) {
            metadata.add(Database.TABLE_NAME, tableName);
        }
        xHandler = new XHTMLContentHandler(handler, metadata);
        xHandler.startDocument();
        try {
            for (String tableName : tableNames) {
                JDBCTableReader tableReader = this.getTableReader(this.connection, tableName, embeddedDocumentUtil);
                xHandler.startElement("table", "name", tableReader.getTableName());
                xHandler.startElement("thead");
                xHandler.startElement("tr");
                for (String header : tableReader.getHeaders()) {
                    xHandler.startElement("th");
                    xHandler.characters(header);
                    xHandler.endElement("th");
                }
                xHandler.endElement("tr");
                xHandler.endElement("thead");
                xHandler.startElement("tbody");
                while (tableReader.nextRow((ContentHandler)xHandler, context)) {
                }
                xHandler.endElement("tbody");
                xHandler.endElement("table");
            }
        }
        finally {
            try {
                this.close();
            }
            catch (IOException | SQLException exception) {}
            if (xHandler != null) {
                xHandler.endDocument();
            }
        }
    }

    protected void close() throws SQLException, IOException {
        this.connection.close();
    }

    protected Connection getConnection(InputStream stream, Metadata metadata, ParseContext context) throws IOException, TikaException {
        String connectionString = this.getConnectionString(stream, metadata, context);
        Connection connection = null;
        try {
            Class.forName(this.getJDBCClassName());
        }
        catch (ClassNotFoundException e) {
            throw new TikaException(e.getMessage());
        }
        try {
            connection = DriverManager.getConnection(connectionString);
        }
        catch (SQLException e) {
            throw new IOExceptionWithCause((Throwable)e);
        }
        return connection;
    }

    protected abstract String getConnectionString(InputStream var1, Metadata var2, ParseContext var3) throws IOException;

    protected abstract String getJDBCClassName();

    protected abstract List<String> getTableNames(Connection var1, Metadata var2, ParseContext var3) throws SQLException;

    @Deprecated
    protected abstract JDBCTableReader getTableReader(Connection var1, String var2, ParseContext var3);

    protected abstract JDBCTableReader getTableReader(Connection var1, String var2, EmbeddedDocumentUtil var3);
}

