/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.image.AbstractImageParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ImageParser
extends AbstractImageParser {
    private static final long serialVersionUID = 7852529269245520335L;
    private static final Logger LOG = LoggerFactory.getLogger(ImageParser.class);
    private static final MediaType MAIN_BMP_TYPE = MediaType.image((String)"bmp");
    private static final MediaType OLD_BMP_TYPE = MediaType.image((String)"x-ms-bmp");
    private static final Set<MediaType> TMP_SUPPORTED = new HashSet<MediaType>(Arrays.asList(MAIN_BMP_TYPE, OLD_BMP_TYPE, MediaType.image((String)"gif"), MediaType.image((String)"png"), MediaType.image((String)"vnd.wap.wbmp"), MediaType.image((String)"x-icon"), MediaType.image((String)"x-xcf"), MediaType.image((String)"x-jbig2")));
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(TMP_SUPPORTED);

    private static void setIfPresent(Metadata metadata, String imageIOkey, String tikaKey) {
        if (metadata.get(imageIOkey) != null) {
            metadata.set(tikaKey, metadata.get(imageIOkey));
        }
    }

    private static void setIfPresent(Metadata metadata, String imageIOkey, Property tikaProp) {
        if (metadata.get(imageIOkey) != null) {
            String v = metadata.get(imageIOkey);
            if (v.endsWith(" ")) {
                v = v.substring(0, v.lastIndexOf(32));
            }
            metadata.set(tikaProp, v);
        }
    }

    private static void loadMetadata(IIOMetadata imageMetadata, Metadata metadata) {
        if (imageMetadata == null) {
            return;
        }
        String[] names = imageMetadata.getMetadataFormatNames();
        if (names == null) {
            return;
        }
        for (String name : names) {
            ImageParser.loadNode(metadata, imageMetadata.getAsTree(name), "", false);
        }
    }

    private static void loadNode(Metadata metadata, Node node, String parents, boolean addThisNodeName) {
        NamedNodeMap map;
        if (addThisNodeName) {
            if (((String)parents).length() > 0) {
                parents = (String)parents + " ";
            }
            parents = (String)parents + node.getNodeName();
        }
        if ((map = node.getAttributes()) != null) {
            int length = map.getLength();
            if (length == 1) {
                metadata.add((String)parents, ImageParser.normalize(map.item(0).getNodeValue()));
            } else if (length > 1) {
                StringBuilder value = new StringBuilder();
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        value.append(", ");
                    }
                    Node attr = map.item(i);
                    value.append(attr.getNodeName());
                    value.append("=");
                    value.append(ImageParser.normalize(attr.getNodeValue()));
                }
                metadata.add((String)parents, value.toString());
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            ImageParser.loadNode(metadata, child, (String)parents, true);
        }
    }

    private static String normalize(String value) {
        value = value != null ? value.trim() : "";
        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
            return Boolean.TRUE.toString();
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(value)) {
            return Boolean.FALSE.toString();
        }
        return value;
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void extractMetadata(InputStream stream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        block17: {
            String type = metadata.get("Content-Type");
            if (type == null) {
                return;
            }
            try {
                Iterator<ImageReader> iterator = ImageIO.getImageReadersByMIMEType(type);
                if (iterator.hasNext()) {
                    ImageReader reader = iterator.next();
                    try (ImageInputStream imageStream = ImageIO.createImageInputStream(CloseShieldInputStream.wrap((InputStream)stream));){
                        reader.setInput(imageStream);
                        try {
                            int numImages = reader.getNumImages(true);
                            if (numImages > -1) {
                                metadata.set(TikaCoreProperties.NUM_IMAGES, numImages);
                            }
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        metadata.set(Metadata.IMAGE_WIDTH, Integer.toString(reader.getWidth(0)));
                        metadata.set(Metadata.IMAGE_LENGTH, Integer.toString(reader.getHeight(0)));
                        metadata.set("height", Integer.toString(reader.getHeight(0)));
                        metadata.set("width", Integer.toString(reader.getWidth(0)));
                        ImageParser.loadMetadata(reader.getImageMetadata(0), metadata);
                    }
                    finally {
                        reader.dispose();
                    }
                }
                ImageParser.setIfPresent(metadata, "CommentExtensions CommentExtension", TikaCoreProperties.COMMENTS);
                ImageParser.setIfPresent(metadata, "markerSequence com", TikaCoreProperties.COMMENTS);
                ImageParser.setIfPresent(metadata, "Data BitsPerSample", Metadata.BITS_PER_SAMPLE);
            }
            catch (IIOException e) {
                if (e.getMessage() != null && e.getMessage().equals("Unexpected block type 0!") && type.equals("image/gif")) break block17;
                throw new TikaException(type + " parse error", (Throwable)e);
            }
        }
    }

    @Override
    MediaType normalizeMediaType(MediaType mediaType) {
        if (mediaType == null) {
            return null;
        }
        if (OLD_BMP_TYPE.equals((Object)mediaType)) {
            return MAIN_BMP_TYPE;
        }
        return mediaType;
    }
}

