/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.TaskContext;
import org.apache.tez.runtime.library.api.Partitioner;
import org.apache.tez.runtime.library.common.combine.Combiner;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutput;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutputFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TezRuntimeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TezRuntimeUtils.class);

    public static String getTaskIdentifier(String vertexName, int taskIndex) {
        return String.format("%s_%06d", vertexName, taskIndex);
    }

    public static String getTaskAttemptIdentifier(int taskIndex, int taskAttemptNumber) {
        return String.format("%d_%d", taskIndex, taskAttemptNumber);
    }

    public static String getTaskAttemptIdentifier(String vertexName, int taskIndex, int taskAttemptNumber) {
        return String.format("%s_%06d_%02d", vertexName, taskIndex, taskAttemptNumber);
    }

    public static Combiner instantiateCombiner(Configuration conf, TaskContext taskContext) throws IOException {
        Class clazz;
        String className = conf.get("tez.runtime.combiner.class");
        if (className == null) {
            LOG.info("No combiner specified via tez.runtime.combiner.class. Combiner will not be used");
            return null;
        }
        LOG.info("Using Combiner class: " + className);
        try {
            clazz = conf.getClassByName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to load combiner class: " + className);
        }
        Combiner combiner = null;
        try {
            Constructor ctor = clazz.getConstructor(TaskContext.class);
            combiner = (Combiner)ctor.newInstance(taskContext);
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e);
        }
        return combiner;
    }

    public static Partitioner instantiatePartitioner(Configuration conf) throws IOException {
        Class clazz;
        try {
            clazz = conf.getClassByName(conf.get("tez.runtime.partitioner.class"));
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to find Partitioner class specified in config : " + conf.get("tez.runtime.partitioner.class"), e);
        }
        LOG.info("Using partitioner class: " + clazz.getName());
        Partitioner partitioner = null;
        try {
            Constructor ctorWithConf = clazz.getConstructor(Configuration.class);
            partitioner = (Partitioner)ctorWithConf.newInstance(conf);
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
        catch (NoSuchMethodException e) {
            try {
                partitioner = (Partitioner)clazz.newInstance();
            }
            catch (InstantiationException e1) {
                throw new IOException(e1);
            }
            catch (IllegalAccessException e1) {
                throw new IOException(e1);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e);
        }
        return partitioner;
    }

    public static TezTaskOutput instantiateTaskOutputManager(Configuration conf, OutputContext outputContext) {
        Class clazz = conf.getClass("tez.runtime.task.local.output.manager", TezTaskOutputFiles.class);
        try {
            Constructor ctor = clazz.getConstructor(Configuration.class, String.class);
            ctor.setAccessible(true);
            TezTaskOutput instance = (TezTaskOutput)ctor.newInstance(conf, outputContext.getUniqueIdentifier());
            return instance;
        }
        catch (Exception e) {
            throw new TezUncheckedException("Unable to instantiate configured TezOutputFileManager: " + conf.get("tez.runtime.task.local.output.manager", TezTaskOutputFiles.class.getName()), (Throwable)e);
        }
    }
}

