/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.rm.TaskSchedulerAppCallbackWrapper;
import org.apache.tez.dag.app.rm.TaskSchedulerService;
import org.apache.tez.dag.app.rm.container.ContainerSignatureMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTaskSchedulerService
extends TaskSchedulerService {
    private static final Logger LOG = LoggerFactory.getLogger(LocalTaskSchedulerService.class);
    final TaskSchedulerService.TaskSchedulerAppCallback realAppClient;
    final TaskSchedulerService.TaskSchedulerAppCallback appClientDelegate;
    final ContainerSignatureMatcher containerSignatureMatcher;
    final PriorityBlockingQueue<TaskRequest> taskRequestQueue;
    AsyncDelegateRequestHandler taskRequestHandler;
    Thread asyncDelegateRequestThread;
    final ExecutorService appCallbackExecutor;
    final HashMap<Object, Container> taskAllocations;
    final String appHostName;
    final int appHostPort;
    final String appTrackingUrl;
    final AppContext appContext;

    public LocalTaskSchedulerService(TaskSchedulerService.TaskSchedulerAppCallback appClient, ContainerSignatureMatcher containerSignatureMatcher, String appHostName, int appHostPort, String appTrackingUrl, AppContext appContext) {
        super(LocalTaskSchedulerService.class.getName());
        this.realAppClient = appClient;
        this.appCallbackExecutor = this.createAppCallbackExecutorService();
        this.containerSignatureMatcher = containerSignatureMatcher;
        this.appClientDelegate = this.createAppCallbackDelegate(appClient);
        this.appHostName = appHostName;
        this.appHostPort = appHostPort;
        this.appTrackingUrl = appTrackingUrl;
        this.appContext = appContext;
        this.taskRequestQueue = new PriorityBlockingQueue();
        this.taskAllocations = new LinkedHashMap<Object, Container>();
    }

    private ExecutorService createAppCallbackExecutorService() {
        return Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("TaskSchedulerAppCaller #%d").setDaemon(true).build());
    }

    private TaskSchedulerService.TaskSchedulerAppCallback createAppCallbackDelegate(TaskSchedulerService.TaskSchedulerAppCallback realAppClient) {
        return new TaskSchedulerAppCallbackWrapper(realAppClient, this.appCallbackExecutor);
    }

    @Override
    public Resource getAvailableResources() {
        long memory = Runtime.getRuntime().freeMemory();
        int cores = Runtime.getRuntime().availableProcessors();
        return LocalTaskSchedulerService.createResource(memory, cores);
    }

    static Resource createResource(long runtimeMemory, int core) {
        if (runtimeMemory < 0L || core < 0) {
            throw new IllegalArgumentException("Negative Memory or Core provided!mem: " + runtimeMemory + " core:" + core);
        }
        return Resource.newInstance((int)Ints.checkedCast((long)(runtimeMemory / 0x100000L)), (int)core);
    }

    @Override
    public int getClusterNodeCount() {
        return 1;
    }

    @Override
    public void dagComplete() {
    }

    @Override
    public Resource getTotalResources() {
        long memory = Runtime.getRuntime().maxMemory();
        int cores = Runtime.getRuntime().availableProcessors();
        return LocalTaskSchedulerService.createResource(memory, cores);
    }

    @Override
    public void blacklistNode(NodeId nodeId) {
    }

    @Override
    public void unblacklistNode(NodeId nodeId) {
    }

    @Override
    public void allocateTask(Object task, Resource capability, String[] hosts, String[] racks, Priority priority, Object containerSignature, Object clientCookie) {
        this.taskRequestHandler.addAllocateTaskRequest(task, capability, priority, clientCookie);
    }

    @Override
    public synchronized void allocateTask(Object task, Resource capability, ContainerId containerId, Priority priority, Object containerSignature, Object clientCookie) {
        this.taskRequestHandler.addAllocateTaskRequest(task, capability, priority, clientCookie);
    }

    @Override
    public boolean deallocateTask(Object task, boolean taskSucceeded) {
        return this.taskRequestHandler.addDeallocateTaskRequest(task);
    }

    @Override
    public Object deallocateContainer(ContainerId containerId) {
        return null;
    }

    public void serviceInit(Configuration conf) {
        this.taskRequestHandler = this.createRequestHandler(conf);
        this.asyncDelegateRequestThread = new Thread(this.taskRequestHandler);
        this.asyncDelegateRequestThread.setDaemon(true);
    }

    protected AsyncDelegateRequestHandler createRequestHandler(Configuration conf) {
        return new AsyncDelegateRequestHandler(this.taskRequestQueue, new LocalContainerFactory(this.appContext), this.taskAllocations, this.appClientDelegate, conf);
    }

    public void serviceStart() {
        this.asyncDelegateRequestThread.start();
    }

    public void serviceStop() throws InterruptedException {
        if (this.asyncDelegateRequestThread != null) {
            this.asyncDelegateRequestThread.interrupt();
        }
        this.appCallbackExecutor.shutdownNow();
        this.appCallbackExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setShouldUnregister() {
    }

    @Override
    public boolean hasUnregistered() {
        return true;
    }

    static class AsyncDelegateRequestHandler
    implements Runnable {
        final BlockingQueue<TaskRequest> taskRequestQueue;
        final LocalContainerFactory localContainerFactory;
        final HashMap<Object, Container> taskAllocations;
        final TaskSchedulerService.TaskSchedulerAppCallback appClientDelegate;
        final int MAX_TASKS;

        AsyncDelegateRequestHandler(BlockingQueue<TaskRequest> taskRequestQueue, LocalContainerFactory localContainerFactory, HashMap<Object, Container> taskAllocations, TaskSchedulerService.TaskSchedulerAppCallback appClientDelegate, Configuration conf) {
            this.taskRequestQueue = taskRequestQueue;
            this.localContainerFactory = localContainerFactory;
            this.taskAllocations = taskAllocations;
            this.appClientDelegate = appClientDelegate;
            this.MAX_TASKS = conf.getInt("tez.am.inline.task.execution.max-tasks", 1);
        }

        public void addAllocateTaskRequest(Object task, Resource capability, Priority priority, Object clientCookie) {
            try {
                this.taskRequestQueue.put(new AllocateTaskRequest(task, capability, priority, clientCookie));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addDeallocateTaskRequest(Object task) {
            try {
                this.taskRequestQueue.put(new DeallocateTaskRequest(task));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            BlockingQueue<TaskRequest> blockingQueue = this.taskRequestQueue;
            synchronized (blockingQueue) {
                this.taskRequestQueue.notify();
            }
            return true;
        }

        boolean shouldWait() {
            return this.taskAllocations.size() >= this.MAX_TASKS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                BlockingQueue<TaskRequest> blockingQueue = this.taskRequestQueue;
                synchronized (blockingQueue) {
                    try {
                        if (this.shouldWait()) {
                            this.taskRequestQueue.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.processRequest();
            }
        }

        void processRequest() {
            try {
                TaskRequest request = this.taskRequestQueue.take();
                if (request instanceof AllocateTaskRequest) {
                    this.allocateTask((AllocateTaskRequest)request);
                } else if (request instanceof DeallocateTaskRequest) {
                    this.deallocateTask((DeallocateTaskRequest)request);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (NullPointerException e) {
                LOG.warn("Task request was badly constructed");
            }
        }

        void allocateTask(AllocateTaskRequest request) {
            Container container = this.localContainerFactory.createContainer(request.capability, request.priority);
            this.taskAllocations.put(request.task, container);
            this.appClientDelegate.taskAllocated(request.task, request.clientCookie, container);
        }

        void deallocateTask(DeallocateTaskRequest request) {
            Container container = this.taskAllocations.remove(request.task);
            if (container != null) {
                this.appClientDelegate.containerBeingReleased(container.getId());
            } else {
                boolean deallocationBeforeAllocation = false;
                Iterator iter = this.taskRequestQueue.iterator();
                while (iter.hasNext()) {
                    TaskRequest taskRequest = (TaskRequest)iter.next();
                    if (!(taskRequest instanceof AllocateTaskRequest) || !taskRequest.task.equals(request.task)) continue;
                    iter.remove();
                    deallocationBeforeAllocation = true;
                    LOG.info("deallcation happen before allocation for task:" + request.task);
                    break;
                }
                if (!deallocationBeforeAllocation) {
                    throw new TezUncheckedException("Unable to find and remove task " + request.task + " from task allocations");
                }
            }
        }
    }

    static class DeallocateTaskRequest
    extends TaskRequest {
        static final Priority DEALLOCATE_PRIORITY = Priority.newInstance((int)-2);

        public DeallocateTaskRequest(Object task) {
            super(task, DEALLOCATE_PRIORITY);
        }
    }

    static class AllocateTaskRequest
    extends TaskRequest {
        Resource capability;
        Object clientCookie;

        public AllocateTaskRequest(Object task, Resource capability, Priority priority, Object clientCookie) {
            super(task, priority);
            this.capability = capability;
            this.clientCookie = clientCookie;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AllocateTaskRequest that = (AllocateTaskRequest)o;
            if (this.capability != null ? !this.capability.equals((Object)that.capability) : that.capability != null) {
                return false;
            }
            return !(this.clientCookie != null ? !this.clientCookie.equals(that.clientCookie) : that.clientCookie != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 12329 * result + (this.capability != null ? this.capability.hashCode() : 0);
            result = 12329 * result + (this.clientCookie != null ? this.clientCookie.hashCode() : 0);
            return result;
        }
    }

    static class TaskRequest
    implements Comparable<TaskRequest> {
        static final int HIGHEST_PRIORITY = -2;
        Object task;
        Priority priority;

        public TaskRequest(Object task, Priority priority) {
            this.task = task;
            this.priority = priority;
        }

        @Override
        public int compareTo(TaskRequest request) {
            return request.priority.compareTo(this.priority);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskRequest that = (TaskRequest)o;
            if (this.priority != null ? !this.priority.equals((Object)that.priority) : that.priority != null) {
                return false;
            }
            return !(this.task != null ? !this.task.equals(that.task) : that.task != null);
        }

        public int hashCode() {
            int result = 1;
            result = 7841 * result + (this.task != null ? this.task.hashCode() : 0);
            result = 7841 * result + (this.priority != null ? this.priority.hashCode() : 0);
            return result;
        }
    }

    static class LocalContainerFactory {
        final AppContext appContext;
        AtomicInteger nextId;

        public LocalContainerFactory(AppContext appContext) {
            this.appContext = appContext;
            this.nextId = new AtomicInteger(1);
        }

        public Container createContainer(Resource capability, Priority priority) {
            ApplicationAttemptId appAttemptId = this.appContext.getApplicationAttemptId();
            ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)this.nextId.getAndIncrement());
            NodeId nodeId = NodeId.newInstance((String)"127.0.0.1", (int)0);
            String nodeHttpAddress = "127.0.0.1:0";
            Container container = Container.newInstance((ContainerId)containerId, (NodeId)nodeId, (String)nodeHttpAddress, (Resource)capability, (Priority)priority, null);
            return container;
        }
    }
}

