/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.CreateStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.MergeShardsRequest;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.SplitShardRequest;
import com.amazonaws.services.kinesis.model.StreamDescription;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.kinesis.KinesisDataGenerator;
import org.apache.spark.streaming.kinesis.KinesisTestUtils$;
import org.apache.spark.streaming.kinesis.SimpleDataGenerator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t}a!B\u00181\u0001AR\u0004\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u000b1\u0003A\u0011A'\t\u000fE\u0003!\u0019!C\u0001%\"1a\f\u0001Q\u0001\nMCqa\u0018\u0001C\u0002\u0013\u0005!\u000b\u0003\u0004a\u0001\u0001\u0006Ia\u0015\u0005\bC\u0002\u0011\r\u0011\"\u0003c\u0011\u0019\u0019\u0007\u0001)A\u0005\u0013\"9A\r\u0001b\u0001\n\u0013\u0011\u0007BB3\u0001A\u0003%\u0011\nC\u0004g\u0001\u0001\u0007I\u0011B4\t\u000f-\u0004\u0001\u0019!C\u0005Y\"1!\u000f\u0001Q!\n!D\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002*\t\u0013a\u0004\u0001\u0019!a\u0001\n\u0013I\b\"C>\u0001\u0001\u0004\u0005\t\u0015)\u0003T\u0011!i\b\u0001#b\u0001\n#q\bBCA\u000b\u0001!\u0015\r\u0011\"\u0003\u0002\u0018!9\u0011\u0011\u0006\u0001\u0005\u0012\u0005-\u0002BBA\u001c\u0001\u0011\u0005!\u000bC\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003g\u0002A\u0011AA;\u0011\u001d\t\u0019\b\u0001C\u0001\u0003\u001bCq!!)\u0001\t\u0003\tY\u0004C\u0004\u0002$\u0002!\t!!*\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\"9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0007bBAb\u0001\u0011%\u0011QY\u0004\t\u0003\u0017\u0004\u0004\u0012\u0001\u0019\u0002N\u001a9q\u0006\rE\u0001a\u0005=\u0007B\u0002'\"\t\u0003\t\t\u000eC\u0005\u0002T\u0006\u0012\r\u0011\"\u0001\u0002V\"A\u0011\u0011]\u0011!\u0002\u0013\t9\u000eC\u0005\u0002d\u0006\u0012\r\u0011\"\u0001\u0002V\"A\u0011Q]\u0011!\u0002\u0013\t9\u000eC\u0005\u0002h\u0006\u0012\r\u0011\"\u0001\u0002V\"A\u0011\u0011^\u0011!\u0002\u0013\t9\u000eC\u0004\u0002l\u0006\"\t!!<\t\u0013\u0005M\u0018\u0005#b\u0001\n\u00039\u0007\u0002C)\"\u0011\u000b\u0007I\u0011\u0001*\t\r\u0005U\u0018\u0005\"\u0001h\u0011\u001d\t90\tC\u0001\u0003sD\u0011Ba\u0002\"#\u0003%\tA!\u0003\u0003!-Kg.Z:jgR+7\u000f^+uS2\u001c(BA\u00193\u0003\u001dY\u0017N\\3tSNT!a\r\u001b\u0002\u0013M$(/Z1nS:<'BA\u001b7\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0004(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002s\u0005\u0019qN]4\u0014\u0007\u0001Y\u0014\t\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tR\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\r\u000e\u0013q\u0001T8hO&tw-\u0001\ttiJ,\u0017-\\*iCJ$7i\\;oi\u000e\u0001\u0001C\u0001\u001fK\u0013\tYUHA\u0002J]R\fa\u0001P5oSRtDC\u0001(Q!\ty\u0005!D\u00011\u0011\u001d9%\u0001%AA\u0002%\u000b1\"\u001a8ea>Lg\u000e^+sYV\t1\u000b\u0005\u0002U7:\u0011Q+\u0017\t\u0003-vj\u0011a\u0016\u0006\u00031\"\u000ba\u0001\u0010:p_Rt\u0014B\u0001.>\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ik\u0014\u0001D3oIB|\u0017N\u001c;Ve2\u0004\u0013A\u0003:fO&|gNT1nK\u0006Y!/Z4j_:t\u0015-\\3!\u0003i\u0019'/Z1uKN#(/Z1n)&lWm\\;u'\u0016\u001cwN\u001c3t+\u0005I\u0015aG2sK\u0006$Xm\u0015;sK\u0006lG+[7f_V$8+Z2p]\u0012\u001c\b%A\u000feKN\u001c'/\u001b2f'R\u0014X-Y7Q_2dG+[7f'\u0016\u001cwN\u001c3t\u0003y!Wm]2sS\n,7\u000b\u001e:fC6\u0004v\u000e\u001c7US6,7+Z2p]\u0012\u001c\b%A\u0007tiJ,\u0017-\\\"sK\u0006$X\rZ\u000b\u0002QB\u0011A([\u0005\u0003Uv\u0012qAQ8pY\u0016\fg.A\ttiJ,\u0017-\\\"sK\u0006$X\rZ0%KF$\"!\u001c9\u0011\u0005qr\u0017BA8>\u0005\u0011)f.\u001b;\t\u000fEd\u0011\u0011!a\u0001Q\u0006\u0019\u0001\u0010J\u0019\u0002\u001dM$(/Z1n\u0007J,\u0017\r^3eA!\u0012Q\u0002\u001e\t\u0003yUL!A^\u001f\u0003\u0011Y|G.\u0019;jY\u0016\f1bX:ue\u0016\fWNT1nK\u0006yql\u001d;sK\u0006lg*Y7f?\u0012*\u0017\u000f\u0006\u0002nu\"9\u0011oDA\u0001\u0002\u0004\u0019\u0016\u0001D0tiJ,\u0017-\u001c(b[\u0016\u0004\u0003F\u0001\tu\u00035Y\u0017N\\3tSN\u001cE.[3oiV\tq\u0010\u0005\u0003\u0002\u0002\u0005EQBAA\u0002\u0015\r\t\u0014Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0005tKJ4\u0018nY3t\u0015\u0011\tY!!\u0004\u0002\u0013\u0005l\u0017M_8oC^\u001c(BAA\b\u0003\r\u0019w.\\\u0005\u0005\u0003'\t\u0019AA\nB[\u0006TxN\\&j]\u0016\u001c\u0018n]\"mS\u0016tG/\u0001\u0005es:\fWn\u001c#C+\t\tI\u0002\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\u0011\u0011|7-^7f]RTA!a\t\u0002\u0006\u0005QA-\u001f8b[>$'M\u001e\u001a\n\t\u0005\u001d\u0012Q\u0004\u0002\t\tft\u0017-\\8E\u0005\u0006Yq-\u001a;Qe>$WoY3s)\u0011\ti#a\r\u0011\u0007=\u000by#C\u0002\u00022A\u0012AcS5oKNL7\u000fR1uC\u001e+g.\u001a:bi>\u0014\bBBA\u001b'\u0001\u0007\u0001.A\u0005bO\u001e\u0014XmZ1uK\u0006Q1\u000f\u001e:fC6t\u0015-\\3\u0002\u0019\r\u0014X-\u0019;f'R\u0014X-Y7\u0015\u00035\f\u0011bZ3u'\"\f'\u000fZ:\u0015\u0005\u0005\u0005\u0003CBA\"\u0003\u001b\n\u0019F\u0004\u0003\u0002F\u0005%cb\u0001,\u0002H%\ta(C\u0002\u0002Lu\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002P\u0005E#aA*fc*\u0019\u00111J\u001f\u0011\t\u0005U\u00131L\u0007\u0003\u0003/RA!!\u0017\u0002\u0004\u0005)Qn\u001c3fY&!\u0011QLA,\u0005\u0015\u0019\u0006.\u0019:e\u0003)\u0019\b\u000f\\5u'\"\f'\u000f\u001a\u000b\u0004[\u0006\r\u0004BBA3/\u0001\u00071+A\u0004tQ\u0006\u0014H-\u00133\u0002\u00155,'oZ3TQ\u0006\u0014H\rF\u0003n\u0003W\ny\u0007\u0003\u0004\u0002na\u0001\raU\u0001\rg\"\f'\u000f\u001a+p\u001b\u0016\u0014x-\u001a\u0005\u0007\u0003cB\u0002\u0019A*\u0002)\u0005$'.Y2f]R\u001c\u0006.\u0019:e)>lUM]4f\u0003!\u0001Xo\u001d5ECR\fGCBA<\u0003\u000b\u000bY\t\u0005\u0004U\u0003s\u001a\u0016QP\u0005\u0004\u0003wj&aA'baB1\u00111IA'\u0003\u007f\u0002R\u0001PAA\u0013NK1!a!>\u0005\u0019!V\u000f\u001d7fe!9\u0011qQ\rA\u0002\u0005%\u0015\u0001\u0003;fgR$\u0015\r^1\u0011\u000b\u0005\r\u0013QJ%\t\r\u0005U\u0012\u00041\u0001i)\ri\u0017q\u0012\u0005\b\u0003\u000fS\u0002\u0019AAI!\u0015\t\u0019*!(J\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006e\u0015\u0001B;uS2T!!a'\u0002\t)\fg/Y\u0005\u0005\u0003?\u000b)J\u0001\u0003MSN$\u0018\u0001\u00043fY\u0016$Xm\u0015;sK\u0006l\u0017a\u00053fY\u0016$X\rR=oC6|GI\u0011+bE2,GcA7\u0002(\"1\u0011\u0011\u0016\u000fA\u0002M\u000b\u0011\u0002^1cY\u0016t\u0015-\\3\u0002\u001d\u0011,7o\u0019:jE\u0016\u001cFO]3b[R!\u0011qVA^!\u0015a\u0014\u0011WA[\u0013\r\t\u0019,\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005U\u0013qW\u0005\u0005\u0003s\u000b9FA\tTiJ,\u0017-\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:Da!!0\u001e\u0001\u0004\u0019\u0016\u0001F:ue\u0016\fWNT1nKR{G)Z:de&\u0014W-A\rgS:$gj\u001c8Fq&\u001cH/\u001a8u'R\u0014X-Y7OC6,G#A*\u0002/]\f\u0017\u000e\u001e$peN#(/Z1n)>\u0014U-Q2uSZ,GcA7\u0002H\"1\u0011\u0011Z\u0010A\u0002M\u000b1c\u001d;sK\u0006lg*Y7f)><\u0016-\u001b;G_J\f\u0001cS5oKNL7\u000fV3tiV#\u0018\u000e\\:\u0011\u0005=\u000b3CA\u0011<)\t\ti-\u0001\u000ef]Z4\u0016M\u001d(b[\u00164uN]#oC\nd\u0017N\\4UKN$8/\u0006\u0002\u0002XB!\u0011\u0011\\Ap\u001b\t\tYN\u0003\u0003\u0002^\u0006e\u0015\u0001\u00027b]\u001eL1\u0001XAn\u0003m)gN\u001e,be:\u000bW.\u001a$pe\u0016s\u0017M\u00197j]\u001e$Vm\u001d;tA\u0005)RM\u001c3WCJt\u0015-\\3G_J,e\u000e\u001a9pS:$\u0018AF3oIZ\u000b'OT1nK\u001a{'/\u00128ea>Lg\u000e\u001e\u0011\u0002%\u0011,g-Y;mi\u0016sG\r]8j]R,&\u000f\\\u0001\u0014I\u00164\u0017-\u001e7u\u000b:$\u0007o\\5oiV\u0013H\u000eI\u0001\u0018O\u0016$(+Z4j_:t\u0015-\\3Cs\u0016sG\r]8j]R$2aUAx\u0011\u0019\t\t0\u000ba\u0001'\u0006AQM\u001c3q_&tG/\u0001\btQ>,H\u000e\u001a*v]R+7\u000f^:\u0002/%\u001c\u0018iV*De\u0016$WM\u001c;jC2\u001c\bK]3tK:$\u0018!E4fi\u0006;6k\u0011:fI\u0016tG/[1mgR\u0011\u00111 \t\u0005\u0003{\u0014\u0019!\u0004\u0002\u0002\u0000*!!\u0011AA\u0005\u0003\u0011\tW\u000f\u001e5\n\t\t\u0015\u0011q \u0002\u000f\u0003^\u001b6I]3eK:$\u0018.\u00197t\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u0002\u0016\u0004\u0013\n51F\u0001B\b!\u0011\u0011\tBa\u0007\u000e\u0005\tM!\u0002\u0002B\u000b\u0005/\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\teQ(\u0001\u0006b]:|G/\u0019;j_:LAA!\b\u0003\u0014\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class KinesisTestUtils
implements Logging {
    private AmazonKinesisClient kinesisClient;
    private DynamoDB dynamoDB;
    private final int streamShardCount;
    private final String endpointUrl;
    private final String regionName;
    private final int createStreamTimeoutSeconds;
    private final int describeStreamPollTimeSeconds;
    private volatile boolean streamCreated;
    private volatile String _streamName;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static int $lessinit$greater$default$1() {
        return KinesisTestUtils$.MODULE$.$lessinit$greater$default$1();
    }

    public static AWSCredentials getAWSCredentials() {
        return KinesisTestUtils$.MODULE$.getAWSCredentials();
    }

    public static boolean isAWSCredentialsPresent() {
        return KinesisTestUtils$.MODULE$.isAWSCredentialsPresent();
    }

    public static boolean shouldRunTests() {
        return KinesisTestUtils$.MODULE$.shouldRunTests();
    }

    public static String getRegionNameByEndpoint(String string) {
        return KinesisTestUtils$.MODULE$.getRegionNameByEndpoint(string);
    }

    public static String defaultEndpointUrl() {
        return KinesisTestUtils$.MODULE$.defaultEndpointUrl();
    }

    public static String endVarNameForEndpoint() {
        return KinesisTestUtils$.MODULE$.endVarNameForEndpoint();
    }

    public static String envVarNameForEnablingTests() {
        return KinesisTestUtils$.MODULE$.envVarNameForEnablingTests();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String endpointUrl() {
        return this.endpointUrl;
    }

    public String regionName() {
        return this.regionName;
    }

    private int createStreamTimeoutSeconds() {
        return this.createStreamTimeoutSeconds;
    }

    private int describeStreamPollTimeSeconds() {
        return this.describeStreamPollTimeSeconds;
    }

    private boolean streamCreated() {
        return this.streamCreated;
    }

    private void streamCreated_$eq(boolean x$1) {
        this.streamCreated = x$1;
    }

    private String _streamName() {
        return this._streamName;
    }

    private void _streamName_$eq(String x$1) {
        this._streamName = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private AmazonKinesisClient kinesisClient$lzycompute() {
        KinesisTestUtils kinesisTestUtils = this;
        synchronized (kinesisTestUtils) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                AmazonKinesisClient client = new AmazonKinesisClient(KinesisTestUtils$.MODULE$.getAWSCredentials());
                client.setEndpoint(this.endpointUrl());
                this.kinesisClient = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.kinesisClient;
    }

    public AmazonKinesisClient kinesisClient() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.kinesisClient$lzycompute();
        }
        return this.kinesisClient;
    }

    private DynamoDB dynamoDB$lzycompute() {
        KinesisTestUtils kinesisTestUtils = this;
        synchronized (kinesisTestUtils) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                AmazonDynamoDBClient dynamoDBClient = new AmazonDynamoDBClient((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
                dynamoDBClient.setRegion(RegionUtils.getRegion((String)this.regionName()));
                this.dynamoDB = new DynamoDB((AmazonDynamoDB)dynamoDBClient);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dynamoDB;
    }

    private DynamoDB dynamoDB() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.dynamoDB$lzycompute();
        }
        return this.dynamoDB;
    }

    public KinesisDataGenerator getProducer(boolean aggregate) {
        if (!aggregate) {
            return new SimpleDataGenerator(this.kinesisClient());
        }
        throw new UnsupportedOperationException("Aggregation is not supported through this code path");
    }

    public String streamName() {
        Predef$.MODULE$.require(this.streamCreated(), (Function0 & Serializable & scala.Serializable)() -> "Stream not yet created, call createStream() to create one");
        return this._streamName();
    }

    public void createStream() {
        Predef$.MODULE$.require(!this.streamCreated(), (Function0 & Serializable & scala.Serializable)() -> "Stream already created");
        this._streamName_$eq(this.findNonExistentStreamName());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Creating stream ").append(this._streamName()).toString());
        CreateStreamRequest createStreamRequest = new CreateStreamRequest();
        createStreamRequest.setStreamName(this._streamName());
        createStreamRequest.setShardCount(Predef$.MODULE$.int2Integer(this.streamShardCount));
        this.kinesisClient().createStream(createStreamRequest);
        this.waitForStreamToBeActive(this._streamName());
        this.streamCreated_$eq(true);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Created stream ").append(this._streamName()).toString());
    }

    public Seq<Shard> getShards() {
        return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.kinesisClient().describeStream(this._streamName()).getStreamDescription().getShards()).asScala()).toSeq();
    }

    public void splitShard(String shardId) {
        SplitShardRequest splitShardRequest = new SplitShardRequest();
        splitShardRequest.withStreamName(this._streamName());
        splitShardRequest.withShardToSplit(shardId);
        splitShardRequest.withNewStartingHashKey("170141183460469231731687303715884105728");
        this.kinesisClient().splitShard(splitShardRequest);
        this.waitForStreamToBeActive(this._streamName());
    }

    public void mergeShard(String shardToMerge, String adjacentShardToMerge) {
        MergeShardsRequest mergeShardRequest = new MergeShardsRequest();
        mergeShardRequest.withStreamName(this._streamName());
        mergeShardRequest.withShardToMerge(shardToMerge);
        mergeShardRequest.withAdjacentShardToMerge(adjacentShardToMerge);
        this.kinesisClient().mergeShards(mergeShardRequest);
        this.waitForStreamToBeActive(this._streamName());
    }

    public Map<String, Seq<Tuple2<Object, String>>> pushData(Seq<Object> testData, boolean aggregate) {
        Predef$.MODULE$.require(this.streamCreated(), (Function0 & Serializable & scala.Serializable)() -> "Stream not yet created, call createStream() to create one");
        KinesisDataGenerator producer = this.getProducer(aggregate);
        Map<String, Seq<Tuple2<Object, String>>> shardIdToSeqNumbers = producer.sendData(this.streamName(), testData);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Pushed ").append(testData).append(":\n\t ").append(shardIdToSeqNumbers.mkString("\n\t")).toString());
        return shardIdToSeqNumbers.toMap(Predef$.MODULE$.$conforms());
    }

    public void pushData(List<Object> testData) {
        this.pushData((Seq<Object>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(testData).asScala()).toSeq(), false);
    }

    public void deleteStream() {
        try {
            if (this.streamCreated()) {
                this.kinesisClient().deleteStream(this.streamName());
            }
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Could not delete stream ").append(this.streamName()).toString());
        }
    }

    public void deleteDynamoDBTable(String tableName) {
        try {
            Table table = this.dynamoDB().getTable(tableName);
            table.delete();
            table.waitForDelete();
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Could not delete DynamoDB table ").append(tableName).toString());
        }
    }

    private Option<StreamDescription> describeStream(String streamNameToDescribe) {
        None$ none$;
        try {
            DescribeStreamRequest describeStreamRequest = new DescribeStreamRequest().withStreamName(streamNameToDescribe);
            StreamDescription desc = this.kinesisClient().describeStream(describeStreamRequest).getStreamDescription();
            none$ = new Some((Object)desc);
        }
        catch (ResourceNotFoundException rnfe) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private String findNonExistentStreamName() {
        String testStreamName = null;
        do {
            Thread.sleep(TimeUnit.SECONDS.toMillis(this.describeStreamPollTimeSeconds()));
            testStreamName = new StringBuilder(17).append("KinesisTestUtils-").append(package$.MODULE$.abs(Random$.MODULE$.nextLong())).toString();
        } while (this.describeStream(testStreamName).nonEmpty());
        return testStreamName;
    }

    private void waitForStreamToBeActive(String streamNameToWaitFor) {
        Object object = new Object();
        try {
            long startTimeNs = System.nanoTime();
            while (System.nanoTime() - startTimeNs < TimeUnit.SECONDS.toNanos(this.createStreamTimeoutSeconds())) {
                Thread.sleep(TimeUnit.SECONDS.toMillis(this.describeStreamPollTimeSeconds()));
                this.describeStream(streamNameToWaitFor).foreach((Function1 & Serializable & scala.Serializable)description -> {
                    KinesisTestUtils.$anonfun$waitForStreamToBeActive$1(this, object, description);
                    return BoxedUnit.UNIT;
                });
            }
            Predef$.MODULE$.require(false, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Stream ").append(this.streamName()).append(" never became active").toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ void $anonfun$waitForStreamToBeActive$1(KinesisTestUtils $this, Object nonLocalReturnKey1$1, StreamDescription description) {
        String streamStatus = description.getStreamStatus();
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("\t- current state: ").append(streamStatus).append("\n").toString());
        if ("ACTIVE".equals(streamStatus)) {
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    public KinesisTestUtils(int streamShardCount) {
        this.streamShardCount = streamShardCount;
        Logging.$init$((Logging)this);
        this.endpointUrl = KinesisTestUtils$.MODULE$.endpointUrl();
        this.regionName = KinesisTestUtils$.MODULE$.getRegionNameByEndpoint(this.endpointUrl());
        this.createStreamTimeoutSeconds = 300;
        this.describeStreamPollTimeSeconds = 1;
        this.streamCreated = false;
    }
}

