/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.api.java.function.VoidFunction2;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.CreateTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.TableSpec;
import org.apache.spark.sql.catalyst.streaming.InternalOutputModes$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.catalog.V2TableWithV1Fallback;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.sources.ForeachBatchSink;
import org.apache.spark.sql.execution.streaming.sources.ForeachWriterTable;
import org.apache.spark.sql.execution.streaming.sources.ForeachWriterTable$;
import org.apache.spark.sql.execution.streaming.sources.MemoryPlan;
import org.apache.spark.sql.execution.streaming.sources.MemorySink;
import org.apache.spark.sql.streaming.DataStreamWriter$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\r5f\u0001\u0002&L\u0005YC\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\u0007]\u0002!\t!T8\t\u000fM\u0004!\u0019!C\u0005i\"1A\u0010\u0001Q\u0001\nUDQ! \u0001\u0005\u0002yDa! \u0001\u0005\u0002\u0005\u001d\u0001bBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kAq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002X\u0001!\t!!\u0017\t\u000f\u0005]\u0003\u0001\"\u0001\u0002d!9\u0011q\u000b\u0001\u0005\u0002\u0005=\u0004bBA,\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\t9\t\u0001C\u0001\u00033Cq!a+\u0001\t\u0003\ti\u000bC\u0004\u0002,\u0002!\t!!/\t\u000f\u0005m\b\u0001\"\u0001\u0002~\"9!1\u0004\u0001\u0005\n\tu\u0001\"\u0003B\u001f\u0001E\u0005I\u0011\u0002B \u0011\u001d\u0011\t\u0006\u0001C\u0005\u0005'B\u0011Ba%\u0001#\u0003%IA!&\t\u0013\te\u0005!%A\u0005\n\tm\u0005\"\u0003BP\u0001E\u0005I\u0011\u0002B \u0011\u001d\u0011\t\u000b\u0001C\u0005\u0005GCqAa.\u0001\t\u0003\u0011I\fC\u0004\u0003F\u0002!\tAa2\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003\\\"9!1 \u0001\u0005\n\tu\bbBB\u0007\u0001\u0011%1q\u0002\u0005\b\u00073\u0001A\u0011BB\u000e\u0011%\tI\u0004\u0001a\u0001\n\u0013\t)\u000eC\u0005\u0004\"\u0001\u0001\r\u0011\"\u0003\u0004$!A1\u0011\u0006\u0001!B\u0013\tY\u0001C\u0005\u0003\u0002\u0001\u0001\r\u0011\"\u0003\u0002V\"I11\u0006\u0001A\u0002\u0013%1Q\u0006\u0005\t\u0007c\u0001\u0001\u0015)\u0003\u0002\f!AQ\u0010\u0001a\u0001\n\u0013\u0019\u0019\u0004C\u0005\u00046\u0001\u0001\r\u0011\"\u0003\u00048!A11\b\u0001!B\u0013\t\t\u0001C\u0005\u0002\"\u0001\u0001\r\u0011\"\u0003\u0004>!I1q\b\u0001A\u0002\u0013%1\u0011\t\u0005\t\u0007\u000b\u0002\u0001\u0015)\u0003\u0002(!I1q\t\u0001A\u0002\u0013%1\u0011\n\u0005\n\u0007\u0017\u0002\u0001\u0019!C\u0005\u0007\u001bB\u0001b!\u0015\u0001A\u0003&!1\u000e\u0005\n\u0007'\u0002\u0001\u0019!C\u0005\u0007+B\u0011ba\u0016\u0001\u0001\u0004%Ia!\u0017\t\u0011\ru\u0003\u0001)Q\u0005\u0005\u007fC\u0011ba\u0018\u0001\u0001\u0004%Ia!\u0019\t\u0013\r\r\u0004\u00011A\u0005\n\r\u0015\u0004\u0002CB5\u0001\u0001\u0006KA!4\t\u0013\r-\u0004\u00011A\u0005\n\tu\b\"CB7\u0001\u0001\u0007I\u0011BB8\u0011!\u0019\u0019\b\u0001Q!\n\t}xaBB<\u0017\"\u00051\u0011\u0010\u0004\u0007\u0015.C\taa\u001f\t\r9TD\u0011AB?\u0011%\u0019yH\u000fb\u0001\n\u0003\u0019\t\t\u0003\u0005\u0004\bj\u0002\u000b\u0011BBB\u0011%\u0019II\u000fb\u0001\n\u0003\u0019\t\t\u0003\u0005\u0004\fj\u0002\u000b\u0011BBB\u0011%\u0019iI\u000fb\u0001\n\u0003\u0019\t\t\u0003\u0005\u0004\u0010j\u0002\u000b\u0011BBB\u0011%\u0019\tJ\u000fb\u0001\n\u0003\u0019\t\t\u0003\u0005\u0004\u0014j\u0002\u000b\u0011BBB\u0011%\u0019)J\u000fb\u0001\n\u0003\u0019\t\t\u0003\u0005\u0004\u0018j\u0002\u000b\u0011BBB\u0011%\u0019IJ\u000fb\u0001\n\u0003\u0019\t\t\u0003\u0005\u0004\u001cj\u0002\u000b\u0011BBB\u0011%\u0019iJ\u000fb\u0001\n\u0003\u0019y\n\u0003\u0005\u0004,j\u0002\u000b\u0011BBQ\u0005A!\u0015\r^1TiJ,\u0017-\\,sSR,'O\u0003\u0002M\u001b\u0006I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u001d>\u000b1a]9m\u0015\t\u0001\u0016+A\u0003ta\u0006\u00148N\u0003\u0002S'\u00061\u0011\r]1dQ\u0016T\u0011\u0001V\u0001\u0004_J<7\u0001A\u000b\u0003/\u0016\u001c\"\u0001\u0001-\u0011\u0005ecV\"\u0001.\u000b\u0003m\u000bQa]2bY\u0006L!!\u0018.\u0003\r\u0005s\u0017PU3g\u0003\t!7\u000fE\u0002aC\u000el\u0011!T\u0005\u0003E6\u0013q\u0001R1uCN,G\u000f\u0005\u0002eK2\u0001A!\u00024\u0001\u0005\u00049'!\u0001+\u0012\u0005!\\\u0007CA-j\u0013\tQ'LA\u0004O_RD\u0017N\\4\u0011\u0005ec\u0017BA7[\u0005\r\te._\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\u0014\bcA9\u0001G6\t1\nC\u0003_\u0005\u0001\u0007q,\u0001\u0002eMV\tQ\u000f\u0005\u0002ws:\u0011\u0001m^\u0005\u0003q6\u000bq\u0001]1dW\u0006<W-\u0003\u0002{w\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003q6\u000b1\u0001\u001a4!\u0003)yW\u000f\u001e9vi6{G-\u001a\u000b\u0003a~Da!`\u0003A\u0002\u0005\u0005\u0001cA9\u0002\u0004%\u0019\u0011QA&\u0003\u0015=+H\u000f];u\u001b>$W\rF\u0002q\u0003\u0013Aa! \u0004A\u0002\u0005-\u0001\u0003BA\u0007\u00037qA!a\u0004\u0002\u0018A\u0019\u0011\u0011\u0003.\u000e\u0005\u0005M!bAA\u000b+\u00061AH]8pizJ1!!\u0007[\u0003\u0019\u0001&/\u001a3fM&!\u0011QDA\u0010\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0004.\u0002\u000fQ\u0014\u0018nZ4feR\u0019\u0001/!\n\t\u000f\u0005\u0005r\u00011\u0001\u0002(A\u0019\u0011/!\u000b\n\u0007\u0005-2JA\u0004Ue&<w-\u001a:\u0002\u0013E,XM]=OC6,Gc\u00019\u00022!9\u0011Q\u0006\u0005A\u0002\u0005-\u0011A\u00024pe6\fG\u000fF\u0002q\u0003oAq!!\u000f\n\u0001\u0004\tY!\u0001\u0004t_V\u00148-Z\u0001\fa\u0006\u0014H/\u001b;j_:\u0014\u0015\u0010F\u0002q\u0003\u007fAq!!\u0011\u000b\u0001\u0004\t\u0019%\u0001\u0005d_2t\u0015-\\3t!\u0015I\u0016QIA\u0006\u0013\r\t9E\u0017\u0002\u000byI,\u0007/Z1uK\u0012t\u0004f\u0001\u0006\u0002LA!\u0011QJA*\u001b\t\tyEC\u0002\u0002Ri\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t)&a\u0014\u0003\u000fY\f'/\u0019:hg\u00061q\u000e\u001d;j_:$R\u0001]A.\u0003?Bq!!\u0018\f\u0001\u0004\tY!A\u0002lKfDq!!\u0019\f\u0001\u0004\tY!A\u0003wC2,X\rF\u0003q\u0003K\n9\u0007C\u0004\u0002^1\u0001\r!a\u0003\t\u000f\u0005\u0005D\u00021\u0001\u0002jA\u0019\u0011,a\u001b\n\u0007\u00055$LA\u0004C_>dW-\u00198\u0015\u000bA\f\t(a\u001d\t\u000f\u0005uS\u00021\u0001\u0002\f!9\u0011\u0011M\u0007A\u0002\u0005U\u0004cA-\u0002x%\u0019\u0011\u0011\u0010.\u0003\t1{gn\u001a\u000b\u0006a\u0006u\u0014q\u0010\u0005\b\u0003;r\u0001\u0019AA\u0006\u0011\u001d\t\tG\u0004a\u0001\u0003\u0003\u00032!WAB\u0013\r\t)I\u0017\u0002\u0007\t>,(\r\\3\u0002\u000f=\u0004H/[8ogR\u0019\u0001/a#\t\u000f\u0005\u001du\u00021\u0001\u0002\u000eBA\u0011qRAK\u0003\u0017\tY!\u0004\u0002\u0002\u0012*\u0019\u00111\u0013.\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0018\u0006E%aA'baR\u0019\u0001/a'\t\u000f\u0005\u001d\u0005\u00031\u0001\u0002\u001eBA\u0011qTAU\u0003\u0017\tY!\u0004\u0002\u0002\"*!\u00111UAS\u0003\u0011)H/\u001b7\u000b\u0005\u0005\u001d\u0016\u0001\u00026bm\u0006LA!a&\u0002\"\u0006)1\u000f^1siR!\u0011qVA[!\r\t\u0018\u0011W\u0005\u0004\u0003g[%AD*ue\u0016\fW.\u001b8h#V,'/\u001f\u0005\b\u0003o\u000b\u0002\u0019AA\u0006\u0003\u0011\u0001\u0018\r\u001e5\u0015\u0005\u0005=\u0006&\u0002\n\u0002>\u0006=\u0007#B-\u0002@\u0006\r\u0017bAAa5\n1A\u000f\u001b:poN\u0004B!!2\u0002L6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\f\t+\u0001\u0006d_:\u001cWO\u001d:f]RLA!!4\u0002H\n\u0001B+[7f_V$X\t_2faRLwN\\\u0019\b=\u0005-\u0011\u0011[A}c%\u0019\u00131[Am\u0003_\fY.\u0006\u0003\u0002V\u0006]WCAA\u0006\t\u00191WK1\u0001\u0002b&!\u00111\\Ao\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u0011q\u001c.\u0002\rQD'o\\<t#\rA\u00171\u001d\t\u0005\u0003K\fIOD\u0002Z\u0003OL!\u0001\u001f.\n\t\u0005-\u0018Q\u001e\u0002\n)\"\u0014xn^1cY\u0016T!\u0001\u001f.2\u0013\r\n\t0a=\u0002v\u0006}gbA-\u0002t&\u0019\u0011q\u001c.2\u000b\tJ&,a>\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\n\u0019-A\u0004u_R\u000b'\r\\3\u0015\t\u0005=\u0016q \u0005\b\u0005\u0003\u0019\u0002\u0019AA\u0006\u0003%!\u0018M\u00197f\u001d\u0006lW\rK\u0003\u0014\u0003{\u0013)!M\u0004\u001f\u0003\u0017\u00119A!\u00042\u0013\r\n\u0019.!7\u0003\n\u0005m\u0017'C\u0012\u0002r\u0006M(1BApc\u0015\u0011\u0013LWA|c\r1\u00131\u0019\u0015\u0004'\tE\u0001\u0003\u0002B\n\u0005/i!A!\u0006\u000b\u0007\u0005Es*\u0003\u0003\u0003\u001a\tU!\u0001C#w_24\u0018N\\4\u0002\u001bM$\u0018M\u001d;J]R,'O\\1m)\u0019\tyKa\b\u0003(!9\u0011q\u0017\u000bA\u0002\t\u0005\u0002#B-\u0003$\u0005-\u0011b\u0001B\u00135\n1q\n\u001d;j_:D\u0011B!\u000b\u0015!\u0003\u0005\rAa\u000b\u0002\u0019\r\fG/\u00197pOR\u000b'\r\\3\u0011\u000be\u0013\u0019C!\f\u0011\t\t=\"\u0011H\u0007\u0003\u0005cQAAa\r\u00036\u000591-\u0019;bY><'b\u0001B\u001c\u001b\u0006A1-\u0019;bYf\u001cH/\u0003\u0003\u0003<\tE\"\u0001D\"bi\u0006dwn\u001a+bE2,\u0017aF:uCJ$\u0018J\u001c;fe:\fG\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\tE\u000b\u0003\u0003,\t\r3F\u0001B#!\u0011\u00119E!\u0014\u000e\u0005\t%#\u0002\u0002B&\u0003\u001f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\n\t\t=#\u0011\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AC:uCJ$\u0018+^3ssRa\u0011q\u0016B+\u0005O\u0012)H!\u001f\u0003\u0012\"9!q\u000b\fA\u0002\te\u0013\u0001B:j].\u0004BAa\u0017\u0003d5\u0011!Q\f\u0006\u0005\u0005g\u0011yFC\u0002\u0003b5\u000b\u0011bY8o]\u0016\u001cGo\u001c:\n\t\t\u0015$Q\f\u0002\u0006)\u0006\u0014G.\u001a\u0005\b\u0005S2\u0002\u0019\u0001B6\u0003)qWm^(qi&|gn\u001d\t\u0007\u0005[\u0012\t(a\u0003\u000e\u0005\t=$\u0002BAR\u0005kIAAa\u001d\u0003p\t\u00112)Y:f\u0013:\u001cXM\\:ji&4X-T1q\u0011%\u00119H\u0006I\u0001\u0002\u0004\tI'A\u000bsK\u000e|g/\u001a:Ge>l7\t[3dWB|\u0017N\u001c;\t\u0013\tmd\u0003%AA\u0002\tu\u0014aD2bi\u0006dwnZ!oI&#WM\u001c;\u0011\u000be\u0013\u0019Ca \u0011\u000fe\u0013\tI!\"\u0003\f&\u0019!1\u0011.\u0003\rQ+\b\u000f\\33!\u0011\u0011YFa\"\n\t\t%%Q\f\u0002\r)\u0006\u0014G.Z\"bi\u0006dwn\u001a\t\u0005\u00057\u0012i)\u0003\u0003\u0003\u0010\nu#AC%eK:$\u0018NZ5fe\"I!\u0011\u0006\f\u0011\u0002\u0003\u0007!1F\u0001\u0015gR\f'\u000f^)vKJLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t]%\u0006BA5\u0005\u0007\nAc\u001d;beR\fV/\u001a:zI\u0011,g-Y;mi\u0012\"TC\u0001BOU\u0011\u0011iHa\u0011\u0002)M$\u0018M\u001d;Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00031\u0019'/Z1uKZ\u000b4+\u001b8l)\u0011\u0011)Ka-\u0011\t\t\u001d&qV\u0007\u0003\u0005SS1\u0001\u0014BV\u0015\r\u0011i+T\u0001\nKb,7-\u001e;j_:LAA!-\u0003*\n!1+\u001b8l\u0011\u001d\u0011)L\u0007a\u0001\u0005W\nqb\u001c9uS>t7oV5uQB\u000bG\u000f[\u0001\bM>\u0014X-Y2i)\r\u0001(1\u0018\u0005\b\u0005{[\u0002\u0019\u0001B`\u0003\u00199(/\u001b;feB!\u0001M!1d\u0013\r\u0011\u0019-\u0014\u0002\u000e\r>\u0014X-Y2i/JLG/\u001a:\u0002\u0019\u0019|'/Z1dQ\n\u000bGo\u00195\u0015\u0007A\u0014I\rC\u0004\u0003Lr\u0001\rA!4\u0002\u0011\u0019,hn\u0019;j_:\u0004\u0002\"\u0017Bh?\u0006U$1[\u0005\u0004\u0005#T&!\u0003$v]\u000e$\u0018n\u001c83!\rI&Q[\u0005\u0004\u0005/T&\u0001B+oSRD3\u0001\bB\t)\r\u0001(Q\u001c\u0005\b\u0005\u0017l\u0002\u0019\u0001Bp!\u001d\u0011\tOa;`\u0005_l!Aa9\u000b\t\t-'Q\u001d\u0006\u0005\u0003O\u00139OC\u0002\u0003j>\u000b1!\u00199j\u0013\u0011\u0011iOa9\u0003\u001bY{\u0017\u000e\u001a$v]\u000e$\u0018n\u001c83!\u0011\u0011\tPa>\u000e\u0005\tM(\u0002\u0002B{\u0003K\u000bA\u0001\\1oO&!\u0011\u0011\u0010BzQ\ri\"\u0011C\u0001\u0012]>\u0014X.\u00197ju\u0016$\u0007+\u0019:D_2\u001cXC\u0001B\u0000!\u0015I&1EB\u0001!\u0019\u0019\u0019a!\u0003\u0002\f9!1QAAt\u001d\u0011\t\tba\u0002\n\u0003mKAaa\u0003\u0002n\n\u00191+Z9\u0002\u00139|'/\\1mSj,GCBA\u0006\u0007#\u0019)\u0002C\u0004\u0004\u0014}\u0001\r!a\u0003\u0002\u0015\r|G.^7o\u001d\u0006lW\rC\u0004\u0004\u0018}\u0001\r!a\u0003\u0002\u0015\r|G.^7o)f\u0004X-\u0001\u000bbgN,'\u000f\u001e(piB\u000b'\u000f^5uS>tW\r\u001a\u000b\u0005\u0005'\u001ci\u0002C\u0004\u0004 \u0001\u0002\r!a\u0003\u0002\u0013=\u0004XM]1uS>t\u0017AC:pkJ\u001cWm\u0018\u0013fcR!!1[B\u0013\u0011%\u00199CIA\u0001\u0002\u0004\tY!A\u0002yIE\nqa]8ve\u000e,\u0007%A\u0007uC\ndWMT1nK~#S-\u001d\u000b\u0005\u0005'\u001cy\u0003C\u0005\u0004(\u0015\n\t\u00111\u0001\u0002\f\u0005QA/\u00192mK:\u000bW.\u001a\u0011\u0016\u0005\u0005\u0005\u0011AD8viB,H/T8eK~#S-\u001d\u000b\u0005\u0005'\u001cI\u0004C\u0005\u0004(!\n\t\u00111\u0001\u0002\u0002\u0005Yq.\u001e;qkRlu\u000eZ3!+\t\t9#A\u0006ue&<w-\u001a:`I\u0015\fH\u0003\u0002Bj\u0007\u0007B\u0011ba\n,\u0003\u0003\u0005\r!a\n\u0002\u0011Q\u0014\u0018nZ4fe\u0002\nA\"\u001a=ue\u0006|\u0005\u000f^5p]N,\"Aa\u001b\u0002!\u0015DHO]1PaRLwN\\:`I\u0015\fH\u0003\u0002Bj\u0007\u001fB\u0011ba\n/\u0003\u0003\u0005\rAa\u001b\u0002\u001b\u0015DHO]1PaRLwN\\:!\u000351wN]3bG\"<&/\u001b;feV\u0011!qX\u0001\u0012M>\u0014X-Y2i/JLG/\u001a:`I\u0015\fH\u0003\u0002Bj\u00077B\u0011ba\n2\u0003\u0003\u0005\rAa0\u0002\u001d\u0019|'/Z1dQ^\u0013\u0018\u000e^3sA\u0005\u0011bm\u001c:fC\u000eD')\u0019;dQ^\u0013\u0018\u000e^3s+\t\u0011i-\u0001\fg_J,\u0017m\u00195CCR\u001c\u0007n\u0016:ji\u0016\u0014x\fJ3r)\u0011\u0011\u0019na\u001a\t\u0013\r\u001dB'!AA\u0002\t5\u0017a\u00054pe\u0016\f7\r\u001b\"bi\u000eDwK]5uKJ\u0004\u0013a\u00059beRLG/[8oS:<7i\u001c7v[:\u001c\u0018a\u00069beRLG/[8oS:<7i\u001c7v[:\u001cx\fJ3r)\u0011\u0011\u0019n!\u001d\t\u0013\r\u001dr'!AA\u0002\t}\u0018\u0001\u00069beRLG/[8oS:<7i\u001c7v[:\u001c\b\u0005K\u0002\u0001\u0005#\t\u0001\u0003R1uCN#(/Z1n/JLG/\u001a:\u0011\u0005ET4C\u0001\u001eY)\t\u0019I(\u0001\nT\u001fV\u00136)R0O\u00036+u,T#N\u001fJKVCABB!\u0011\u0011\tp!\"\n\t\u0005u!1_\u0001\u0014'>+&kQ#`\u001d\u0006kUiX'F\u001b>\u0013\u0016\fI\u0001\u0014'>+&kQ#`\u001d\u0006kUi\u0018$P%\u0016\u000b5\tS\u0001\u0015'>+&kQ#`\u001d\u0006kUi\u0018$P%\u0016\u000b5\t\u0013\u0011\u00023M{UKU\"F?:\u000bU*R0G\u001fJ+\u0015i\u0011%`\u0005\u0006#6\tS\u0001\u001b'>+&kQ#`\u001d\u0006kUi\u0018$P%\u0016\u000b5\tS0C\u0003R\u001b\u0005\nI\u0001\u0014'>+&kQ#`\u001d\u0006kUiX\"P\u001dN{E*R\u0001\u0015'>+&kQ#`\u001d\u0006kUiX\"P\u001dN{E*\u0012\u0011\u0002#M{UKU\"F?:\u000bU*R0U\u0003\ncU)\u0001\nT\u001fV\u00136)R0O\u00036+u\fV!C\u0019\u0016\u0003\u0013\u0001E*P+J\u001bUi\u0018(B\u001b\u0016{fjT(Q\u0003E\u0019v*\u0016*D\u000b~s\u0015)T#`\u001d>{\u0005\u000bI\u0001\u001d'>+&kQ#T?\u0006cEjT,`\u001f:+u\fV%N\u000b~\u000bV+\u0012*Z+\t\u0019\t\u000b\u0005\u0004\u0004$\u000e%61Q\u0007\u0003\u0007KSAaa*\u0002\u0012\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0007\u0017\u0019)+A\u000fT\u001fV\u00136)R*`\u00032cujV0P\u001d\u0016{F+S'F?F+VIU-!\u0001")
public final class DataStreamWriter<T> {
    private final Dataset<T> ds;
    private final Dataset<Row> df;
    private String source;
    private String tableName;
    private OutputMode outputMode;
    private Trigger trigger;
    private CaseInsensitiveMap<String> extraOptions;
    private ForeachWriter<T> foreachWriter;
    private Function2<Dataset<T>, Object, BoxedUnit> foreachBatchWriter;
    private Option<Seq<String>> partitioningColumns;

    public static Seq<String> SOURCES_ALLOW_ONE_TIME_QUERY() {
        return DataStreamWriter$.MODULE$.SOURCES_ALLOW_ONE_TIME_QUERY();
    }

    public static String SOURCE_NAME_NOOP() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_NOOP();
    }

    public static String SOURCE_NAME_TABLE() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_TABLE();
    }

    public static String SOURCE_NAME_CONSOLE() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_CONSOLE();
    }

    public static String SOURCE_NAME_FOREACH_BATCH() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH();
    }

    public static String SOURCE_NAME_FOREACH() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH();
    }

    public static String SOURCE_NAME_MEMORY() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY();
    }

    public DataStreamWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataStreamWriter<T> outputMode(OutputMode outputMode) {
        this.outputMode_$eq(outputMode);
        return this;
    }

    public DataStreamWriter<T> outputMode(String outputMode) {
        this.outputMode_$eq(InternalOutputModes$.MODULE$.apply(outputMode));
        return this;
    }

    public DataStreamWriter<T> trigger(Trigger trigger) {
        this.trigger_$eq(trigger);
        return this;
    }

    public DataStreamWriter<T> queryName(String queryName) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"queryName"), (Object)queryName)));
        return this;
    }

    public DataStreamWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataStreamWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataStreamWriter<T> option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataStreamWriter<T> option(String key, boolean value) {
        return this.option(key, Boolean.toString(value));
    }

    public DataStreamWriter<T> option(String key, long value) {
        return this.option(key, Long.toString(value));
    }

    public DataStreamWriter<T> option(String key, double value) {
        return this.option(key, Double.toString(value));
    }

    public DataStreamWriter<T> options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataStreamWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public StreamingQuery start(String path) {
        if (!this.df().sparkSession().sessionState().conf().legacyPathOptionBehavior() && this.extraOptions().contains("path")) {
            throw QueryCompilationErrors$.MODULE$.setPathOptionAndCallWithPathParameterError("start");
        }
        return this.startInternal((Option<String>)new Some((Object)path), this.startInternal$default$2());
    }

    public StreamingQuery start() throws TimeoutException {
        return this.startInternal((Option<String>)None$.MODULE$, this.startInternal$default$2());
    }

    @Evolving
    public StreamingQuery toTable(String tableName) throws TimeoutException {
        StreamingQuery streamingQuery;
        SupportsWrite supportsWrite;
        Table tableInstance;
        Object object;
        Option option;
        Seq originalMultipartIdentifier;
        this.tableName_$eq(tableName);
        Seq seq = originalMultipartIdentifier = this.df().sparkSession().sessionState().sqlParser().parseMultipartIdentifier(tableName);
        if (seq == null || (option = this.df().sparkSession().sessionState().analyzer().CatalogAndIdentifier().unapply(seq)).isEmpty()) {
            throw new MatchError((Object)seq);
        }
        CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option.get())._1();
        Identifier identifier = (Identifier)((Tuple2)option.get())._2();
        Tuple2 tuple2 = new Tuple2((Object)catalog, (Object)identifier);
        Tuple2 tuple22 = tuple2;
        CatalogPlugin catalog2 = (CatalogPlugin)tuple22._1();
        Identifier identifier2 = (Identifier)tuple22._2();
        if (this.df().sparkSession().sessionState().catalog().isTempView(originalMultipartIdentifier)) {
            throw QueryCompilationErrors$.MODULE$.tempViewNotSupportStreamingWriteError(tableName);
        }
        if (!CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog().tableExists(identifier2)) {
            TableSpec tableSpec = new TableSpec(Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), Predef$.MODULE$.Map().empty(), this.extraOptions().get("path"), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
            CreateTable cmd = new CreateTable((LogicalPlan)new UnresolvedIdentifier(originalMultipartIdentifier, UnresolvedIdentifier$.MODULE$.apply$default$2()), this.df().schema().asNullable(), ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])CatalogV2Implicits$.MODULE$.PartitionTypeHelper((Seq)this.partitioningColumns().getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil())).asTransforms())), tableSpec, false);
            object = Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)cmd);
        } else {
            object = BoxedUnit.UNIT;
        }
        Table table = tableInstance = CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog().loadTable(identifier2);
        if (table instanceof SupportsWrite && DataSourceV2Implicits$.MODULE$.TableHelper((Table)(supportsWrite = (SupportsWrite)table)).supports(TableCapability.STREAMING_WRITE)) {
            SupportsWrite x$1 = supportsWrite;
            CaseInsensitiveMap<String> x$2 = this.extraOptions();
            Some x$3 = new Some((Object)new Tuple2((Object)CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog(), (Object)identifier2));
            boolean x$4 = this.startQuery$default$3();
            Option<CatalogTable> x$5 = this.startQuery$default$5();
            streamingQuery = this.startQuery((Table)x$1, x$2, x$4, (Option<Tuple2<TableCatalog, Identifier>>)x$3, x$5);
        } else if (table instanceof V2TableWithV1Fallback) {
            V2TableWithV1Fallback v2TableWithV1Fallback = (V2TableWithV1Fallback)table;
            streamingQuery = this.writeToV1Table$1(v2TableWithV1Fallback.v1Table(), tableName);
        } else if (table instanceof V1Table) {
            V1Table v1Table = (V1Table)table;
            streamingQuery = this.writeToV1Table$1(v1Table.v1Table(), tableName);
        } else {
            throw QueryCompilationErrors$.MODULE$.tableNotSupportStreamingWriteError(tableName, table);
        }
        return streamingQuery;
    }

    private StreamingQuery startInternal(Option<String> path, Option<CatalogTable> catalogTable) {
        StreamingQuery streamingQuery;
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw QueryCompilationErrors$.MODULE$.cannotOperateOnHiveDataSourceFilesError("write");
        }
        String string3 = this.source();
        String string4 = DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY());
            if (this.extraOptions().get("queryName").isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.queryNameNotSpecifiedForMemorySinkError();
            }
            MemorySink sink = new MemorySink();
            Dataset<Row> resultDf = Dataset$.MODULE$.ofRows(this.df().sparkSession(), new MemoryPlan(sink, (Seq<Attribute>)this.df().schema().toAttributes()));
            OutputMode outputMode = this.outputMode();
            OutputMode outputMode2 = OutputMode.Complete();
            boolean recoverFromCheckpoint = !(outputMode != null ? !outputMode.equals(outputMode2) : outputMode2 != null);
            MemorySink x$1 = sink;
            CaseInsensitiveMap<String> x$22 = this.extraOptions();
            boolean x$3 = recoverFromCheckpoint;
            Option<CatalogTable> x$4 = catalogTable;
            Option<Tuple2<TableCatalog, Identifier>> x$5 = this.startQuery$default$4();
            StreamingQuery query = this.startQuery(x$1, x$22, x$3, x$5, x$4);
            resultDf.createOrReplaceTempView(query.name());
            streamingQuery = query;
        } else {
            String string5 = this.source();
            String string6 = DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH();
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                ForeachWriterTable<?> sink;
                this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH());
                ForeachWriterTable<?> x$6 = sink = ForeachWriterTable$.MODULE$.apply(this.foreachWriter(), this.ds.exprEnc());
                CaseInsensitiveMap<String> x$7 = this.extraOptions();
                Option<CatalogTable> x$8 = catalogTable;
                boolean x$9 = this.startQuery$default$3();
                Option<Tuple2<TableCatalog, Identifier>> x$10 = this.startQuery$default$4();
                streamingQuery = this.startQuery(x$6, x$7, x$9, x$10, x$8);
            } else {
                String string7 = this.source();
                String string8 = DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH();
                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                    ForeachBatchSink<T> sink;
                    this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH());
                    if (this.trigger() instanceof ContinuousTrigger) {
                        throw QueryCompilationErrors$.MODULE$.sourceNotSupportedWithContinuousTriggerError(this.source());
                    }
                    ForeachBatchSink<T> x$11 = sink = new ForeachBatchSink<T>(this.foreachBatchWriter(), this.ds.exprEnc());
                    CaseInsensitiveMap<String> x$12 = this.extraOptions();
                    Option<CatalogTable> x$13 = catalogTable;
                    boolean x$14 = this.startQuery$default$3();
                    Option<Tuple2<TableCatalog, Identifier>> x$15 = this.startQuery$default$4();
                    streamingQuery = this.startQuery(x$11, x$12, x$14, x$15, x$13);
                } else {
                    Sink sink;
                    Sink sink2;
                    CaseInsensitiveMap optionsWithPath;
                    Class<?> cls = DataSource$.MODULE$.lookupDataSource(this.source(), this.df().sparkSession().sessionState().conf());
                    Seq disabledSources = Utils$.MODULE$.stringToSeq(this.df().sparkSession().sqlContext().conf().disabledV2StreamingWriters());
                    boolean useV1Source = disabledSources.contains((Object)cls.getCanonicalName()) || FileDataSourceV2.class.isAssignableFrom(cls);
                    CaseInsensitiveMap caseInsensitiveMap = optionsWithPath = path.isEmpty() ? this.extraOptions() : this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), path.get()));
                    if (TableProvider.class.isAssignableFrom(cls) && !useV1Source) {
                        SupportsWrite supportsWrite;
                        Table table;
                        TableProvider provider = (TableProvider)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                        scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(provider, this.df().sparkSession().sessionState().conf());
                        scala.collection.immutable.Map finalOptions = (scala.collection.immutable.Map)sessionOptions.filterKeys((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataStreamWriter.$anonfun$startInternal$1(optionsWithPath, x$2))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)optionsWithPath.originalMap());
                        CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)finalOptions).asJava());
                        None$ outputSchema = provider.supportsExternalMetadata() ? new Some((Object)this.df().schema()) : None$.MODULE$;
                        Table table2 = table = DataSourceV2Utils$.MODULE$.getTableFromProvider(provider, dsOptions, (Option<StructType>)outputSchema);
                        Sink sink3 = table2 instanceof SupportsWrite && DataSourceV2Implicits$.MODULE$.TableHelper((Table)(supportsWrite = (SupportsWrite)table2)).supports(TableCapability.STREAMING_WRITE) ? supportsWrite : this.createV1Sink((CaseInsensitiveMap<String>)optionsWithPath);
                        sink2 = sink3;
                    } else {
                        sink2 = this.createV1Sink((CaseInsensitiveMap<String>)optionsWithPath);
                    }
                    Sink x$16 = sink = sink2;
                    CaseInsensitiveMap x$17 = optionsWithPath;
                    Option<CatalogTable> x$18 = catalogTable;
                    boolean x$19 = this.startQuery$default$3();
                    Option<Tuple2<TableCatalog, Identifier>> x$20 = this.startQuery$default$4();
                    streamingQuery = this.startQuery(x$16, (CaseInsensitiveMap<String>)x$17, x$19, x$20, x$18);
                }
            }
        }
        return streamingQuery;
    }

    private Option<CatalogTable> startInternal$default$2() {
        return None$.MODULE$;
    }

    private StreamingQuery startQuery(Table sink, CaseInsensitiveMap<String> newOptions, boolean recoverFromCheckpoint, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent, Option<CatalogTable> catalogTable) {
        boolean useTempCheckpointLocation = DataStreamWriter$.MODULE$.SOURCES_ALLOW_ONE_TIME_QUERY().contains((Object)this.source());
        Option x$1 = newOptions.get("queryName");
        Option x$2 = newOptions.get("checkpointLocation");
        Dataset<Row> x$3 = this.df();
        scala.collection.immutable.Map x$4 = newOptions.originalMap();
        Table x$5 = sink;
        OutputMode x$6 = this.outputMode();
        boolean x$7 = useTempCheckpointLocation;
        boolean x$8 = recoverFromCheckpoint;
        Trigger x$9 = this.trigger();
        Option<Tuple2<TableCatalog, Identifier>> x$10 = catalogAndIdent;
        Option<CatalogTable> x$11 = catalogTable;
        Clock x$12 = this.df().sparkSession().sessionState().streamingQueryManager().startQuery$default$10();
        return this.df().sparkSession().sessionState().streamingQueryManager().startQuery((Option<String>)x$1, (Option<String>)x$2, x$3, (scala.collection.immutable.Map<String, String>)x$4, x$5, x$6, x$7, x$8, x$9, x$12, x$10, x$11);
    }

    private boolean startQuery$default$3() {
        return true;
    }

    private Option<Tuple2<TableCatalog, Identifier>> startQuery$default$4() {
        return None$.MODULE$;
    }

    private Option<CatalogTable> startQuery$default$5() {
        return None$.MODULE$;
    }

    private Sink createV1Sink(CaseInsensitiveMap<String> optionsWithPath) {
        SparkSession x$1 = this.df().sparkSession();
        String x$2 = this.source();
        scala.collection.immutable.Map x$3 = optionsWithPath.originalMap();
        Seq x$4 = (Seq)this.normalizedParCols().getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil());
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource ds = new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$4, x$7, (scala.collection.immutable.Map<String, String>)x$3, x$8);
        return ds.createSink(this.outputMode());
    }

    public DataStreamWriter<T> foreach(ForeachWriter<T> writer) {
        this.source_$eq(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH());
        if (writer == null) {
            throw new IllegalArgumentException("foreach writer cannot be null");
        }
        this.foreachWriter_$eq((ForeachWriter)this.ds.sparkSession().sparkContext().clean(writer, this.ds.sparkSession().sparkContext().clean$default$2()));
        return this;
    }

    @Evolving
    public DataStreamWriter<T> foreachBatch(Function2<Dataset<T>, Object, BoxedUnit> function) {
        this.source_$eq(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH());
        if (function == null) {
            throw new IllegalArgumentException("foreachBatch function cannot be null");
        }
        this.foreachBatchWriter_$eq(function);
        return this;
    }

    @Evolving
    public DataStreamWriter<T> foreachBatch(VoidFunction2<Dataset<T>, Long> function) {
        return this.foreachBatch((Function2 & Serializable)(batchDs, batchId) -> {
            function.call((Object)batchDs, (Object)Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)batchId)));
            return BoxedUnit.UNIT;
        });
    }

    private Option<Seq<String>> normalizedParCols() {
        return this.partitioningColumns().map((Function1 & Serializable)cols -> (Seq)cols.map((Function1 & Serializable)x$3 -> this.normalize((String)x$3, "Partition")));
    }

    private String normalize(String columnName, String columnType) {
        Seq validColumnNames = (Seq)this.df().logicalPlan().output().map((Function1 & Serializable)x$4 -> x$4.name());
        return (String)validColumnNames.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DataStreamWriter.$anonfun$normalize$2(this, columnName, x$5))).getOrElse((Function0 & Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.columnNotFoundInExistingColumnsError(columnType, columnName, validColumnNames);
        });
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw QueryCompilationErrors$.MODULE$.operationNotSupportPartitioningError(operation);
        }
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private String tableName() {
        return this.tableName;
    }

    private void tableName_$eq(String x$1) {
        this.tableName = x$1;
    }

    private OutputMode outputMode() {
        return this.outputMode;
    }

    private void outputMode_$eq(OutputMode x$1) {
        this.outputMode = x$1;
    }

    private Trigger trigger() {
        return this.trigger;
    }

    private void trigger_$eq(Trigger x$1) {
        this.trigger = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    private ForeachWriter<T> foreachWriter() {
        return this.foreachWriter;
    }

    private void foreachWriter_$eq(ForeachWriter<T> x$1) {
        this.foreachWriter = x$1;
    }

    private Function2<Dataset<T>, Object, BoxedUnit> foreachBatchWriter() {
        return this.foreachBatchWriter;
    }

    private void foreachBatchWriter_$eq(Function2<Dataset<T>, Object, BoxedUnit> x$1) {
        this.foreachBatchWriter = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private final StreamingQuery writeToV1Table$1(CatalogTable table, String tableName$1) {
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw QueryCompilationErrors$.MODULE$.streamingIntoViewNotSupportedError(tableName$1);
        }
        Predef$.MODULE$.require(table.provider().isDefined());
        String string = this.source();
        Object object = table.provider().get();
        if (string == null ? object != null : !string.equals(object)) {
            throw QueryCompilationErrors$.MODULE$.inputSourceDiffersFromDataSourceProviderError(this.source(), tableName$1, table);
        }
        return super.startInternal((Option<String>)new Some((Object)new Path(table.location()).toString()), (Option<CatalogTable>)new Some((Object)table));
    }

    public static final /* synthetic */ boolean $anonfun$startInternal$1(CaseInsensitiveMap optionsWithPath$1, String x$2) {
        return !optionsWithPath$1.contains(x$2);
    }

    public static final /* synthetic */ boolean $anonfun$normalize$2(DataStreamWriter $this, String columnName$1, String x$5) {
        return BoxesRunTime.unboxToBoolean((Object)$this.df().sparkSession().sessionState().analyzer().resolver().apply((Object)x$5, (Object)columnName$1));
    }

    public DataStreamWriter(Dataset<T> ds) {
        this.ds = ds;
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.tableName = null;
        this.outputMode = OutputMode.Append();
        this.trigger = Trigger.ProcessingTime(0L);
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
        this.foreachWriter = null;
        this.foreachBatchWriter = null;
        this.partitioningColumns = None$.MODULE$;
    }
}

