/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource$;
import org.apache.spark.sql.execution.datasources.json.JsonOutputWriter;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function1;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\u0007\u000e\u0001qAQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013\u0005C\u0006\u0003\u0004;\u0001\u0001\u0006I!\f\u0005\u0006w\u0001!\t\u0005\u0010\u0005\u0006-\u0002!\te\u0016\u0005\u0006c\u0002!\tE\u001d\u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\t\t\u0006\u0001C!\u0003'Bq!!\u0016\u0001\t\u0003\n9\u0006C\u0004\u0002`\u0001!\t%!\u0019\t\u000f\u00055\u0004\u0001\"\u0011\u0002p\tq!j]8o\r&dWMR8s[\u0006$(B\u0001\b\u0010\u0003\u0011Q7o\u001c8\u000b\u0005A\t\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT!AE\n\u0002\u0013\u0015DXmY;uS>t'B\u0001\u000b\u0016\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003-]\tQa\u001d9be.T!\u0001G\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0012aA8sO\u000e\u00011c\u0001\u0001\u001eCA\u0011adH\u0007\u0002\u001f%\u0011\u0001e\u0004\u0002\u0014)\u0016DHOQ1tK\u00124\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003E\u0015j\u0011a\t\u0006\u0003IM\tqa]8ve\u000e,7/\u0003\u0002'G\t\u0011B)\u0019;b'>,(oY3SK\u001eL7\u000f^3s\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\tQ\"A\u0005tQ>\u0014HOT1nKV\tQ\u0006\u0005\u0002/o9\u0011q&\u000e\t\u0003aMj\u0011!\r\u0006\u0003em\ta\u0001\u0010:p_Rt$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a\u0014A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!AN\u001a\u0002\u0015MDwN\u001d;OC6,\u0007%A\u0006jgN\u0003H.\u001b;bE2,G\u0003B\u001fB\u000f2\u0003\"AP \u000e\u0003MJ!\u0001Q\u001a\u0003\u000f\t{w\u000e\\3b]\")!\t\u0002a\u0001\u0007\u0006a1\u000f]1sWN+7o]5p]B\u0011A)R\u0007\u0002'%\u0011ai\u0005\u0002\r'B\f'o[*fgNLwN\u001c\u0005\u0006\u0011\u0012\u0001\r!S\u0001\b_B$\u0018n\u001c8t!\u0011q#*L\u0017\n\u0005-K$aA'ba\")Q\n\u0002a\u0001\u001d\u0006!\u0001/\u0019;i!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0002gg*\u00111kF\u0001\u0007Q\u0006$wn\u001c9\n\u0005U\u0003&\u0001\u0002)bi\"\f1\"\u001b8gKJ\u001c6\r[3nCR!\u0001,\u00192d!\rq\u0014lW\u0005\u00035N\u0012aa\u00149uS>t\u0007C\u0001/`\u001b\u0005i&B\u00010\u0014\u0003\u0015!\u0018\u0010]3t\u0013\t\u0001WL\u0001\u0006TiJ,8\r\u001e+za\u0016DQAQ\u0003A\u0002\rCQ\u0001S\u0003A\u0002%CQ\u0001Z\u0003A\u0002\u0015\fQAZ5mKN\u00042AZ6o\u001d\t9\u0017N\u0004\u00021Q&\tA'\u0003\u0002kg\u00059\u0001/Y2lC\u001e,\u0017B\u00017n\u0005\r\u0019V-\u001d\u0006\u0003UN\u0002\"aT8\n\u0005A\u0004&A\u0003$jY\u0016\u001cF/\u0019;vg\u0006a\u0001O]3qCJ,wK]5uKR11O^<\u0000\u0003\u0003\u0001\"A\b;\n\u0005U|!aE(viB,Ho\u0016:ji\u0016\u0014h)Y2u_JL\b\"\u0002\"\u0007\u0001\u0004\u0019\u0005\"\u0002=\u0007\u0001\u0004I\u0018a\u00016pEB\u0011!0`\u0007\u0002w*\u0011APU\u0001\n[\u0006\u0004(/\u001a3vG\u0016L!A`>\u0003\u0007){'\rC\u0003I\r\u0001\u0007\u0011\n\u0003\u0004\u0002\u0004\u0019\u0001\raW\u0001\u000bI\u0006$\u0018mU2iK6\f\u0017a\u00032vS2$'+Z1eKJ$\u0002#!\u0003\u0002(\u0005%\u00121FA\u0018\u0003g\ty$!\u0011\u0011\u000fy\nY!a\u0004\u0002\u0016%\u0019\u0011QB\u001a\u0003\u0013\u0019+hn\u0019;j_:\f\u0004c\u0001\u0010\u0002\u0012%\u0019\u00111C\b\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016\u0004RAZA\f\u00037I1!!\u0007n\u0005!IE/\u001a:bi>\u0014\b\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u00052#\u0001\u0005dCR\fG._:u\u0013\u0011\t)#a\b\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006\u0005\u001e\u0001\ra\u0011\u0005\u0007\u0003\u00079\u0001\u0019A.\t\r\u00055r\u00011\u0001\\\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007BBA\u0019\u000f\u0001\u00071,\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\t\u000f\u0005Ur\u00011\u0001\u00028\u00059a-\u001b7uKJ\u001c\b\u0003\u00024l\u0003s\u00012AIA\u001e\u0013\r\tid\t\u0002\u0007\r&dG/\u001a:\t\u000b!;\u0001\u0019A%\t\u000f\u0005\rs\u00011\u0001\u0002F\u0005Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013S\u0003\u0011\u0019wN\u001c4\n\t\u0005=\u0013\u0011\n\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!L\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011\f\t\u0004}\u0005m\u0013bAA/g\t\u0019\u0011J\u001c;\u0002\r\u0015\fX/\u00197t)\ri\u00141\r\u0005\b\u0003KR\u0001\u0019AA4\u0003\u0015yG\u000f[3s!\rq\u0014\u0011N\u0005\u0004\u0003W\u001a$aA!os\u0006y1/\u001e9q_J$H)\u0019;b)f\u0004X\rF\u0002>\u0003cBq!a\u001d\f\u0001\u0004\t)(\u0001\u0005eCR\fG+\u001f9f!\ra\u0016qO\u0005\u0004\u0003sj&\u0001\u0003#bi\u0006$\u0016\u0010]3")
public class JsonFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    private final String shortName;

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        JsonDataSource jsonDataSource = JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions);
        return jsonDataSource.isSplitable() && super.isSplitable(sparkSession, options, path);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        return JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions).inferSchema(sparkSession, files, (JSONOptions)parsedOptions);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        Configuration conf = job.getConfiguration();
        JSONOptions parsedOptions = new JSONOptions(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        parsedOptions.compressionCodec().foreach((Function1 & Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(conf, codec);
            return BoxedUnit.UNIT;
        });
        return new OutputWriterFactory(null, parsedOptions){
            private final JSONOptions parsedOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new JsonOutputWriter(path, this.parsedOptions$1, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(5).append(".json").append(CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
            {
                this.parsedOptions$1 = parsedOptions$1;
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)requiredSchema.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JsonFileFormat.$anonfun$buildReader$1(parsedOptions, x$1))));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(dataSchema, parsedOptions.columnNameOfCorruptRecord());
        if (requiredSchema.length() == 1) {
            String string = ((StructField)requiredSchema.head()).name();
            String string2 = parsedOptions.columnNameOfCorruptRecord();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw QueryCompilationErrors$.MODULE$.queryFromRawFilesIncludeCorruptRecordColumnError();
            }
        }
        return (Function1 & Serializable)file -> {
            JacksonParser parser = new JacksonParser((DataType)actualSchema, (JSONOptions)parsedOptions, true, filters);
            return JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions).readFile(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), (PartitionedFile)file, parser, requiredSchema);
        };
    }

    public String toString() {
        return "JSON";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof JsonFileFormat;
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType) && this.supportDataType(valueType);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType());
        } else {
            bl = dataType2 instanceof NullType;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$1(JSONOptionsInRead parsedOptions$2, StructField x$1) {
        String string = x$1.name();
        String string2 = parsedOptions$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public JsonFileFormat() {
        this.shortName = "json";
    }
}

