/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.FileSourceMetadataAttribute$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FileFormat$ {
    public static final FileFormat$ MODULE$ = new FileFormat$();
    private static final String FILE_PATH = "file_path";
    private static final String FILE_NAME = "file_name";
    private static final String FILE_BLOCK_START = "file_block_start";
    private static final String FILE_BLOCK_LENGTH = "file_block_length";
    private static final String FILE_SIZE = "file_size";
    private static final String FILE_MODIFICATION_TIME = "file_modification_time";
    private static final String ROW_INDEX = "row_index";
    private static final String ROW_INDEX_TEMPORARY_COLUMN_NAME = new StringBuilder(14).append("_tmp_metadata_").append(MODULE$.ROW_INDEX()).toString();
    private static final String METADATA_NAME = "_metadata";
    private static final String OPTION_RETURNING_BATCH = "returning_batch";
    private static final StructType BASE_METADATA_STRUCT = new StructType().add(new StructField(MODULE$.FILE_PATH(), (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())).add(new StructField(MODULE$.FILE_NAME(), (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())).add(new StructField(MODULE$.FILE_SIZE(), (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())).add(new StructField(MODULE$.FILE_BLOCK_START(), (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())).add(new StructField(MODULE$.FILE_BLOCK_LENGTH(), (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())).add(new StructField(MODULE$.FILE_MODIFICATION_TIME(), (DataType)TimestampType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));

    public String FILE_PATH() {
        return FILE_PATH;
    }

    public String FILE_NAME() {
        return FILE_NAME;
    }

    public String FILE_BLOCK_START() {
        return FILE_BLOCK_START;
    }

    public String FILE_BLOCK_LENGTH() {
        return FILE_BLOCK_LENGTH;
    }

    public String FILE_SIZE() {
        return FILE_SIZE;
    }

    public String FILE_MODIFICATION_TIME() {
        return FILE_MODIFICATION_TIME;
    }

    public String ROW_INDEX() {
        return ROW_INDEX;
    }

    public String ROW_INDEX_TEMPORARY_COLUMN_NAME() {
        return ROW_INDEX_TEMPORARY_COLUMN_NAME;
    }

    public String METADATA_NAME() {
        return METADATA_NAME;
    }

    public String OPTION_RETURNING_BATCH() {
        return OPTION_RETURNING_BATCH;
    }

    public StructType BASE_METADATA_STRUCT() {
        return BASE_METADATA_STRUCT;
    }

    public AttributeReference createFileMetadataCol(FileFormat fileFormat) {
        StructType struct = fileFormat instanceof ParquetFileFormat ? this.BASE_METADATA_STRUCT().add(new StructField(this.ROW_INDEX(), (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())) : this.BASE_METADATA_STRUCT();
        return FileSourceMetadataAttribute$.MODULE$.apply(this.METADATA_NAME(), (DataType)struct, FileSourceMetadataAttribute$.MODULE$.apply$default$3());
    }

    public InternalRow createMetadataInternalRow(Seq<String> fieldNames, Path filePath, long fileSize, long fileModificationTime) {
        Predef$.MODULE$.assert(!fieldNames.contains((Object)this.FILE_BLOCK_START()) && !fieldNames.contains((Object)this.FILE_BLOCK_LENGTH()));
        return this.updateMetadataInternalRow((InternalRow)new GenericInternalRow(fieldNames.length()), fieldNames, filePath, fileSize, 0L, fileSize, fileModificationTime);
    }

    public InternalRow updateMetadataInternalRow(InternalRow row, Seq<String> fieldNames, Path filePath, long fileSize, long fileBlockStart, long fileBlockLength, long fileModificationTime) {
        ((IterableOnceOps)fieldNames.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            FileFormat$.$anonfun$updateMetadataInternalRow$1(filePath, row, fileSize, fileBlockStart, fileBlockLength, fileModificationTime, x0$1);
            return BoxedUnit.UNIT;
        });
        return row;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$updateMetadataInternalRow$1(Path filePath$1, InternalRow row$1, long fileSize$1, long fileBlockStart$1, long fileBlockLength$1, long fileModificationTime$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String name = (String)tuple2._1();
        int i = tuple2._2$mcI$sp();
        String string = name;
        String string2 = MODULE$.FILE_PATH();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            String pathString = new Path(filePath$1.toString()).toUri().toString();
            row$1.update(i, (Object)UTF8String.fromString((String)pathString));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = MODULE$.FILE_NAME();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                String fileName = (String)ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.refArrayOps((Object[])filePath$1.toUri().getRawPath().split("/"))).getOrElse((Function0 & Serializable)() -> "");
                row$1.update(i, (Object)UTF8String.fromString((String)fileName));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string6 = MODULE$.FILE_SIZE();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    row$1.update(i, (Object)BoxesRunTime.boxToLong((long)fileSize$1));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string8 = MODULE$.FILE_BLOCK_START();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        row$1.update(i, (Object)BoxesRunTime.boxToLong((long)fileBlockStart$1));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string10 = MODULE$.FILE_BLOCK_LENGTH();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            row$1.update(i, (Object)BoxesRunTime.boxToLong((long)fileBlockLength$1));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String string12 = MODULE$.FILE_MODIFICATION_TIME();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                row$1.update(i, (Object)BoxesRunTime.boxToLong((long)(fileModificationTime$1 * 1000L)));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                String string14 = MODULE$.ROW_INDEX();
                                String string15 = string;
                                if (string14 != null ? !string14.equals(string15) : string15 != null) throw new MatchError((Object)string);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                    }
                }
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private FileFormat$() {
    }
}

