/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnDictionary;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.DictionaryEncoding$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.StringType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tuuA\u0002\u001e<\u0011\u0003k\u0014J\u0002\u0004Lw!\u0005U\b\u0014\u0005\u0006M\u0006!\ta\u001a\u0005\bQ\u0006\u0011\r\u0011\"\u0011j\u0011\u0019i\u0017\u0001)A\u0005U\"9a.\u0001b\u0001\n\u0003y\u0007BB:\u0002A\u0003%\u0001\u000fC\u0003u\u0003\u0011\u0005S\u000fC\u0004\u0002B\u0006!\t%a1\t\u000f\t-\u0013\u0001\"\u0011\u0003N\u00191\u0011\u0011Z\u0001\u0001\u0003\u0017D!\"a\u000b\u000b\u0005\u0003\u0005\u000b\u0011BAl\u0011\u00191'\u0002\"\u0001\u0002Z\"A\u0011q\u001c\u0006A\u0002\u0013%\u0011\u000eC\u0005\u0002b*\u0001\r\u0011\"\u0003\u0002d\"9\u0011q\u001d\u0006!B\u0013Q\u0007\"CAu\u0015\u0001\u0007I\u0011BAL\u0011%\tYO\u0003a\u0001\n\u0013\ti\u000f\u0003\u0005\u0002r*\u0001\u000b\u0015BAM\u0011!\t\u0019P\u0003a\u0001\n\u0013I\u0007\"CA{\u0015\u0001\u0007I\u0011BA|\u0011\u001d\tYP\u0003Q!\n)D\u0011\"!@\u000b\u0005\u0004%I!a@\t\u0011\t]!\u0002)A\u0005\u0005\u0003A\u0011\"!\u0011\u000b\u0005\u0004%IA!\u0007\t\u0011\u0005E#\u0002)A\u0005\u00057A\u0001B!\t\u000b\u0001\u0004%I!\u001b\u0005\n\u0005GQ\u0001\u0019!C\u0005\u0005KAqA!\u000b\u000bA\u0003&!\u000eC\u0004\u0003,)!\tE!\f\t\u000f\tM\"\u0002\"\u0011\u00036!1!q\b\u0006\u0005B%DaA!\u0011\u000b\t\u0003Jg\u0001B=\u0002\u0001iD!\"!\u0007\"\u0005\u0003\u0005\u000b\u0011BA\u000e\u0011)\tY#\tB\u0001B\u0003%\u0011Q\u0006\u0005\u0007M\u0006\"\t!!\u000e\t\u0011\u0005u\u0012E1A\u0005\u0002%Dq!a\u0010\"A\u0003%!\u000eC\u0005\u0002B\u0005\u0012\r\u0011\"\u0003\u0002D!A\u0011\u0011K\u0011!\u0002\u0013\t)\u0005C\u0005\u0002T\u0005\u0002\r\u0011\"\u0003\u0002V!I\u0011\u0011L\u0011A\u0002\u0013%\u00111\f\u0005\t\u0003O\n\u0003\u0015)\u0003\u0002X!I\u0011\u0011N\u0011A\u0002\u0013%\u00111\u000e\u0005\n\u0003k\n\u0003\u0019!C\u0005\u0003oB\u0001\"a\u001f\"A\u0003&\u0011Q\u000e\u0005\b\u0003{\nC\u0011IA@\u0011\u001d\t)*\tC!\u0003/Cq!a(\"\t\u0003\n\t\u000bC\u0005\u0003b\u0005\t\t\u0011\"\u0011\u0003d!A!\u0011O\u0001\u0002\u0002\u0013\u0005\u0011\u000eC\u0005\u0003t\u0005\t\t\u0011\"\u0001\u0003v!I!\u0011P\u0001\u0002\u0002\u0013\u0005#1\u0010\u0005\n\u0005\u000b\u000b\u0011\u0011!C\u0001\u0005\u000fC\u0011Ba#\u0002\u0003\u0003%\tE!$\t\u0013\t=\u0015!!A\u0005B\tE\u0005\"\u0003BJ\u0003\u0005\u0005I\u0011\u0002BK\u0003I!\u0015n\u0019;j_:\f'/_#oG>$\u0017N\\4\u000b\u0005qj\u0014aC2p[B\u0014Xm]:j_:T!AP \u0002\u0011\r|G.^7oCJT!\u0001Q!\u0002\u0013\u0015DXmY;uS>t'B\u0001\"D\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\t\u0016\u000bQa\u001d9be.T!AR$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0015aA8sOB\u0011!*A\u0007\u0002w\t\u0011B)[2uS>t\u0017M]=F]\u000e|G-\u001b8h'\u0015\tQj\u0015,Z!\tq\u0015+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u0019\te.\u001f*fMB\u0011!\nV\u0005\u0003+n\u0012\u0011cQ8naJ,7o]5p]N\u001b\u0007.Z7f!\tqu+\u0003\u0002Y\u001f\n9\u0001K]8ek\u000e$\bC\u0001.d\u001d\tY\u0016M\u0004\u0002]A6\tQL\u0003\u0002_?\u00061AH]8piz\u001a\u0001!C\u0001Q\u0013\t\u0011w*A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0011,'\u0001D*fe&\fG.\u001b>bE2,'B\u00012P\u0003\u0019a\u0014N\\5u}Q\t\u0011*\u0001\u0004usB,\u0017\nZ\u000b\u0002UB\u0011aj[\u0005\u0003Y>\u00131!\u00138u\u0003\u001d!\u0018\u0010]3JI\u0002\nQ\"T!Y?\u0012K5\tV0T\u0013j+U#\u00019\u0011\u00059\u000b\u0018B\u0001:P\u0005\u0015\u0019\u0006n\u001c:u\u00039i\u0015\tW0E\u0013\u000e#vlU%[\u000b\u0002\nq\u0001Z3d_\u0012,'/F\u0002w\u0003s#Ra^A^\u0003{\u0003B\u0001_\u0011\u000286\t\u0011AA\u0004EK\u000e|G-\u001a:\u0016\u0007m\f\taE\u0002\"\u001br\u00042AS?\u007f\u0013\tI8\bE\u0002\u0000\u0003\u0003a\u0001\u0001B\u0004\u0002\u0004\u0005\u0012\r!!\u0002\u0003\u0003Q\u000bB!a\u0002\u0002\u000eA\u0019a*!\u0003\n\u0007\u0005-qJA\u0004O_RD\u0017N\\4\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005B\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t9\"!\u0005\u0003\u0015\u0005#x.\\5d)f\u0004X-\u0001\u0004ck\u001a4WM\u001d\t\u0005\u0003;\t9#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\rq\u0017n\u001c\u0006\u0003\u0003K\tAA[1wC&!\u0011\u0011FA\u0010\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\u000bG>dW/\u001c8UsB,\u0007#BA\u0018\u0003cqX\"A\u001f\n\u0007\u0005MRH\u0001\tOCRLg/Z\"pYVlg\u000eV=qKR1\u0011qGA\u001d\u0003w\u00012\u0001_\u0011\u007f\u0011\u001d\tI\u0002\na\u0001\u00037Aq!a\u000b%\u0001\u0004\ti#\u0001\u0006fY\u0016lWM\u001c;Ok6\f1\"\u001a7f[\u0016tGOT;nA\u0005QA-[2uS>t\u0017M]=\u0016\u0005\u0005\u0015\u0003#\u0002(\u0002H\u0005-\u0013bAA%\u001f\n)\u0011I\u001d:bsB\u0019a*!\u0014\n\u0007\u0005=sJA\u0002B]f\f1\u0002Z5di&|g.\u0019:zA\u0005i\u0011N\u001c;ES\u000e$\u0018n\u001c8bef,\"!a\u0016\u0011\t9\u000b9E[\u0001\u0012S:$H)[2uS>t\u0017M]=`I\u0015\fH\u0003BA/\u0003G\u00022ATA0\u0013\r\t\tg\u0014\u0002\u0005+:LG\u000fC\u0005\u0002f)\n\t\u00111\u0001\u0002X\u0005\u0019\u0001\u0010J\u0019\u0002\u001d%tG\u000fR5di&|g.\u0019:zA\u0005qAn\u001c8h\t&\u001cG/[8oCJLXCAA7!\u0015q\u0015qIA8!\rq\u0015\u0011O\u0005\u0004\u0003gz%\u0001\u0002'p]\u001e\f!\u0003\\8oO\u0012K7\r^5p]\u0006\u0014\u0018p\u0018\u0013fcR!\u0011QLA=\u0011%\t)'LA\u0001\u0002\u0004\ti'A\bm_:<G)[2uS>t\u0017M]=!\u0003\u0011qW\r\u001f;\u0015\r\u0005u\u0013\u0011QAI\u0011\u001d\t\u0019i\fa\u0001\u0003\u000b\u000b1A]8x!\u0011\t9)!$\u000e\u0005\u0005%%bAAF\u0003\u0006A1-\u0019;bYf\u001cH/\u0003\u0003\u0002\u0010\u0006%%aC%oi\u0016\u0014h.\u00197S_^Da!a%0\u0001\u0004Q\u0017aB8sI&t\u0017\r\\\u0001\bQ\u0006\u001ch*\u001a=u+\t\tI\nE\u0002O\u00037K1!!(P\u0005\u001d\u0011un\u001c7fC:\f!\u0002Z3d_6\u0004(/Z:t)\u0019\ti&a)\u00024\"9\u0011QU\u0019A\u0002\u0005\u001d\u0016\u0001D2pYVlgNV3di>\u0014\b\u0003BAU\u0003_k!!a+\u000b\u0007\u00055v(\u0001\u0006wK\u000e$xN]5{K\u0012LA!!-\u0002,\n!rK]5uC\ndWmQ8mk6tg+Z2u_JDa!!.2\u0001\u0004Q\u0017\u0001C2ba\u0006\u001c\u0017\u000e^=\u0011\u0007}\fI\fB\u0004\u0002\u0004\u001d\u0011\r!!\u0002\t\u000f\u0005eq\u00011\u0001\u0002\u001c!9\u00111F\u0004A\u0002\u0005}\u0006CBA\u0018\u0003c\t9,A\u0004f]\u000e|G-\u001a:\u0016\t\u0005\u0015'Q\t\u000b\u0005\u0003\u000f\u00149\u0005\u0005\u0003y\u0015\t\r#aB#oG>$WM]\u000b\u0005\u0003\u001b\f)n\u0005\u0003\u000b\u001b\u0006=\u0007#\u0002&\u0002R\u0006M\u0017bAAewA\u0019q0!6\u0005\u000f\u0005\r!B1\u0001\u0002\u0006A1\u0011qFA\u0019\u0003'$B!a7\u0002^B!\u0001PCAj\u0011\u001d\tY\u0003\u0004a\u0001\u0003/\f\u0011cX;oG>l\u0007O]3tg\u0016$7+\u001b>f\u0003UyVO\\2p[B\u0014Xm]:fINK'0Z0%KF$B!!\u0018\u0002f\"A\u0011Q\r\b\u0002\u0002\u0003\u0007!.\u0001\n`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016\u0004\u0013\u0001C8wKJ4Gn\\<\u0002\u0019=4XM\u001d4m_^|F%Z9\u0015\t\u0005u\u0013q\u001e\u0005\n\u0003K\n\u0012\u0011!a\u0001\u00033\u000b\u0011b\u001c<fe\u001adwn\u001e\u0011\u0002\u000b\r|WO\u001c;\u0002\u0013\r|WO\u001c;`I\u0015\fH\u0003BA/\u0003sD\u0001\"!\u001a\u0015\u0003\u0003\u0005\rA[\u0001\u0007G>,h\u000e\u001e\u0011\u0002\rY\fG.^3t+\t\u0011\t\u0001\u0005\u0004\u0003\u0004\t5!\u0011C\u0007\u0003\u0005\u000bQAAa\u0002\u0003\n\u00059Q.\u001e;bE2,'b\u0001B\u0006\u001f\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t=!Q\u0001\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0003\u0002T\nM\u0011\u0002\u0002B\u000b\u0003+\u0011A\"\u00138uKJt\u0017\r\u001c+za\u0016\fqA^1mk\u0016\u001c\b%\u0006\u0002\u0003\u001cA9!1\u0001B\u000f\u0003\u0017\u0002\u0018\u0002\u0002B\u0010\u0005\u000b\u0011q\u0001S1tQ6\u000b\u0007/\u0001\beS\u000e$\u0018n\u001c8bef\u001c\u0016N_3\u0002%\u0011L7\r^5p]\u0006\u0014\u0018pU5{K~#S-\u001d\u000b\u0005\u0003;\u00129\u0003\u0003\u0005\u0002fm\t\t\u00111\u0001k\u0003=!\u0017n\u0019;j_:\f'/_*ju\u0016\u0004\u0013AG4bi\",'oQ8naJ,7o]5cS2LG/_*uCR\u001cHCBA/\u0005_\u0011\t\u0004C\u0004\u0002\u0004v\u0001\r!!\"\t\r\u0005MU\u00041\u0001k\u0003!\u0019w.\u001c9sKN\u001cHCBA\u000e\u0005o\u0011Y\u0004C\u0004\u0003:y\u0001\r!a\u0007\u0002\t\u0019\u0014x.\u001c\u0005\b\u0005{q\u0002\u0019AA\u000e\u0003\t!x.\u0001\tv]\u000e|W\u000e\u001d:fgN,GmU5{K\u0006q1m\\7qe\u0016\u001c8/\u001a3TSj,\u0007cA@\u0003F\u00119\u00111\u0001\u0005C\u0002\u0005\u0015\u0001bBA\u0016\u0011\u0001\u0007!\u0011\n\t\u0007\u0003_\t\tDa\u0011\u0002\u0011M,\b\u000f]8siN$B!!'\u0003P!9\u00111F\u0005A\u0002\tE\u0003\u0007\u0002B*\u00057\u0002b!a\f\u0003V\te\u0013b\u0001B,{\tQ1i\u001c7v[:$\u0016\u0010]3\u0011\u0007}\u0014Y\u0006\u0002\u0007\u0003^\t=\u0013\u0011!A\u0001\u0006\u0003\u0011yFA\u0002`IM\nB!a\u0002\u0002L\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u001a\u0011\t\t\u001d$QN\u0007\u0003\u0005SRAAa\u001b\u0002$\u0005!A.\u00198h\u0013\u0011\u0011yG!\u001b\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0013\u0003x!A\u0011Q\r\u001b\u0002\u0002\u0003\u0007!.A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011i\b\u0005\u0004\u0003\u0000\t\u0005\u00151J\u0007\u0003\u0005\u0013IAAa!\u0003\n\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tIJ!#\t\u0013\u0005\u0015d'!AA\u0002\u0005-\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003)\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005K\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa&\u0011\t\t\u001d$\u0011T\u0005\u0005\u00057\u0013IG\u0001\u0004PE*,7\r\u001e")
public final class DictionaryEncoding {
    public static String toString() {
        return DictionaryEncoding$.MODULE$.toString();
    }

    public static int hashCode() {
        return DictionaryEncoding$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object x$1) {
        return DictionaryEncoding$.MODULE$.canEqual(x$1);
    }

    public static Iterator<Object> productIterator() {
        return DictionaryEncoding$.MODULE$.productIterator();
    }

    public static Object productElement(int x$1) {
        return DictionaryEncoding$.MODULE$.productElement(x$1);
    }

    public static int productArity() {
        return DictionaryEncoding$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return DictionaryEncoding$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return DictionaryEncoding$.MODULE$.supports(columnType);
    }

    public static <T extends AtomicType> Encoder<T> encoder(NativeColumnType<T> columnType) {
        return DictionaryEncoding$.MODULE$.encoder((NativeColumnType)columnType);
    }

    public static <T extends AtomicType> Decoder<T> decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
        return DictionaryEncoding$.MODULE$.decoder(buffer, (NativeColumnType)columnType);
    }

    public static short MAX_DICT_SIZE() {
        return DictionaryEncoding$.MODULE$.MAX_DICT_SIZE();
    }

    public static int typeId() {
        return DictionaryEncoding$.MODULE$.typeId();
    }

    public static Iterator<String> productElementNames() {
        return DictionaryEncoding$.MODULE$.productElementNames();
    }

    public static String productElementName(int n) {
        return DictionaryEncoding$.MODULE$.productElementName(n);
    }

    public static class Decoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<T> {
        private final ByteBuffer buffer;
        private final NativeColumnType<T> columnType;
        private final int elementNum;
        private final Object[] dictionary;
        private int[] intDictionary;
        private long[] longDictionary;

        public int elementNum() {
            return this.elementNum;
        }

        private Object[] dictionary() {
            return this.dictionary;
        }

        private int[] intDictionary() {
            return this.intDictionary;
        }

        private void intDictionary_$eq(int[] x$1) {
            this.intDictionary = x$1;
        }

        private long[] longDictionary() {
            return this.longDictionary;
        }

        private void longDictionary_$eq(long[] x$1) {
            this.longDictionary = x$1;
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            this.columnType.setField(row, ordinal, this.dictionary()[this.buffer.getShort()]);
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            int pos;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            T t = this.columnType.dataType();
            if (t instanceof IntegerType) {
                WritableColumnVector dictionaryIds = columnVector.reserveDictionaryIds(capacity);
                columnVector.setDictionary(new ColumnDictionary(this.intDictionary()));
                for (pos = 0; pos < capacity; ++pos) {
                    if (pos != nextNullIndex) {
                        dictionaryIds.putInt(pos, this.buffer.getShort());
                        continue;
                    }
                    if (++seenNulls < nullCount) {
                        nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                    }
                    columnVector.putNull(pos);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof LongType) {
                WritableColumnVector dictionaryIds = columnVector.reserveDictionaryIds(capacity);
                columnVector.setDictionary(new ColumnDictionary(this.longDictionary()));
                while (pos < capacity) {
                    if (pos != nextNullIndex) {
                        dictionaryIds.putInt(pos, this.buffer.getShort());
                    } else {
                        if (++seenNulls < nullCount) {
                            nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                        }
                        columnVector.putNull(pos);
                    }
                    ++pos;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new IllegalStateException("Not supported type in DictionaryEncoding.");
            }
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
            this.buffer = buffer;
            this.columnType = columnType;
            this.elementNum = ByteBufferHelper$.MODULE$.getInt(buffer);
            this.dictionary = new Object[this.elementNum()];
            this.intDictionary = null;
            this.longDictionary = null;
            T t = columnType.dataType();
            if (t instanceof IntegerType) {
                this.intDictionary_$eq(new int[this.elementNum()]);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    int v;
                    $this.intDictionary()[i] = v = BoxesRunTime.unboxToInt($this.columnType.extract($this.buffer));
                    $this.dictionary()[i] = BoxesRunTime.boxToInteger((int)v);
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof LongType) {
                this.longDictionary_$eq(new long[this.elementNum()]);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    long v;
                    $this.longDictionary()[i] = v = BoxesRunTime.unboxToLong($this.columnType.extract($this.buffer));
                    $this.dictionary()[i] = BoxesRunTime.boxToLong((long)v);
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof StringType) {
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    Object v = $this.columnType.extract($this.buffer);
                    $this.dictionary()[i] = v;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(t);
            }
        }
    }

    public static class Encoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<T> {
        private final NativeColumnType<T> columnType;
        private int _uncompressedSize;
        private boolean overflow;
        private int count;
        private final ArrayBuffer<Object> values;
        private final HashMap<Object, Object> dictionary;
        private int dictionarySize;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        private int _uncompressedSize() {
            return this._uncompressedSize;
        }

        private void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        private boolean overflow() {
            return this.overflow;
        }

        private void overflow_$eq(boolean x$1) {
            this.overflow = x$1;
        }

        private int count() {
            return this.count;
        }

        private void count_$eq(int x$1) {
            this.count = x$1;
        }

        private ArrayBuffer<Object> values() {
            return this.values;
        }

        private HashMap<Object, Object> dictionary() {
            return this.dictionary;
        }

        private int dictionarySize() {
            return this.dictionarySize;
        }

        private void dictionarySize_$eq(int x$1) {
            this.dictionarySize = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            block3: {
                Object value = this.columnType.getField(row, ordinal);
                if (this.overflow()) break block3;
                int actualSize = this.columnType.actualSize(row, ordinal);
                this.count_$eq(this.count() + 1);
                this._uncompressedSize_$eq(this._uncompressedSize() + actualSize);
                if (!this.dictionary().contains(value)) {
                    if (this.dictionary().size() < DictionaryEncoding$.MODULE$.MAX_DICT_SIZE()) {
                        Object clone = this.columnType.clone(value);
                        this.values().$plus$eq(clone);
                        this.dictionarySize_$eq(this.dictionarySize() + actualSize);
                        this.dictionary().update(clone, (Object)BoxesRunTime.boxToShort((short)((short)this.dictionary().size())));
                    } else {
                        this.overflow_$eq(true);
                        this.values().clear();
                        this.dictionary().clear();
                    }
                }
            }
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            if (this.overflow()) {
                throw QueryExecutionErrors$.MODULE$.useDictionaryEncodingWhenDictionaryOverflowError();
            }
            to.putInt(DictionaryEncoding$.MODULE$.typeId()).putInt(this.dictionary().size());
            for (int i = 0; i < this.values().length(); ++i) {
                this.columnType.append(this.values().apply(i), to);
            }
            while (from.hasRemaining()) {
                to.putShort(BoxesRunTime.unboxToShort((Object)this.dictionary().apply(this.columnType.extract(from))));
            }
            to.rewind();
            return to;
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        @Override
        public int compressedSize() {
            return this.overflow() ? Integer.MAX_VALUE : this.dictionarySize() + this.count() * 2;
        }

        public Encoder(NativeColumnType<T> columnType) {
            this.columnType = columnType;
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._uncompressedSize = 0;
            this.overflow = false;
            this.count = 0;
            this.values = new ArrayBuffer(1024);
            this.dictionary = HashMap$.MODULE$.empty();
            this.dictionarySize = 4;
        }
    }
}

