/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u0010!\u0001=B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001B\u0001B\u0003%q\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u00038\u0011!i\u0004A!A!\u0002\u00139\u0004\"\u0002 \u0001\t\u0003y\u0004\"\u0002 \u0001\t\u00039\u0005\"\u0002 \u0001\t\u0003\u0001\u0006\"B-\u0001\t\u0003Q\u0006\"B.\u0001\t\u0003a\u0006\"\u00027\u0001\t\u0003i\u0007bB<\u0001#\u0003%\t\u0001\u001f\u0005\b\u0003\u000f\u0001A\u0011BA\u0005\u0011!\ti\u0002AI\u0001\n\u0013A\bbBA\u0010\u0001\u0011%\u0011\u0011\u0005\u0005\b\u0003{\u0001A\u0011AA \u0011%\t9\u0006AI\u0001\n\u0003\tI\u0006C\u0004\u0002^\u0001!I!a\u0018\t\u0013\u00055\u0004!%A\u0005\n\u0005e\u0003bBA8\u0001\u0011%\u0011\u0011\u000f\u0005\n\u0003o\u0002\u0011\u0013!C\u0005\u00033B\u0001\"!\u001f\u0001\t\u0003\u0001\u00131P\u0004\n\u0003\u0017\u0003\u0013\u0011!E\u0001\u0003\u001b3\u0001b\b\u0011\u0002\u0002#\u0005\u0011q\u0012\u0005\u0007}a!\t!!%\t\u0013\u0005M\u0005$%A\u0005\u0002\u0005U\u0005\"CAM1E\u0005I\u0011AAK\u0011%\tY\nGI\u0001\n\u0003\t)\nC\u0005\u0002\u001eb\t\n\u0011\"\u0001\u0002\u0016\"I\u0011q\u0014\r\u0012\u0002\u0013\u0005\u0011Q\u0013\u0002\u001e!\u0006\u0014\u0018/^3u)>\u001c\u0006/\u0019:l'\u000eDW-\\1D_:4XM\u001d;fe*\u0011\u0011EI\u0001\ba\u0006\u0014\u0018/^3u\u0015\t\u0019C%A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0013'\u0003%)\u00070Z2vi&|gN\u0003\u0002(Q\u0005\u00191/\u001d7\u000b\u0005%R\u0013!B:qCJ\\'BA\u0016-\u0003\u0019\t\u0007/Y2iK*\tQ&A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001aA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t1\u0011I\\=SK\u001a\fA#Y:tk6,')\u001b8befL5o\u0015;sS:<\u0007CA\u00199\u0013\tI$GA\u0004C_>dW-\u00198\u0002-\u0005\u001c8/^7f\u0013:$\u0018HN%t)&lWm\u001d;b[B\fQbY1tKN+gn]5uSZ,\u0017!E5oM\u0016\u0014H+[7fgR\fW\u000e\u001d(U5\u0006Ya.\u00198pg\u0006\u001bHj\u001c8h\u0003\u0019a\u0014N\\5u}Q1\u0001IQ\"E\u000b\u001a\u0003\"!\u0011\u0001\u000e\u0003\u0001BqA\u000e\u0004\u0011\u0002\u0003\u0007q\u0007C\u0004;\rA\u0005\t\u0019A\u001c\t\u000fm2\u0001\u0013!a\u0001o!9AH\u0002I\u0001\u0002\u00049\u0004bB\u001f\u0007!\u0003\u0005\ra\u000e\u000b\u0003\u0001\"CQ!S\u0004A\u0002)\u000bAaY8oMB\u00111JT\u0007\u0002\u0019*\u0011QJJ\u0001\tS:$XM\u001d8bY&\u0011q\n\u0014\u0002\b'Fc5i\u001c8g)\t\u0001\u0015\u000bC\u0003J\u0011\u0001\u0007!\u000b\u0005\u0002T/6\tAK\u0003\u0002J+*\u0011aKK\u0001\u0007Q\u0006$wn\u001c9\n\u0005a#&!D\"p]\u001aLw-\u001e:bi&|g.A\u000bjgRKW.Z:uC6\u0004h\n\u0016.F]\u0006\u0014G.\u001a3\u0015\u0003]\nqaY8om\u0016\u0014H\u000f\u0006\u0002^GB\u0011a,Y\u0007\u0002?*\u0011\u0001MJ\u0001\u0006if\u0004Xm]\u0005\u0003E~\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015!'\u00021\u0001f\u00035\u0001\u0018M]9vKR\u001c6\r[3nCB\u0011aM[\u0007\u0002O*\u0011\u0001.[\u0001\u0007g\u000eDW-\\1\u000b\u0005\u0005R\u0013BA6h\u0005-iUm]:bO\u0016$\u0016\u0010]3\u0002)\r|gN^3siB\u000b'/];fi\u000e{G.^7o)\rq\u0017O\u001d\t\u0003\u0003>L!\u0001\u001d\u0011\u0003\u001bA\u000b'/];fi\u000e{G.^7o\u0011\u0015!7\u00021\u0001f\u0011\u001d\u00198\u0002%AA\u0002Q\fqb\u001d9be.\u0014V-\u00193TG\",W.\u0019\t\u0004cUl\u0016B\u0001<3\u0005\u0019y\u0005\u000f^5p]\u0006q2m\u001c8wKJ$\b+\u0019:rk\u0016$8i\u001c7v[:$C-\u001a4bk2$HEM\u000b\u0002s*\u0012AO_\u0016\u0002wB\u0019A0a\u0001\u000e\u0003uT!A`@\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0001e\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005\u0015QPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqbY8om\u0016\u0014H/\u00138uKJt\u0017\r\u001c\u000b\u0006]\u0006-\u00111\u0004\u0005\b\u0003\u001bi\u0001\u0019AA\b\u0003-9'o\\;q\u0007>dW/\u001c8\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006j\u0003\tIw.\u0003\u0003\u0002\u001a\u0005M!!D$s_V\u00048i\u001c7v[:Lu\nC\u0004t\u001bA\u0005\t\u0019\u0001;\u00023\r|gN^3si&sG/\u001a:oC2$C-\u001a4bk2$HEM\u0001\u0013]>\u0014X.\u00197ju\u00164\u0015.\u001a7e\u001d\u0006lW\r\u0006\u0003\u0002$\u0005e\u0002\u0003BA\u0013\u0003gqA!a\n\u00020A\u0019\u0011\u0011\u0006\u001a\u000e\u0005\u0005-\"bAA\u0017]\u00051AH]8pizJ1!!\r3\u0003\u0019\u0001&/\u001a3fM&!\u0011QGA\u001c\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0007\u001a\t\u000f\u0005mr\u00021\u0001\u0002$\u0005!a.Y7f\u00031\u0019wN\u001c<feR4\u0015.\u001a7e)\u0015q\u0017\u0011IA&\u0011\u001d\t\u0019\u0005\u0005a\u0001\u0003\u000b\nQAZ5fY\u0012\u0004B!!\u0005\u0002H%!\u0011\u0011JA\n\u0005!\u0019u\u000e\\;n]&{\u0005\"CA'!A\u0005\t\u0019AA(\u00035\u0019\b/\u0019:l%\u0016\fG\rV=qKB!\u0011'^A)!\rq\u00161K\u0005\u0004\u0003+z&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002-\r|gN^3si\u001aKW\r\u001c3%I\u00164\u0017-\u001e7uII*\"!a\u0017+\u0007\u0005=#0A\u000bd_:4XM\u001d;Qe&l\u0017\u000e^5wK\u001aKW\r\u001c3\u0015\u000b9\f\t'a\u001b\t\u000f\u0005\r$\u00031\u0001\u0002f\u0005y\u0001O]5nSRLg/Z\"pYVlg\u000e\u0005\u0003\u0002\u0012\u0005\u001d\u0014\u0002BA5\u0003'\u0011\u0011\u0003\u0015:j[&$\u0018N^3D_2,XN\\%P\u0011%\tiE\u0005I\u0001\u0002\u0004\ty%A\u0010d_:4XM\u001d;Qe&l\u0017\u000e^5wK\u001aKW\r\u001c3%I\u00164\u0017-\u001e7uII\n\u0011cY8om\u0016\u0014Ho\u0012:pkB4\u0015.\u001a7e)\u0015q\u00171OA;\u0011\u001d\ti\u0001\u0006a\u0001\u0003\u001fA\u0011\"!\u0014\u0015!\u0003\u0005\r!a\u0014\u00027\r|gN^3si\u001e\u0013x.\u001e9GS\u0016dG\r\n3fM\u0006,H\u000e\u001e\u00133\u00035I7/\u00127f[\u0016tG\u000fV=qKR)q'! \u0002\b\"9\u0011q\u0010\fA\u0002\u0005\u0005\u0015\u0001\u0004:fa\u0016\fG/\u001a3UsB,\u0007c\u00014\u0002\u0004&\u0019\u0011QQ4\u0003\tQK\b/\u001a\u0005\b\u0003\u00133\u0002\u0019AA\u0012\u0003)\u0001\u0018M]3oi:\u000bW.Z\u0001\u001e!\u0006\u0014\u0018/^3u)>\u001c\u0006/\u0019:l'\u000eDW-\\1D_:4XM\u001d;feB\u0011\u0011\tG\n\u00031A\"\"!!$\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t9J\u000b\u00028u\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\u000e")
public class ParquetToSparkSchemaConverter {
    private final boolean assumeBinaryIsString;
    private final boolean assumeInt96IsTimestamp;
    private final boolean caseSensitive;
    private final boolean inferTimestampNTZ;
    private final boolean nanosAsLong;

    public static boolean $lessinit$greater$default$5() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$4() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$3() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public boolean isTimestampNTZEnabled() {
        return this.inferTimestampNTZ;
    }

    public StructType convert(MessageType parquetSchema) {
        MessageColumnIO column = new ColumnIOFactory().getColumnIO(parquetSchema);
        ParquetColumn converted = this.convertInternal((GroupColumnIO)column, this.convertInternal$default$2());
        return (StructType)converted.sparkType();
    }

    public ParquetColumn convertParquetColumn(MessageType parquetSchema, Option<StructType> sparkReadSchema) {
        MessageColumnIO column = new ColumnIOFactory().getColumnIO(parquetSchema);
        return this.convertInternal((GroupColumnIO)column, sparkReadSchema);
    }

    public Option<StructType> convertParquetColumn$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertInternal(GroupColumnIO groupColumn, Option<StructType> sparkReadSchema) {
        Option schemaMapOpt = sparkReadSchema.map((Function1 & Serializable & scala.Serializable)schema -> ((TraversableOnce)schema.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.normalizeFieldName(f.name())), f), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        IndexedSeq converted = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), groupColumn.getChildrenCount()).map((Function1 & Serializable & scala.Serializable)i -> ParquetToSparkSchemaConverter.$anonfun$convertInternal$3(this, groupColumn, schemaMapOpt, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return ParquetColumn$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)converted.map((Function1 & Serializable & scala.Serializable)x$3 -> (StructField)x$3._1(), IndexedSeq$.MODULE$.canBuildFrom())), groupColumn, (Seq<ParquetColumn>)((Seq)converted.map((Function1 & Serializable & scala.Serializable)x$4 -> (ParquetColumn)x$4._2(), IndexedSeq$.MODULE$.canBuildFrom())));
    }

    private Option<StructType> convertInternal$default$2() {
        return None$.MODULE$;
    }

    private String normalizeFieldName(String name) {
        if (this.caseSensitive) {
            return name;
        }
        return name.toLowerCase(Locale.ROOT);
    }

    public ParquetColumn convertField(ColumnIO field, Option<DataType> sparkReadType) {
        Option targetType = sparkReadType.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DataType dataType = x0$1;
            if (dataType instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType;
                return userDefinedType.sqlType();
            }
            return dataType;
        });
        ColumnIO columnIO = field;
        if (columnIO instanceof PrimitiveColumnIO) {
            PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
            return this.convertPrimitiveField(primitiveColumnIO, (Option<DataType>)targetType);
        }
        if (columnIO instanceof GroupColumnIO) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            return this.convertGroupField(groupColumnIO, (Option<DataType>)targetType);
        }
        throw new MatchError((Object)columnIO);
    }

    public Option<DataType> convertField$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertPrimitiveField(PrimitiveColumnIO primitiveColumn, Option<DataType> sparkReadType) {
        PrimitiveType parquetType = primitiveColumn.getType().asPrimitiveType();
        LogicalTypeAnnotation typeAnnotation = primitiveColumn.getType().getLogicalTypeAnnotation();
        PrimitiveType.PrimitiveTypeName typeName = primitiveColumn.getPrimitive();
        DataType sparkType = (DataType)sparkReadType.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            PrimitiveType.PrimitiveTypeName primitiveTypeName;
            block51: {
                LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalTypeAnnotation;
                boolean bl;
                block52: {
                    block53: {
                        primitiveTypeName = typeName;
                        if (PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(primitiveTypeName)) {
                            return BooleanType$.MODULE$;
                        }
                        if (PrimitiveType.PrimitiveTypeName.FLOAT.equals(primitiveTypeName)) {
                            return FloatType$.MODULE$;
                        }
                        if (PrimitiveType.PrimitiveTypeName.DOUBLE.equals(primitiveTypeName)) {
                            return DoubleType$.MODULE$;
                        }
                        if (PrimitiveType.PrimitiveTypeName.INT32.equals(primitiveTypeName)) {
                            boolean bl2 = false;
                            LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalTypeAnnotation = null;
                            LogicalTypeAnnotation logicalTypeAnnotation = typeAnnotation;
                            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                                bl2 = true;
                                intLogicalTypeAnnotation = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation;
                                if (intLogicalTypeAnnotation.isSigned()) {
                                    int n = intLogicalTypeAnnotation.getBitWidth();
                                    switch (n) {
                                        case 8: {
                                            return ByteType$.MODULE$;
                                        }
                                        case 16: {
                                            return ShortType$.MODULE$;
                                        }
                                        case 32: {
                                            return IntegerType$.MODULE$;
                                        }
                                    }
                                    throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                                }
                            }
                            if (logicalTypeAnnotation == null) {
                                return IntegerType$.MODULE$;
                            }
                            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                                return DateType$.MODULE$;
                            }
                            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                                return ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_INT_DIGITS(), typeAnnotation, typeName);
                            }
                            if (bl2 && !intLogicalTypeAnnotation.isSigned()) {
                                int n = intLogicalTypeAnnotation.getBitWidth();
                                switch (n) {
                                    case 8: {
                                        return ShortType$.MODULE$;
                                    }
                                    case 16: {
                                        return IntegerType$.MODULE$;
                                    }
                                    case 32: {
                                        return LongType$.MODULE$;
                                    }
                                }
                                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                            }
                            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                                LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalTypeAnnotation2 = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation;
                                LogicalTypeAnnotation.TimeUnit timeUnit = timestampLogicalTypeAnnotation2.getUnit();
                                LogicalTypeAnnotation.TimeUnit timeUnit2 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                                if (!(timeUnit != null ? !timeUnit.equals(timeUnit2) : timeUnit2 != null)) {
                                    throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeAnnotation, typeName);
                                }
                            }
                            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                        }
                        if (!PrimitiveType.PrimitiveTypeName.INT64.equals(primitiveTypeName)) break block51;
                        boolean bl3 = false;
                        LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalTypeAnnotation = null;
                        bl = false;
                        timestampLogicalTypeAnnotation = null;
                        LogicalTypeAnnotation logicalTypeAnnotation = typeAnnotation;
                        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                            bl3 = true;
                            intLogicalTypeAnnotation = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation;
                            if (intLogicalTypeAnnotation.isSigned()) {
                                int n = intLogicalTypeAnnotation.getBitWidth();
                                switch (n) {
                                    case 64: {
                                        return LongType$.MODULE$;
                                    }
                                }
                                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                            }
                        }
                        if (logicalTypeAnnotation == null) {
                            return LongType$.MODULE$;
                        }
                        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                            return ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_LONG_DIGITS(), typeAnnotation, typeName);
                        }
                        if (bl3 && !intLogicalTypeAnnotation.isSigned()) {
                            int n = intLogicalTypeAnnotation.getBitWidth();
                            switch (n) {
                                case 64: {
                                    return new DecimalType(20, 0);
                                }
                            }
                            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                        }
                        if (!(logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)) break block52;
                        bl = true;
                        timestampLogicalTypeAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation;
                        LogicalTypeAnnotation.TimeUnit timeUnit = timestampLogicalTypeAnnotation.getUnit();
                        LogicalTypeAnnotation.TimeUnit timeUnit3 = LogicalTypeAnnotation.TimeUnit.MICROS;
                        if (!(timeUnit == null ? timeUnit3 != null : !timeUnit.equals(timeUnit3))) break block53;
                        LogicalTypeAnnotation.TimeUnit timeUnit4 = timestampLogicalTypeAnnotation.getUnit();
                        LogicalTypeAnnotation.TimeUnit timeUnit5 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                        if (timeUnit4 != null ? !timeUnit4.equals(timeUnit5) : timeUnit5 != null) break block52;
                    }
                    if (timestampLogicalTypeAnnotation.isAdjustedToUTC() || !$this.inferTimestampNTZ) {
                        return TimestampType$.MODULE$;
                    }
                    return TimestampNTZType$.MODULE$;
                }
                if (bl) {
                    LogicalTypeAnnotation.TimeUnit timeUnit = timestampLogicalTypeAnnotation.getUnit();
                    LogicalTypeAnnotation.TimeUnit timeUnit6 = LogicalTypeAnnotation.TimeUnit.NANOS;
                    if (!(timeUnit != null ? !timeUnit.equals(timeUnit6) : timeUnit6 != null) && $this.nanosAsLong) {
                        return LongType$.MODULE$;
                    }
                }
                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
            }
            if (PrimitiveType.PrimitiveTypeName.INT96.equals(primitiveTypeName)) {
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> $this.assumeInt96IsTimestamp, new StringBuilder(88).append("INT96 is not supported unless it's interpreted as timestamp. ").append("Please try to set ").append(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()).append(" to true.").toString());
                return TimestampType$.MODULE$;
            }
            if (PrimitiveType.PrimitiveTypeName.BINARY.equals(primitiveTypeName)) {
                boolean bl = false;
                LogicalTypeAnnotation logicalTypeAnnotation = null;
                LogicalTypeAnnotation logicalTypeAnnotation2 = typeAnnotation;
                if (logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation ? true : (logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.EnumLogicalTypeAnnotation ? true : logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.JsonLogicalTypeAnnotation)) {
                    return StringType$.MODULE$;
                }
                if (logicalTypeAnnotation2 == null) {
                    bl = true;
                    logicalTypeAnnotation = logicalTypeAnnotation2;
                    if ($this.assumeBinaryIsString) {
                        return StringType$.MODULE$;
                    }
                }
                if (bl) {
                    return BinaryType$.MODULE$;
                }
                if (logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.BsonLogicalTypeAnnotation) {
                    return BinaryType$.MODULE$;
                }
                if (logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    return ParquetToSparkSchemaConverter.makeDecimalType$1(ParquetToSparkSchemaConverter.makeDecimalType$default$1$1(), typeAnnotation, typeName);
                }
                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
            }
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(primitiveTypeName)) {
                LogicalTypeAnnotation logicalTypeAnnotation = typeAnnotation;
                if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    return ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.maxPrecisionForBytes(parquetType.getTypeLength()), typeAnnotation, typeName);
                }
                if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntervalLogicalTypeAnnotation) {
                    throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeAnnotation, typeName);
                }
                if (logicalTypeAnnotation == null) {
                    return BinaryType$.MODULE$;
                }
                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
            }
            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
        });
        return ParquetColumn$.MODULE$.apply(sparkType, primitiveColumn);
    }

    private Option<DataType> convertPrimitiveField$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertGroupField(GroupColumnIO groupColumn, Option<DataType> sparkReadType) {
        GroupType field = groupColumn.getType().asGroupType();
        return (ParquetColumn)Option$.MODULE$.apply((Object)field.getLogicalTypeAnnotation()).fold((Function0 & Serializable & scala.Serializable)() -> this.convertInternal(groupColumn, (Option<StructType>)sparkReadType.map((Function1 & Serializable & scala.Serializable)x$5 -> (StructType)x$5)), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogicalTypeAnnotation logicalTypeAnnotation = x0$1;
            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1, new StringBuilder(18).append("Invalid list type ").append(field).toString());
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> sparkReadType.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ParquetToSparkSchemaConverter.$anonfun$convertGroupField$6(x$6))), new StringBuilder(61).append("Invalid Spark read type: expected ").append(field).append(" to be list type but found ").append(sparkReadType).toString());
                ColumnIO repeated = groupColumn.getChild(0);
                Type repeatedType = repeated.getType();
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> repeatedType.isRepetition(Type.Repetition.REPEATED), new StringBuilder(18).append("Invalid list type ").append(field).toString());
                Option sparkReadElementType = sparkReadType.map((Function1 & Serializable & scala.Serializable)x$7 -> ((ArrayType)x$7).elementType());
                if (this.isElementType(repeatedType, field.getName())) {
                    ObjectRef converted = ObjectRef.create((Object)this.convertField(repeated, (Option<DataType>)sparkReadElementType));
                    DataType convertedType = (DataType)sparkReadElementType.getOrElse((Function0 & Serializable & scala.Serializable)() -> ((ParquetColumn)converted$1.elem).sparkType());
                    if (repeatedType.isPrimitive()) {
                        ParquetColumn qual$1 = (ParquetColumn)converted.elem;
                        boolean x$1 = true;
                        DataType x$2 = qual$1.copy$default$1();
                        Option<ColumnDescriptor> x$3 = qual$1.copy$default$2();
                        int x$4 = qual$1.copy$default$3();
                        int x$5 = qual$1.copy$default$4();
                        Seq<String> x$6 = qual$1.copy$default$6();
                        Seq<ParquetColumn> x$72 = qual$1.copy$default$7();
                        converted.elem = qual$1.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$72);
                    }
                    return ParquetColumn$.MODULE$.apply((DataType)new ArrayType(convertedType, false), groupColumn, (Seq<ParquetColumn>)((Seq)new .colon.colon((Object)((ParquetColumn)converted.elem), (List)Nil$.MODULE$)));
                }
                ColumnIO element = ((GroupColumnIO)repeated).getChild(0);
                ParquetColumn converted = this.convertField(element, (Option<DataType>)sparkReadElementType);
                DataType convertedType = (DataType)sparkReadElementType.getOrElse((Function0 & Serializable & scala.Serializable)() -> converted.sparkType());
                boolean optional = element.getType().isRepetition(Type.Repetition.OPTIONAL);
                return ParquetColumn$.MODULE$.apply((DataType)new ArrayType(convertedType, optional), groupColumn, (Seq<ParquetColumn>)((Seq)new .colon.colon((Object)converted, (List)Nil$.MODULE$)));
            }
            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation ? true : logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapKeyValueTypeAnnotation) {
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1 && !field.getType(0).isPrimitive(), new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> sparkReadType.forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ParquetToSparkSchemaConverter.$anonfun$convertGroupField$13(x$8))), new StringBuilder(60).append("Invalid Spark read type: expected ").append(field).append(" to be map type but found ").append(sparkReadType).toString());
                GroupColumnIO keyValue = (GroupColumnIO)groupColumn.getChild(0);
                GroupType keyValueType = keyValue.getType().asGroupType();
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> keyValueType.isRepetition(Type.Repetition.REPEATED) && keyValueType.getFieldCount() == 2, new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                ColumnIO key = keyValue.getChild(0);
                ColumnIO value = keyValue.getChild(1);
                Option sparkReadKeyType = sparkReadType.map((Function1 & Serializable & scala.Serializable)x$9 -> ((MapType)x$9).keyType());
                Option sparkReadValueType = sparkReadType.map((Function1 & Serializable & scala.Serializable)x$10 -> ((MapType)x$10).valueType());
                ParquetColumn convertedKey = this.convertField(key, (Option<DataType>)sparkReadKeyType);
                ParquetColumn convertedValue = this.convertField(value, (Option<DataType>)sparkReadValueType);
                DataType convertedKeyType = (DataType)sparkReadKeyType.getOrElse((Function0 & Serializable & scala.Serializable)() -> convertedKey.sparkType());
                DataType convertedValueType = (DataType)sparkReadValueType.getOrElse((Function0 & Serializable & scala.Serializable)() -> convertedValue.sparkType());
                boolean valueOptional = value.getType().isRepetition(Type.Repetition.OPTIONAL);
                return ParquetColumn$.MODULE$.apply((DataType)new MapType(convertedKeyType, convertedValueType, valueOptional), groupColumn, (Seq<ParquetColumn>)((Seq)new .colon.colon((Object)convertedKey, (List)new .colon.colon((Object)convertedValue, (List)Nil$.MODULE$))));
            }
            throw QueryCompilationErrors$.MODULE$.unrecognizedParquetTypeError(field.toString());
        });
    }

    private Option<DataType> convertGroupField$default$2() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isElementType(Type repeatedType, String parentName) {
        if (repeatedType.isPrimitive()) return true;
        if (repeatedType.asGroupType().getFieldCount() > 1) return true;
        String string = repeatedType.getName();
        String string2 = "array";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = repeatedType.getName();
        String string4 = new StringBuilder(6).append(parentName).append("_tuple").toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ Tuple2 $anonfun$convertInternal$3(ParquetToSparkSchemaConverter $this, GroupColumnIO groupColumn$1, Option schemaMapOpt$1, int i) {
        ColumnIO field = groupColumn$1.getChild(i);
        Option fieldFromReadSchema = schemaMapOpt$1.flatMap((Function1 & Serializable & scala.Serializable)schemaMap -> schemaMap.get((Object)$this.normalizeFieldName(field.getName())));
        Option fieldReadType = fieldFromReadSchema.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType());
        Type.Repetition repetition = field.getType().getRepetition();
        Type.Repetition repetition2 = Type.Repetition.REPEATED;
        if (!(repetition != null ? !repetition.equals(repetition2) : repetition2 != null)) {
            fieldReadType = fieldReadType.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DataType dataType = x0$1;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    return new Some((Object)arrayType.elementType());
                }
                throw QueryCompilationErrors$.MODULE$.illegalParquetTypeError(groupColumn$1.toString());
            });
        }
        ParquetColumn convertedField = $this.convertField(field, (Option<DataType>)fieldReadType);
        String fieldName = (String)fieldFromReadSchema.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name()).getOrElse((Function0 & Serializable & scala.Serializable)() -> field.getType().getName());
        Type.Repetition repetition3 = field.getType().getRepetition();
        if (Type.Repetition.OPTIONAL.equals(repetition3) ? true : Type.Repetition.REQUIRED.equals(repetition3)) {
            Type.Repetition repetition4 = field.getType().getRepetition();
            Type.Repetition repetition5 = Type.Repetition.OPTIONAL;
            boolean nullable = !(repetition4 != null ? !repetition4.equals(repetition5) : repetition5 != null);
            return new Tuple2((Object)new StructField(fieldName, convertedField.sparkType(), nullable, StructField$.MODULE$.apply$default$4()), (Object)convertedField);
        }
        if (Type.Repetition.REPEATED.equals(repetition3)) {
            ArrayType arrayType = new ArrayType(convertedField.sparkType(), false);
            boolean x$12 = true;
            DataType x$22 = convertedField.copy$default$1();
            Option<ColumnDescriptor> x$3 = convertedField.copy$default$2();
            int x$4 = convertedField.copy$default$3();
            int x$5 = convertedField.copy$default$4();
            Seq<String> x$6 = convertedField.copy$default$6();
            Seq<ParquetColumn> x$7 = convertedField.copy$default$7();
            return new Tuple2((Object)new StructField(fieldName, (DataType)arrayType, false, StructField$.MODULE$.apply$default$4()), (Object)new ParquetColumn((DataType)arrayType, (Option<ColumnDescriptor>)None$.MODULE$, convertedField.repetitionLevel() - 1, convertedField.definitionLevel() - 1, true, convertedField.path(), (Seq<ParquetColumn>)((Seq)new .colon.colon((Object)convertedField.copy(x$22, x$3, x$4, x$5, x$12, x$6, x$7), (List)Nil$.MODULE$))));
        }
        throw new MatchError((Object)repetition3);
    }

    private static final String typeString$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        if (typeAnnotation$1 == null) {
            return String.valueOf(typeName$1);
        }
        return new StringBuilder(3).append(typeName$1).append(" (").append(typeAnnotation$1).append(")").toString();
    }

    private static final Nothing$ typeNotImplemented$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw QueryCompilationErrors$.MODULE$.parquetTypeUnsupportedYetError(ParquetToSparkSchemaConverter.typeString$1(typeAnnotation$1, typeName$1));
    }

    private static final Nothing$ illegalType$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw QueryCompilationErrors$.MODULE$.illegalParquetTypeError(ParquetToSparkSchemaConverter.typeString$1(typeAnnotation$1, typeName$1));
    }

    private static final DecimalType makeDecimalType$1(int maxPrecision, LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation$1;
        int precision = decimalLogicalTypeAnnotation.getPrecision();
        int scale = decimalLogicalTypeAnnotation.getScale();
        ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> maxPrecision == -1 || 1 <= precision && precision <= maxPrecision, new StringBuilder(55).append("Invalid decimal precision: ").append(typeName$1).append(" cannot store ").append(precision).append(" digits (max ").append(maxPrecision).append(")").toString());
        return new DecimalType(precision, scale);
    }

    private static final int makeDecimalType$default$1$1() {
        return -1;
    }

    public static final /* synthetic */ boolean $anonfun$convertGroupField$6(DataType x$6) {
        return x$6 instanceof ArrayType;
    }

    public static final /* synthetic */ boolean $anonfun$convertGroupField$13(DataType x$8) {
        return x$8 instanceof MapType;
    }

    public ParquetToSparkSchemaConverter(boolean assumeBinaryIsString, boolean assumeInt96IsTimestamp, boolean caseSensitive, boolean inferTimestampNTZ, boolean nanosAsLong) {
        this.assumeBinaryIsString = assumeBinaryIsString;
        this.assumeInt96IsTimestamp = assumeInt96IsTimestamp;
        this.caseSensitive = caseSensitive;
        this.inferTimestampNTZ = inferTimestampNTZ;
        this.nanosAsLong = nanosAsLong;
    }

    public ParquetToSparkSchemaConverter(SQLConf conf) {
        this(conf.isParquetBinaryAsString(), conf.isParquetINT96AsTimestamp(), conf.caseSensitiveAnalysis(), conf.parquetInferTimestampNTZEnabled(), conf.legacyParquetNanosAsLong());
    }

    public ParquetToSparkSchemaConverter(Configuration conf) {
        this(new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.CASE_SENSITIVE().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key()))).toBoolean());
    }
}

