/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.RowIndexUtil$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil;
import org.apache.spark.sql.types.StructType;

public final class ParquetRowIndexUtil$ {
    public static ParquetRowIndexUtil$ MODULE$;

    static {
        new ParquetRowIndexUtil$();
    }

    public ParquetRowIndexUtil.RowIndexGenerator createGeneratorIfNeeded(StructType sparkSchema) {
        int columnIdx = RowIndexUtil$.MODULE$.findRowIndexColumnIndexInSchema(sparkSchema);
        if (columnIdx >= 0) {
            return new ParquetRowIndexUtil.RowIndexGenerator(columnIdx);
        }
        return null;
    }

    public RecordReader<Void, InternalRow> addRowIndexToRecordReaderIfNeeded(ParquetRecordReader<InternalRow> reader, StructType sparkSchema) {
        int rowIndexColumnIdx = RowIndexUtil$.MODULE$.findRowIndexColumnIndexInSchema(sparkSchema);
        if (rowIndexColumnIdx >= 0) {
            return new ParquetRowIndexUtil.RecordReaderWithRowIndexes(reader, rowIndexColumnIdx);
        }
        return reader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRowIndexColumn(ParquetColumn column) {
        if (column.path().length() != 1) return false;
        Object object = column.path().last();
        String string = FileFormat$.MODULE$.ROW_INDEX_TEMPORARY_COLUMN_NAME();
        if (object != null) {
            if (!object.equals(string)) return false;
            return true;
        }
        if (string == null) return true;
        return false;
    }

    private ParquetRowIndexUtil$() {
        MODULE$ = this;
    }
}

