/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.FileSourceOptions;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class SchemaMergeUtils$
implements Logging {
    public static SchemaMergeUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SchemaMergeUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<StructType> mergeSchemasInParallel(SparkSession sparkSession, Map<String, String> parameters, Seq<FileStatus> files, Function3<Seq<FileStatus>, Configuration, Object, Seq<StructType>> schemaReader) {
        boolean x$2;
        Function1 & Serializable & scala.Serializable x$1;
        SerializableConfiguration serializedConf = new SerializableConfiguration(sparkSession.sessionState().newHadoopConfWithOptions(parameters));
        Seq partialFileStatusInfo = (Seq)files.map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.getPath().toString(), (Object)BoxesRunTime.boxToLong((long)f.getLen())), Seq$.MODULE$.canBuildFrom());
        int numParallelism = Math.min(Math.max(partialFileStatusInfo.size(), 1), sparkSession.sparkContext().defaultParallelism());
        boolean ignoreCorruptFiles = new FileSourceOptions(CaseInsensitiveMap$.MODULE$.apply(parameters)).ignoreCorruptFiles();
        RDD qual$1 = sparkSession.sparkContext().parallelize(partialFileStatusInfo, numParallelism, ClassTag$.MODULE$.apply(Tuple2.class));
        StructType[] partiallyMergedSchemas = (StructType[])qual$1.mapPartitions((Function1)(x$1 = (Function1 & Serializable & scala.Serializable)iterator -> {
            Seq fakeFileStatuses = iterator.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String path = (String)tuple2._1();
                    long length = tuple2._2$mcJ$sp();
                    return new FileStatus(length, false, 0, 0L, 0L, 0L, null, null, null, new Path(path));
                }
                throw new MatchError((Object)tuple2);
            }).toSeq();
            Seq schemas = (Seq)schemaReader.apply((Object)fakeFileStatuses, (Object)serializedConf.value(), (Object)BoxesRunTime.boxToBoolean((boolean)ignoreCorruptFiles));
            if (schemas.isEmpty()) {
                return package$.MODULE$.Iterator().empty();
            }
            ObjectRef mergedSchema = ObjectRef.create((Object)((StructType)schemas.head()));
            ((IterableLike)schemas.tail()).foreach((Function1 & Serializable & scala.Serializable)schema -> {
                SchemaMergeUtils$.$anonfun$mergeSchemasInParallel$4(mergedSchema, schema);
                return BoxedUnit.UNIT;
            });
            return package$.MODULE$.Iterator().single((Object)((StructType)mergedSchema.elem));
        }), x$2 = qual$1.mapPartitions$default$2(), ClassTag$.MODULE$.apply(StructType.class)).collect();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas)).isEmpty()) {
            return None$.MODULE$;
        }
        ObjectRef finalSchema = ObjectRef.create((Object)((StructType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas)).head()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas)).tail())).foreach((Function1 & Serializable & scala.Serializable)schema -> {
            SchemaMergeUtils$.$anonfun$mergeSchemasInParallel$5(finalSchema, schema);
            return BoxedUnit.UNIT;
        });
        return new Some((Object)((StructType)finalSchema.elem));
    }

    public static final /* synthetic */ void $anonfun$mergeSchemasInParallel$4(ObjectRef mergedSchema$1, StructType schema) {
        try {
            mergedSchema$1.elem = ((StructType)mergedSchema$1.elem).merge(schema);
        }
        catch (SparkException cause) {
            throw QueryExecutionErrors$.MODULE$.failedMergingSchemaError(schema, cause);
        }
    }

    public static final /* synthetic */ void $anonfun$mergeSchemasInParallel$5(ObjectRef finalSchema$1, StructType schema) {
        try {
            finalSchema$1.elem = ((StructType)finalSchema$1.elem).merge(schema);
        }
        catch (SparkException cause) {
            throw QueryExecutionErrors$.MODULE$.failedMergingSchemaError(schema, cause);
        }
    }

    private SchemaMergeUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

