/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.AppendData$;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect$;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic$;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect$;
import org.apache.spark.sql.catalyst.plans.logical.TableSpec;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsCatalogOptions;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Stable
@ScalaSignature(bytes="\u0006\u0001\r]b\u0001B A\u0005%C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\u0007C\u0002!\t\u0001\u00112\t\u000f\u0015\u0004!\u0019!C\u0005M\"1a\u000e\u0001Q\u0001\n\u001dDQa\u001c\u0001\u0005\u0002ADQa\u001c\u0001\u0005\u0002YDq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u001c!9\u0011q\u0002\u0001\u0005\u0002\u0005\u001d\u0002bBA\b\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\ty\u0004\u0001C\u0001\u0003#Bq!a\u0019\u0001\t\u0003\t)\u0007C\u0004\u0002\u0000\u0001!\t!!!\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005\u0006bBAP\u0001\u0011\u0005\u0011Q\u0016\u0005\b\u0003_\u0003A\u0011BAY\u0011\u001d\tY\f\u0001C\u0005\u0003{Cq!a4\u0001\t\u0013\t\t\u000eC\u0004\u0002V\u0002!\t!a6\t\u000f\u0005U\u0007\u0001\"\u0003\u0002^\"9\u0011Q\u001b\u0001\u0005\n\u0005m\bb\u0002B\u0005\u0001\u0011%!1\u0002\u0005\b\u00053\u0001A\u0011\u0002B\u000e\u0011\u001d\u0011\t\u0003\u0001C\u0005\u0005GAqAa\n\u0001\t\u0003\u0011I\u0003C\u0004\u0003(\u0001!IA!\f\t\u000f\t\u001d\u0002\u0001\"\u0003\u0003N!9!\u0011\u000b\u0001\u0005\n\tM\u0003b\u0002B,\u0001\u0011%!\u0011\f\u0005\b\u0005S\u0002A\u0011\u0002B6\u0011\u001d\u00119\b\u0001C\u0001\u0005sBqA!$\u0001\t\u0003\u0011y\tC\u0004\u0003\u0014\u0002!\tA!&\t\u000f\te\u0005\u0001\"\u0001\u0003\u001c\"9!q\u0014\u0001\u0005\u0002\t\u0005\u0006b\u0002BS\u0001\u0011\u0005!q\u0015\u0005\b\u0005W\u0003A\u0011\u0002BW\u0011\u001d\u0011y\r\u0001C\u0005\u0005#D\u0011\"!\u0004\u0001\u0001\u0004%IAa7\t\u0013\tu\u0007\u00011A\u0005\n\t}\u0007b\u0002Bs\u0001\u0001\u0006K\u0001\u001f\u0005\t_\u0002\u0001\r\u0011\"\u0003\u0003h\"I!\u0011\u001e\u0001A\u0002\u0013%!1\u001e\u0005\b\u0005_\u0004\u0001\u0015)\u0003t\u0011%\u0011\t\u0010\u0001a\u0001\n\u0013\u0011\u0019\u0010C\u0005\u0003v\u0002\u0001\r\u0011\"\u0003\u0003x\"A!1 \u0001!B\u0013\ty\fC\u0005\u0003~\u0002\u0001\r\u0011\"\u0003\u0003\u0000\"I11\u0001\u0001A\u0002\u0013%1Q\u0001\u0005\t\u0007\u0013\u0001\u0001\u0015)\u0003\u0004\u0002!I11\u0002\u0001A\u0002\u0013%!q \u0005\n\u0007\u001b\u0001\u0001\u0019!C\u0005\u0007\u001fA\u0001ba\u0005\u0001A\u0003&1\u0011\u0001\u0005\n\u0003\u000b\u0003\u0001\u0019!C\u0005\u0007+A\u0011b!\u0007\u0001\u0001\u0004%Iaa\u0007\t\u0011\r}\u0001\u0001)Q\u0005\u0007/A\u0011b!\t\u0001\u0001\u0004%IAa@\t\u0013\r\r\u0002\u00011A\u0005\n\r\u0015\u0002\u0002CB\u0015\u0001\u0001\u0006Ka!\u0001\u0003\u001f\u0011\u000bG/\u0019$sC6,wK]5uKJT!!\u0011\"\u0002\u0007M\fHN\u0003\u0002D\t\u0006)1\u000f]1sW*\u0011QIR\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\u000b1a\u001c:h\u0007\u0001)\"A\u0013-\u0014\u0005\u0001Y\u0005C\u0001'P\u001b\u0005i%\"\u0001(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ak%AB!osJ+g-\u0001\u0002egB\u00191\u000b\u0016,\u000e\u0003\u0001K!!\u0016!\u0003\u000f\u0011\u000bG/Y:fiB\u0011q\u000b\u0017\u0007\u0001\t\u0015I\u0006A1\u0001[\u0005\u0005!\u0016CA._!\taE,\u0003\u0002^\u001b\n9aj\u001c;iS:<\u0007C\u0001'`\u0013\t\u0001WJA\u0002B]f\fa\u0001P5oSRtDCA2e!\r\u0019\u0006A\u0016\u0005\u0006#\n\u0001\rAU\u0001\u0003I\u001a,\u0012a\u001a\t\u0003Q.t!aU5\n\u0005)\u0004\u0015a\u00029bG.\fw-Z\u0005\u0003Y6\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005)\u0004\u0015a\u00013gA\u0005!Qn\u001c3f)\t\u0019\u0017\u000fC\u0003s\u000b\u0001\u00071/\u0001\u0005tCZ,Wj\u001c3f!\t\u0019F/\u0003\u0002v\u0001\nA1+\u0019<f\u001b>$W\r\u0006\u0002do\")!O\u0002a\u0001qB\u0019\u00110!\u0001\u000f\u0005it\bCA>N\u001b\u0005a(BA?I\u0003\u0019a$o\\8u}%\u0011q0T\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0011Q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}l\u0015A\u00024pe6\fG\u000fF\u0002d\u0003\u0017Aa!!\u0004\b\u0001\u0004A\u0018AB:pkJ\u001cW-\u0001\u0004paRLwN\u001c\u000b\u0006G\u0006M\u0011q\u0003\u0005\u0007\u0003+A\u0001\u0019\u0001=\u0002\u0007-,\u0017\u0010\u0003\u0004\u0002\u001a!\u0001\r\u0001_\u0001\u0006m\u0006dW/\u001a\u000b\u0006G\u0006u\u0011q\u0004\u0005\u0007\u0003+I\u0001\u0019\u0001=\t\u000f\u0005e\u0011\u00021\u0001\u0002\"A\u0019A*a\t\n\u0007\u0005\u0015RJA\u0004C_>dW-\u00198\u0015\u000b\r\fI#a\u000b\t\r\u0005U!\u00021\u0001y\u0011\u001d\tIB\u0003a\u0001\u0003[\u00012\u0001TA\u0018\u0013\r\t\t$\u0014\u0002\u0005\u0019>tw\rF\u0003d\u0003k\t9\u0004\u0003\u0004\u0002\u0016-\u0001\r\u0001\u001f\u0005\b\u00033Y\u0001\u0019AA\u001d!\ra\u00151H\u0005\u0004\u0003{i%A\u0002#pk\ndW-A\u0004paRLwN\\:\u0015\u0007\r\f\u0019\u0005C\u0004\u0002@1\u0001\r!!\u0012\u0011\r\u0005\u001d\u0013Q\n=y\u001b\t\tIEC\u0002\u0002L5\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty%!\u0013\u0003\u00075\u000b\u0007\u000fF\u0002d\u0003'Bq!a\u0010\u000e\u0001\u0004\t)\u0006\u0005\u0004\u0002X\u0005\u0005\u0004\u0010_\u0007\u0003\u00033RA!a\u0017\u0002^\u0005!Q\u000f^5m\u0015\t\ty&\u0001\u0003kCZ\f\u0017\u0002BA(\u00033\n1\u0002]1si&$\u0018n\u001c8CsR\u00191-a\u001a\t\u000f\u0005%d\u00021\u0001\u0002l\u0005A1m\u001c7OC6,7\u000f\u0005\u0003M\u0003[B\u0018bAA8\u001b\nQAH]3qK\u0006$X\r\u001a )\u00079\t\u0019\b\u0005\u0003\u0002v\u0005mTBAA<\u0015\r\tI(T\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA?\u0003o\u0012qA^1sCJ<7/\u0001\u0005ck\u000e\\W\r\u001e\"z)\u001d\u0019\u00171QAG\u0003#Cq!!\"\u0010\u0001\u0004\t9)\u0001\u0006ok6\u0014UoY6fiN\u00042\u0001TAE\u0013\r\tY)\u0014\u0002\u0004\u0013:$\bBBAH\u001f\u0001\u0007\u00010A\u0004d_2t\u0015-\\3\t\u000f\u0005%t\u00021\u0001\u0002l!\u001aq\"a\u001d\u0002\rM|'\u000f\u001e\"z)\u0015\u0019\u0017\u0011TAN\u0011\u0019\ty\t\u0005a\u0001q\"9\u0011\u0011\u000e\tA\u0002\u0005-\u0004f\u0001\t\u0002t\u0005!1/\u0019<f)\u0011\t\u0019+!+\u0011\u00071\u000b)+C\u0002\u0002(6\u0013A!\u00168ji\"1\u00111V\tA\u0002a\fA\u0001]1uQR\u0011\u00111U\u0001\rg\u00064X-\u00138uKJt\u0017\r\u001c\u000b\u0005\u0003G\u000b\u0019\fC\u0004\u0002,N\u0001\r!!.\u0011\t1\u000b9\f_\u0005\u0004\u0003sk%AB(qi&|g.\u0001\nhKR|\u0005\u000f^5p]N<\u0016\u000e\u001e5QCRDG\u0003BA`\u0003\u001b\u0004R!!1\u0002Jbl!!a1\u000b\t\u0005m\u0013Q\u0019\u0006\u0004\u0003\u000f\u0004\u0015\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005-\u00171\u0019\u0002\u0013\u0007\u0006\u001cX-\u00138tK:\u001c\u0018\u000e^5wK6\u000b\u0007\u000fC\u0004\u0002,R\u0001\r!!.\u0002\u001dM\fg/\u001a+p-F\u001av.\u001e:dKR!\u00111UAj\u0011\u001d\tY+\u0006a\u0001\u0003k\u000b!\"\u001b8tKJ$\u0018J\u001c;p)\u0011\t\u0019+!7\t\r\u0005mg\u00031\u0001y\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0006\u0004\u0002$\u0006}\u0017\u0011\u001f\u0005\b\u0003C<\u0002\u0019AAr\u0003\u001d\u0019\u0017\r^1m_\u001e\u0004B!!:\u0002n6\u0011\u0011q\u001d\u0006\u0005\u0003C\fIOC\u0002\u0002l\u0002\u000b\u0011bY8o]\u0016\u001cGo\u001c:\n\t\u0005=\u0018q\u001d\u0002\u000e\u0007\u0006$\u0018\r\\8h!2,x-\u001b8\t\u000f\u0005Mx\u00031\u0001\u0002v\u0006)\u0011\u000eZ3oiB!\u0011Q]A|\u0013\u0011\tI0a:\u0003\u0015%#WM\u001c;jM&,'\u000f\u0006\u0003\u0002$\u0006u\bbBA\u00001\u0001\u0007!\u0011A\u0001\u000bi\u0006\u0014G.Z%eK:$\b\u0003\u0002B\u0002\u0005\u000bi!!!2\n\t\t\u001d\u0011Q\u0019\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\u0006iq-\u001a;Ck\u000e\\W\r^*qK\u000e,\"A!\u0004\u0011\u000b1\u000b9La\u0004\u0011\t\tE!QC\u0007\u0003\u0005'QA!!9\u0002F&!!q\u0003B\n\u0005)\u0011UoY6fiN\u0003XmY\u0001\u0012CN\u001cXM\u001d;O_R\u0014UoY6fi\u0016$G\u0003BAR\u0005;AaAa\b\u001b\u0001\u0004A\u0018!C8qKJ\fG/[8o\u0003Q\t7o]3si:{G\u000fU1si&$\u0018n\u001c8fIR!\u00111\u0015B\u0013\u0011\u0019\u0011yb\u0007a\u0001q\u0006Y1/\u0019<f\u0003N$\u0016M\u00197f)\u0011\t\u0019Ka\u000b\t\r\u0005mG\u00041\u0001y)!\t\u0019Ka\f\u00038\te\u0002bBAq;\u0001\u0007!\u0011\u0007\t\u0005\u0003K\u0014\u0019$\u0003\u0003\u00036\u0005\u001d(\u0001\u0004+bE2,7)\u0019;bY><\u0007bBAz;\u0001\u0007\u0011Q\u001f\u0005\b\u0005wi\u0002\u0019\u0001B\u001f\u0003%q\u0017-\\3QCJ$8\u000fE\u0003\u0003@\t\u001d\u0003P\u0004\u0003\u0003B\t\u0015cbA>\u0003D%\ta*\u0003\u0002k\u001b&!!\u0011\nB&\u0005\r\u0019V-\u001d\u0006\u0003U6#B!a)\u0003P!9\u0011q \u0010A\u0002\t\u0005\u0011aC2sK\u0006$X\rV1cY\u0016$B!a)\u0003V!9\u0011q`\u0010A\u0002\t\u0005\u0011\u0001\u00059beRLG/[8oS:<\u0017i\u001d,3+\t\u0011Y\u0006\u0005\u0004\u0003@\t\u001d#Q\f\t\u0005\u0005?\u0012)'\u0004\u0002\u0003b)!!1MAu\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\t\u001d$\u0011\r\u0002\n)J\fgn\u001d4pe6\fqd\u00195fG.\u0004\u0016M\u001d;ji&|g.\u001b8h\u001b\u0006$8\r[3t-J\"\u0016M\u00197f)\u0011\t\u0019K!\u001c\t\u000f\t=\u0014\u00051\u0001\u0003r\u0005iQ\r_5ti&tw\rV1cY\u0016\u0004B!!:\u0003t%!!QOAt\u0005\u0015!\u0016M\u00197f\u0003\u0011QGMY2\u0015\u0011\u0005\r&1\u0010B@\u0005\u0007CaA! #\u0001\u0004A\u0018aA;sY\"1!\u0011\u0011\u0012A\u0002a\fQ\u0001^1cY\u0016DqA!\"#\u0001\u0004\u00119)\u0001\u000bd_:tWm\u0019;j_:\u0004&o\u001c9feRLWm\u001d\t\u0005\u0003/\u0012I)\u0003\u0003\u0003\f\u0006e#A\u0003)s_B,'\u000f^5fg\u0006!!n]8o)\u0011\t\u0019K!%\t\r\u0005-6\u00051\u0001y\u0003\u001d\u0001\u0018M]9vKR$B!a)\u0003\u0018\"1\u00111\u0016\u0013A\u0002a\f1a\u001c:d)\u0011\t\u0019K!(\t\r\u0005-V\u00051\u0001y\u0003\u0011!X\r\u001f;\u0015\t\u0005\r&1\u0015\u0005\u0007\u0003W3\u0003\u0019\u0001=\u0002\u0007\r\u001ch\u000f\u0006\u0003\u0002$\n%\u0006BBAVO\u0001\u0007\u00010\u0001\u0006sk:\u001cu.\\7b]\u0012$BAa,\u0003FR!\u00111\u0015BY\u0011\u001d\u0011\u0019\f\u000ba\u0001\u0005k\u000bqaY8n[\u0006tG\r\u0005\u0003\u00038\n\u0005WB\u0001B]\u0015\u0011\u0011YL!0\u0002\u000f1|w-[2bY*!!qXAc\u0003\u0015\u0001H.\u00198t\u0013\u0011\u0011\u0019M!/\u0003\u00171{w-[2bYBc\u0017M\u001c\u0005\b\u0005\u000fD\u0003\u0019\u0001Be\u0003\u001d\u0019Xm]:j_:\u00042a\u0015Bf\u0013\r\u0011i\r\u0011\u0002\r'B\f'o[*fgNLwN\\\u0001\u0011Y>|7.\u001e9WeA\u0013xN^5eKJ$\"Aa5\u0011\u000b1\u000b9L!6\u0011\t\u0005\u0015(q[\u0005\u0005\u00053\f9OA\u0007UC\ndW\r\u0015:pm&$WM]\u000b\u0002q\u0006Q1o\\;sG\u0016|F%Z9\u0015\t\u0005\r&\u0011\u001d\u0005\t\u0005G\\\u0013\u0011!a\u0001q\u0006\u0019\u0001\u0010J\u0019\u0002\u000fM|WO]2fAU\t1/\u0001\u0005n_\u0012,w\fJ3r)\u0011\t\u0019K!<\t\u0011\t\rh&!AA\u0002M\fQ!\\8eK\u0002\nA\"\u001a=ue\u0006|\u0005\u000f^5p]N,\"!a0\u0002!\u0015DHO]1PaRLwN\\:`I\u0015\fH\u0003BAR\u0005sD\u0011Ba92\u0003\u0003\u0005\r!a0\u0002\u001b\u0015DHO]1PaRLwN\\:!\u0003M\u0001\u0018M\u001d;ji&|g.\u001b8h\u0007>dW/\u001c8t+\t\u0019\t\u0001E\u0003M\u0003o\u0013i$A\fqCJ$\u0018\u000e^5p]&twmQ8mk6t7o\u0018\u0013fcR!\u00111UB\u0004\u0011%\u0011\u0019\u000fNA\u0001\u0002\u0004\u0019\t!\u0001\u000bqCJ$\u0018\u000e^5p]&twmQ8mk6t7\u000fI\u0001\u0012EV\u001c7.\u001a;D_2,XN\u001c(b[\u0016\u001c\u0018!\u00062vG.,GoQ8mk6tg*Y7fg~#S-\u001d\u000b\u0005\u0003G\u001b\t\u0002C\u0005\u0003d^\n\t\u00111\u0001\u0004\u0002\u0005\u0011\"-^2lKR\u001cu\u000e\\;n]:\u000bW.Z:!+\t\u00199\u0002E\u0003M\u0003o\u000b9)\u0001\bok6\u0014UoY6fiN|F%Z9\u0015\t\u0005\r6Q\u0004\u0005\n\u0005GT\u0014\u0011!a\u0001\u0007/\t1B\\;n\u0005V\u001c7.\u001a;tA\u0005y1o\u001c:u\u0007>dW/\u001c8OC6,7/A\nt_J$8i\u001c7v[:t\u0015-\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002$\u000e\u001d\u0002\"\u0003Br{\u0005\u0005\t\u0019AB\u0001\u0003A\u0019xN\u001d;D_2,XN\u001c(b[\u0016\u001c\b\u0005K\u0002\u0001\u0007[\u0001Baa\f\u000445\u00111\u0011\u0007\u0006\u0004\u0003s\u0012\u0015\u0002BB\u001b\u0007c\u0011aa\u0015;bE2,\u0007")
public final class DataFrameWriter<T> {
    private final Dataset<Row> df;
    private String source;
    private SaveMode mode;
    private CaseInsensitiveMap<String> extraOptions;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> bucketColumnNames;
    private Option<Object> numBuckets;
    private Option<Seq<String>> sortColumnNames;

    public DataFrameWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataFrameWriter<T> mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter<T> mode(String saveMode) {
        String string = saveMode.toLowerCase(Locale.ROOT);
        if ("overwrite".equals(string)) {
            return this.mode(SaveMode.Overwrite);
        }
        if ("append".equals(string)) {
            return this.mode(SaveMode.Append);
        }
        if ("ignore".equals(string)) {
            return this.mode(SaveMode.Ignore);
        }
        if ("error".equals(string) ? true : ("errorifexists".equals(string) ? true : "default".equals(string))) {
            return this.mode(SaveMode.ErrorIfExists);
        }
        throw new IllegalArgumentException(new StringBuilder(114).append("Unknown save mode: ").append(saveMode).append(". Accepted ").append("save modes are 'overwrite', 'append', 'ignore', 'error', 'errorifexists', 'default'.").toString());
    }

    public DataFrameWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameWriter<T> option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataFrameWriter<T> option(String key, boolean value) {
        return this.option(key, Boolean.toString(value));
    }

    public DataFrameWriter<T> option(String key, long value) {
        return this.option(key, Long.toString(value));
    }

    public DataFrameWriter<T> option(String key, double value) {
        return this.option(key, Double.toString(value));
    }

    public DataFrameWriter<T> options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataFrameWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public DataFrameWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, Seq<String> colNames) {
        this.numBuckets_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)));
        String string = colName;
        this.bucketColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public DataFrameWriter<T> sortBy(String colName, Seq<String> colNames) {
        String string = colName;
        this.sortColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public void save(String path) {
        if (!this.df().sparkSession().sessionState().conf().legacyPathOptionBehavior() && this.extraOptions().contains("path")) {
            throw QueryCompilationErrors$.MODULE$.pathOptionNotSetCorrectlyWhenWritingError();
        }
        this.saveInternal((Option<String>)new Some((Object)path));
    }

    public void save() {
        this.saveInternal((Option<String>)None$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveInternal(Option<String> path) {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw QueryCompilationErrors$.MODULE$.cannotOperateOnHiveDataSourceFilesError("write");
        }
        this.assertNotBucketed("save");
        Option<TableProvider> maybeV2Provider = this.lookupV2Provider();
        if (maybeV2Provider.isDefined()) {
            TableProvider provider = (TableProvider)maybeV2Provider.get();
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(provider, this.df().sparkSession().sessionState().conf());
            CaseInsensitiveMap<String> optionsWithPath = this.getOptionsWithPath(path);
            scala.collection.immutable.Map finalOptions = sessionOptions.filterKeys((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DataFrameWriter.$anonfun$saveInternal$1(optionsWithPath, x$3))).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)optionsWithPath.originalMap());
            CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)finalOptions).asJava());
            CatalogManager catalogManager = this.df().sparkSession().sessionState().catalogManager();
            SaveMode saveMode = this.mode();
            if (((Object)((Object)SaveMode.Append)).equals((Object)saveMode) ? true : ((Object)((Object)SaveMode.Overwrite)).equals((Object)saveMode)) {
                Tuple3 tuple3;
                TableProvider tableProvider = provider;
                if (tableProvider instanceof SupportsCatalogOptions) {
                    SupportsCatalogOptions supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
                    Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
                    TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
                    tuple3 = new Tuple3((Object)catalog.loadTable(ident), (Object)new Some((Object)catalog), (Object)new Some((Object)ident));
                } else {
                    if (tableProvider == null) throw new MatchError((Object)tableProvider);
                    Table t = this.getTable$1(provider, dsOptions);
                    if (DataSourceV2Implicits$.MODULE$.TableHelper(t).supports(TableCapability.BATCH_WRITE)) {
                        tuple3 = new Tuple3((Object)t, (Object)None$.MODULE$, (Object)None$.MODULE$);
                    } else {
                        this.saveToV1Source(path);
                        return;
                    }
                }
                Tuple3 tuple32 = tuple3;
                if (tuple32 == null) {
                    throw new MatchError((Object)tuple32);
                }
                Table table = (Table)tuple32._1();
                Option catalog = (Option)tuple32._2();
                Option ident = (Option)tuple32._3();
                Tuple3 tuple33 = new Tuple3((Object)table, (Object)catalog, (Object)ident);
                Table table2 = (Table)tuple33._1();
                Option catalog2 = (Option)tuple33._2();
                Option ident2 = (Option)tuple33._3();
                DataSourceV2Relation relation = DataSourceV2Relation$.MODULE$.create(table2, catalog2, ident2, dsOptions);
                this.checkPartitioningMatchesV2Table(table2);
                SaveMode saveMode2 = this.mode();
                SaveMode saveMode3 = SaveMode.Append;
                if (!(saveMode2 != null ? !((Object)((Object)saveMode2)).equals((Object)saveMode3) : saveMode3 != null)) {
                    this.runCommand(this.df().sparkSession(), (LogicalPlan)AppendData$.MODULE$.byName((NamedRelation)relation, this.df().logicalPlan(), finalOptions));
                    return;
                }
                this.runCommand(this.df().sparkSession(), (LogicalPlan)OverwriteByExpression$.MODULE$.byName((NamedRelation)relation, this.df().logicalPlan(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), finalOptions));
                return;
            }
            TableProvider tableProvider = provider;
            if (tableProvider instanceof SupportsCatalogOptions) {
                SupportsCatalogOptions supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
                Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
                TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
                TableSpec tableSpec = new TableSpec(Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), Predef$.MODULE$.Map().empty(), this.extraOptions().get("path"), this.extraOptions().get("comment"), (Option)None$.MODULE$, false);
                String string3 = catalog.name();
                SaveMode saveMode4 = saveMode;
                SaveMode saveMode5 = SaveMode.Ignore;
                this.runCommand(this.df().sparkSession(), (LogicalPlan)new CreateTableAsSelect((LogicalPlan)new UnresolvedIdentifier((Seq)((SeqLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).toSeq().$plus$colon((Object)string3, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)ident.name(), Seq$.MODULE$.canBuildFrom()), UnresolvedIdentifier$.MODULE$.apply$default$2()), this.partitioningAsV2(), this.df().queryExecution().analyzed(), tableSpec, finalOptions, !(saveMode4 != null ? !((Object)((Object)saveMode4)).equals((Object)saveMode5) : saveMode5 != null), CreateTableAsSelect$.MODULE$.apply$default$7()));
                return;
            } else {
                if (tableProvider == null) throw new MatchError((Object)tableProvider);
                if (DataSourceV2Implicits$.MODULE$.TableHelper(this.getTable$1(provider, dsOptions)).supports(TableCapability.BATCH_WRITE)) {
                    throw QueryCompilationErrors$.MODULE$.writeWithSaveModeUnsupportedBySourceError(this.source(), saveMode.name());
                }
                this.saveToV1Source(path);
            }
            return;
        }
        this.saveToV1Source(path);
    }

    private CaseInsensitiveMap<String> getOptionsWithPath(Option<String> path) {
        if (path.isEmpty()) {
            return this.extraOptions();
        }
        return this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), path.get()));
    }

    private void saveToV1Source(Option<String> path) {
        this.partitioningColumns().foreach((Function1 & Serializable & scala.Serializable)columns -> {
            this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.PARTITIONING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)columns))));
            return BoxedUnit.UNIT;
        });
        CaseInsensitiveMap<String> optionsWithPath = this.getOptionsWithPath(path);
        SparkSession x$1 = this.df().sparkSession();
        String x$2 = this.source();
        Seq x$3 = (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        scala.collection.immutable.Map x$4 = optionsWithPath.originalMap();
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        this.runCommand(this.df().sparkSession(), new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$3, x$7, (scala.collection.immutable.Map<String, String>)x$4, x$8).planForWriting(this.mode(), this.df().logicalPlan()));
    }

    public void insertInto(String tableName) {
        Option option;
        this.assertNotBucketed("insertInto");
        if (this.partitioningColumns().isDefined()) {
            throw QueryCompilationErrors$.MODULE$.partitionByDoesNotAllowedWhenUsingInsertIntoError();
        }
        SparkSession session = this.df().sparkSession();
        boolean canUseV2 = this.lookupV2Provider().isDefined();
        Seq seq = session.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        Option option2 = this.df().sparkSession().sessionState().analyzer().NonSessionCatalogAndIdentifier().unapply(seq);
        if (!option2.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option2.get())._1();
            Identifier ident = (Identifier)((Tuple2)option2.get())._2();
            this.insertInto(catalog, ident);
            return;
        }
        Option option3 = this.df().sparkSession().sessionState().analyzer().SessionCatalogAndIdentifier().unapply(seq);
        if (!option3.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option3.get())._1();
            Identifier ident = (Identifier)((Tuple2)option3.get())._2();
            if (canUseV2 && ident.namespace().length <= 1) {
                this.insertInto(catalog, ident);
                return;
            }
        }
        if (!(option = this.df().sparkSession().sessionState().analyzer().AsTableIdentifier().unapply(seq)).isEmpty()) {
            TableIdentifier tableIdentifier = (TableIdentifier)option.get();
            this.insertInto(tableIdentifier);
            return;
        }
        throw QueryCompilationErrors$.MODULE$.cannotFindCatalogToHandleIdentifierError(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(seq).quoted());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void insertInto(CatalogPlugin catalog, Identifier ident) {
        block4: {
            block5: {
                block3: {
                    var7_3 = CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog().loadTable(ident);
                    if (var7_3 instanceof V1Table) {
                        this.insertInto(TableIdentifier$.MODULE$.apply(ident.name(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).headOption()));
                        return;
                    }
                    table = DataSourceV2Relation$.MODULE$.create(var7_3, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
                    var9_5 = this.mode();
                    if (!(SaveMode.Append.equals((Object)var9_5) != false ? true : (SaveMode.ErrorIfExists.equals((Object)var9_5) != false ? true : SaveMode.Ignore.equals((Object)var9_5) != false))) break block3;
                    v0 /* !! */  = AppendData$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), this.extraOptions().toMap());
                    break block4;
                }
                if (!SaveMode.Overwrite.equals((Object)var9_5)) break block5;
                conf = this.df().sparkSession().sessionState().conf();
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.table().partitioning())).size() <= 0) ** GOTO lbl-1000
                v1 = conf.partitionOverwriteMode();
                var12_7 = SQLConf.PartitionOverwriteMode$.MODULE$.DYNAMIC();
                if (!(v1 != null ? v1.equals(var12_7) == false : var12_7 != null)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = dynamicPartitionOverwrite = false;
                }
                v0 /* !! */  = dynamicPartitionOverwrite ? OverwritePartitionsDynamic$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), this.extraOptions().toMap()) : OverwriteByExpression$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.extraOptions().toMap());
                break block4;
            }
            throw new MatchError((Object)var9_5);
        }
        command = v0 /* !! */ ;
        this.runCommand(this.df().sparkSession(), (LogicalPlan)command);
    }

    private void insertInto(TableIdentifier tableIdent) {
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        this.runCommand(this.df().sparkSession(), (LogicalPlan)new InsertIntoStatement((LogicalPlan)UnresolvedRelation$.MODULE$.apply(tableIdent), Predef$.MODULE$.Map().empty(), (Seq)Nil$.MODULE$, this.df().logicalPlan(), !(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null), false));
    }

    private Option<BucketSpec> getBucketSpec() {
        if (this.sortColumnNames().isDefined() && this.numBuckets().isEmpty()) {
            throw QueryCompilationErrors$.MODULE$.sortByWithoutBucketingError();
        }
        return this.numBuckets().map((Function1 & Serializable & scala.Serializable)n -> DataFrameWriter.$anonfun$getBucketSpec$1(this, BoxesRunTime.unboxToInt((Object)n)));
    }

    private void assertNotBucketed(String operation) {
        if (this.getBucketSpec().isDefined()) {
            if (this.sortColumnNames().isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.bucketByUnsupportedByOperationError(operation);
            }
            throw QueryCompilationErrors$.MODULE$.bucketByAndSortByUnsupportedByOperationError(operation);
        }
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw QueryCompilationErrors$.MODULE$.operationNotSupportPartitioningError(operation);
        }
    }

    public void saveAsTable(String tableName) {
        Option option;
        SparkSession session = this.df().sparkSession();
        boolean canUseV2 = this.lookupV2Provider().isDefined();
        Seq seq = session.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        Option option2 = this.df().sparkSession().sessionState().analyzer().NonSessionCatalogAndIdentifier().unapply(seq);
        if (!option2.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option2.get())._1();
            Identifier ident = (Identifier)((Tuple2)option2.get())._2();
            this.saveAsTable(CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog(), ident, (Seq<String>)seq);
            return;
        }
        Option option3 = this.df().sparkSession().sessionState().analyzer().SessionCatalogAndIdentifier().unapply(seq);
        if (!option3.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option3.get())._1();
            Identifier ident = (Identifier)((Tuple2)option3.get())._2();
            if (canUseV2 && ident.namespace().length <= 1) {
                this.saveAsTable(CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog(), ident, (Seq<String>)seq);
                return;
            }
        }
        if (!(option = this.df().sparkSession().sessionState().analyzer().AsTableIdentifier().unapply(seq)).isEmpty()) {
            TableIdentifier tableIdentifier = (TableIdentifier)option.get();
            this.saveAsTable(tableIdentifier);
            return;
        }
        throw QueryCompilationErrors$.MODULE$.cannotFindCatalogToHandleIdentifierError(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(seq).quoted());
    }

    /*
     * Unable to fully structure code
     */
    private void saveAsTable(TableCatalog catalog, Identifier ident, Seq<String> nameParts) {
        try {
            v0 = Option$.MODULE$.apply((Object)catalog.loadTable(ident));
        }
        catch (NoSuchTableException v1) {
            v0 = None$.MODULE$;
        }
        tableOpt = v0;
        var7_5 = new Tuple2((Object)this.mode(), (Object)tableOpt);
        if (var7_5 != null && (var8_6 = (Option)var7_5._2()) instanceof Some && (var9_7 = (Some)var8_6).value() instanceof V1Table) {
            this.saveAsTable(TableIdentifier$.MODULE$.apply(ident.name(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).headOption()));
            return;
        }
        if (var7_5 == null) ** GOTO lbl-1000
        var10_8 = (SaveMode)var7_5._1();
        var11_9 = (Option)var7_5._2();
        if (SaveMode.Append.equals((Object)var10_8) && var11_9 instanceof Some) {
            var12_10 = (Some)var11_9;
            table = (Table)var12_10.value();
            this.checkPartitioningMatchesV2Table(table);
            v2Relation = DataSourceV2Relation$.MODULE$.create(table, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
            v2 = AppendData$.MODULE$.byName((NamedRelation)v2Relation, this.df().logicalPlan(), this.extraOptions().toMap());
        } else if (var7_5 != null && SaveMode.Overwrite.equals((Object)(var15_13 = (SaveMode)var7_5._1()))) {
            tableSpec = new TableSpec(Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), Predef$.MODULE$.Map().empty(), this.extraOptions().get("path"), this.extraOptions().get("comment"), (Option)None$.MODULE$, false);
            v2 = new ReplaceTableAsSelect((LogicalPlan)new UnresolvedIdentifier(nameParts, UnresolvedIdentifier$.MODULE$.apply$default$2()), this.partitioningAsV2(), this.df().queryExecution().analyzed(), tableSpec, this.extraOptions().toMap(), true, ReplaceTableAsSelect$.MODULE$.apply$default$7());
        } else if (var7_5 != null) {
            other = (SaveMode)var7_5._1();
            tableSpec = new TableSpec(Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), Predef$.MODULE$.Map().empty(), this.extraOptions().get("path"), this.extraOptions().get("comment"), (Option)None$.MODULE$, false);
            v3 = other;
            var19_17 = SaveMode.Ignore;
            v4 = !(v3 != null ? v3.equals((Object)var19_17) == false : var19_17 != null);
            v2 = new CreateTableAsSelect((LogicalPlan)new UnresolvedIdentifier(nameParts, UnresolvedIdentifier$.MODULE$.apply$default$2()), this.partitioningAsV2(), this.df().queryExecution().analyzed(), tableSpec, this.extraOptions().toMap(), v4, CreateTableAsSelect$.MODULE$.apply$default$7());
        } else {
            throw new MatchError((Object)var7_5);
        }
        command = v2;
        this.runCommand(this.df().sparkSession(), (LogicalPlan)command);
    }

    private void saveAsTable(TableIdentifier tableIdent) {
        SessionCatalog catalog = this.df().sparkSession().sessionState().catalog();
        TableIdentifier qualifiedIdent = catalog.qualifyIdentifier(tableIdent);
        boolean tableExists = catalog.tableExists(qualifiedIdent);
        String tableName = qualifiedIdent.unquotedString();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)tableExists), (Object)this.mode());
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Ignore)).equals((Object)saveMode)) {
                return;
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.ErrorIfExists)).equals((Object)saveMode)) {
                throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(qualifiedIdent);
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Overwrite)).equals((Object)saveMode)) {
                HiveTableRelation hiveTableRelation;
                BaseRelation baseRelation;
                LogicalRelation logicalRelation;
                BaseRelation dest;
                Seq srcRelations = this.df().logicalPlan().collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        A1 A1 = x1;
                        if (A1 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)A1).relation()) != null) {
                            BaseRelation baseRelation = src;
                            return (B1)baseRelation;
                        }
                        if (A1 instanceof HiveTableRelation) {
                            HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                            return (B1)hiveTableRelation.tableMeta().identifier();
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        LogicalPlan logicalPlan2 = x1;
                        if (logicalPlan2 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null) {
                            return true;
                        }
                        return logicalPlan2 instanceof HiveTableRelation;
                    }
                });
                LogicalPlan tableRelation = this.df().sparkSession().table(qualifiedIdent).queryExecution().analyzed();
                LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(tableRelation);
                if (logicalPlan2 instanceof LogicalRelation && (dest = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null && srcRelations.contains((Object)(baseRelation = dest))) {
                    throw QueryCompilationErrors$.MODULE$.cannotOverwriteTableThatIsBeingReadFromError(tableName);
                }
                if (logicalPlan2 instanceof HiveTableRelation && srcRelations.contains((Object)(hiveTableRelation = (HiveTableRelation)logicalPlan2).tableMeta().identifier())) {
                    throw QueryCompilationErrors$.MODULE$.cannotOverwriteTableThatIsBeingReadFromError(tableName);
                }
                catalog.dropTable(qualifiedIdent, true, false);
                this.createTable(qualifiedIdent);
                catalog.refreshTable(qualifiedIdent);
                return;
            }
        }
        this.createTable(qualifiedIdent);
    }

    private void createTable(TableIdentifier tableIdent) {
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap());
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, new StructType(), (Option)new Some((Object)this.source()), (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), this.getBucketSpec(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
        this.runCommand(this.df().sparkSession(), new CreateTable(tableDesc, this.mode(), (Option<LogicalPlan>)new Some((Object)this.df().logicalPlan())));
    }

    private Seq<Transform> partitioningAsV2() {
        Seq partitioning2 = (Seq)this.partitioningColumns().map((Function1 & Serializable & scala.Serializable)colNames -> (Seq)colNames.map((Function1 & Serializable & scala.Serializable)name -> new IdentityTransform(FieldReference$.MODULE$.apply(name)), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        Seq bucketing = Option$.MODULE$.option2Iterable(this.getBucketSpec().map((Function1 & Serializable & scala.Serializable)spec -> CatalogV2Implicits$.MODULE$.BucketSpecHelper(spec).asTransform())).toSeq();
        return (Seq)partitioning2.$plus$plus((GenTraversableOnce)bucketing, Seq$.MODULE$.canBuildFrom());
    }

    private void checkPartitioningMatchesV2Table(Table existingTable) {
        Seq<Transform> v2Partitions = this.partitioningAsV2();
        if (v2Partitions.isEmpty()) {
            return;
        }
        Predef$.MODULE$.require(v2Partitions.sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])existingTable.partitioning())), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("The provided partitioning does not match of the table.\n").append(" - provided: ").append(v2Partitions.mkString(", ")).append("\n").append(" - table: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingTable.partitioning())).mkString(", ")).toString());
    }

    public void jdbc(String url, String table, Properties connectionProperties) {
        this.assertNotPartitioned("jdbc");
        this.assertNotBucketed("jdbc");
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala()));
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)url), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)table), (List)Nil$.MODULE$))));
        this.format("jdbc").save();
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    public void orc(String path) {
        this.format("orc").save(path);
    }

    public void text(String path) {
        this.format("text").save(path);
    }

    public void csv(String path) {
        this.format("csv").save(path);
    }

    private void runCommand(SparkSession session, LogicalPlan command) {
        QueryExecution qe = session.sessionState().executePlan(command, session.sessionState().executePlan$default$2());
        qe.assertCommandExecuted();
    }

    private Option<TableProvider> lookupV2Provider() {
        Some some;
        Option<TableProvider> option = DataSource$.MODULE$.lookupDataSourceV2(this.source(), this.df().sparkSession().sessionState().conf());
        if (option instanceof Some && (some = (Some)option).value() instanceof FileDataSourceV2) {
            return None$.MODULE$;
        }
        return option;
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private Option<Seq<String>> bucketColumnNames() {
        return this.bucketColumnNames;
    }

    private void bucketColumnNames_$eq(Option<Seq<String>> x$1) {
        this.bucketColumnNames = x$1;
    }

    private Option<Object> numBuckets() {
        return this.numBuckets;
    }

    private void numBuckets_$eq(Option<Object> x$1) {
        this.numBuckets = x$1;
    }

    private Option<Seq<String>> sortColumnNames() {
        return this.sortColumnNames;
    }

    private void sortColumnNames_$eq(Option<Seq<String>> x$1) {
        this.sortColumnNames = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$saveInternal$1(CaseInsensitiveMap optionsWithPath$1, String x$3) {
        return !optionsWithPath$1.contains(x$3);
    }

    private final Table getTable$1(TableProvider provider$1, CaseInsensitiveStringMap dsOptions$1) {
        if (provider$1.supportsExternalMetadata()) {
            return provider$1.getTable(this.df().schema().asNullable(), (Transform[])this.partitioningAsV2().toArray(ClassTag$.MODULE$.apply(Transform.class)), dsOptions$1.asCaseSensitiveMap());
        }
        return DataSourceV2Utils$.MODULE$.getTableFromProvider(provider$1, dsOptions$1, (Option<StructType>)None$.MODULE$);
    }

    public static final /* synthetic */ BucketSpec $anonfun$getBucketSpec$1(DataFrameWriter $this, int n) {
        return new BucketSpec(n, (Seq)$this.bucketColumnNames().get(), (Seq)$this.sortColumnNames().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
    }

    public DataFrameWriter(Dataset<T> ds) {
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
        this.partitioningColumns = None$.MODULE$;
        this.bucketColumnNames = None$.MODULE$;
        this.numBuckets = None$.MODULE$;
        this.sortColumnNames = None$.MODULE$;
    }
}

