/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Catalog;
import org.apache.spark.sql.catalog.Column;
import org.apache.spark.sql.catalog.Database;
import org.apache.spark.sql.catalog.Function;
import org.apache.spark.sql.catalog.Table;
import org.apache.spark.sql.catalyst.DefinedByConstructorParams;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.internal.CatalogImpl$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005a\u0001B\u0001\u0003\u00015\u00111bQ1uC2|w-S7qY*\u00111\u0001B\u0001\tS:$XM\u001d8bY*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tqaY1uC2|w-\u0003\u0002\u0014!\t91)\u0019;bY><\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005]AR\"\u0001\u0003\n\u0005e!!\u0001D*qCJ\\7+Z:tS>t\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001e?A\u0011a\u0004A\u0007\u0002\u0005!)QC\u0007a\u0001-!)\u0011\u0005\u0001C\u0005E\u0005q1/Z:tS>t7)\u0019;bY><W#A\u0012\u0011\u0005\u0011BS\"A\u0013\u000b\u0005E1#BA\u0014\u0005\u0003!\u0019\u0017\r^1msN$\u0018BA\u0015&\u00059\u0019Vm]:j_:\u001c\u0015\r^1m_\u001eDQa\u000b\u0001\u0005\n1\nQC]3rk&\u0014X\rR1uC\n\f7/Z#ySN$8\u000f\u0006\u0002.gA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t!QK\\5u\u0011\u0015!$\u00061\u00016\u0003\u0019!'MT1nKB\u0011a'\u000f\b\u0003]]J!\u0001O\u0018\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003q=BQ!\u0010\u0001\u0005\ny\n!C]3rk&\u0014X\rV1cY\u0016,\u00050[:ugR\u0019Qf\u0010!\t\u000bQb\u0004\u0019A\u001b\t\u000b\u0005c\u0004\u0019A\u001b\u0002\u0013Q\f'\r\\3OC6,\u0007\"B\"\u0001\t\u0003\"\u0015aD2veJ,g\u000e\u001e#bi\u0006\u0014\u0017m]3\u0016\u0003UBQA\u0012\u0001\u0005B\u001d\u000b!c]3u\u0007V\u0014(/\u001a8u\t\u0006$\u0018MY1tKR\u0011Q\u0006\u0013\u0005\u0006i\u0015\u0003\r!\u000e\u0015\u0004\u000b*\u0003\u0006c\u0001\u0018L\u001b&\u0011Aj\f\u0002\u0007i\"\u0014xn^:\u0011\u0005]q\u0015BA(\u0005\u0005E\te.\u00197zg&\u001cX\t_2faRLwN\\\u0011\u0002#\u00069B-\u0019;bE\u0006\u001cX\r\t3pKN\u0004cn\u001c;!KbL7\u000f\u001e\u0005\u0006'\u0002!\t\u0005V\u0001\u000eY&\u001cH\u000fR1uC\n\f7/Z:\u0015\u0003U\u00032a\u0006,Y\u0013\t9FAA\u0004ECR\f7/\u001a;\u0011\u0005=I\u0016B\u0001.\u0011\u0005!!\u0015\r^1cCN,\u0007\"\u0002/\u0001\t\u0013i\u0016\u0001D7bW\u0016$\u0015\r^1cCN,GC\u0001-_\u0011\u0015!4\f1\u00016\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0003)a\u0017n\u001d;UC\ndWm\u001d\u000b\u0002EB\u0019qCV2\u0011\u0005=!\u0017BA3\u0011\u0005\u0015!\u0016M\u00197f\u0011\u0015\u0001\u0007\u0001\"\u0011h)\t\u0011\u0007\u000eC\u00035M\u0002\u0007Q\u0007K\u0002g\u0015BCQa\u001b\u0001\u0005\n1\f\u0011\"\\1lKR\u000b'\r\\3\u0015\u0005\rl\u0007\"\u00028k\u0001\u0004y\u0017A\u0003;bE2,\u0017\nZ3oiB\u0011\u0001/]\u0007\u0002M%\u0011!O\n\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\")A\u000f\u0001C!k\u0006iA.[:u\rVt7\r^5p]N$\u0012A\u001e\t\u0004/Y;\bCA\by\u0013\tI\bC\u0001\u0005Gk:\u001cG/[8o\u0011\u0015!\b\u0001\"\u0011|)\t1H\u0010C\u00035u\u0002\u0007Q\u0007K\u0002{\u0015BCaa \u0001\u0005\n\u0005\u0005\u0011\u0001D7bW\u00164UO\\2uS>tGcA<\u0002\u0004!9\u0011Q\u0001@A\u0002\u0005\u001d\u0011!\u00034v]\u000eLE-\u001a8u!\r\u0001\u0018\u0011B\u0005\u0004\u0003\u00171#A\u0005$v]\u000e$\u0018n\u001c8JI\u0016tG/\u001b4jKJDq!a\u0004\u0001\t\u0003\n\t\"A\u0006mSN$8i\u001c7v[:\u001cH\u0003BA\n\u00037\u0001Ba\u0006,\u0002\u0016A\u0019q\"a\u0006\n\u0007\u0005e\u0001C\u0001\u0004D_2,XN\u001c\u0005\u0007\u0003\u00065\u0001\u0019A\u001b)\u000b\u00055!*a\b\"\u0005\u0005\u0005\u0012\u0001\u0006;bE2,\u0007\u0005Z8fg\u0002rw\u000e\u001e\u0011fq&\u001cH\u000fC\u0004\u0002\u0010\u0001!\t%!\n\u0015\r\u0005M\u0011qEA\u0015\u0011\u0019!\u00141\u0005a\u0001k!1\u0011)a\tA\u0002UBS!a\tK\u0003[\t#!a\f\u0002A\u0011\fG/\u00192bg\u0016\u0004sN\u001d\u0011uC\ndW\r\t3pKN\u0004cn\u001c;!KbL7\u000f\u001e\u0005\b\u0003\u001f\u0001A\u0011BA\u001a)\u0011\t\u0019\"!\u000e\t\u000f\u0005]\u0012\u0011\u0007a\u0001_\u0006yA/\u00192mK&#WM\u001c;jM&,'\u000fC\u0004\u0002<\u0001!\t%!\u0010\u0002\u0017\u001d,G\u000fR1uC\n\f7/\u001a\u000b\u00041\u0006}\u0002B\u0002\u001b\u0002:\u0001\u0007Q\u0007C\u0004\u0002D\u0001!\t%!\u0012\u0002\u0011\u001d,G\u000fV1cY\u0016$2aYA$\u0011\u0019\t\u0015\u0011\ta\u0001k!9\u00111\t\u0001\u0005B\u0005-C#B2\u0002N\u0005=\u0003B\u0002\u001b\u0002J\u0001\u0007Q\u0007\u0003\u0004B\u0003\u0013\u0002\r!\u000e\u0005\b\u0003'\u0002A\u0011IA+\u0003-9W\r\u001e$v]\u000e$\u0018n\u001c8\u0015\u0007]\f9\u0006C\u0004\u0002Z\u0005E\u0003\u0019A\u001b\u0002\u0019\u0019,hn\u0019;j_:t\u0015-\\3\t\u000f\u0005M\u0003\u0001\"\u0011\u0002^Q)q/a\u0018\u0002b!1A'a\u0017A\u0002UBq!!\u0017\u0002\\\u0001\u0007Q\u0007C\u0004\u0002f\u0001!\t%a\u001a\u0002\u001d\u0011\fG/\u00192bg\u0016,\u00050[:ugR!\u0011\u0011NA8!\rq\u00131N\u0005\u0004\u0003[z#a\u0002\"p_2,\u0017M\u001c\u0005\u0007i\u0005\r\u0004\u0019A\u001b\t\u000f\u0005M\u0004\u0001\"\u0011\u0002v\u0005YA/\u00192mK\u0016C\u0018n\u001d;t)\u0011\tI'a\u001e\t\r\u0005\u000b\t\b1\u00016\u0011\u001d\t\u0019\b\u0001C!\u0003w\"b!!\u001b\u0002~\u0005}\u0004B\u0002\u001b\u0002z\u0001\u0007Q\u0007\u0003\u0004B\u0003s\u0002\r!\u000e\u0005\b\u0003\u0007\u0003A\u0011IAC\u000391WO\\2uS>tW\t_5tiN$B!!\u001b\u0002\b\"9\u0011\u0011LAA\u0001\u0004)\u0004bBAB\u0001\u0011\u0005\u00131\u0012\u000b\u0007\u0003S\ni)a$\t\rQ\nI\t1\u00016\u0011\u001d\tI&!#A\u0002UBq!a%\u0001\t\u0003\n)*A\u0006de\u0016\fG/\u001a+bE2,GCBAL\u0003w\u000bi\f\u0005\u0003\u0002\u001a\u0006Uf\u0002BAN\u0003csA!!(\u00020:!\u0011qTAW\u001d\u0011\t\t+a+\u000f\t\u0005\r\u0016\u0011V\u0007\u0003\u0003KS1!a*\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I1!a-\u0005\u0003\u001d\u0001\u0018mY6bO\u0016LA!a.\u0002:\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u0003g#\u0001BB!\u0002\u0012\u0002\u0007Q\u0007C\u0004\u0002@\u0006E\u0005\u0019A\u001b\u0002\tA\fG\u000f\u001b\u0015\u0005\u0003#\u000b\u0019\r\u0005\u0003\u0002F\u0006-WBAAd\u0015\r\tIMB\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAg\u0003\u000f\u0014A\"\u0012=qKJLW.\u001a8uC2Dq!a%\u0001\t\u0003\n\t\u000e\u0006\u0005\u0002\u0018\u0006M\u0017Q[Al\u0011\u0019\t\u0015q\u001aa\u0001k!9\u0011qXAh\u0001\u0004)\u0004bBAm\u0003\u001f\u0004\r!N\u0001\u0007g>,(oY3)\t\u0005=\u00171\u0019\u0005\b\u0003'\u0003A\u0011IAp)!\t9*!9\u0002d\u0006\u0015\bBB!\u0002^\u0002\u0007Q\u0007C\u0004\u0002Z\u0006u\u0007\u0019A\u001b\t\u0011\u0005\u001d\u0018Q\u001ca\u0001\u0003S\fqa\u001c9uS>t7\u000fE\u00037\u0003W,T'C\u0002\u0002nn\u00121!T1qQ\u0011\ti.a1\t\u000f\u0005M\u0005\u0001\"\u0011\u0002tRQ\u0011qSA{\u0003o\fIP!\u0003\t\r\u0005\u000b\t\u00101\u00016\u0011\u001d\tI.!=A\u0002UB\u0001\"a?\u0002r\u0002\u0007\u0011Q`\u0001\u0007g\u000eDW-\\1\u0011\t\u0005}(QA\u0007\u0003\u0005\u0003Q1Aa\u0001\u0005\u0003\u0015!\u0018\u0010]3t\u0013\u0011\u00119A!\u0001\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0005\u0002h\u0006E\b\u0019AAuQ\u0011\t\t0a1\t\u000f\t=\u0001\u0001\"\u0011\u0003\u0012\u0005aAM]8q)\u0016l\u0007OV5foR!\u0011\u0011\u000eB\n\u0011\u001d\u0011)B!\u0004A\u0002U\n\u0001B^5fo:\u000bW.\u001a\u0005\b\u00053\u0001A\u0011\tB\u000e\u0003I!'o\u001c9HY>\u0014\u0017\r\u001c+f[B4\u0016.Z<\u0015\t\u0005%$Q\u0004\u0005\b\u0005+\u00119\u00021\u00016\u0011\u001d\u0011\t\u0003\u0001C!\u0005G\t\u0011C]3d_Z,'\u000fU1si&$\u0018n\u001c8t)\ri#Q\u0005\u0005\u0007\u0003\n}\u0001\u0019A\u001b\t\u000f\t%\u0002\u0001\"\u0011\u0003,\u0005A\u0011n]\"bG\",G\r\u0006\u0003\u0002j\t5\u0002BB!\u0003(\u0001\u0007Q\u0007C\u0004\u00032\u0001!\tEa\r\u0002\u0015\r\f7\r[3UC\ndW\rF\u0002.\u0005kAa!\u0011B\u0018\u0001\u0004)\u0004b\u0002B\u0019\u0001\u0011\u0005#\u0011\b\u000b\u0006[\tm\"Q\b\u0005\u0007\u0003\n]\u0002\u0019A\u001b\t\u0011\t}\"q\u0007a\u0001\u0005\u0003\nAb\u001d;pe\u0006<W\rT3wK2\u0004BAa\u0011\u0003J5\u0011!Q\t\u0006\u0004\u0005\u000f2\u0011aB:u_J\fw-Z\u0005\u0005\u0005\u0017\u0012)E\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000eC\u0004\u0003P\u0001!\tE!\u0015\u0002\u0019Ut7-Y2iKR\u000b'\r\\3\u0015\u00075\u0012\u0019\u0006\u0003\u0004B\u0005\u001b\u0002\r!\u000e\u0005\b\u0005/\u0002A\u0011\tB-\u0003)\u0019G.Z1s\u0007\u0006\u001c\u0007.\u001a\u000b\u0002[!A!\u0011\u0006\u0001\u0005\u0012\u0011\u0011i\u0006\u0006\u0003\u0002j\t}\u0003\u0002\u0003B1\u00057\u0002\rAa\u0019\u0002\u000bEt\u0015-\\31\t\t\u0015$1\u000e\t\u0005/Y\u00139\u0007\u0005\u0003\u0003j\t-D\u0002\u0001\u0003\r\u0005[\u0012y&!A\u0001\u0002\u000b\u0005!q\u000e\u0002\u0004?\u0012\n\u0014\u0003\u0002B9\u0005o\u00022A\fB:\u0013\r\u0011)h\f\u0002\b\u001d>$\b.\u001b8h!\rq#\u0011P\u0005\u0004\u0005wz#aA!os\"9!q\u0010\u0001\u0005B\t\u0005\u0015\u0001\u0004:fMJ,7\u000f\u001b+bE2,GcA\u0017\u0003\u0004\"1\u0011I! A\u0002UBqAa\"\u0001\t\u0003\u0012I)A\u0007sK\u001a\u0014Xm\u001d5CsB\u000bG\u000f\u001b\u000b\u0004[\t-\u0005b\u0002BG\u0005\u000b\u0003\r!N\u0001\re\u0016\u001cx.\u001e:dKB\u000bG\u000f[\u0004\t\u0005#\u0013\u0001\u0012\u0001\u0003\u0003\u0014\u0006Y1)\u0019;bY><\u0017*\u001c9m!\rq\"Q\u0013\u0004\b\u0003\tA\t\u0001\u0002BL'\u0011\u0011)J!'\u0011\u00079\u0012Y*C\u0002\u0003\u001e>\u0012a!\u00118z%\u00164\u0007bB\u000e\u0003\u0016\u0012\u0005!\u0011\u0015\u000b\u0003\u0005'C\u0001B!*\u0003\u0016\u0012\u0005!qU\u0001\f[\u0006\\W\rR1uCN,G/\u0006\u0003\u0003*\nEFC\u0002BV\u0005_\u0014y\u0010\u0006\u0003\u0003.\nu\u0006\u0003B\fW\u0005_\u0003BA!\u001b\u00032\u0012A!1\u0017BR\u0005\u0004\u0011)LA\u0001U#\u0011\u0011\tHa.\u0011\u0007A\u0014I,C\u0002\u0003<\u001a\u0012!\u0004R3gS:,GMQ=D_:\u001cHO];di>\u0014\b+\u0019:b[ND!Ba0\u0003$\u0006\u0005\t9\u0001Ba\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0005\u0007\u0014\u0019Oa,\u000f\t\t\u0015'Q\u001c\b\u0005\u0005\u000f\u0014IN\u0004\u0003\u0003J\nMg\u0002\u0002Bf\u0005\u001ftA!a)\u0003N&\t\u0001'C\u0002\u0003R>\nqA]3gY\u0016\u001cG/\u0003\u0003\u0003V\n]\u0017a\u0002:v]RLW.\u001a\u0006\u0004\u0005#|\u0013\u0002BAZ\u00057TAA!6\u0003X&!!q\u001cBq\u0003!)h.\u001b<feN,'\u0002BAZ\u00057LAA!:\u0003h\n9A+\u001f9f)\u0006<\u0017\u0002\u0002Bu\u0005W\u0014\u0001\u0002V=qKR\u000bwm\u001d\u0006\u0005\u0005[\u00149.A\u0002ba&D\u0001B!=\u0003$\u0002\u0007!1_\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u0003v\ne(q\u0016\b\u0005\u0005\u0017\u001490C\u0002\u00024>JAAa?\u0003~\n\u00191+Z9\u000b\u0007\u0005Mv\u0006\u0003\u0004\u0016\u0005G\u0003\rA\u0006")
public class CatalogImpl
extends Catalog {
    public final SparkSession org$apache$spark$sql$internal$CatalogImpl$$sparkSession;

    public static <T extends DefinedByConstructorParams> Dataset<T> makeDataset(Seq<T> seq, SparkSession sparkSession, TypeTags.TypeTag<T> typeTag) {
        return CatalogImpl$.MODULE$.makeDataset(seq, sparkSession, typeTag);
    }

    public SessionCatalog org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog() {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().catalog();
    }

    private void requireDatabaseExists(String dbName) {
        if (this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().databaseExists(dbName)) {
            return;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Database '", "' does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private void requireTableExists(String dbName, String tableName) {
        if (this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().tableExists(new TableIdentifier(tableName, (Option)new Some((Object)dbName)))) {
            return;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table '", "' does not exist in database '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, dbName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    @Override
    public String currentDatabase() {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getCurrentDatabase();
    }

    @Override
    public void setCurrentDatabase(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().setCurrentDatabase(dbName);
    }

    @Override
    public Dataset<Database> listDatabases() {
        Seq databases = (Seq)this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().listDatabases().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;

            public final Database apply(String dbName) {
                return this.$outer.org$apache$spark$sql$internal$CatalogImpl$$makeDatabase(dbName);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Database").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(databases, this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(this)));
    }

    public Database org$apache$spark$sql$internal$CatalogImpl$$makeDatabase(String dbName) {
        CatalogDatabase metadata = this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getDatabaseMetadata(dbName);
        return new Database(metadata.name(), metadata.description(), CatalogUtils$.MODULE$.URIToString(metadata.locationUri()));
    }

    @Override
    public Dataset<Table> listTables() {
        return this.listTables(this.currentDatabase());
    }

    @Override
    public Dataset<Table> listTables(String dbName) throws AnalysisException {
        Seq tables = (Seq)this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().listTables(dbName).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;

            public final Table apply(TableIdentifier tableIdent) {
                return this.$outer.org$apache$spark$sql$internal$CatalogImpl$$makeTable(tableIdent);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Table").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator2$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(tables, this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator2$1(this)));
    }

    public Table org$apache$spark$sql$internal$CatalogImpl$$makeTable(TableIdentifier tableIdent) {
        Some some;
        try {
            some = new Some((Object)this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdent));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        Some metadata = some;
        boolean isTemp = this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().isTemporaryTable(tableIdent);
        return new Table(tableIdent.table(), (String)((Option)metadata.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(CatalogTable x$1) {
                return x$1.identifier().database();
            }
        }).getOrElse((Function0)new Serializable(this, tableIdent){
            public static final long serialVersionUID = 0L;
            private final TableIdentifier tableIdent$1;

            public final Option<String> apply() {
                return this.tableIdent$1.database();
            }
            {
                this.tableIdent$1 = tableIdent$1;
            }
        })).orNull(Predef$.MODULE$.$conforms()), (String)metadata.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(CatalogTable x$2) {
                return (String)x$2.comment().orNull(Predef$.MODULE$.$conforms());
            }
        }).orNull(Predef$.MODULE$.$conforms()), isTemp ? "TEMPORARY" : (String)metadata.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(CatalogTable x$3) {
                return x$3.tableType().name();
            }
        }).orNull(Predef$.MODULE$.$conforms()), isTemp);
    }

    @Override
    public Dataset<Function> listFunctions() {
        return this.listFunctions(this.currentDatabase());
    }

    @Override
    public Dataset<Function> listFunctions(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        Seq functions2 = (Seq)this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().listFunctions(dbName).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;

            public final Function apply(Tuple2<FunctionIdentifier, String> x0$1) {
                Tuple2<FunctionIdentifier, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    FunctionIdentifier functIdent = (FunctionIdentifier)tuple2._1();
                    Function function = this.$outer.org$apache$spark$sql$internal$CatalogImpl$$makeFunction(functIdent);
                    return function;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Function").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator3$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(functions2, this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator3$1(this)));
    }

    public Function org$apache$spark$sql$internal$CatalogImpl$$makeFunction(FunctionIdentifier funcIdent) {
        ExpressionInfo metadata = this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().lookupFunctionInfo(funcIdent);
        return new Function(metadata.getName(), metadata.getDb(), null, metadata.getClassName(), metadata.getDb() == null);
    }

    @Override
    public Dataset<Column> listColumns(String tableName) throws AnalysisException {
        TableIdentifier tableIdent = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.listColumns(tableIdent);
    }

    @Override
    public Dataset<Column> listColumns(String dbName, String tableName) throws AnalysisException {
        this.requireTableExists(dbName, tableName);
        return this.listColumns(new TableIdentifier(tableName, (Option)new Some((Object)dbName)));
    }

    private Dataset<Column> listColumns(TableIdentifier tableIdentifier) {
        CatalogTable tableMetadata = this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdentifier);
        Set partitionColumnNames = tableMetadata.partitionColumnNames().toSet();
        Set bucketColumnNames = ((TraversableOnce)tableMetadata.bucketSpec().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(BucketSpec x$4) {
                return x$4.bucketColumnNames();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        })).toSet();
        Seq columns2 = (Seq)tableMetadata.schema().map((Function1)new Serializable(this, partitionColumnNames, bucketColumnNames){
            public static final long serialVersionUID = 0L;
            private final Set partitionColumnNames$1;
            private final Set bucketColumnNames$1;

            public final Column apply(StructField c) {
                return new Column(c.name(), (String)c.getComment().orNull(Predef$.MODULE$.$conforms()), c.dataType().catalogString(), c.nullable(), this.partitionColumnNames$1.contains((Object)c.name()), this.bucketColumnNames$1.contains((Object)c.name()));
            }
            {
                this.partitionColumnNames$1 = partitionColumnNames$1;
                this.bucketColumnNames$1 = bucketColumnNames$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Column").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator4$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(columns2, this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator4$1(this)));
    }

    @Override
    public Database getDatabase(String dbName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$makeDatabase(dbName);
    }

    @Override
    public Table getTable(String tableName) {
        TableIdentifier tableIdent = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.getTable((String)tableIdent.database().orNull(Predef$.MODULE$.$conforms()), tableIdent.table());
    }

    @Override
    public Table getTable(String dbName, String tableName) {
        if (this.tableExists(dbName, tableName)) {
            return this.org$apache$spark$sql$internal$CatalogImpl$$makeTable(new TableIdentifier(tableName, Option$.MODULE$.apply((Object)dbName)));
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table or view '", "' not found in database '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, dbName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    @Override
    public Function getFunction(String functionName) {
        FunctionIdentifier functionIdent = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().sqlParser().parseFunctionIdentifier(functionName);
        return this.getFunction((String)functionIdent.database().orNull(Predef$.MODULE$.$conforms()), functionIdent.funcName());
    }

    @Override
    public Function getFunction(String dbName, String functionName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$makeFunction(new FunctionIdentifier(functionName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    public boolean databaseExists(String dbName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().databaseExists(dbName);
    }

    @Override
    public boolean tableExists(String tableName) {
        TableIdentifier tableIdent = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.tableExists((String)tableIdent.database().orNull(Predef$.MODULE$.$conforms()), tableIdent.table());
    }

    @Override
    public boolean tableExists(String dbName, String tableName) {
        TableIdentifier tableIdent = new TableIdentifier(tableName, Option$.MODULE$.apply((Object)dbName));
        return this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().isTemporaryTable(tableIdent) || this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().tableExists(tableIdent);
    }

    @Override
    public boolean functionExists(String functionName) {
        FunctionIdentifier functionIdent = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().sqlParser().parseFunctionIdentifier(functionName);
        return this.functionExists((String)functionIdent.database().orNull(Predef$.MODULE$.$conforms()), functionIdent.funcName());
    }

    @Override
    public boolean functionExists(String dbName, String functionName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().functionExists(new FunctionIdentifier(functionName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    @Experimental
    public Dataset<Row> createTable(String tableName, String path) {
        String dataSourceName = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().conf().defaultDataSourceName();
        return this.createTable(tableName, path, dataSourceName);
    }

    @Override
    @Experimental
    public Dataset<Row> createTable(String tableName, String path, String source) {
        return this.createTable(tableName, source, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)}))));
    }

    @Override
    @Experimental
    public Dataset<Row> createTable(String tableName, String source, Map<String, String> options) {
        return this.createTable(tableName, source, new StructType(), options);
    }

    @Override
    @Experimental
    public Dataset<Row> createTable(String tableName, String source, StructType schema2, Map<String, String> options) {
        TableIdentifier tableIdent = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions(options);
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, schema2, (Option)new Some((Object)source), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19());
        CreateTable plan = new CreateTable(tableDesc, SaveMode.ErrorIfExists, (Option<LogicalPlan>)None$.MODULE$);
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().executePlan(plan).toRdd();
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.table(tableIdent);
    }

    @Override
    public boolean dropTempView(String viewName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().catalog().getTempView(viewName).exists((Function1)new Serializable(this, viewName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;
            private final String viewName$1;

            public final boolean apply(LogicalPlan viewDef) {
                this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery(this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, viewDef, false, true);
                return this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().dropTempView(this.viewName$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.viewName$1 = viewName$1;
            }
        });
    }

    @Override
    public boolean dropGlobalTempView(String viewName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().catalog().getGlobalTempView(viewName).exists((Function1)new Serializable(this, viewName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;
            private final String viewName$2;

            public final boolean apply(LogicalPlan viewDef) {
                this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery(this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, viewDef, false, true);
                return this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().dropGlobalTempView(this.viewName$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.viewName$2 = viewName$2;
            }
        });
    }

    @Override
    public void recoverPartitions(String tableName) {
        TableIdentifier tableIdent = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().executePlan(new AlterTableRecoverPartitionsCommand(tableIdent, AlterTableRecoverPartitionsCommand$.MODULE$.apply$default$2())).toRdd();
    }

    @Override
    public boolean isCached(String tableName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().lookupCachedData(this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.table(tableName)).nonEmpty();
    }

    @Override
    public void cacheTable(String tableName) {
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().cacheQuery(this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.table(tableName), (Option<String>)new Some((Object)tableName), this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().cacheQuery$default$3());
    }

    @Override
    public void cacheTable(String tableName, StorageLevel storageLevel2) {
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().cacheQuery(this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.table(tableName), (Option<String>)new Some((Object)tableName), storageLevel2);
    }

    @Override
    public void uncacheTable(String tableName) {
        TableIdentifier tableIdent = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        boolean cascade = !this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().isTemporaryTable(tableIdent);
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery(this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.table(tableName), cascade, this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery$default$3());
    }

    @Override
    public void clearCache() {
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().clearCache();
    }

    public boolean isCached(Dataset<?> qName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().lookupCachedData(qName).nonEmpty();
    }

    @Override
    public void refreshTable(String tableName) {
        TableIdentifier tableIdent = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        CatalogTable tableMetadata = this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdent);
        Dataset<Row> table = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.table(tableIdent);
        CatalogTableType catalogTableType = tableMetadata.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            table.queryExecution().analyzed().refresh();
        } else {
            this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().refreshTable(tableIdent);
        }
        if (this.isCached(table)) {
            this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery(table, true, true);
            this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().cacheQuery(table, (Option<String>)new Some((Object)tableIdent.table()), this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().cacheQuery$default$3());
        }
    }

    @Override
    public void refreshByPath(String resourcePath) {
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().recacheByPath(this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, resourcePath);
    }

    public CatalogImpl(SparkSession sparkSession) {
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession = sparkSession;
    }
}

