/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import java.util.Optional;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.execution.streaming.continuous.RateStreamContinuousReader;
import org.apache.spark.sql.execution.streaming.sources.RateStreamMicroBatchReader;
import org.apache.spark.sql.execution.streaming.sources.RateStreamProvider$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.v2.ContinuousReadSupport;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.MicroBatchReadSupport;
import org.apache.spark.sql.sources.v2.reader.streaming.ContinuousReader;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.types.StructType;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001E\u0011!CU1uKN#(/Z1n!J|g/\u001b3fe*\u00111\u0001B\u0001\bg>,(oY3t\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\nKb,7-\u001e;j_:T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\n\u001bC\u0011:\u0003CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0011a\u0017M\\4\u000b\u0003]\tAA[1wC&\u0011\u0011\u0004\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005myR\"\u0001\u000f\u000b\u0005uq\u0012A\u0001<3\u0015\t\u0019\u0001\"\u0003\u0002!9\taA)\u0019;b'>,(oY3WeA\u00111DI\u0005\u0003Gq\u0011Q#T5de>\u0014\u0015\r^2i%\u0016\fGmU;qa>\u0014H\u000f\u0005\u0002\u001cK%\u0011a\u0005\b\u0002\u0016\u0007>tG/\u001b8v_V\u001c(+Z1e'V\u0004\bo\u001c:u!\tA\u0013&D\u0001\u001f\u0013\tQcD\u0001\nECR\f7k\\;sG\u0016\u0014VmZ5ti\u0016\u0014\b\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\bF\u0001/!\ty\u0003!D\u0001\u0003\u0011\u0015\t\u0004\u0001\"\u00113\u0003Y\u0019'/Z1uK6K7M]8CCR\u001c\u0007NU3bI\u0016\u0014H\u0003B\u001a;\u0011R\u0003\"\u0001\u000e\u001d\u000e\u0003UR!!\u0002\u001c\u000b\u0005]b\u0012A\u0002:fC\u0012,'/\u0003\u0002:k\t\u0001R*[2s_\n\u000bGo\u00195SK\u0006$WM\u001d\u0005\u0006wA\u0002\r\u0001P\u0001\u0007g\u000eDW-\\1\u0011\u0007u\u0002%)D\u0001?\u0015\tyd#\u0001\u0003vi&d\u0017BA!?\u0005!y\u0005\u000f^5p]\u0006d\u0007CA\"G\u001b\u0005!%BA#\t\u0003\u0015!\u0018\u0010]3t\u0013\t9EI\u0001\u0006TiJ,8\r\u001e+za\u0016DQ!\u0013\u0019A\u0002)\u000b!c\u00195fG.\u0004x.\u001b8u\u0019>\u001c\u0017\r^5p]B\u00111*\u0015\b\u0003\u0019>k\u0011!\u0014\u0006\u0002\u001d\u0006)1oY1mC&\u0011\u0001+T\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002Q\u001b\")Q\u000b\ra\u0001-\u00069q\u000e\u001d;j_:\u001c\bCA\u000eX\u0013\tAFDA\tECR\f7k\\;sG\u0016|\u0005\u000f^5p]NDQA\u0017\u0001\u0005Bm\u000bac\u0019:fCR,7i\u001c8uS:,x.^:SK\u0006$WM\u001d\u000b\u00059~\u0003\u0017\r\u0005\u00025;&\u0011a,\u000e\u0002\u0011\u0007>tG/\u001b8v_V\u001c(+Z1eKJDQaO-A\u0002qBQ!S-A\u0002)CQ!V-A\u0002YCQa\u0019\u0001\u0005B\u0011\f\u0011b\u001d5peRt\u0015-\\3\u0015\u0003);QA\u001a\u0002\t\u0002\u001d\f!CU1uKN#(/Z1n!J|g/\u001b3feB\u0011q\u0006\u001b\u0004\u0006\u0003\tA\t![\n\u0003Q*\u0004\"\u0001T6\n\u00051l%AB!osJ+g\rC\u0003-Q\u0012\u0005a\u000eF\u0001h\u0011\u001d\u0001\bN1A\u0005\u0002E\faaU\"I\u000b6\u000bU#\u0001\"\t\rMD\u0007\u0015!\u0003C\u0003\u001d\u00196\tS#N\u0003\u0002Bq!\u001e5C\u0002\u0013\u0005a/A\u0004W\u000bJ\u001b\u0016j\u0014(\u0016\u0003]\u0004\"\u0001\u0014=\n\u0005el%aA%oi\"11\u0010\u001bQ\u0001\n]\f\u0001BV#S'&{e\n\t\u0005\b{\"\u0014\r\u0011\"\u0001\u007f\u00039qU+T0Q\u0003J#\u0016\nV%P\u001dN+\u0012a \t\u0004'\u0005\u0005\u0011B\u0001*\u0015\u0011\u001d\t)\u0001\u001bQ\u0001\n}\fqBT+N?B\u000b%\u000bV%U\u0013>s5\u000b\t\u0005\t\u0003\u0013A'\u0019!C\u0001}\u0006y!kT,T?B+%kX*F\u0007>sE\tC\u0004\u0002\u000e!\u0004\u000b\u0011B@\u0002!I{ukU0Q\u000bJ{6+R\"P\u001d\u0012\u0003\u0003\u0002CA\tQ\n\u0007I\u0011\u0001@\u0002\u0019I\u000bU\nU0V!~#\u0016*T#\t\u000f\u0005U\u0001\u000e)A\u0005\u007f\u0006i!+Q'Q?V\u0003v\fV%N\u000b\u0002Bq!!\u0007i\t\u0003\tY\"A\u0007wC2,X-\u0011;TK\u000e|g\u000e\u001a\u000b\t\u0003;\t\u0019#a\n\u0002,A\u0019A*a\b\n\u0007\u0005\u0005RJ\u0001\u0003M_:<\u0007\u0002CA\u0013\u0003/\u0001\r!!\b\u0002\u000fM,7m\u001c8eg\"A\u0011\u0011FA\f\u0001\u0004\ti\"A\u0007s_^\u001c\b+\u001a:TK\u000e|g\u000e\u001a\u0005\t\u0003[\t9\u00021\u0001\u0002\u001e\u0005\t\"/Y7q+B$\u0016.\\3TK\u000e|g\u000eZ:")
public class RateStreamProvider
implements MicroBatchReadSupport,
ContinuousReadSupport,
DataSourceRegister {
    public static long valueAtSecond(long l, long l2, long l3) {
        return RateStreamProvider$.MODULE$.valueAtSecond(l, l2, l3);
    }

    public static String RAMP_UP_TIME() {
        return RateStreamProvider$.MODULE$.RAMP_UP_TIME();
    }

    public static String ROWS_PER_SECOND() {
        return RateStreamProvider$.MODULE$.ROWS_PER_SECOND();
    }

    public static String NUM_PARTITIONS() {
        return RateStreamProvider$.MODULE$.NUM_PARTITIONS();
    }

    public static int VERSION() {
        return RateStreamProvider$.MODULE$.VERSION();
    }

    public static StructType SCHEMA() {
        return RateStreamProvider$.MODULE$.SCHEMA();
    }

    @Override
    public MicroBatchReader createMicroBatchReader(Optional<StructType> schema2, String checkpointLocation, DataSourceOptions options) {
        int numPartitions;
        long rampUpTimeSeconds;
        long rowsPerSecond;
        if (options.get(RateStreamProvider$.MODULE$.ROWS_PER_SECOND()).isPresent() && (rowsPerSecond = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamProvider$.MODULE$.ROWS_PER_SECOND()).get())).toLong()) <= 0L) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value '", "'. The option 'rowsPerSecond' must be positive"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)rowsPerSecond)})));
        }
        if (options.get(RateStreamProvider$.MODULE$.RAMP_UP_TIME()).isPresent() && (rampUpTimeSeconds = JavaUtils.timeStringAsSec((String)options.get(RateStreamProvider$.MODULE$.RAMP_UP_TIME()).get())) < 0L) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value '", "'. The option 'rampUpTime' must not be negative"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)rampUpTimeSeconds)})));
        }
        if (options.get(RateStreamProvider$.MODULE$.NUM_PARTITIONS()).isPresent() && (numPartitions = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamProvider$.MODULE$.NUM_PARTITIONS()).get())).toInt()) <= 0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value '", "'. The option 'numPartitions' must be positive"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numPartitions)})));
        }
        if (schema2.isPresent()) {
            throw new AnalysisException("The rate source does not support a user-specified schema.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return new RateStreamMicroBatchReader(options, checkpointLocation);
    }

    @Override
    public ContinuousReader createContinuousReader(Optional<StructType> schema2, String checkpointLocation, DataSourceOptions options) {
        return new RateStreamContinuousReader(options);
    }

    @Override
    public String shortName() {
        return "rate";
    }
}

