/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.util.Date;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.SparkHadoopWriterUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.BindReferences$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SortExec;
import org.apache.spark.sql.execution.SortExec$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.DynamicPartitionDataWriter;
import org.apache.spark.sql.execution.datasources.EmptyDirectoryDataWriter;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormatDataWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter$;
import org.apache.spark.sql.execution.datasources.FileFormatWriter$$anonfun$org$apache$spark$sql$execution$datasources$FileFormatWriter$;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.SingleDirectoryDataWriter;
import org.apache.spark.sql.execution.datasources.WriteJobDescription;
import org.apache.spark.sql.execution.datasources.WriteJobStatsTracker;
import org.apache.spark.sql.execution.datasources.WriteTaskResult;
import org.apache.spark.sql.execution.datasources.WriteTaskStats;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class FileFormatWriter$
implements Logging {
    public static final FileFormatWriter$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new FileFormatWriter$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Set<String> write(SparkSession sparkSession, SparkPlan plan, FileFormat fileFormat, FileCommitProtocol committer, FileFormatWriter.OutputSpec outputSpec, Configuration hadoopConf, Seq<Attribute> partitionColumns, Option<BucketSpec> bucketSpec, Seq<WriteJobStatsTracker> statsTrackers, Map<String, String> options) {
        Job job = Job.getInstance((Configuration)hadoopConf);
        job.setOutputKeyClass(Void.class);
        job.setOutputValueClass(InternalRow.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputSpec.outputPath()));
        AttributeSet partitionSet = AttributeSet$.MODULE$.apply(partitionColumns);
        Seq dataColumns = (Seq)outputSpec.outputColumns().filterNot((Function1)new Serializable(partitionSet){
            public static final long serialVersionUID = 0L;
            private final AttributeSet partitionSet$1;

            public final boolean apply(NamedExpression elem) {
                return this.partitionSet$1.contains(elem);
            }
            {
                this.partitionSet$1 = partitionSet$1;
            }
        });
        Option bucketIdExpression = bucketSpec.map((Function1)new Serializable(dataColumns){
            public static final long serialVersionUID = 0L;
            public final Seq dataColumns$1;

            public final Expression apply(BucketSpec spec) {
                Seq bucketColumns = (Seq)spec.bucketColumnNames().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.3 $outer;

                    public final Attribute apply(String c) {
                        return (Attribute)this.$outer.dataColumns$1.find((Function1)new Serializable(this, c){
                            public static final long serialVersionUID = 0L;
                            private final String c$1;

                            public final boolean apply(Attribute x$1) {
                                String string = x$1.name();
                                String string2 = this.c$1;
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                            {
                                this.c$1 = c$1;
                            }
                        }).get();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                return new HashPartitioning(bucketColumns, spec.numBuckets()).partitionIdExpression();
            }
            {
                this.dataColumns$1 = dataColumns$1;
            }
        });
        Seq sortColumns = (Seq)Option$.MODULE$.option2Iterable(bucketSpec).toSeq().flatMap((Function1)new Serializable(dataColumns){
            public static final long serialVersionUID = 0L;
            public final Seq dataColumns$1;

            public final Seq<Attribute> apply(BucketSpec spec) {
                return (Seq)spec.sortColumnNames().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.5 $outer;

                    public final Attribute apply(String c) {
                        return (Attribute)this.$outer.dataColumns$1.find((Function1)new Serializable(this, c){
                            public static final long serialVersionUID = 0L;
                            private final String c$2;

                            public final boolean apply(Attribute x$2) {
                                String string = x$2.name();
                                String string2 = this.c$2;
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                            {
                                this.c$2 = c$2;
                            }
                        }).get();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.dataColumns$1 = dataColumns$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        CaseInsensitiveMap caseInsensitiveOptions = CaseInsensitiveMap$.MODULE$.apply(options);
        StructType dataSchema = package$.MODULE$.AttributeSeq(dataColumns).toStructType();
        DataSourceUtils$.MODULE$.verifyWriteSchema(fileFormat, dataSchema);
        OutputWriterFactory outputWriterFactory = fileFormat.prepareWrite(sparkSession, job, (Map<String, String>)caseInsensitiveOptions, dataSchema);
        WriteJobDescription description = new WriteJobDescription(UUID.randomUUID().toString(), new SerializableConfiguration(job.getConfiguration()), outputWriterFactory, outputSpec.outputColumns(), (Seq<Attribute>)dataColumns, partitionColumns, (Option<Expression>)bucketIdExpression, outputSpec.outputPath(), outputSpec.customPartitionLocations(), BoxesRunTime.unboxToLong((Object)caseInsensitiveOptions.get("maxRecordsPerFile").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toLong();
            }
        }).getOrElse((Function0)new Serializable(sparkSession){
            public static final long serialVersionUID = 0L;
            private final SparkSession sparkSession$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.sparkSession$1.sessionState().conf().maxRecordsPerFile();
            }
            {
                this.sparkSession$1 = sparkSession$1;
            }
        })), (String)caseInsensitiveOptions.get(DateTimeUtils$.MODULE$.TIMEZONE_OPTION()).getOrElse((Function0)new Serializable(sparkSession){
            public static final long serialVersionUID = 0L;
            private final SparkSession sparkSession$1;

            public final String apply() {
                return this.sparkSession$1.sessionState().conf().sessionLocalTimeZone();
            }
            {
                this.sparkSession$1 = sparkSession$1;
            }
        }), statsTrackers);
        Seq requiredOrdering = (Seq)((TraversableLike)partitionColumns.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(bucketIdExpression), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)sortColumns, Seq$.MODULE$.canBuildFrom());
        Seq actualOrdering = (Seq)plan.outputOrdering().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Expression apply(SortOrder x$4) {
                return x$4.child();
            }
        }, Seq$.MODULE$.canBuildFrom());
        boolean orderingMatched = requiredOrdering.length() > actualOrdering.length() ? false : ((IterableLike)requiredOrdering.zip((GenIterable)actualOrdering, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Expression, Expression> x0$1) {
                Tuple2<Expression, Expression> tuple2 = x0$1;
                if (tuple2 != null) {
                    Expression requiredOrder = (Expression)tuple2._1();
                    Expression childOutputOrder = (Expression)tuple2._2();
                    boolean bl = requiredOrder.semanticEquals(childOutputOrder);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        SQLExecution$.MODULE$.checkSQLExecutionId(sparkSession);
        committer.setupJob((JobContext)job);
        try {
            RDD<InternalRow> rDD;
            if (orderingMatched) {
                rDD = plan.execute();
            } else {
                Seq orderingExpr = (Seq)((TraversableLike)requiredOrdering.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final SortOrder apply(Expression x$5) {
                        return SortOrder$.MODULE$.apply(x$5, (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
                    }
                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(outputSpec){
                    public static final long serialVersionUID = 0L;
                    private final FileFormatWriter.OutputSpec outputSpec$1;

                    public final SortOrder apply(SortOrder x$6) {
                        return (SortOrder)BindReferences$.MODULE$.bindReference((Expression)x$6, package$.MODULE$.AttributeSeq(this.outputSpec$1.outputColumns()), BindReferences$.MODULE$.bindReference$default$3());
                    }
                    {
                        this.outputSpec$1 = outputSpec$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                rDD = new SortExec((Seq<SortOrder>)orderingExpr, false, plan, SortExec$.MODULE$.apply$default$4()).execute();
            }
            RDD<InternalRow> rdd2 = rDD;
            RDD<InternalRow> rddWithNonEmptyPartitions = rdd2.partitions().length == 0 ? sparkSession.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InternalRow.class))), 1, ClassTag$.MODULE$.apply(InternalRow.class)) : rdd2;
            WriteTaskResult[] ret = new WriteTaskResult[rddWithNonEmptyPartitions.partitions().length];
            sparkSession.sparkContext().runJob(rddWithNonEmptyPartitions, (Function2)new Serializable(committer, description){
                public static final long serialVersionUID = 0L;
                private final FileCommitProtocol committer$1;
                private final WriteJobDescription description$1;

                public final WriteTaskResult apply(TaskContext taskContext, Iterator<InternalRow> iter) {
                    return FileFormatWriter$.MODULE$.org$apache$spark$sql$execution$datasources$FileFormatWriter$$executeTask(this.description$1, taskContext.stageId(), taskContext.partitionId(), taskContext.attemptNumber(), this.committer$1, iter);
                }
                {
                    this.committer$1 = committer$1;
                    this.description$1 = description$1;
                }
            }, (Seq)Predef$.MODULE$.refArrayOps((Object[])rddWithNonEmptyPartitions.partitions()).indices(), (Function2)new Serializable(committer, ret){
                public static final long serialVersionUID = 0L;
                private final FileCommitProtocol committer$1;
                private final WriteTaskResult[] ret$1;

                public final void apply(int index, WriteTaskResult res) {
                    this.committer$1.onTaskCommit(res.commitMsg());
                    this.ret$1[index] = res;
                }
                {
                    this.committer$1 = committer$1;
                    this.ret$1 = ret$1;
                }
            }, ClassTag$.MODULE$.apply(WriteTaskResult.class));
            FileCommitProtocol.TaskCommitMessage[] commitMsgs = (FileCommitProtocol.TaskCommitMessage[])Predef$.MODULE$.refArrayOps((Object[])ret).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final FileCommitProtocol.TaskCommitMessage apply(WriteTaskResult x$7) {
                    return x$7.commitMsg();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileCommitProtocol.TaskCommitMessage.class)));
            committer.commitJob((JobContext)job, (Seq)Predef$.MODULE$.wrapRefArray((Object[])commitMsgs));
            this.logInfo((Function0<String>)new Serializable(description){
                public static final long serialVersionUID = 0L;
                private final WriteJobDescription description$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Write Job ", " committed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.description$1.uuid()}));
                }
                {
                    this.description$1 = description$1;
                }
            });
            this.processStats(description.statsTrackers(), (Seq<Seq<WriteTaskStats>>)((Seq)Predef$.MODULE$.refArrayOps((Object[])ret).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<WriteTaskStats> apply(WriteTaskResult x$8) {
                    return x$8.summary().stats();
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
            this.logInfo((Function0<String>)new Serializable(description){
                public static final long serialVersionUID = 0L;
                private final WriteJobDescription description$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished processing stats for write job ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.description$1.uuid()}));
                }
                {
                    this.description$1 = description$1;
                }
            });
            return (Set)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])ret).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Set<String> apply(WriteTaskResult x$9) {
                    return x$9.summary().updatedPartitions();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Set.class)))).reduceOption((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Set<String> apply(Set<String> x$10, Set<String> x$11) {
                    return (Set)x$10.$plus$plus(x$11);
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Set<String> apply() {
                    return Predef$.MODULE$.Set().empty();
                }
            });
        }
        catch (Throwable throwable) {
            this.logError((Function0<String>)new Serializable(description){
                public static final long serialVersionUID = 0L;
                private final WriteJobDescription description$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborting job ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.description$1.uuid()}));
                }
                {
                    this.description$1 = description$1;
                }
            }, throwable);
            committer.abortJob((JobContext)job);
            throw new SparkException("Job aborted.", throwable);
        }
    }

    public WriteTaskResult org$apache$spark$sql$execution$datasources$FileFormatWriter$$executeTask(WriteJobDescription description, int sparkStageId, int sparkPartitionId, int sparkAttemptNumber, FileCommitProtocol committer, Iterator<InternalRow> iterator2) {
        JobID jobId = SparkHadoopWriterUtils$.MODULE$.createJobID(new Date(), sparkStageId);
        TaskID taskId = new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, TaskType.MAP, sparkPartitionId);
        TaskAttemptID taskAttemptId = new TaskAttemptID(taskId, sparkAttemptNumber);
        Configuration hadoopConf = description.serializableHadoopConf().value();
        hadoopConf.set("mapreduce.job.id", jobId.toString());
        hadoopConf.set("mapreduce.task.id", taskAttemptId.getTaskID().toString());
        hadoopConf.set("mapreduce.task.attempt.id", taskAttemptId.toString());
        hadoopConf.setBoolean("mapreduce.task.ismap", true);
        hadoopConf.setInt("mapreduce.task.partition", 0);
        TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(hadoopConf, taskAttemptId);
        committer.setupTask((TaskAttemptContext)taskAttemptContext);
        FileFormatDataWriter dataWriter = sparkPartitionId != 0 && !iterator2.hasNext() ? new EmptyDirectoryDataWriter(description, (TaskAttemptContext)taskAttemptContext, committer) : (description.partitionColumns().isEmpty() && description.bucketIdExpression().isEmpty() ? new SingleDirectoryDataWriter(description, (TaskAttemptContext)taskAttemptContext, committer) : new DynamicPartitionDataWriter(description, (TaskAttemptContext)taskAttemptContext, committer));
        try {
            Serializable x$15 = new Serializable(iterator2, dataWriter){
                public static final long serialVersionUID = 0L;
                private final Iterator iterator$1;
                private final FileFormatDataWriter dataWriter$1;

                public final WriteTaskResult apply() {
                    while (this.iterator$1.hasNext()) {
                        this.dataWriter$1.write((InternalRow)this.iterator$1.next());
                    }
                    return this.dataWriter$1.commit();
                }
                {
                    this.iterator$1 = iterator$1;
                    this.dataWriter$1 = dataWriter$1;
                }
            };
            Serializable x$16 = new Serializable(jobId, dataWriter){
                public static final long serialVersionUID = 0L;
                public final JobID jobId$1;
                private final FileFormatDataWriter dataWriter$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.dataWriter$1.abort();
                    FileFormatWriter$.MODULE$.logError((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$FileFormatWriter$$executeTask$1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Job ", " aborted."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.jobId$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.jobId$1 = jobId$1;
                    this.dataWriter$1 = dataWriter$1;
                }
            };
            Serializable x$17 = new Serializable((Function0)x$15){
                public static final long serialVersionUID = 0L;
                private final Function0 x$15$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$3(this.x$15$1);
                }
                {
                    this.x$15$1 = x$15$1;
                }
            };
            return (WriteTaskResult)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0)x$15, (Function0)x$16, (Function0)x$17);
        }
        catch (Throwable throwable) {
            throw new SparkException("Task failed while writing rows.", throwable);
        }
        catch (FetchFailedException fetchFailedException) {
            throw fetchFailedException;
        }
    }

    private void processStats(Seq<WriteJobStatsTracker> statsTrackers, Seq<Seq<WriteTaskStats>> statsPerTask) {
        int numStatsTrackers = statsTrackers.length();
        Predef$.MODULE$.assert(statsPerTask.forall((Function1)new Serializable(numStatsTrackers){
            public static final long serialVersionUID = 0L;
            private final int numStatsTrackers$1;

            public final boolean apply(Seq<WriteTaskStats> x$12) {
                return x$12.length() == this.numStatsTrackers$1;
            }
            {
                this.numStatsTrackers$1 = numStatsTrackers$1;
            }
        }), (Function0)new Serializable(statsPerTask, numStatsTrackers){
            public static final long serialVersionUID = 0L;
            private final Seq statsPerTask$1;
            public final int numStatsTrackers$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Every WriteTask should have produced one `WriteTaskStats` object for every tracker.\n         |There are ", " statsTrackers, but some task returned\n         |", " results instead.\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numStatsTrackers$1), BoxesRunTime.boxToInteger((int)((SeqLike)this.statsPerTask$1.find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.processStats.1 $outer;

                    public final boolean apply(Seq<WriteTaskStats> x$13) {
                        return x$13.length() != this.$outer.numStatsTrackers$1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).get()).length())})))).stripMargin();
            }
            {
                this.statsPerTask$1 = statsPerTask$1;
                this.numStatsTrackers$1 = numStatsTrackers$1;
            }
        });
        Seq statsPerTracker = statsPerTask.nonEmpty() ? (Seq)statsPerTask.transpose((Function1)Predef$.MODULE$.$conforms()) : (Seq)statsTrackers.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply(WriteJobStatsTracker x$14) {
                return (Seq)Seq$.MODULE$.empty();
            }
        }, Seq$.MODULE$.canBuildFrom());
        ((IterableLike)statsTrackers.zip((GenIterable)statsPerTracker, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<WriteJobStatsTracker, Seq<WriteTaskStats>> x0$2) {
                Tuple2<WriteJobStatsTracker, Seq<WriteTaskStats>> tuple2 = x0$2;
                if (tuple2 != null) {
                    WriteJobStatsTracker statsTracker = (WriteJobStatsTracker)tuple2._1();
                    Seq stats = (Seq)tuple2._2();
                    statsTracker.processStats((Seq<WriteTaskStats>)stats);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    private FileFormatWriter$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

