/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.kafka010.CachedKafkaConsumer;
import org.apache.spark.sql.kafka010.CachedKafkaConsumer$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CachedKafkaConsumer$
implements Logging,
Serializable {
    public static final CachedKafkaConsumer$ MODULE$;
    private LinkedHashMap<CachedKafkaConsumer.CacheKey, CachedKafkaConsumer> cache;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new CachedKafkaConsumer$();
    }

    private LinkedHashMap cache$lzycompute() {
        CachedKafkaConsumer$ cachedKafkaConsumer$ = this;
        synchronized (cachedKafkaConsumer$) {
            if (!this.bitmap$0) {
                SparkConf conf = SparkEnv$.MODULE$.get().conf();
                int capacity = conf.getInt("spark.sql.kafkaConsumerCache.capacity", 64);
                this.cache = new LinkedHashMap<CachedKafkaConsumer.CacheKey, CachedKafkaConsumer>(capacity){
                    public final int capacity$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean removeEldestEntry(Map.Entry<CachedKafkaConsumer.CacheKey, CachedKafkaConsumer> entry) {
                        if (this.size() <= this.capacity$1) return false;
                        CachedKafkaConsumer$.MODULE$.logWarning((Function0<String>)new Serializable(this, entry){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;
                            private final Map.Entry entry$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KafkaConsumer cache hitting max capacity of ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.capacity$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"removing consumer for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entry$1.getKey()}))).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.entry$1 = entry$1;
                            }
                        });
                        try {
                            entry.getValue().org$apache$spark$sql$kafka010$CachedKafkaConsumer$$close();
                            return true;
                        }
                        catch (SparkException sparkException) {
                            CachedKafkaConsumer$.MODULE$.logError((Function0<String>)new Serializable(this, entry){
                                public static final long serialVersionUID = 0L;
                                private final Map.Entry entry$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error closing earliest Kafka consumer for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entry$1.getKey()}));
                                }
                                {
                                    this.entry$1 = entry$1;
                                }
                            }, sparkException);
                        }
                        return true;
                    }
                    {
                        this.capacity$1 = capacity$1;
                        super(capacity$1, 0.75f, true);
                    }
                };
                this.bitmap$0 = true;
            }
            return this.cache;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private LinkedHashMap<CachedKafkaConsumer.CacheKey, CachedKafkaConsumer> cache() {
        return this.bitmap$0 ? this.cache : this.cache$lzycompute();
    }

    public synchronized CachedKafkaConsumer getOrCreate(String topic, int partition, Map<String, Object> kafkaParams) {
        CachedKafkaConsumer cachedKafkaConsumer;
        String groupId = (String)kafkaParams.get("group.id");
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        CachedKafkaConsumer.CacheKey key = new CachedKafkaConsumer.CacheKey(groupId, topicPartition);
        if (TaskContext$.MODULE$.get() != null && TaskContext$.MODULE$.get().attemptNumber() > 1) {
            this.cache().remove(key);
            cachedKafkaConsumer = new CachedKafkaConsumer(topicPartition, kafkaParams);
        } else {
            Object object = this.cache().containsKey(key) ? BoxedUnit.UNIT : this.cache().put(key, new CachedKafkaConsumer(topicPartition, kafkaParams));
            cachedKafkaConsumer = this.cache().get(key);
        }
        return cachedKafkaConsumer;
    }

    public CachedKafkaConsumer apply(TopicPartition topicPartition, Map<String, Object> kafkaParams) {
        return new CachedKafkaConsumer(topicPartition, kafkaParams);
    }

    public Option<Tuple2<TopicPartition, Map<String, Object>>> unapply(CachedKafkaConsumer x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.topicPartition(), x$0.kafkaParams()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CachedKafkaConsumer$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

