/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.NoSuchElementException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.avro.AvroDeserializer;
import org.apache.spark.sql.avro.AvroFileFormat$;
import org.apache.spark.sql.avro.AvroOptions;
import org.apache.spark.sql.avro.AvroOutputWriterFactory;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg!\u0002\t\u0012\u0001EY\u0002\"\u0002 \u0001\t\u0003\u0001\u0005\"B\"\u0001\t\u0003\"\u0005\"B'\u0001\t\u0003r\u0005\"\u0002*\u0001\t\u0003\u001a\u0006bBA\u0006\u0001\u0011%\u0011Q\u0002\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u001d\t)\u0004\u0001C!\u0003oAq!!\u0013\u0001\t\u0003\nY\u0005C\u0004\u0002l\u0001!\t%!\u001c\b\u0011\u0005-\u0016\u0003#\u0001\u0012\u0003[3q\u0001E\t\t\u0002E\ty\u000b\u0003\u0004?\u0017\u0011\u0005\u0011Q\u0017\u0005\n\u0003o[!\u0019!C\u0001\u0003sC\u0001\"!2\fA\u0003%\u00111\u0018\u0005\n\u0003\u000f\\\u0011\u0011!C\u0005\u0003\u0013\u0014a\"\u0011<s_\u001aKG.\u001a$pe6\fGO\u0003\u0002\u0013'\u0005!\u0011M\u001e:p\u0015\t!R#A\u0002tc2T!AF\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\n\u0007\u0001q\u0011#\u0006\r\u001c\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\r\u0005s\u0017PU3g!\t\u0019\u0003&D\u0001%\u0015\t)c%A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0014\u0014\u0003%)\u00070Z2vi&|g.\u0003\u0002*I\tQa)\u001b7f\r>\u0014X.\u0019;\u0011\u0005-rS\"\u0001\u0017\u000b\u00055\u001a\u0012aB:pkJ\u001cWm]\u0005\u0003_1\u0012!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u0011\u0011\u0007N\u0007\u0002e)\u00111'F\u0001\tS:$XM\u001d8bY&\u0011QG\r\u0002\b\u0019><w-\u001b8h!\t9D(D\u00019\u0015\tI$(\u0001\u0002j_*\t1(\u0001\u0003kCZ\f\u0017BA\u001f9\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}\r\u0001A#A!\u0011\u0005\t\u0003Q\"A\t\u0002\r\u0015\fX/\u00197t)\t)\u0005\n\u0005\u0002\u001e\r&\u0011qI\b\u0002\b\u0005>|G.Z1o\u0011\u0015I%\u00011\u0001K\u0003\u0015yG\u000f[3s!\ti2*\u0003\u0002M=\t\u0019\u0011I\\=\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\u0014\t\u0003;AK!!\u0015\u0010\u0003\u0007%sG/A\u0006j]\u001a,'oU2iK6\fG\u0003\u0002+^EJ\u00042!H+X\u0013\t1fD\u0001\u0004PaRLwN\u001c\t\u00031nk\u0011!\u0017\u0006\u00035N\tQ\u0001^=qKNL!\u0001X-\u0003\u0015M#(/^2u)f\u0004X\rC\u0003\u0017\t\u0001\u0007a\f\u0005\u0002`A6\t1#\u0003\u0002b'\ta1\u000b]1sWN+7o]5p]\")1\r\u0002a\u0001I\u00069q\u000e\u001d;j_:\u001c\b\u0003B3m_>t!A\u001a6\u0011\u0005\u001dtR\"\u00015\u000b\u0005%|\u0014A\u0002\u001fs_>$h(\u0003\u0002l=\u00051\u0001K]3eK\u001aL!!\u001c8\u0003\u00075\u000b\u0007O\u0003\u0002l=A\u0011Q\r]\u0005\u0003c:\u0014aa\u0015;sS:<\u0007\"B:\u0005\u0001\u0004!\u0018!\u00024jY\u0016\u001c\bcA;{{:\u0011a\u000f\u001f\b\u0003O^L\u0011aH\u0005\u0003sz\tq\u0001]1dW\u0006<W-\u0003\u0002|y\n\u00191+Z9\u000b\u0005et\u0002c\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011A\u00014t\u0015\r\t)aF\u0001\u0007Q\u0006$wn\u001c9\n\u0007\u0005%qP\u0001\u0006GS2,7\u000b^1ukN\f\u0001$\u001b8gKJ\feO]8TG\",W.\u0019$s_64\u0015\u000e\\3t))\ty!!\u0007\u0002\u001c\u0005%\u0012Q\u0006\t\u0005\u0003#\t)\"\u0004\u0002\u0002\u0014)\u0011!cF\u0005\u0005\u0003/\t\u0019B\u0001\u0004TG\",W.\u0019\u0005\u0006g\u0016\u0001\r\u0001\u001e\u0005\b\u0003;)\u0001\u0019AA\u0010\u0003\u0011\u0019wN\u001c4\u0011\t\u0005\u0005\u0012QE\u0007\u0003\u0003GQA!!\b\u0002\u0004%!\u0011qEA\u0012\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"1\u00111F\u0003A\u0002\u0015\u000bq\"[4o_J,W\t\u001f;f]NLwN\u001c\u0005\u0007\u0003_)\u0001\u0019A#\u0002%%<gn\u001c:f\u0007>\u0014(/\u001e9u\r&dWm]\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012a\\\u0001\fSN\u001c\u0006\u000f\\5uC\ndW\rF\u0004F\u0003s\ti$a\u0010\t\r\u0005mr\u00011\u0001_\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o\u0011\u0015\u0019w\u00011\u0001e\u0011\u001d\t\te\u0002a\u0001\u0003\u0007\nA\u0001]1uQB\u0019a0!\u0012\n\u0007\u0005\u001dsP\u0001\u0003QCRD\u0017\u0001\u00049sKB\f'/Z,sSR,GCCA'\u0003'\n)&!\u001a\u0002hA\u00191%a\u0014\n\u0007\u0005ECEA\nPkR\u0004X\u000f^,sSR,'OR1di>\u0014\u0018\u0010C\u0003\u0017\u0011\u0001\u0007a\fC\u0004\u0002X!\u0001\r!!\u0017\u0002\u0007)|'\r\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\u0011\ty&a\u0001\u0002\u00135\f\u0007O]3ek\u000e,\u0017\u0002BA2\u0003;\u00121AS8c\u0011\u0015\u0019\u0007\u00021\u0001e\u0011\u0019\tI\u0007\u0003a\u0001/\u0006QA-\u0019;b'\u000eDW-\\1\u0002\u0017\t,\u0018\u000e\u001c3SK\u0006$WM\u001d\u000b\u0011\u0003_\ni)a$\u0002\u0012\u0006U\u0015\u0011TAS\u0003O\u0003r!HA9\u0003k\nY(C\u0002\u0002ty\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0007\r\n9(C\u0002\u0002z\u0011\u0012q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0006k\u0006u\u0014\u0011Q\u0005\u0004\u0003\u007fb(\u0001C%uKJ\fGo\u001c:\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\"\u0014\u0003!\u0019\u0017\r^1msN$\u0018\u0002BAF\u0003\u000b\u00131\"\u00138uKJt\u0017\r\u001c*po\")a#\u0003a\u0001=\"1\u0011\u0011N\u0005A\u0002]Ca!a%\n\u0001\u00049\u0016a\u00049beRLG/[8o'\u000eDW-\\1\t\r\u0005]\u0015\u00021\u0001X\u00039\u0011X-];je\u0016$7k\u00195f[\u0006Dq!a'\n\u0001\u0004\ti*A\u0004gS2$XM]:\u0011\tUT\u0018q\u0014\t\u0004W\u0005\u0005\u0016bAARY\t1a)\u001b7uKJDQaY\u0005A\u0002\u0011Dq!!+\n\u0001\u0004\ty\"\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\fa\"\u0011<s_\u001aKG.\u001a$pe6\fG\u000f\u0005\u0002C\u0017M!1\u0002HAY!\ri\u00121W\u0005\u0003{y!\"!!,\u0002G%;gn\u001c:f\r&dWm],ji\"|W\u000f^#yi\u0016t7/[8o!J|\u0007/\u001a:usV\u0011\u00111\u0018\t\u0005\u0003{\u000b\u0019-\u0004\u0002\u0002@*\u0019\u0011\u0011\u0019\u001e\u0002\t1\fgnZ\u0005\u0004c\u0006}\u0016\u0001J%h]>\u0014XMR5mKN<\u0016\u000e\u001e5pkR,\u0005\u0010^3og&|g\u000e\u0015:pa\u0016\u0014H/\u001f\u0011\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0017\u0004B!!0\u0002N&!\u0011qZA`\u0005\u0019y%M[3di\u0002")
public class AvroFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
Serializable {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String IgnoreFilesWithoutExtensionProperty() {
        return AvroFileFormat$.MODULE$.IgnoreFilesWithoutExtensionProperty();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.supportBatch$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$((FileFormat)this, (StructType)requiredSchema, (StructType)partitionSchema, (SQLConf)sqlConf);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReaderWithPartitionValues$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        return FileFormat.supportDataType$((FileFormat)this, (DataType)dataType, (boolean)isReadPath);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean equals(Object other) {
        Object object = other;
        boolean bl = object instanceof AvroFileFormat;
        return bl;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Option<StructType> inferSchema(SparkSession spark, Map<String, String> options, Seq<FileStatus> files) {
        Configuration conf = spark.sessionState().newHadoopConf();
        AvroOptions parsedOptions = new AvroOptions(options, conf);
        Schema.Parser parser = new Schema.Parser();
        Schema avroSchema = (Schema)parsedOptions.schema().map((Function1 & Serializable & scala.Serializable)x$1 -> parser.parse(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.inferAvroSchemaFromFiles(files, conf, parsedOptions.ignoreExtension(), spark.sessionState().conf().ignoreCorruptFiles()));
        DataType dataType = SchemaConverters$.MODULE$.toSqlType(avroSchema).dataType();
        if (!(dataType instanceof StructType)) {
            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(97).append("Avro schema cannot be converted to a Spark SQL StructType:\n           |\n           |").append(avroSchema.toString(true)).append("\n           |").toString())).stripMargin());
        }
        StructType structType = (StructType)dataType;
        Some some = new Some((Object)structType);
        return some;
    }

    private Schema inferAvroSchemaFromFiles(Seq<FileStatus> files, Configuration conf, boolean ignoreExtension, boolean ignoreCorruptFiles) {
        Schema schema;
        Option avroReader = files.iterator().map((Function1 & Serializable & scala.Serializable)f -> {
            Path path = f.getPath();
            return !ignoreExtension && !path.getName().endsWith(".avro") ? None$.MODULE$ : (Option)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new FsInput(path, conf), (Function1 & Serializable & scala.Serializable)in -> {
                Some some;
                try {
                    some = new Some((Object)DataFileReader.openReader((SeekableInput)in, (DatumReader)new GenericDatumReader()));
                }
                catch (IOException e) {
                    if (ignoreCorruptFiles) {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(42).append("Skipped the footer in the corrupted file: ").append(path).toString(), e);
                        some = None$.MODULE$;
                    }
                    throw new SparkException(new java.lang.StringBuilder(21).append("Could not read file: ").append(path).toString(), (Throwable)e);
                }
                return some;
            });
        }).collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Option<FileReader<GenericRecord>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    FileReader reader = (FileReader)some.value();
                    object = reader;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<FileReader<GenericRecord>> x1) {
                Option<FileReader<GenericRecord>> option = x1;
                boolean bl = option instanceof Some;
                return bl;
            }
        });
        Option option = avroReader;
        if (option instanceof Some) {
            Some some = (Some)option;
            try (FileReader reader = (FileReader)some.value();){
                schema = reader.getSchema();
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new FileNotFoundException("No Avro files found. If files don't have .avro extension, set ignoreExtension to true");
            }
            throw new MatchError((Object)option);
        }
        Schema schema2 = schema;
        return schema2;
    }

    public String shortName() {
        return "avro";
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    public OutputWriterFactory prepareWrite(SparkSession spark, Job job, Map<String, String> options, StructType dataSchema) {
        AvroOptions parsedOptions = new AvroOptions(options, spark.sessionState().newHadoopConf());
        Schema.Parser parser = new Schema.Parser();
        Schema outputAvroSchema = (Schema)parsedOptions.schema().map((Function1 & Serializable & scala.Serializable)x$1 -> parser.parse(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> SchemaConverters$.MODULE$.toAvroType((DataType)dataSchema, false, parsedOptions.recordName(), parsedOptions.recordNamespace()));
        AvroJob.setOutputKeySchema((Job)job, (Schema)outputAvroSchema);
        String string = parsedOptions.compression();
        String string2 = "uncompressed";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            job.getConfiguration().setBoolean("mapred.output.compress", false);
        } else {
            String string3;
            job.getConfiguration().setBoolean("mapred.output.compress", true);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(40).append("Compressing Avro output using the ").append(parsedOptions.compression()).append(" codec").toString());
            String string4 = parsedOptions.compression();
            if ("deflate".equals(string4)) {
                int deflateLevel = spark.sessionState().conf().avroDeflateLevel();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(55).append("Avro compression level ").append(deflateLevel).append(" will be used for ").append("deflate").append(" codec.").toString());
                job.getConfiguration().setInt("avro.mapred.deflate.level", deflateLevel);
                string3 = "deflate";
            } else {
                boolean bl = "snappy".equals(string4) ? true : ("bzip2".equals(string4) ? true : "xz".equals(string4));
                if (bl) {
                    string3 = string4;
                } else {
                    throw new IllegalArgumentException(new java.lang.StringBuilder(27).append("Invalid compression codec: ").append(string4).toString());
                }
            }
            String codec = string3;
            job.getConfiguration().set("avro.output.codec", codec);
        }
        return new AvroOutputWriterFactory(dataSchema, outputAvroSchema.toString());
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession spark, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedConf = spark.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        AvroOptions parsedOptions = new AvroOptions(options, hadoopConf);
        return (Function1 & Serializable & scala.Serializable)file -> {
            Iterator iterator;
            Configuration conf = ((SerializableConfiguration)broadcastedConf.value()).value();
            Schema.Parser parser = new Schema.Parser();
            Option userProvidedSchema = parsedOptions.schema().map((Function1 & Serializable & scala.Serializable)x$1 -> parser.parse(x$1));
            if (parsedOptions.ignoreExtension() || file.filePath().endsWith(".avro")) {
                FileReader fileReader;
                FsInput in = new FsInput(new Path(new URI(file.filePath())), conf);
                try {
                    GenericDatumReader genericDatumReader;
                    Option option = userProvidedSchema;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Schema userSchema = (Schema)some.value();
                        genericDatumReader = new GenericDatumReader(userSchema);
                    } else {
                        genericDatumReader = new GenericDatumReader();
                    }
                    GenericDatumReader datumReader = genericDatumReader;
                    fileReader = DataFileReader.openReader((SeekableInput)in, (DatumReader)datumReader);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while opening DataFileReader", e);
                        in.close();
                        throw e;
                    }
                    throw throwable;
                }
                FileReader reader = fileReader;
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)taskContext -> taskContext.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$1 -> {
                    reader.close();
                    return BoxedUnit.UNIT;
                }));
                reader.sync(file.start());
                long stop = file.start() + file.length();
                AvroDeserializer deserializer = new AvroDeserializer((Schema)userProvidedSchema.getOrElse((Function0 & Serializable & scala.Serializable)() -> reader.getSchema()), (DataType)requiredSchema);
                iterator = new Iterator<InternalRow>(null, reader, stop, deserializer){
                    private boolean completed;
                    private final FileReader reader$1;
                    private final long stop$1;
                    private final AvroDeserializer deserializer$1;

                    public Iterator<InternalRow> seq() {
                        return Iterator.seq$((Iterator)this);
                    }

                    public boolean isEmpty() {
                        return Iterator.isEmpty$((Iterator)this);
                    }

                    public boolean isTraversableAgain() {
                        return Iterator.isTraversableAgain$((Iterator)this);
                    }

                    public boolean hasDefiniteSize() {
                        return Iterator.hasDefiniteSize$((Iterator)this);
                    }

                    public Iterator<InternalRow> take(int n) {
                        return Iterator.take$((Iterator)this, (int)n);
                    }

                    public Iterator<InternalRow> drop(int n) {
                        return Iterator.drop$((Iterator)this, (int)n);
                    }

                    public Iterator<InternalRow> slice(int from, int until) {
                        return Iterator.slice$((Iterator)this, (int)from, (int)until);
                    }

                    public Iterator<InternalRow> sliceIterator(int from, int until) {
                        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                    }

                    public <B> Iterator<B> map(Function1<InternalRow, B> f) {
                        return Iterator.map$((Iterator)this, f);
                    }

                    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                        return Iterator.$plus$plus$((Iterator)this, that);
                    }

                    public <B> Iterator<B> flatMap(Function1<InternalRow, GenTraversableOnce<B>> f) {
                        return Iterator.flatMap$((Iterator)this, f);
                    }

                    public Iterator<InternalRow> filter(Function1<InternalRow, Object> p) {
                        return Iterator.filter$((Iterator)this, p);
                    }

                    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<InternalRow, B, Object> p) {
                        return Iterator.corresponds$((Iterator)this, that, p);
                    }

                    public Iterator<InternalRow> withFilter(Function1<InternalRow, Object> p) {
                        return Iterator.withFilter$((Iterator)this, p);
                    }

                    public Iterator<InternalRow> filterNot(Function1<InternalRow, Object> p) {
                        return Iterator.filterNot$((Iterator)this, p);
                    }

                    public <B> Iterator<B> collect(PartialFunction<InternalRow, B> pf) {
                        return Iterator.collect$((Iterator)this, pf);
                    }

                    public <B> Iterator<B> scanLeft(B z, Function2<B, InternalRow, B> op) {
                        return Iterator.scanLeft$((Iterator)this, z, op);
                    }

                    public <B> Iterator<B> scanRight(B z, Function2<InternalRow, B, B> op) {
                        return Iterator.scanRight$((Iterator)this, z, op);
                    }

                    public Iterator<InternalRow> takeWhile(Function1<InternalRow, Object> p) {
                        return Iterator.takeWhile$((Iterator)this, p);
                    }

                    public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> partition(Function1<InternalRow, Object> p) {
                        return Iterator.partition$((Iterator)this, p);
                    }

                    public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> span(Function1<InternalRow, Object> p) {
                        return Iterator.span$((Iterator)this, p);
                    }

                    public Iterator<InternalRow> dropWhile(Function1<InternalRow, Object> p) {
                        return Iterator.dropWhile$((Iterator)this, p);
                    }

                    public <B> Iterator<Tuple2<InternalRow, B>> zip(Iterator<B> that) {
                        return Iterator.zip$((Iterator)this, that);
                    }

                    public <A1> Iterator<A1> padTo(int len, A1 elem) {
                        return Iterator.padTo$((Iterator)this, (int)len, elem);
                    }

                    public Iterator<Tuple2<InternalRow, Object>> zipWithIndex() {
                        return Iterator.zipWithIndex$((Iterator)this);
                    }

                    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                    }

                    public <U> void foreach(Function1<InternalRow, U> f) {
                        Iterator.foreach$((Iterator)this, f);
                    }

                    public boolean forall(Function1<InternalRow, Object> p) {
                        return Iterator.forall$((Iterator)this, p);
                    }

                    public boolean exists(Function1<InternalRow, Object> p) {
                        return Iterator.exists$((Iterator)this, p);
                    }

                    public boolean contains(Object elem) {
                        return Iterator.contains$((Iterator)this, (Object)elem);
                    }

                    public Option<InternalRow> find(Function1<InternalRow, Object> p) {
                        return Iterator.find$((Iterator)this, p);
                    }

                    public int indexWhere(Function1<InternalRow, Object> p) {
                        return Iterator.indexWhere$((Iterator)this, p);
                    }

                    public int indexWhere(Function1<InternalRow, Object> p, int from) {
                        return Iterator.indexWhere$((Iterator)this, p, (int)from);
                    }

                    public <B> int indexOf(B elem) {
                        return Iterator.indexOf$((Iterator)this, elem);
                    }

                    public <B> int indexOf(B elem, int from) {
                        return Iterator.indexOf$((Iterator)this, elem, (int)from);
                    }

                    public BufferedIterator<InternalRow> buffered() {
                        return Iterator.buffered$((Iterator)this);
                    }

                    public <B> Iterator.GroupedIterator<B> grouped(int size) {
                        return Iterator.grouped$((Iterator)this, (int)size);
                    }

                    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                    }

                    public <B> int sliding$default$2() {
                        return Iterator.sliding$default$2$((Iterator)this);
                    }

                    public int length() {
                        return Iterator.length$((Iterator)this);
                    }

                    public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> duplicate() {
                        return Iterator.duplicate$((Iterator)this);
                    }

                    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                    }

                    public boolean sameElements(Iterator<?> that) {
                        return Iterator.sameElements$((Iterator)this, that);
                    }

                    public Traversable<InternalRow> toTraversable() {
                        return Iterator.toTraversable$((Iterator)this);
                    }

                    public Iterator<InternalRow> toIterator() {
                        return Iterator.toIterator$((Iterator)this);
                    }

                    public Stream<InternalRow> toStream() {
                        return Iterator.toStream$((Iterator)this);
                    }

                    public String toString() {
                        return Iterator.toString$((Iterator)this);
                    }

                    public List<InternalRow> reversed() {
                        return TraversableOnce.reversed$((TraversableOnce)this);
                    }

                    public int size() {
                        return TraversableOnce.size$((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.nonEmpty$((TraversableOnce)this);
                    }

                    public int count(Function1<InternalRow, Object> p) {
                        return TraversableOnce.count$((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<InternalRow, B> pf) {
                        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, InternalRow, B> op) {
                        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<InternalRow, B, B> op) {
                        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, InternalRow, B> op) {
                        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<InternalRow, B, B> op) {
                        return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, InternalRow, B> op) {
                        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                    }

                    public <B> B reduceRight(Function2<InternalRow, B, B> op) {
                        return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, InternalRow, B> op) {
                        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<InternalRow, B, B> op) {
                        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, InternalRow, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.product$((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                    }

                    public List<InternalRow> toList() {
                        return TraversableOnce.toList$((TraversableOnce)this);
                    }

                    public Iterable<InternalRow> toIterable() {
                        return TraversableOnce.toIterable$((TraversableOnce)this);
                    }

                    public Seq<InternalRow> toSeq() {
                        return TraversableOnce.toSeq$((TraversableOnce)this);
                    }

                    public IndexedSeq<InternalRow> toIndexedSeq() {
                        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.toBuffer$((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.toSet$((TraversableOnce)this);
                    }

                    public Vector<InternalRow> toVector() {
                        return TraversableOnce.toVector$((TraversableOnce)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, InternalRow, Col> cbf) {
                        return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                    }

                    public <T, U> Map<T, U> toMap(Predef$.less.colon.less<InternalRow, Tuple2<T, U>> ev) {
                        return TraversableOnce.toMap$((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.mkString$((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                    }

                    public int sizeHintIfCheap() {
                        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public boolean hasNext() {
                        boolean bl;
                        if (this.completed) {
                            bl = false;
                        } else {
                            void var1_1;
                            boolean r;
                            boolean bl2 = r = this.reader$1.hasNext() && !this.reader$1.pastSync(this.stop$1);
                            if (!r) {
                                this.reader$1.close();
                                this.completed = true;
                            }
                            bl = var1_1;
                        }
                        return bl;
                    }

                    public InternalRow next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException("next on empty iterator");
                        }
                        GenericRecord record = (GenericRecord)this.reader$1.next();
                        return (InternalRow)this.deserializer$1.deserialize(record);
                    }
                    {
                        this.reader$1 = reader$1;
                        this.stop$1 = stop$1;
                        this.deserializer$1 = deserializer$1;
                        GenTraversableOnce.$init$((GenTraversableOnce)this);
                        TraversableOnce.$init$((TraversableOnce)this);
                        Iterator.$init$((Iterator)this);
                        this.completed = false;
                    }
                };
            } else {
                iterator = package$.MODULE$.Iterator().empty();
            }
            return iterator;
        };
    }

    public AvroFileFormat() {
        FileFormat.$init$((FileFormat)this);
        Logging.$init$((Logging)this);
    }
}

