/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public abstract class NumberEvaluator
extends ComplexEvaluator {
    protected static final long serialVersionUID = 1L;

    public NumberEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public abstract Number evaluate(Tuple var1) throws IOException;

    public List<BigDecimal> evaluateAll(Tuple tuple) throws IOException {
        ArrayList<BigDecimal> results = new ArrayList<BigDecimal>();
        for (StreamEvaluator subEvaluator : this.subEvaluators) {
            Object result = subEvaluator.evaluate(tuple);
            if (null == result) {
                results.add(null);
                continue;
            }
            if (result instanceof Number) {
                results.add(new BigDecimal(result.toString()));
                continue;
            }
            String message = String.format(Locale.ROOT, "Failed to evaluate to a numeric value - evaluator '%s' resulted in type '%s' and value '%s'", subEvaluator.toExpression(this.constructingFactory), result.getClass().getName(), result.toString());
            throw new IOException(message);
        }
        return results;
    }

    public Number normalizeType(BigDecimal value) {
        if (null == value) {
            return null;
        }
        if (value.signum() == 0 || value.scale() <= 0 || value.stripTrailingZeros().scale() <= 0) {
            return value.longValue();
        }
        return value.doubleValue();
    }
}

