/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.BooleanEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class GreaterThanEvaluator
extends BooleanEvaluator {
    protected static final long serialVersionUID = 1L;

    public GreaterThanEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.subEvaluators.size() < 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least two values but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public Boolean evaluate(Tuple tuple) throws IOException {
        List<Object> results = this.evaluateAll(tuple);
        if (results.size() < 2) {
            String message = null;
            message = 1 == results.size() ? String.format(Locale.ROOT, "%s(...) only works with at least 2 values but 1 was provided", this.constructingFactory.getFunctionName(this.getClass())) : String.format(Locale.ROOT, "%s(...) only works with at least 2 values but 0 were provided", this.constructingFactory.getFunctionName(this.getClass()));
            throw new IOException(message);
        }
        BooleanEvaluator.Checker checker = this.constructChecker(results.get(0));
        if (results.stream().anyMatch(result -> null == result)) {
            throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) because a null value was found", this.constructingFactory.getFunctionName(this.getClass())));
        }
        if (results.stream().anyMatch(result -> !checker.isCorrectType(result))) {
            throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) of differing types [%s]", this.constructingFactory.getFunctionName(this.getClass()), results.stream().map(item -> item.getClass().getSimpleName()).collect(Collectors.joining(","))));
        }
        for (int idx = 1; idx < results.size(); ++idx) {
            if (checker.test(results.get(idx - 1), results.get(idx))) continue;
            return false;
        }
        return true;
    }

    private BooleanEvaluator.Checker constructChecker(Object fromValue) throws IOException {
        if (null == fromValue) {
            throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) because a null value was found", this.constructingFactory.getFunctionName(this.getClass())));
        }
        if (fromValue instanceof Number) {
            return new BooleanEvaluator.NumberChecker(){

                @Override
                public boolean test(Object left, Object right) {
                    return new BigDecimal(left.toString()).compareTo(new BigDecimal(right.toString())) > 0;
                }
            };
        }
        if (fromValue instanceof String) {
            return new BooleanEvaluator.StringChecker(){

                @Override
                public boolean test(Object left, Object right) {
                    return ((String)left).compareToIgnoreCase((String)right) > 0;
                }
            };
        }
        throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) for values of type '%s'", this.constructingFactory.getFunctionName(this.getClass()), fromValue.getClass().getSimpleName()));
    }
}

