/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.CloudLegacySolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.CountMetric;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

public class TimeSeriesStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private String start;
    private String end;
    private String gap;
    private String field;
    private String format;
    private String split;
    private String limit;
    private DateTimeFormatter formatter;
    private Metric[] metrics;
    private List<Tuple> tuples = new ArrayList<Tuple>();
    private int index;
    private String zkHost;
    private SolrParams params;
    private String collection;
    protected transient SolrClientCache cache;
    protected transient CloudSolrClient cloudSolrClient;

    public TimeSeriesStream(String zkHost, String collection, SolrParams params, Metric[] metrics, String field, String start, String end, String gap, String format) throws IOException {
        this.init(collection, params, field, metrics, start, end, gap, format, null, null, zkHost);
    }

    public TimeSeriesStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        if (collectionName.indexOf(34) > -1) {
            collectionName = collectionName.replace("\"", "").replace(" ", "");
        }
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter startExpression = factory.getNamedOperand(expression, "start");
        StreamExpressionNamedParameter endExpression = factory.getNamedOperand(expression, "end");
        StreamExpressionNamedParameter fieldExpression = factory.getNamedOperand(expression, "field");
        StreamExpressionNamedParameter gapExpression = factory.getNamedOperand(expression, "gap");
        StreamExpressionNamedParameter formatExpression = factory.getNamedOperand(expression, "format");
        StreamExpressionNamedParameter splitExpression = factory.getNamedOperand(expression, "split");
        StreamExpressionNamedParameter limitExpression = factory.getNamedOperand(expression, "limit");
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        List<StreamExpression> metricExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, Metric.class);
        String start = null;
        if (startExpression == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - start parameter is required", expression));
        }
        start = ((StreamExpressionValue)startExpression.getParameter()).getValue();
        String end = null;
        if (endExpression == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - end parameter is required", expression));
        }
        end = ((StreamExpressionValue)endExpression.getParameter()).getValue();
        String gap = null;
        if (gapExpression == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - gap parameter is required", expression));
        }
        gap = ((StreamExpressionValue)gapExpression.getParameter()).getValue();
        String field = null;
        if (fieldExpression == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - field parameter is required", expression));
        }
        field = ((StreamExpressionValue)fieldExpression.getParameter()).getValue();
        String format = null;
        if (formatExpression != null) {
            format = ((StreamExpressionValue)formatExpression.getParameter()).getValue();
        }
        String split = null;
        if (splitExpression != null) {
            split = ((StreamExpressionValue)splitExpression.getParameter()).getValue();
        }
        String limit = "10";
        if (limitExpression != null) {
            limit = ((StreamExpressionValue)limitExpression.getParameter()).getValue();
            try {
                Integer.parseInt(limit);
            }
            catch (Exception e) {
                throw new IOException(String.format(Locale.ROOT, "invalid limit %s, integer expected", limit));
            }
        }
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (0 == namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one named parameter expected. eg. 'q=*:*'", expression));
        }
        Metric[] metrics = null;
        if (metricExpressions.size() > 0) {
            metrics = new Metric[metricExpressions.size()];
            for (int idx = 0; idx < metricExpressions.size(); ++idx) {
                metrics[idx] = factory.constructMetric(metricExpressions.get(idx));
            }
        } else {
            metrics = new Metric[]{new CountMetric()};
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("start") || namedParam.getName().equals("end") || namedParam.getName().equals("gap")) continue;
            params.add(namedParam.getName(), new String[]{namedParam.getParameter().toString().trim()});
        }
        if (params.get("q") == null) {
            params.set("q", new String[]{"*:*"});
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        this.init(collectionName, (SolrParams)params, field, metrics, start, end, gap, format, split, limit, zkHost);
    }

    public String getCollection() {
        return this.collection;
    }

    private void init(String collection, SolrParams params, String field, Metric[] metrics, String start, String end, String gap, String format, String split, String limit, String zkHost) throws IOException {
        this.zkHost = zkHost;
        this.collection = collection;
        this.start = start;
        this.gap = gap;
        if (!gap.startsWith("+")) {
            this.gap = "+" + gap;
        }
        this.metrics = metrics;
        this.field = field;
        this.params = params;
        this.split = split;
        this.limit = limit;
        this.end = end;
        if (format != null) {
            this.format = format;
            this.formatter = DateTimeFormatter.ofPattern(format, Locale.ROOT);
        }
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (this.collection.indexOf(44) > -1) {
            expression.addParameter("\"" + this.collection + "\"");
        } else {
            expression.addParameter(this.collection);
        }
        ModifiableSolrParams tmpParams = new ModifiableSolrParams(this.params);
        for (Map.Entry param : tmpParams.getMap().entrySet()) {
            expression.addParameter(new StreamExpressionNamedParameter((String)param.getKey(), String.join((CharSequence)",", (CharSequence[])param.getValue())));
        }
        for (Metric metric : this.metrics) {
            expression.addParameter(metric.toExpression(factory));
        }
        expression.addParameter(new StreamExpressionNamedParameter("start", this.start));
        expression.addParameter(new StreamExpressionNamedParameter("end", this.end));
        expression.addParameter(new StreamExpressionNamedParameter("gap", this.gap));
        expression.addParameter(new StreamExpressionNamedParameter("field", this.gap));
        expression.addParameter(new StreamExpressionNamedParameter("format", this.format));
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        explanation.setExpression(this.toExpression(factory).toString());
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName(String.format(Locale.ROOT, "solr (%s)", this.collection));
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        child.setExpression(this.params.stream().map(e -> String.format(Locale.ROOT, "%s=%s", e.getKey(), Arrays.toString((Object[])e.getValue()))).collect(Collectors.joining(",")));
        explanation.addChild(child);
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.cache = context.getSolrClientCache();
    }

    @Override
    public List<TupleStream> children() {
        return new ArrayList<TupleStream>();
    }

    @Override
    public void open() throws IOException {
        if (this.cache != null) {
            this.cloudSolrClient = this.cache.getCloudSolrClient(this.zkHost);
        } else {
            ArrayList<String> hosts = new ArrayList<String>();
            hosts.add(this.zkHost);
            this.cloudSolrClient = new CloudLegacySolrClient.Builder(hosts, Optional.empty()).build();
        }
        String json = this.getJsonFacetString(this.field, this.metrics, this.start, this.end, this.gap);
        ModifiableSolrParams paramsLoc = new ModifiableSolrParams(this.params);
        paramsLoc.set("json.facet", new String[]{json});
        paramsLoc.set("rows", new String[]{"0"});
        QueryRequest request = new QueryRequest((SolrParams)paramsLoc, SolrRequest.METHOD.POST);
        try {
            NamedList response = this.cloudSolrClient.request((SolrRequest)request, this.collection);
            this.getTuples(response, this.field, this.metrics);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.cache == null) {
            this.cloudSolrClient.close();
        }
    }

    @Override
    public Tuple read() throws IOException {
        if (this.index < this.tuples.size()) {
            Tuple tuple = this.tuples.get(this.index);
            ++this.index;
            return tuple;
        }
        return Tuple.EOF();
    }

    private String getJsonFacetString(String field, Metric[] _metrics, String start, String end, String gap) {
        StringBuilder buf = new StringBuilder();
        this.appendJson(buf, _metrics, field, start, end, gap);
        return "{" + buf.toString() + "}";
    }

    private void appendJson(StringBuilder buf, Metric[] _metrics, String field, String start, String end, String gap) {
        buf.append('\"');
        buf.append("timeseries");
        buf.append('\"');
        buf.append(":{");
        buf.append("\"type\":\"range\"");
        buf.append(",\"field\":\"").append(field).append('\"');
        buf.append(",\"start\":\"").append(start).append('\"');
        buf.append(",\"end\":\"").append(end).append('\"');
        buf.append(",\"gap\":\"").append(gap).append('\"');
        buf.append(",\"facet\":{");
        if (this.split != null) {
            buf.append('\"');
            buf.append("split");
            buf.append('\"');
            buf.append(":{");
            buf.append("\"type\":\"terms\"");
            buf.append(",\"field\":\"").append(this.split.toString()).append('\"');
            buf.append(",\"limit\":").append(this.limit);
            buf.append(",\"overrequest\":100");
            if (_metrics[0].getIdentifier().startsWith("count(")) {
                buf.append(",\"sort\":\"").append("count").append(" desc\"");
            } else {
                buf.append(",\"sort\":\"").append("facet_0").append(" desc\"");
            }
            buf.append(",\"facet\":{");
            int metricCount = 0;
            for (Metric metric : _metrics) {
                String identifier = metric.getIdentifier();
                if (identifier.startsWith("count(")) continue;
                if (metricCount > 0) {
                    buf.append(",");
                }
                if (identifier.startsWith("per(")) {
                    buf.append("\"facet_").append(metricCount).append("\":\"").append(identifier.replaceFirst("per", "percentile")).append('\"');
                } else if (identifier.startsWith("std(")) {
                    buf.append("\"facet_").append(metricCount).append("\":\"").append(identifier.replaceFirst("std", "stddev")).append('\"');
                } else if (identifier.startsWith("countDist(")) {
                    buf.append("\"facet_").append(metricCount).append("\":\"").append(identifier.replaceFirst("countDist", "unique")).append('\"');
                } else {
                    buf.append("\"facet_").append(metricCount).append("\":\"").append(identifier).append('\"');
                }
                ++metricCount;
            }
            buf.append("}}");
        } else {
            int metricCount = 0;
            for (Metric metric : _metrics) {
                String identifier = metric.getIdentifier();
                if (identifier.startsWith("count(")) continue;
                if (metricCount > 0) {
                    buf.append(",");
                }
                if (identifier.startsWith("per(")) {
                    buf.append("\"facet_").append(metricCount).append("\":\"").append(identifier.replaceFirst("per", "percentile")).append('\"');
                } else if (identifier.startsWith("std(")) {
                    buf.append("\"facet_").append(metricCount).append("\":\"").append(identifier.replaceFirst("std", "stddev")).append('\"');
                } else if (identifier.startsWith("countDist(")) {
                    buf.append("\"facet_").append(metricCount).append("\":\"").append(identifier.replaceFirst("countDist", "unique")).append('\"');
                } else {
                    buf.append("\"facet_").append(metricCount).append("\":\"").append(identifier).append('\"');
                }
                ++metricCount;
            }
        }
        buf.append("}}");
    }

    private void getTuples(NamedList<?> response, String field, Metric[] metrics) {
        Tuple tuple = new Tuple();
        NamedList facets = (NamedList)response.get("facets");
        this.fillTuples(this.tuples, tuple, facets, field, metrics);
    }

    private void fillTuples(List<Tuple> tuples, Tuple currentTuple, NamedList<?> facets, String field, Metric[] _metrics) {
        NamedList nl = (NamedList)facets.get("timeseries");
        if (nl == null) {
            return;
        }
        List allBuckets = (List)nl.get("buckets");
        for (int b = 0; b < allBuckets.size(); ++b) {
            NamedList bucket = (NamedList)allBuckets.get(b);
            Object val = bucket.get("val");
            Tuple tx = currentTuple.clone();
            if (this.formatter != null) {
                LocalDateTime localDateTime = LocalDateTime.ofInstant(((Date)val).toInstant(), ZoneOffset.UTC);
                val = localDateTime.format(this.formatter);
            }
            tx.put(field, val);
            if (this.split != null) {
                NamedList splitBuckets = (NamedList)bucket.get("split");
                if (splitBuckets == null) continue;
                List sbuckets = (List)splitBuckets.get("buckets");
                for (int d = 0; d < sbuckets.size(); ++d) {
                    NamedList bucketS = (NamedList)sbuckets.get(d);
                    Object valS = bucketS.get("val");
                    if (valS instanceof Integer) {
                        valS = ((Integer)valS).longValue();
                    }
                    Tuple splitT = tx.clone();
                    splitT.put(this.split, valS);
                    int m = 0;
                    for (Metric metric : _metrics) {
                        String identifier = metric.getIdentifier();
                        if (!identifier.startsWith("count(")) {
                            if (bucketS.get("facet_" + m) != null) {
                                Number n = (Number)bucketS.get("facet_" + m);
                                if (metric.outputLong) {
                                    splitT.put(identifier, Math.round(n.doubleValue()));
                                } else {
                                    splitT.put(identifier, n.doubleValue());
                                }
                            } else {
                                splitT.put(identifier, 0);
                            }
                            ++m;
                            continue;
                        }
                        long l = ((Number)bucketS.get("count")).longValue();
                        splitT.put("count(*)", l);
                    }
                    tuples.add(splitT);
                }
                continue;
            }
            int m = 0;
            for (Metric metric : _metrics) {
                String identifier = metric.getIdentifier();
                if (!identifier.startsWith("count(")) {
                    if (bucket.get("facet_" + m) != null) {
                        Number d = (Number)bucket.get("facet_" + m);
                        if (metric.outputLong) {
                            tx.put(identifier, Math.round(d.doubleValue()));
                        } else {
                            tx.put(identifier, d.doubleValue());
                        }
                    } else {
                        tx.put(identifier, 0);
                    }
                    ++m;
                    continue;
                }
                long l = ((Number)bucket.get("count")).longValue();
                tx.put("count(*)", l);
            }
            tuples.add(tx);
        }
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }
}

