/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.config.ConfigParseUtil;
import org.apache.solr.handler.dataimport.config.Entity;
import org.apache.solr.handler.dataimport.config.EntityField;
import org.apache.solr.handler.dataimport.config.Script;
import org.w3c.dom.Element;

public class Document {
    private final String deleteQuery;
    private final List<Entity> entities;
    private final String onImportStart;
    private final String onImportEnd;
    private final List<Map<String, String>> functions;
    private final Script script;
    private final Map<String, Properties> dataSources;

    public Document(Element element, DataImporter di, List<Map<String, String>> functions, Script script, Map<String, Properties> dataSources) {
        this.deleteQuery = ConfigParseUtil.getStringAttribute(element, "deleteQuery", null);
        this.onImportStart = ConfigParseUtil.getStringAttribute(element, "onImportStart", null);
        this.onImportEnd = ConfigParseUtil.getStringAttribute(element, "onImportEnd", null);
        ArrayList<Entity> modEntities = new ArrayList<Entity>();
        List<Element> l = ConfigParseUtil.getChildNodes(element, "entity");
        boolean docRootFound = false;
        for (Element e : l) {
            Entity entity = new Entity(docRootFound, e, di, null);
            Map<String, EntityField> fields = ConfigParseUtil.gatherAllFields(di, entity);
            ConfigParseUtil.verifyWithSchema(di, fields);
            modEntities.add(entity);
        }
        this.entities = Collections.unmodifiableList(modEntities);
        if (functions == null) {
            functions = Collections.emptyList();
        }
        ArrayList<Map<String, String>> modFunc = new ArrayList<Map<String, String>>(functions.size());
        for (Map<String, String> f : functions) {
            modFunc.add(Collections.unmodifiableMap(f));
        }
        this.functions = Collections.unmodifiableList(modFunc);
        this.script = script;
        this.dataSources = Collections.unmodifiableMap(dataSources);
    }

    public String getDeleteQuery() {
        return this.deleteQuery;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public String getOnImportStart() {
        return this.onImportStart;
    }

    public String getOnImportEnd() {
        return this.onImportEnd;
    }

    public List<Map<String, String>> getFunctions() {
        return this.functions;
    }

    public Map<String, Properties> getDataSources() {
        return this.dataSources;
    }

    public Script getScript() {
        return this.script;
    }
}

