/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.resourceresolver;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.testing.resourceresolver.MockResourceResolver;
import org.apache.sling.testing.resourceresolver.MockResourceResolverFactoryOptions;
import org.osgi.service.event.EventAdmin;

public class MockResourceResolverFactory
implements ResourceResolverFactory {
    private final Map<String, Map<String, Object>> resources = new LinkedHashMap<String, Map<String, Object>>();
    private final MockResourceResolverFactoryOptions options;
    private ThreadLocal<Stack<ResourceResolver>> resolverStackHolder = new ThreadLocal();

    public MockResourceResolverFactory(EventAdmin eventAdmin) {
        this(new MockResourceResolverFactoryOptions().setEventAdmin(eventAdmin));
    }

    public MockResourceResolverFactory() {
        this(new MockResourceResolverFactoryOptions());
    }

    public MockResourceResolverFactory(MockResourceResolverFactoryOptions options) {
        this.options = options;
        this.resources.put("/", new HashMap());
    }

    public ResourceResolver getResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        MockResourceResolver result = new MockResourceResolver(this.options, this, this.resources);
        Stack<Object> resolverStack = this.resolverStackHolder.get();
        if (resolverStack == null) {
            resolverStack = new Stack();
            this.resolverStackHolder.set(resolverStack);
        }
        resolverStack.push((Object)result);
        return result;
    }

    public ResourceResolver getAdministrativeResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return new MockResourceResolver(this.options, this, this.resources);
    }

    public ResourceResolver getServiceResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return new MockResourceResolver(this.options, this, this.resources);
    }

    public ResourceResolver getThreadResourceResolver() {
        ResourceResolver result = null;
        Stack<ResourceResolver> resolverStack = this.resolverStackHolder.get();
        if (resolverStack != null && !resolverStack.isEmpty()) {
            result = resolverStack.peek();
        }
        return result;
    }

    public void closed(ResourceResolver resourceResolverImpl) {
        Stack<ResourceResolver> resolverStack = this.resolverStackHolder.get();
        if (resolverStack != null) {
            resolverStack.remove(resourceResolverImpl);
        }
    }
}

