/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.apache.sling.repoinit.parser.operations.PathSegmentDefinition;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class CreatePath
extends Operation {
    private List<PathSegmentDefinition> pathDef = new ArrayList<PathSegmentDefinition>();
    private final String defaultPrimaryType;

    public CreatePath(String defaultPrimaryType) {
        this.defaultPrimaryType = defaultPrimaryType;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.pathDef;
    }

    @Override
    protected String getParametersDescription() {
        return this.pathDef.toString();
    }

    @Override
    @NotNull
    public String asRepoInitString() {
        String defaultTypeStr = this.defaultPrimaryType == null ? "" : "(" + this.defaultPrimaryType + ") ";
        StringBuilder sb = new StringBuilder();
        for (PathSegmentDefinition psd : this.getDefinitions()) {
            sb.append("/").append(psd.getSegment());
            List<String> mixins = psd.getMixins();
            if (psd.isDefaultPrimary() && mixins.isEmpty()) continue;
            sb.append("(");
            if (!psd.isDefaultPrimary()) {
                sb.append(psd.getPrimaryType());
            }
            if (!mixins.isEmpty()) {
                sb.append(" mixin ").append(CreatePath.listToString(mixins));
            }
            sb.append(")");
        }
        return String.format("create path %s%s%n", defaultTypeStr, sb.toString());
    }

    @Override
    public void accept(OperationVisitor v) {
        v.visitCreatePath(this);
    }

    public void addSegment(String path, String primaryType) {
        this.addSegment(path, primaryType, null);
    }

    public void addSegment(String path, String primaryType, List<String> mixins) {
        String[] segments = path.split("/");
        for (int i = 0; i < segments.length; ++i) {
            if (segments[i].length() == 0) continue;
            String pt = this.defaultPrimaryType;
            boolean isDefaultPrimary = true;
            List<String> ms = null;
            if (i == segments.length - 1) {
                if (primaryType != null) {
                    pt = primaryType;
                    isDefaultPrimary = false;
                }
                if (mixins != null && !mixins.isEmpty()) {
                    ms = mixins;
                }
            }
            this.pathDef.add(new PathSegmentDefinition(segments[i], pt, ms, isDefaultPrimary));
        }
    }

    public List<PathSegmentDefinition> getDefinitions() {
        return Collections.unmodifiableList(this.pathDef);
    }
}

