/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;

public abstract class NodeUtil {
    public static final String MIXIN_TYPES = "jcr:mixinTypes";
    public static final String NODE_TYPE = "jcr:primaryType";

    public static void handleMixinTypes(Node node, String[] mixinTypes) throws RepositoryException {
        HashSet<String> newTypes = new HashSet<String>();
        if (mixinTypes != null) {
            for (String value : mixinTypes) {
                newTypes.add(value);
            }
        }
        HashSet<String> oldTypes = new HashSet<String>();
        for (NodeType mixinType : node.getMixinNodeTypes()) {
            oldTypes.add(mixinType.getName());
        }
        for (String name : oldTypes) {
            if (!newTypes.contains(name)) {
                node.removeMixin(name);
                continue;
            }
            newTypes.remove(name);
        }
        for (String name : newTypes) {
            node.addMixin(name);
        }
    }
}

