/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sling.jcr.contentloader.ContentReader;
import org.apache.sling.jcr.contentloader.ImportOptions;
import org.apache.sling.jcr.contentloader.PathEntry;
import org.apache.sling.jcr.contentloader.internal.ContentReaderWhiteboard;
import org.apache.sling.jcr.contentloader.internal.JcrXmlImporter;

public abstract class BaseImportLoader
extends JcrXmlImporter {
    public static final String EXT_JCR_XML = ".jcr.xml";
    protected ContentReaderWhiteboard contentReaderWhiteboard;

    public BaseImportLoader() {
    }

    public BaseImportLoader(ContentReaderWhiteboard contentReaderWhiteboard) {
        this.contentReaderWhiteboard = contentReaderWhiteboard;
    }

    public Map<String, ContentReader> getContentReaders() {
        LinkedHashMap<String, ContentReader> readers = new LinkedHashMap<String, ContentReader>();
        readers.put(EXT_JCR_XML, null);
        for (Map.Entry<String, ContentReader> e : this.contentReaderWhiteboard.getReadersByExtension().entrySet()) {
            readers.put('.' + e.getKey(), e.getValue());
        }
        return readers;
    }

    protected String toPlainName(String name, String contentReaderExtension) {
        if (contentReaderExtension != null) {
            if (name.length() == contentReaderExtension.length()) {
                return null;
            }
            return name.substring(0, name.length() - contentReaderExtension.length());
        }
        return name;
    }

    protected String getContentReaderExtension(String name) {
        String readerExt = null;
        Iterator<String> ipIter = this.getContentReaders().keySet().iterator();
        while (readerExt == null && ipIter.hasNext()) {
            String ext = ipIter.next();
            if (!name.endsWith(ext)) continue;
            readerExt = ext;
        }
        return readerExt;
    }

    public ContentReader getContentReader(String name, PathEntry configuration) {
        Map<String, ContentReader> contentReaders = this.getContentReaders();
        for (Map.Entry<String, ContentReader> readerEntry : contentReaders.entrySet()) {
            String extension = readerEntry.getKey();
            if (!name.endsWith(extension) || configuration.isIgnoredImportProvider(extension)) continue;
            return readerEntry.getValue();
        }
        return null;
    }

    public ContentReader getContentReader(String name, ImportOptions importOptions) {
        Map<String, ContentReader> contentReaders = this.getContentReaders();
        for (Map.Entry<String, ContentReader> readerEntry : contentReaders.entrySet()) {
            String extension = readerEntry.getKey();
            if (!name.endsWith(extension) || importOptions.isIgnoredImportProvider(extension)) continue;
            return readerEntry.getValue();
        }
        return null;
    }
}

