/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.parser;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.fsprovider.internal.parser.ContentElement;
import org.apache.sling.fsprovider.internal.parser.ContentFileTypes;
import org.apache.sling.jcr.contentparser.ContentParser;
import org.apache.sling.jcr.contentparser.ContentParserFactory;
import org.apache.sling.jcr.contentparser.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContentFileParserUtil {
    private static final Logger log = LoggerFactory.getLogger(ContentFileParserUtil.class);
    private static final ContentParser JSON_PARSER;
    private static final ContentParser JCR_XML_PARSER;

    private ContentFileParserUtil() {
    }

    public static ContentElement parse(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            if (StringUtils.endsWith((CharSequence)file.getName(), (CharSequence)ContentFileTypes.JSON_SUFFIX)) {
                return ContentFileParserUtil.parse(JSON_PARSER, file);
            }
            if (StringUtils.equals((CharSequence)file.getName(), (CharSequence)".content.xml") || StringUtils.endsWith((CharSequence)file.getName(), (CharSequence)ContentFileTypes.JCR_XML_SUFFIX)) {
                return ContentFileParserUtil.parse(JCR_XML_PARSER, file);
            }
        }
        catch (Throwable ex) {
            log.warn("Error parsing content from " + file.getPath(), ex);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static ContentElement parse(ContentParser contentParser, File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ContentFileParserUtil.class.getClassLoader());
            JSON_PARSER = ContentParserFactory.create((ContentType)ContentType.JSON);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        JCR_XML_PARSER = ContentParserFactory.create((ContentType)ContentType.JCR_XML);
    }
}

