/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper.jcr;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.sling.api.resource.ValueMap;

class FsValue
implements Value {
    private final ValueMap props;
    private final String propertyName;
    private final int arrayIndex;

    public FsValue(ValueMap props, String propertyName) {
        this.props = props;
        this.propertyName = propertyName;
        this.arrayIndex = -1;
    }

    public FsValue(ValueMap props, String propertyName, int arrayIndex) {
        this.props = props;
        this.propertyName = propertyName;
        this.arrayIndex = arrayIndex;
    }

    public String getString() throws ValueFormatException, IllegalStateException, RepositoryException {
        if (this.arrayIndex >= 0) {
            return ((String[])this.props.get(this.propertyName, String[].class))[this.arrayIndex];
        }
        return (String)this.props.get(this.propertyName, String.class);
    }

    public long getLong() throws ValueFormatException, RepositoryException {
        if (this.arrayIndex >= 0) {
            return ((Long[])this.props.get(this.propertyName, Long[].class))[this.arrayIndex];
        }
        return (Long)this.props.get(this.propertyName, (Object)0L);
    }

    public double getDouble() throws ValueFormatException, RepositoryException {
        if (this.arrayIndex >= 0) {
            return ((Double[])this.props.get(this.propertyName, Double[].class))[this.arrayIndex];
        }
        return (Double)this.props.get(this.propertyName, (Object)0.0);
    }

    public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
        if (this.arrayIndex >= 0) {
            return ((BigDecimal[])this.props.get(this.propertyName, BigDecimal[].class))[this.arrayIndex];
        }
        return (BigDecimal)this.props.get(this.propertyName, (Object)BigDecimal.ZERO);
    }

    public Calendar getDate() throws ValueFormatException, RepositoryException {
        if (this.arrayIndex >= 0) {
            return ((Calendar[])this.props.get(this.propertyName, Calendar[].class))[this.arrayIndex];
        }
        return (Calendar)this.props.get(this.propertyName, Calendar.class);
    }

    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        if (this.arrayIndex >= 0) {
            return ((Boolean[])this.props.get(this.propertyName, Boolean[].class))[this.arrayIndex];
        }
        return (Boolean)this.props.get(this.propertyName, (Object)false);
    }

    public int getType() {
        Object firstItem;
        Object value = this.props.get((Object)this.propertyName);
        if (value == null) {
            return 0;
        }
        Class<?> type = value.getClass();
        if (type.isArray() && Array.getLength(value) > 0 && (firstItem = Array.get(value, 0)) != null) {
            type = firstItem.getClass();
        }
        if (type == String.class) {
            return 1;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return 6;
        }
        if (type == BigDecimal.class) {
            return 12;
        }
        if (type == Double.class || type == Double.TYPE || type == Float.class || type == Float.TYPE) {
            return 4;
        }
        if (Number.class.isAssignableFrom(type)) {
            return 3;
        }
        if (type == Calendar.class) {
            return 5;
        }
        return 0;
    }

    public InputStream getStream() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Binary getBinary() throws RepositoryException {
        throw new UnsupportedOperationException();
    }
}

