/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.sling.adapter.annotations.Adaptable;
import org.apache.sling.adapter.annotations.Adapter;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.fsprovider.internal.mapper.valuemap.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Adaptable(adaptableClass=Resource.class, adapters={@Adapter(value={File.class, URL.class}), @Adapter(condition="If the resource is an FsResource and is a readable file.", value={InputStream.class})})
public final class FileResource
extends AbstractResource {
    static final String RESOURCE_TYPE_FILE = "nt:file";
    static final String RESOURCE_TYPE_FOLDER = "nt:folder";
    private final ResourceResolver resolver;
    private final String resourcePath;
    private final File file;
    private String resourceType;
    private ResourceMetadata metaData;
    private static final Logger log = LoggerFactory.getLogger(FileResource.class);

    FileResource(ResourceResolver resolver, String resourcePath, File file) {
        this.resolver = resolver;
        this.resourcePath = resourcePath;
        this.file = file;
    }

    public String getPath() {
        return this.resourcePath;
    }

    public ResourceMetadata getResourceMetadata() {
        if (this.metaData == null) {
            this.metaData = new ResourceMetadata();
            this.metaData.setContentLength(this.file.length());
            this.metaData.setModificationTime(this.file.lastModified());
            this.metaData.setResolutionPath(this.resourcePath);
            if (this.file.isDirectory()) {
                this.metaData.put(":org.apache.sling.fsprovider.file.directory", (Object)Boolean.TRUE);
            }
        }
        return this.metaData;
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public String getResourceSuperType() {
        return null;
    }

    public String getResourceType() {
        if (this.resourceType == null) {
            this.resourceType = this.file.isFile() ? RESOURCE_TYPE_FILE : RESOURCE_TYPE_FOLDER;
        }
        return this.resourceType;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == File.class) {
            return (AdapterType)this.file;
        }
        if (type == InputStream.class) {
            if (!this.file.isDirectory() && this.file.canRead()) {
                try {
                    return (AdapterType)new FileInputStream(this.file);
                }
                catch (IOException ioe) {
                    log.info("adaptTo: Cannot open a stream on the file " + this.file, (Throwable)ioe);
                }
            } else {
                log.debug("adaptTo: File {} is not a readable file", (Object)this.file);
            }
        } else if (type == URL.class) {
            try {
                return (AdapterType)this.file.toURI().toURL();
            }
            catch (MalformedURLException mue) {
                log.info("adaptTo: Cannot convert the file path " + this.file + " to an URL", (Throwable)mue);
            }
        } else if (type == ValueMap.class && this.file.exists() && this.file.canRead()) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("jcr:primaryType", this.getResourceType());
            props.put("jcr:createdBy", "system");
            Calendar lastModifed = Calendar.getInstance();
            lastModifed.setTimeInMillis(this.file.lastModified());
            props.put("jcr:created", lastModifed);
            return (AdapterType)new ValueMapDecorator(props);
        }
        return (AdapterType)super.adaptTo(type);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("path", (Object)this.resourcePath).append("file", (Object)this.file.getPath()).append("resourceType", (Object)this.getResourceType()).build();
    }
}

