/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.fsprovider.internal.ContentFileExtensions;
import org.apache.sling.fsprovider.internal.FsResourceMapper;
import org.apache.sling.fsprovider.internal.mapper.ContentFile;
import org.apache.sling.fsprovider.internal.mapper.ContentFileResource;
import org.apache.sling.fsprovider.internal.parser.ContentElement;
import org.apache.sling.fsprovider.internal.parser.ContentFileCache;

public final class ContentFileResourceMapper
implements FsResourceMapper {
    private final String providerRootPrefix;
    private final File providerFile;
    private final ContentFileExtensions contentFileExtensions;
    private final ContentFileCache contentFileCache;

    public ContentFileResourceMapper(String providerRoot, File providerFile, ContentFileExtensions contentFileExtensions, ContentFileCache contentFileCache) {
        this.providerRootPrefix = providerRoot.concat("/");
        this.providerFile = providerFile;
        this.contentFileExtensions = contentFileExtensions;
        this.contentFileCache = contentFileCache;
    }

    @Override
    public Resource getResource(ResourceResolver resolver, String resourcePath) {
        if (this.contentFileExtensions.isEmpty()) {
            return null;
        }
        ContentFile contentFile = this.getFile(resourcePath, null);
        if (contentFile != null && contentFile.hasContent()) {
            return new ContentFileResource(resolver, contentFile);
        }
        return null;
    }

    @Override
    public Iterator<Resource> getChildren(final ResourceResolver resolver, Resource parent) {
        if (this.contentFileExtensions.isEmpty()) {
            return null;
        }
        String parentPath = parent.getPath();
        ContentFile parentContentFile = (ContentFile)parent.adaptTo(ContentFile.class);
        if (parentContentFile == null && (parentContentFile = this.getFile(parentPath, null)) == null) {
            File parentFile = (File)parent.adaptTo(File.class);
            if (parentFile != null && parentFile.isDirectory()) {
                ArrayList<ContentFileResource> childResources = new ArrayList<ContentFileResource>();
                for (File file : parentFile.listFiles()) {
                    String filenameSuffix = this.contentFileExtensions.getSuffix(file);
                    if (filenameSuffix == null) continue;
                    String path = parentPath + "/" + StringUtils.substringBeforeLast((String)file.getName(), (String)filenameSuffix);
                    ContentFile contentFile = new ContentFile(file, path, null, this.contentFileCache);
                    childResources.add(new ContentFileResource(resolver, contentFile));
                }
                if (!childResources.isEmpty()) {
                    return childResources.iterator();
                }
            }
            return null;
        }
        ArrayList<ContentFile> children = new ArrayList<ContentFile>();
        if (parentContentFile.hasContent()) {
            Iterator<Map.Entry<String, ContentElement>> childMaps = parentContentFile.getChildren();
            while (childMaps.hasNext()) {
                Map.Entry<String, ContentElement> entry = childMaps.next();
                children.add(parentContentFile.navigateToRelative(entry.getKey()));
            }
        }
        if (children.isEmpty()) {
            return null;
        }
        return IteratorUtils.transformedIterator(children.iterator(), (Transformer)new Transformer(){

            public Object transform(Object input) {
                ContentFile contentFile = (ContentFile)input;
                return new ContentFileResource(resolver, contentFile);
            }
        });
    }

    private ContentFile getFile(String path, String subPath) {
        if (!StringUtils.startsWith((CharSequence)path, (CharSequence)this.providerRootPrefix)) {
            return null;
        }
        String relPath = path.substring(this.providerRootPrefix.length());
        for (String filenameSuffix : this.contentFileExtensions.getSuffixes()) {
            File file = new File(this.providerFile, relPath + filenameSuffix);
            if (!file.exists()) continue;
            return new ContentFile(file, path, subPath, this.contentFileCache);
        }
        String parentPath = ResourceUtil.getParent((String)path);
        String nextSubPath = path.substring(parentPath.length() + 1) + (subPath != null ? "/" + subPath : "");
        return this.getFile(parentPath, nextSubPath);
    }
}

