/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper;

import javax.jcr.Node;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.fsprovider.internal.mapper.ContentFile;
import org.apache.sling.fsprovider.internal.mapper.jcr.FsNode;

public final class ContentFileResource
extends AbstractResource {
    private final ResourceResolver resolver;
    private final String resourcePath;
    private final ContentFile contentFile;
    private String resourceType;
    private String resourceSuperType;
    private ResourceMetadata metaData;

    ContentFileResource(ResourceResolver resolver, ContentFile contentFile) {
        this.resolver = resolver;
        this.contentFile = contentFile;
        this.resourcePath = contentFile.getPath() + (contentFile.getSubPath() != null ? "/" + contentFile.getSubPath() : "");
    }

    public String getPath() {
        return this.resourcePath;
    }

    public ResourceMetadata getResourceMetadata() {
        if (this.metaData == null) {
            this.metaData = new ResourceMetadata();
            this.metaData.setModificationTime(this.contentFile.getFile().lastModified());
            this.metaData.setResolutionPath(this.resourcePath);
        }
        return this.metaData;
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public String getResourceSuperType() {
        if (this.resourceSuperType == null) {
            this.resourceSuperType = (String)this.getValueMap().get("sling:resourceSuperType", String.class);
        }
        return this.resourceSuperType;
    }

    public String getResourceType() {
        if (this.resourceType == null) {
            ValueMap props = this.getValueMap();
            this.resourceType = (String)props.get("sling:resourceType", String.class);
            if (this.resourceType == null) {
                this.resourceType = (String)props.get("jcr:primaryType", String.class);
            }
        }
        return this.resourceType;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ContentFile.class) {
            return (AdapterType)this.contentFile;
        }
        if (type == ValueMap.class) {
            return (AdapterType)this.contentFile.getValueMap();
        }
        if (type == Node.class) {
            return (AdapterType)new FsNode(this.contentFile, this.getResourceResolver());
        }
        return (AdapterType)super.adaptTo(type);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("path", (Object)this.resourcePath).append("file", (Object)this.contentFile.getFile().getPath()).append("subPath", (Object)this.contentFile.getSubPath()).append("resourceType", (Object)this.getResourceType()).build();
    }
}

