/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.fsprovider.internal.mapper.valuemap.ValueMapUtil;
import org.apache.sling.fsprovider.internal.parser.ContentElement;
import org.apache.sling.fsprovider.internal.parser.ContentFileCache;

public final class ContentFile {
    private final File file;
    private final String path;
    private final String subPath;
    private final ContentFileCache contentFileCache;
    private boolean contentInitialized;
    private ContentElement content;
    private ValueMap valueMap;

    public ContentFile(File file, String path, String subPath, ContentFileCache contentFileCache) {
        this.file = file;
        this.path = path;
        this.subPath = subPath;
        this.contentFileCache = contentFileCache;
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    public String getSubPath() {
        return this.subPath;
    }

    public ContentElement getContent() {
        if (!this.contentInitialized) {
            ContentElement rootContent = this.contentFileCache.get(this.path, this.file);
            this.content = this.subPath == null ? rootContent : rootContent.getChild(this.subPath);
            this.contentInitialized = true;
        }
        return this.content;
    }

    public boolean hasContent() {
        return this.getContent() != null;
    }

    public ValueMap getValueMap() {
        if (this.valueMap == null) {
            ContentElement currentContent = this.getContent();
            this.valueMap = currentContent != null ? ValueMapUtil.toValueMap(currentContent.getProperties()) : ValueMap.EMPTY;
        }
        return this.valueMap;
    }

    public Iterator<Map.Entry<String, ContentElement>> getChildren() {
        return this.getContent().getChildren().entrySet().iterator();
    }

    public ContentFile navigateToAbsolute(String newSubPath) {
        return new ContentFile(this.file, this.path, newSubPath, this.contentFileCache);
    }

    public ContentFile navigateToRelative(String newSubPath) {
        String absoluteSubPath = newSubPath == null ? this.subPath : (this.subPath != null ? this.subPath + "/" : "") + newSubPath;
        return new ContentFile(this.file, this.path, absoluteSubPath, this.contentFileCache);
    }
}

