/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class ContentFileExtensions {
    private final List<String> contentFileSuffixes;

    public ContentFileExtensions(List<String> contentFileSuffixes) {
        this.contentFileSuffixes = contentFileSuffixes;
    }

    public String getSuffix(File file) {
        String fileName = "/" + file.getName();
        for (String suffix : this.contentFileSuffixes) {
            if (!StringUtils.endsWith((CharSequence)fileName, (CharSequence)suffix)) continue;
            return suffix;
        }
        return null;
    }

    public boolean matchesSuffix(File file) {
        return this.getSuffix(file) != null;
    }

    public Collection<String> getSuffixes() {
        return this.contentFileSuffixes;
    }

    public boolean isEmpty() {
        return this.contentFileSuffixes.isEmpty();
    }
}

