/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config.validation;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationDescription;
import org.apache.sling.feature.extension.apiregions.api.config.DescribableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.FactoryConfigurationDescription;
import org.apache.sling.feature.extension.apiregions.api.config.Mode;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyDescription;
import org.apache.sling.feature.extension.apiregions.api.config.Region;
import org.apache.sling.feature.extension.apiregions.api.config.validation.ConfigurationValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.FeatureValidator;
import org.apache.sling.feature.extension.apiregions.api.config.validation.PropertyValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.PropertyValidator;

public class ConfigurationValidator {
    public static final List<String> ALLOWED_PROPERTIES = Arrays.asList("service.description", "service.vendor", "service.ranking");
    private final PropertyValidator propertyValidator = new PropertyValidator();
    private boolean liveValues = false;
    private Map<ArtifactId, Region> cache = new HashMap<ArtifactId, Region>();

    public boolean isLiveValues() {
        return this.liveValues;
    }

    public void setLiveValues(boolean value) {
        this.liveValues = value;
        this.propertyValidator.setLiveValues(value);
    }

    public ConfigurationValidationResult validate(Configuration config, ConfigurableEntity desc, Region region) {
        return this.validate(config, desc, region, Mode.STRICT);
    }

    public ConfigurationValidationResult validate(Configuration config, ConfigurableEntity desc, Region region, Mode mode) {
        Mode validationMode = desc.getMode() != null ? desc.getMode() : (mode != null ? mode : Mode.STRICT);
        ConfigurationValidationResult result = new ConfigurationValidationResult();
        if (config.isFactoryConfiguration()) {
            if (!(desc instanceof FactoryConfigurationDescription)) {
                result.getErrors().add("Factory configuration cannot be validated against non factory configuration description");
            } else if (desc.getPropertyDescriptions().isEmpty()) {
                if (region == Region.GLOBAL && !desc.isAllowAdditionalProperties()) {
                    ConfigurationValidator.setResult(result, validationMode, desc, "Factory configuration is not allowed");
                }
            } else if (region == Region.GLOBAL && desc.getRegion() == Region.INTERNAL) {
                ConfigurationValidator.setResult(result, validationMode, desc, "Factory configuration is not allowed");
            } else {
                this.validateProperties(config, desc, result.getPropertyResults(), region, validationMode);
            }
        } else if (!(desc instanceof ConfigurationDescription)) {
            result.getErrors().add("Configuration cannot be validated against factory configuration description");
        } else if (desc.getPropertyDescriptions().isEmpty()) {
            if (region == Region.GLOBAL && !desc.isAllowAdditionalProperties()) {
                ConfigurationValidator.setResult(result, validationMode, desc, "Configuration is not allowed");
            }
        } else if (region == Region.GLOBAL && desc.getRegion() == Region.INTERNAL) {
            ConfigurationValidator.setResult(result, validationMode, desc, "Configuration is not allowed");
        } else {
            this.validateProperties(config, desc, result.getPropertyResults(), region, validationMode);
        }
        if (desc.getDeprecated() != null) {
            ConfigurationValidator.setResult(result, Mode.LENIENT, desc, desc.getDeprecated());
        }
        return result;
    }

    void validateProperties(Configuration configuration, ConfigurableEntity desc, Map<String, PropertyValidationResult> results, Region region, Mode mode) {
        PropertyValidationResult result;
        Dictionary properties = configuration.getConfigurationProperties();
        for (Map.Entry<String, PropertyDescription> propEntry : desc.getPropertyDescriptions().entrySet()) {
            Object value = properties.get(propEntry.getKey());
            result = this.propertyValidator.validate(value, propEntry.getValue(), mode);
            results.put(propEntry.getKey(), result);
        }
        Enumeration keyEnum = properties.keys();
        while (keyEnum.hasMoreElements()) {
            String propName = (String)keyEnum.nextElement();
            if (desc.getPropertyDescriptions().containsKey(propName)) continue;
            Region propRegion = FeatureValidator.getRegionInfo(region, configuration, propName, this.cache);
            result = new PropertyValidationResult();
            results.put(propName, result);
            if (desc.getInternalPropertyNames().contains(propName)) {
                if (propRegion == Region.INTERNAL) continue;
                PropertyValidator.setResult(result, null, mode, desc, "Property is not allowed");
                continue;
            }
            if ("service.ranking".equalsIgnoreCase(propName)) {
                Object value = properties.get(propName);
                if (value instanceof Integer) continue;
                PropertyValidator.setResult(result, 0, mode, desc, "service.ranking must be of type Integer");
                continue;
            }
            if (this.isAllowedProperty(propName) || propRegion == Region.INTERNAL || desc.isAllowAdditionalProperties()) continue;
            PropertyValidator.setResult(result, null, mode, desc, "Property is not allowed");
        }
    }

    static void setResult(ConfigurationValidationResult result, Mode validationMode, DescribableEntity desc, String msg) {
        String postfixMsg = "";
        if (desc != null && desc.getSince() != null) {
            postfixMsg = postfixMsg.concat(". Since : ").concat(desc.getSince());
        }
        if (desc != null && desc.getEnforceOn() != null) {
            postfixMsg = postfixMsg.concat(". Enforced on : ").concat(desc.getEnforceOn());
        }
        String finalMsg = msg + postfixMsg;
        if (validationMode == Mode.STRICT) {
            result.getErrors().add(finalMsg);
        } else if (validationMode == Mode.LENIENT || validationMode == Mode.DEFINITIVE) {
            result.getWarnings().add(finalMsg);
        }
        if (validationMode == Mode.DEFINITIVE || validationMode == Mode.SILENT_DEFINITIVE) {
            result.setUseDefaultValue(true);
        }
    }

    private boolean isAllowedProperty(String name) {
        for (String allowed : ALLOWED_PROPERTIES) {
            if (!allowed.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    void setCache(Map<ArtifactId, Region> cache) {
        this.cache = cache;
    }
}

