/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.extension.apiregions.api.DeprecationInfo;

public class JDKDeprecationExtension {
    private static final String MSG_KEY = "msg";
    private static final String SINCE_KEY = "since";
    public static final String EXTENSION_NAME = "jdk-deprecation";
    private final Map<String, DeprecationInfo> memberInfos = new LinkedHashMap<String, DeprecationInfo>();

    public static JDKDeprecationExtension getExtension(Feature feature) {
        Extension ext = feature == null ? null : feature.getExtensions().getByName(EXTENSION_NAME);
        return JDKDeprecationExtension.getExtension(ext);
    }

    public static JDKDeprecationExtension getExtension(Extension ext) {
        if (ext == null) {
            return null;
        }
        if (ext.getType() != ExtensionType.JSON) {
            throw new IllegalArgumentException("Extension " + ext.getName() + " must have JSON type");
        }
        return new JDKDeprecationExtension(ext.getJSONStructure());
    }

    private JDKDeprecationExtension(JsonStructure structure) {
        for (Map.Entry prop : structure.asJsonObject().entrySet()) {
            if (((JsonValue)prop.getValue()).getValueType() == JsonValue.ValueType.STRING) {
                DeprecationInfo info = new DeprecationInfo(((JsonString)prop.getValue()).getString());
                this.addMemberInfo((String)prop.getKey(), info);
                continue;
            }
            if (((JsonValue)prop.getValue()).getValueType() == JsonValue.ValueType.OBJECT) {
                JsonObject memberObj = ((JsonValue)prop.getValue()).asJsonObject();
                if (!memberObj.containsKey((Object)MSG_KEY)) {
                    throw new IllegalArgumentException("No msg property found");
                }
                DeprecationInfo info = new DeprecationInfo(memberObj.getString(MSG_KEY));
                info.setSince(memberObj.getString(SINCE_KEY, null));
                this.addMemberInfo((String)prop.getKey(), info);
                continue;
            }
            throw new IllegalArgumentException("Wrong value type " + ((JsonValue)prop.getValue()).getValueType().name());
        }
    }

    public void addMemberInfo(String member, DeprecationInfo i) {
        this.memberInfos.put(member, i);
    }

    public void removeMemberInfo(String member) {
        this.memberInfos.remove(member);
    }

    public Map<String, DeprecationInfo> getMemberInfos() {
        return this.memberInfos;
    }

    public JsonObject toJSON() {
        JsonObjectBuilder membersBuilder = Json.createObjectBuilder();
        for (Map.Entry<String, DeprecationInfo> memberEntry : this.getMemberInfos().entrySet()) {
            if (memberEntry.getValue().getSince() == null) {
                membersBuilder.add(memberEntry.getKey(), memberEntry.getValue().getMessage());
                continue;
            }
            JsonObjectBuilder mBuilder = Json.createObjectBuilder();
            mBuilder.add(MSG_KEY, memberEntry.getValue().getMessage());
            mBuilder.add(SINCE_KEY, memberEntry.getValue().getSince());
            membersBuilder.add(memberEntry.getKey(), mBuilder);
        }
        return membersBuilder.build();
    }

    public int hashCode() {
        return Objects.hash(this.memberInfos);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDKDeprecationExtension other = (JDKDeprecationExtension)obj;
        return Objects.equals(this.memberInfos, other.memberInfos);
    }
}

