/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.event.EndEvent;
import ch.qos.logback.core.joran.event.InPlayListener;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.JoranException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sling.commons.log.logback.internal.ConfigSourceTracker;
import org.apache.sling.commons.log.logback.internal.LogbackManager;
import org.apache.sling.commons.log.logback.internal.OsgiAppenderRefInternalAction;
import org.apache.sling.commons.log.logback.internal.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;

public class OsgiInternalAction
extends Action {
    private static final String INCLUDED_TAG = "included";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(InterpretationContext ec, String name, Attributes attributes) throws ActionException {
        ec.addInPlayListener((InPlayListener)new ConfigCompleteListener(ec));
        this.populateSubstitutionProperties(ec);
        Collection<ConfigSourceTracker.ConfigSourceInfo> providers = this.getFragmentProviders();
        ArrayList consolidatedEventList = new ArrayList();
        for (ConfigSourceTracker.ConfigSourceInfo cp : providers) {
            InputSource is = cp.getConfigProvider().getConfigSource();
            try {
                SaxEventRecorder recorder = new SaxEventRecorder(this.context);
                recorder.recordEvents(is);
                OsgiInternalAction.trimHeadAndTail(recorder);
                consolidatedEventList.addAll(recorder.getSaxEventList());
            }
            catch (JoranException e) {
                this.addError("Error while parsing xml obtained from  [" + cp + "]", e);
            }
            finally {
                Util.close(is);
            }
        }
        ec.getJoranInterpreter().getEventPlayer().addEventsDynamically(consolidatedEventList, 2);
    }

    private void populateSubstitutionProperties(InterpretationContext ec) {
        this.getLogbackManager().addSubsitutionProperties(ec);
    }

    public void end(InterpretationContext ec, String name) throws ActionException {
    }

    private Collection<ConfigSourceTracker.ConfigSourceInfo> getFragmentProviders() {
        ConfigSourceTracker tracker = (ConfigSourceTracker)this.getContext().getObject(ConfigSourceTracker.class.getName());
        if (tracker != null) {
            return tracker.getSources();
        }
        return Collections.emptyList();
    }

    private LogbackManager getLogbackManager() {
        LogbackManager lm = (LogbackManager)((Object)this.getContext().getObject(LogbackManager.class.getName()));
        if (lm == null) {
            throw new IllegalStateException("LogbackManager not found in Context map");
        }
        return lm;
    }

    private static void trimHeadAndTail(SaxEventRecorder recorder) {
        SaxEvent last;
        List saxEventList = recorder.saxEventList;
        if (saxEventList.size() == 0) {
            return;
        }
        SaxEvent first = (SaxEvent)saxEventList.get(0);
        if (first != null && first.qName.equalsIgnoreCase(INCLUDED_TAG)) {
            saxEventList.remove(0);
        }
        if ((last = (SaxEvent)saxEventList.get(recorder.saxEventList.size() - 1)) != null && last.qName.equalsIgnoreCase(INCLUDED_TAG)) {
            saxEventList.remove(recorder.saxEventList.size() - 1);
        }
    }

    private class ConfigCompleteListener
    implements InPlayListener {
        private static final String CONFIG_TAG = "configuration";
        private final String[] OBJECT_NAMES = new String[]{"APPENDER_BAG", OsgiAppenderRefInternalAction.OSGI_APPENDER_REF_BAG};
        private final InterpretationContext ic;

        public ConfigCompleteListener(InterpretationContext ec) {
            this.ic = ec;
        }

        public void inPlay(SaxEvent event) {
            if (event instanceof EndEvent && event.qName.equalsIgnoreCase(CONFIG_TAG)) {
                this.transferObjectsToContext();
                OsgiInternalAction.this.getLogbackManager().fireResetCompleteListeners();
                this.removeTransferredObjects();
            }
        }

        private void transferObjectsToContext() {
            for (String name : this.OBJECT_NAMES) {
                OsgiInternalAction.this.getContext().putObject(name, this.ic.getObjectMap().get(name));
            }
        }

        private void removeTransferredObjects() {
            for (String name : this.OBJECT_NAMES) {
                OsgiInternalAction.this.getContext().putObject(name, null);
            }
        }
    }
}

