/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.core.Context;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.commons.log.logback.internal.LogWriter;

public class LogConfig {
    private static final String[] LEGACY_MARKERS = new String[]{"{0}", "{1}", "{2}", "{3}", "{4}", "{5}"};
    private final String configPid;
    private final Set<String> categories;
    private final Level logLevel;
    private final String pattern;
    private final String logWriterName;
    private final LogWriterProvider logWriterProvider;
    private final LoggerContext loggerContext;
    private final boolean isAdditiv;

    LogConfig(LogWriterProvider logWriterProvider, String pattern, Set<String> categories, Level logLevel, String logWriterName, boolean isAdditiv, String configPid, LoggerContext loggerContext) {
        this.logWriterProvider = logWriterProvider;
        this.configPid = configPid;
        this.pattern = pattern;
        this.categories = Collections.unmodifiableSet(categories);
        this.logLevel = logLevel;
        this.logWriterName = logWriterName;
        this.loggerContext = loggerContext;
        this.isAdditiv = isAdditiv;
    }

    public String getConfigPid() {
        return this.configPid;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public String getLogWriterName() {
        return this.logWriterName;
    }

    public boolean isAppenderDefined() {
        return this.logWriterName != null;
    }

    public boolean isAdditive() {
        return this.isAdditiv;
    }

    public LogWriter getLogWriter() {
        return this.logWriterProvider.getLogWriter(this.getLogWriterName());
    }

    public PatternLayout createLayout() {
        Pattern date = Pattern.compile("\\{0,date,(.+?)\\}");
        Matcher m = date.matcher(this.pattern);
        String logBackPattern = this.pattern;
        if (m.matches()) {
            logBackPattern = m.replaceAll("%d'{'$1'}'");
        }
        boolean legacyPattern = false;
        for (String marker : LEGACY_MARKERS) {
            if (!logBackPattern.contains(marker)) continue;
            legacyPattern = true;
            break;
        }
        if (legacyPattern) {
            logBackPattern = MessageFormat.format(logBackPattern, "zero", "%marker", "%thread", "%logger", "%level", "%message") + "%n";
        }
        PatternLayout pl = new PatternLayout();
        pl.setPattern(logBackPattern);
        pl.setOutputPatternAsHeader(false);
        pl.setContext((Context)this.loggerContext);
        pl.start();
        return pl;
    }

    public String toString() {
        return "LogConfig{configPid='" + this.configPid + '\'' + ", categories=" + this.categories + ", logLevel=" + this.logLevel + ", logWriterName='" + this.logWriterName + '\'' + '}';
    }

    public static interface LogWriterProvider {
        public LogWriter getLogWriter(String var1);
    }
}

