/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.resource.impl.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.iterators.CollatingIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.caconfig.resource.spi.ContextResource;

public class ResourcePathCollatingIterator
extends CollatingIterator {
    private static Comparator<ContextResource> PATH_LENGTH_COMPARATOR = new Comparator<ContextResource>(){

        @Override
        public int compare(ContextResource o1, ContextResource o2) {
            Integer length1 = o1.getResource().getPath().length();
            Integer length2 = o2.getResource().getPath().length();
            int result = length2.compareTo(length1);
            if (result == 0) {
                Integer ranking1 = o1.getServiceRanking();
                Integer ranking2 = o2.getServiceRanking();
                result = ranking2.compareTo(ranking1);
                if (result == 0) {
                    result = StringUtils.defaultString((String)o1.getConfigRef()).compareTo(StringUtils.defaultString((String)o2.getConfigRef()));
                }
            }
            return result;
        }
    };

    public ResourcePathCollatingIterator(List<Iterator<ContextResource>> iterator) {
        super(PATH_LENGTH_COMPARATOR, iterator);
    }
}

