/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.management.impl.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.caconfig.management.ConfigurationData;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.management.ValueInfo;
import org.apache.sling.caconfig.management.multiplexer.ContextPathStrategyMultiplexer;
import org.apache.sling.caconfig.resource.spi.ContextResource;
import org.apache.sling.xss.XSSAPI;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.description=Apache Sling Context-Aware Configuration Web Console Plugin", "felix.webconsole.label=slingcaconfig", "felix.webconsole.title=Context-Aware Configuration", "felix.webconsole.category=Sling"})
public class ConfigurationWebConsolePlugin
extends AbstractWebConsolePlugin {
    public static final String LABEL = "slingcaconfig";
    public static final String TITLE = "Context-Aware Configuration";
    private static final Logger log = LoggerFactory.getLogger(ConfigurationWebConsolePlugin.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ResourceResolverFactory resolverFactory;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ConfigurationManager configurationManager;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ContextPathStrategyMultiplexer contextPathStrategyMultiplexer;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private XSSAPI xss;

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return TITLE;
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        this.info(pw, "Configurations are managed in the resource tree. Use this tool to test configuration resolutions.");
        pw.println("<br/>");
        this.printResolutionTestTool(request, pw);
    }

    private String getParameter(HttpServletRequest request, String name, String defaultValue) {
        String value = request.getParameter(name);
        if (value != null && !value.trim().isEmpty()) {
            return value.trim();
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printResolutionTestTool(HttpServletRequest request, PrintWriter pw) {
        String path = this.getParameter(request, "path", "/content");
        String configNameOther = this.getParameter(request, "configNameOther", null);
        String configName = this.getParameter(request, "configName", null);
        if (configName == null) {
            configName = configNameOther;
        } else {
            configNameOther = null;
        }
        boolean resourceCollection = BooleanUtils.toBoolean((String)this.getParameter(request, "resourceCollection", "false"));
        try (ResourceResolver resolver = null;){
            Resource contentResource = null;
            if (path != null && (resolver = this.getResolver(request)) != null) {
                contentResource = resolver.getResource(path);
            }
            pw.println("<form method='get'>");
            this.tableStart(pw, "Test Configuration Resolution", 2);
            String alertMessage = null;
            if (path != null) {
                if (resolver == null) {
                    alertMessage = "Unable to access repository - please check system configuration.";
                } else if (contentResource == null) {
                    alertMessage = "Path does not exist.";
                }
            }
            this.textField(pw, "Content Path", "path", path, alertMessage);
            this.tableRows(pw);
            this.selectField(pw, "Config Name", "configName", configName, this.configurationManager.getConfigurationNames());
            this.tableRows(pw);
            this.textField(pw, "Other Config Name", "configNameOther", configNameOther, new String[0]);
            this.tableRows(pw);
            this.checkboxField(pw, "Resource collection", "resourceCollection", resourceCollection);
            this.tableRows(pw);
            pw.println("<td></td>");
            pw.println("<td><input type='submit' value='Resolve'/></td>");
            this.tableEnd(pw);
            pw.println("</form>");
            pw.println("<br/>");
            if (contentResource != null && configName != null) {
                ConfigurationData configData;
                Iterator contextResources = this.contextPathStrategyMultiplexer.findContextResources(contentResource);
                this.tableStart(pw, "Context paths", 3);
                pw.println("<th>Context path</th>");
                pw.println("<th>Config reference</th>");
                pw.println("<th>Ranking</th>");
                while (contextResources.hasNext()) {
                    ContextResource contextResource = (ContextResource)contextResources.next();
                    this.tableRows(pw);
                    pw.println("<td>" + this.xss.encodeForHTML(contextResource.getResource().getPath()) + "</td>");
                    pw.println("<td>" + this.xss.encodeForHTML(contextResource.getConfigRef()) + "</td>");
                    pw.println("<td>" + contextResource.getServiceRanking() + "</td>");
                }
                this.tableEnd(pw);
                pw.println("<br/>");
                Collection<ConfigurationData> configDatas = resourceCollection ? this.configurationManager.getConfigurationCollection(contentResource, configName).getItems() : ((configData = this.configurationManager.getConfiguration(contentResource, configName)) != null ? Collections.singletonList(configData) : Collections.emptyList());
                this.tableStart(pw, "Result", 6);
                if (configDatas.size() == 0) {
                    pw.println("<td colspan='6'>");
                    this.alertDiv(pw, "No matching item found.");
                    pw.println("<br/>&nbsp;</td>");
                } else {
                    pw.println("<th>Property</th>");
                    pw.println("<th>Effective Value</th>");
                    pw.println("<th>Value</th>");
                    pw.println("<th>Default</th>");
                    pw.println("<th>Inherited</th>");
                    pw.println("<th>Overwritten</th>");
                    for (ConfigurationData data : configDatas) {
                        this.tableRows(pw);
                        pw.println("<td colspan='6' style='background-color:#f3f3f3'>");
                        pw.print("Path: " + this.xss.encodeForHTML(data.getResourcePath()));
                        pw.println("</td>");
                        for (String propertyName : data.getPropertyNames()) {
                            ValueInfo<?> valueInfo = data.getValueInfo(propertyName);
                            this.tableRows(pw);
                            this.td(pw, propertyName, new String[0]);
                            this.td(pw, valueInfo.getEffectiveValue(), new String[0]);
                            this.td(pw, valueInfo.getValue(), new String[0]);
                            this.td(pw, valueInfo.isDefault(), new String[0]);
                            String title = null;
                            if (valueInfo.isInherited()) {
                                title = "Source path: " + valueInfo.getConfigSourcePath();
                            }
                            this.td(pw, valueInfo.isInherited(), title);
                            this.td(pw, valueInfo.isOverridden(), new String[0]);
                        }
                    }
                }
                this.tableEnd(pw);
            }
        }
    }

    private void info(PrintWriter pw, String text) {
        pw.print("<p class='statline ui-state-highlight'>");
        pw.print(this.xss.encodeForHTML(text));
        pw.println("</p>");
    }

    private void tableStart(PrintWriter pw, String title, int colspan) {
        pw.println("<table class='nicetable ui-widget'>");
        pw.println("<thead class='ui-widget-header'>");
        pw.println("<tr>");
        pw.print("<th colspan=");
        pw.print(String.valueOf(colspan));
        pw.print(">");
        pw.print(this.xss.encodeForHTML(title));
        pw.println("</th>");
        pw.println("</tr>");
        pw.println("</thead>");
        pw.println("<tbody class='ui-widget-content'>");
        pw.println("<tr>");
    }

    private void tableEnd(PrintWriter pw) {
        pw.println("</tr>");
        pw.println("</tbody>");
        pw.println("</table>");
    }

    private void tableRows(PrintWriter pw) {
        pw.println("</tr>");
        pw.println("<tr>");
    }

    private void textField(PrintWriter pw, String label, String fieldName, String value, String ... alertMessages) {
        pw.print("<td style='width:20%'>");
        pw.print(this.xss.encodeForHTMLAttr(label));
        pw.println("</td>");
        pw.print("<td><input name='");
        pw.print(this.xss.encodeForHTMLAttr(fieldName));
        pw.print("' value='");
        pw.print(this.xss.encodeForHTMLAttr(StringUtils.defaultString((String)value)));
        pw.print("' style='width:100%'/>");
        for (String alertMessage : alertMessages) {
            this.alertDiv(pw, alertMessage);
        }
        pw.println("</td>");
    }

    private void selectField(PrintWriter pw, String label, String fieldName, String value, Collection<String> options) {
        pw.print("<td style='width:20%'>");
        pw.print(this.xss.encodeForHTMLAttr(label));
        pw.println("</td>");
        pw.print("<td><select name='");
        pw.print(this.xss.encodeForHTMLAttr(fieldName));
        pw.print("' style='width:100%'>");
        pw.print("<option value=''>(please select)</option>");
        for (String option : options) {
            pw.print("<option");
            if (StringUtils.equals((CharSequence)option, (CharSequence)value)) {
                pw.print(" selected");
            }
            pw.print(">");
            pw.print(this.xss.encodeForHTMLAttr(option));
            pw.print("</option>");
        }
        pw.print("</select>");
        pw.println("</td>");
    }

    private void checkboxField(PrintWriter pw, String label, String fieldName, boolean checked) {
        pw.print("<td style='width:20%'>");
        pw.print(this.xss.encodeForHTMLAttr(label));
        pw.println("</td>");
        pw.print("<td><input type='checkbox' name='");
        pw.print(this.xss.encodeForHTMLAttr(fieldName));
        pw.print("' value='true'");
        if (checked) {
            pw.print(" checked");
        }
        pw.print("/></td>");
    }

    private void alertDiv(PrintWriter pw, String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return;
        }
        pw.println("<div>");
        pw.println("<span class='ui-icon ui-icon-alert' style='float:left'></span>");
        pw.print("<span style='float:left'>");
        pw.print(this.xss.encodeForHTML(text));
        pw.println("</span>");
        pw.println("</div>");
    }

    private void td(PrintWriter pw, Object value, String ... title) {
        pw.print("<td");
        if (title.length > 0 && !StringUtils.isBlank((CharSequence)title[0])) {
            pw.print(" title='");
            pw.print(this.xss.encodeForHTML(title[0]));
            pw.print("'");
        }
        pw.print(">");
        if (value != null) {
            if (value.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object itemValue = Array.get(value, i);
                    pw.print(this.xss.encodeForHTML(ObjectUtils.defaultIfNull((Object)itemValue, (Object)"").toString()));
                    pw.println("<br>");
                }
            } else {
                pw.print(this.xss.encodeForHTML(value.toString()));
            }
        }
        if (title.length > 0 && !StringUtils.isBlank((CharSequence)title[0])) {
            pw.print("<span class='ui-icon ui-icon-info' style='float:left'></span>");
        }
        pw.print("</td>");
    }

    private ResourceResolver getResolver(HttpServletRequest request) {
        ResourceResolver resolver = null;
        try {
            resolver = this.resolverFactory.getServiceResourceResolver(null);
        }
        catch (LoginException ex) {
            resolver = (ResourceResolver)request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
            if (resolver == null) {
                log.warn("Unable to get resource resolver - please ensure a system user is configured: {}", (Object)ex.getMessage());
            }
            log.debug("No system user configured, use resource resolver from web console.");
        }
        return resolver;
    }
}

