/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.management.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.management.ValueInfo;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationOverrideMultiplexer;
import org.apache.sling.caconfig.spi.metadata.PropertyMetadata;

final class ValueInfoImpl<T>
implements ValueInfo<T> {
    private final String name;
    private final T value;
    private final T effectiveValue;
    private final T defaultValue;
    private final PropertyMetadata<T> propertyMetadata;
    private final Resource resolvedConfigurationResource;
    private final Resource writebackConfigurationResource;
    private final List<Resource> configurationResourceInheritanceChain;
    private final Resource contextResource;
    private final String configName;
    private final ConfigurationOverrideMultiplexer configurationOverrideMultiplexer;
    private final boolean isAllOverridden;

    public ValueInfoImpl(String name, T value, T effectiveValue, PropertyMetadata<T> propertyMetadata, Resource resolvedConfigurationResource, Resource writebackConfigurationResource, List<Resource> configurationResourceInheritanceChain, Resource contextResource, String configName, ConfigurationOverrideMultiplexer configurationOverrideMultiplexer, boolean isAllOverridden) {
        this.name = name;
        this.value = value;
        this.effectiveValue = effectiveValue;
        this.defaultValue = propertyMetadata != null ? propertyMetadata.getDefaultValue() : null;
        this.propertyMetadata = propertyMetadata;
        this.resolvedConfigurationResource = resolvedConfigurationResource;
        this.writebackConfigurationResource = writebackConfigurationResource;
        this.configurationResourceInheritanceChain = configurationResourceInheritanceChain;
        this.contextResource = contextResource;
        this.configName = configName;
        this.configurationOverrideMultiplexer = configurationOverrideMultiplexer;
        this.isAllOverridden = isAllOverridden;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PropertyMetadata<T> getPropertyMetadata() {
        return this.propertyMetadata;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public T getEffectiveValue() {
        return this.effectiveValue;
    }

    @Override
    public String getConfigSourcePath() {
        Resource resource;
        if (this.effectiveValue != null && this.resolvedConfigurationResource != null && (resource = this.getResourceFromInheritanceChain()) != null) {
            return resource.getPath();
        }
        return null;
    }

    @Override
    public boolean isDefault() {
        if (this.defaultValue == null) {
            return false;
        }
        if (this.resolvedConfigurationResource == null) {
            return true;
        }
        return !this.resolvedConfigurationResource.getValueMap().containsKey((Object)this.name);
    }

    @Override
    public boolean isInherited() {
        if (this.isDefault() || this.effectiveValue == null) {
            return false;
        }
        if (this.resolvedConfigurationResource == null || this.resolvedConfigurationResource.getPath() == null) {
            return false;
        }
        if (this.writebackConfigurationResource == null) {
            return true;
        }
        if (!StringUtils.equals((CharSequence)this.resolvedConfigurationResource.getPath(), (CharSequence)this.writebackConfigurationResource.getPath())) {
            return true;
        }
        Resource inheritanceSource = this.getResourceFromInheritanceChain();
        if (inheritanceSource != null) {
            return !StringUtils.equals((CharSequence)this.resolvedConfigurationResource.getPath(), (CharSequence)inheritanceSource.getPath());
        }
        return false;
    }

    private Resource getResourceFromInheritanceChain() {
        if (this.configurationResourceInheritanceChain == null) {
            return null;
        }
        return this.getResourceFromInheritanceChain(this.configurationResourceInheritanceChain.iterator());
    }

    private Resource getResourceFromInheritanceChain(Iterator<Resource> inheritanceChain) {
        if (!inheritanceChain.hasNext()) {
            return null;
        }
        Resource resource = inheritanceChain.next();
        Object valueFromResource = resource.getValueMap().get(this.name, this.effectiveValue.getClass());
        if (valueFromResource != null) {
            return resource;
        }
        return this.getResourceFromInheritanceChain(inheritanceChain);
    }

    @Override
    public boolean isOverridden() {
        if (this.contextResource == null) {
            return false;
        }
        if (this.isAllOverridden) {
            return true;
        }
        Map<String, Object> overrideProperties = this.configurationOverrideMultiplexer.overrideProperties(this.contextResource.getPath(), this.configName, Collections.emptyMap());
        if (overrideProperties != null) {
            return overrideProperties.containsKey(this.name) || this.getValue() != null && this.effectiveValue == null;
        }
        return false;
    }
}

