/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.management.impl;

import caconfigimpl.org.apache.sling.commons.osgi.Order;
import caconfigimpl.org.apache.sling.commons.osgi.RankedServices;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.management.ContextPathStrategyMultiplexer;
import org.apache.sling.caconfig.resource.impl.util.ResourceEliminateDuplicatesIterator;
import org.apache.sling.caconfig.resource.impl.util.ResourcePathCollatingIterator;
import org.apache.sling.caconfig.resource.spi.ContextPathStrategy;
import org.apache.sling.caconfig.resource.spi.ContextResource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={org.apache.sling.caconfig.management.multiplexer.ContextPathStrategyMultiplexer.class, ContextPathStrategyMultiplexer.class}, reference={@Reference(name="contextPathStrategy", service=ContextPathStrategy.class, bind="bindContextPathStrategy", unbind="unbindContextPathStrategy", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)})
public class ContextPathStrategyMultiplexerImpl
implements org.apache.sling.caconfig.management.multiplexer.ContextPathStrategyMultiplexer,
ContextPathStrategyMultiplexer {
    private RankedServices<ContextPathStrategy> items = new RankedServices(Order.DESCENDING);

    protected void bindContextPathStrategy(ContextPathStrategy contextPathStrategy, Map<String, Object> props) {
        this.items.bind(contextPathStrategy, props);
    }

    protected void unbindContextPathStrategy(ContextPathStrategy contextPathStrategy, Map<String, Object> props) {
        this.items.unbind(contextPathStrategy, props);
    }

    public Iterator<ContextResource> findContextResources(Resource resource) {
        List<Iterator<ContextResource>> allResults = this.getAllResults(resource);
        if (allResults.isEmpty()) {
            return Collections.emptyIterator();
        }
        if (allResults.size() == 1) {
            return allResults.get(0);
        }
        return this.mergeResults(allResults);
    }

    private List<Iterator<ContextResource>> getAllResults(Resource resource) {
        ArrayList<Iterator<ContextResource>> results = new ArrayList<Iterator<ContextResource>>();
        for (ContextPathStrategy item : this.items) {
            Iterator result = item.findContextResources(resource);
            if (!result.hasNext()) continue;
            results.add(result);
        }
        return results;
    }

    private Iterator<ContextResource> mergeResults(List<Iterator<ContextResource>> allResults) {
        return new ResourceEliminateDuplicatesIterator((Iterator<ContextResource>)((Object)new ResourcePathCollatingIterator(allResults)));
    }
}

