/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.management.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.ListIteratorWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.management.ConfigurationCollectionData;
import org.apache.sling.caconfig.management.ConfigurationData;
import org.apache.sling.caconfig.management.ConfigurationManagementSettings;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.management.ConfigurationResourceResolverConfig;
import org.apache.sling.caconfig.management.impl.ConfigurationCollectionDataImpl;
import org.apache.sling.caconfig.management.impl.ConfigurationDataImpl;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationInheritanceStrategyMultiplexer;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationMetadataProviderMultiplexer;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationOverrideMultiplexer;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationPersistenceStrategyMultiplexer;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationResourceResolvingStrategyMultiplexer;
import org.apache.sling.caconfig.resource.impl.util.ConfigNameUtil;
import org.apache.sling.caconfig.resource.impl.util.MapUtil;
import org.apache.sling.caconfig.spi.ConfigurationCollectionPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceException;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.apache.sling.caconfig.spi.metadata.PropertyMetadata;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ConfigurationManager.class})
public class ConfigurationManagerImpl
implements ConfigurationManager {
    @Reference
    private ConfigurationResourceResolvingStrategyMultiplexer configurationResourceResolvingStrategy;
    @Reference
    private ConfigurationMetadataProviderMultiplexer configurationMetadataProvider;
    @Reference
    private ConfigurationPersistenceStrategyMultiplexer configurationPersistenceStrategy;
    @Reference
    private ConfigurationInheritanceStrategyMultiplexer configurationInheritanceStrategy;
    @Reference
    private ConfigurationOverrideMultiplexer configurationOverrideMultiplexer;
    @Reference
    private ConfigurationResourceResolverConfig configurationResourceResolverConfig;
    @Reference
    private ConfigurationManagementSettings configurationManagementSettings;
    private static final Logger log = LoggerFactory.getLogger(ConfigurationManagerImpl.class);

    @Override
    public ConfigurationData getConfiguration(Resource resource, String configName) {
        ConfigNameUtil.ensureValidConfigName(configName);
        if (log.isDebugEnabled()) {
            log.debug("Get configuration for context path {}, name '{}'", (Object)resource.getPath(), (Object)configName);
        }
        ConfigurationMetadata configMetadata = this.getConfigurationMetadata(configName);
        Resource configResource = null;
        Iterator configResourceInheritanceChain = this.configurationResourceResolvingStrategy.getResourceInheritanceChain(resource, this.configurationResourceResolverConfig.configBucketNames(), configName);
        if (configResourceInheritanceChain != null) {
            ListIteratorWrapper resettableConfigResourceInheritanceChain = new ListIteratorWrapper(configResourceInheritanceChain);
            configResource = this.applyPersistenceAndInheritance(resource.getPath(), configName, (Iterator<Resource>)resettableConfigResourceInheritanceChain, false, resource.getResourceResolver());
            if (configResource != null) {
                Resource writebackConfigResource = null;
                String writebackConfigResourcePath = null;
                for (String configBucketName : this.configurationResourceResolverConfig.configBucketNames()) {
                    writebackConfigResourcePath = this.configurationResourceResolvingStrategy.getResourcePath(resource, configBucketName, configName);
                    if (writebackConfigResourcePath == null || (writebackConfigResource = resource.getResourceResolver().getResource(writebackConfigResourcePath)) == null) continue;
                    writebackConfigResource = this.configurationPersistenceStrategy.getResource(writebackConfigResource);
                    break;
                }
                if (log.isTraceEnabled() && configResource != null) {
                    log.trace("+ Found config resource for context path " + resource.getPath() + ": " + configResource.getPath() + " " + MapUtil.traceOutput((Map<String, Object>)configResource.getValueMap()) + ", writeback config resource: " + writebackConfigResourcePath);
                }
                resettableConfigResourceInheritanceChain.reset();
                return new ConfigurationDataImpl(configMetadata, configResource, writebackConfigResource, this.applyPersistence((Iterator<Resource>)resettableConfigResourceInheritanceChain, false), resource, configName, this, this.configurationManagementSettings, this.configurationOverrideMultiplexer, this.configurationPersistenceStrategy, false, null);
            }
        }
        if (configMetadata != null) {
            configResource = this.configurationOverrideMultiplexer.overrideProperties(resource.getPath(), configName, null, resource.getResourceResolver());
            if (configResource != null) {
                return new ConfigurationDataImpl(configMetadata, configResource, null, null, resource, configName, this, this.configurationManagementSettings, this.configurationOverrideMultiplexer, this.configurationPersistenceStrategy, false, null);
            }
            return new ConfigurationDataImpl(configMetadata, resource, configName, this, this.configurationManagementSettings, this.configurationOverrideMultiplexer, this.configurationPersistenceStrategy, false);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationCollectionData getConfigurationCollection(Resource resource, String configName) {
        void var8_15;
        Resource writebackConfigResourceCollectionParent;
        ConfigNameUtil.ensureValidConfigName(configName);
        if (log.isDebugEnabled()) {
            log.debug("Get configuration collection for context path {}, name '{}'", (Object)resource.getPath(), (Object)configName);
        }
        ConfigurationMetadata configMetadata = this.getConfigurationMetadata(configName);
        ArrayList<ConfigurationData> configData = new ArrayList<ConfigurationData>();
        Collection<String> collectionParentConfigNames = this.configurationPersistenceStrategy.getAllCollectionParentConfigNames(configName);
        ArrayList configResourceInheritanceChains = new ArrayList();
        for (String string : collectionParentConfigNames) {
            Collection result = this.configurationResourceResolvingStrategy.getResourceCollectionInheritanceChain(resource, this.configurationResourceResolverConfig.configBucketNames(), string);
            if (result == null) continue;
            configResourceInheritanceChains.addAll(result);
        }
        String writebackConfigResourceCollectionParentPath = null;
        if (configResourceInheritanceChains != null) {
            for (Iterator configResourceInheritanceChain : configResourceInheritanceChains) {
                ListIteratorWrapper resettableConfigResourceInheritanceChain = new ListIteratorWrapper(configResourceInheritanceChain);
                Resource configResource = this.applyPersistenceAndInheritance(resource.getPath(), configName, (Iterator<Resource>)resettableConfigResourceInheritanceChain, true, resource.getResourceResolver());
                resettableConfigResourceInheritanceChain.reset();
                Resource untransformedConfigResource = (Resource)resettableConfigResourceInheritanceChain.next();
                if (configResource == null) continue;
                Resource writebackConfigResource = null;
                String writebackConfigResourcePath = null;
                for (String configBucketName : this.configurationResourceResolverConfig.configBucketNames()) {
                    writebackConfigResourceCollectionParentPath = this.configurationResourceResolvingStrategy.getResourceCollectionParentPath(resource, configBucketName, configName);
                    if (writebackConfigResourceCollectionParentPath == null) continue;
                    writebackConfigResourceCollectionParentPath = this.configurationPersistenceStrategy.getCollectionParentResourcePath(writebackConfigResourceCollectionParentPath);
                    writebackConfigResourcePath = writebackConfigResourceCollectionParentPath + "/" + untransformedConfigResource.getName();
                    writebackConfigResource = configResource.getResourceResolver().getResource(writebackConfigResourcePath);
                    if (writebackConfigResource == null) continue;
                    writebackConfigResource = this.configurationPersistenceStrategy.getCollectionItemResource(writebackConfigResource);
                    break;
                }
                if (log.isTraceEnabled() && configResource != null) {
                    log.trace("+ Found config resource for context path " + resource.getPath() + ": " + configResource.getPath() + " " + MapUtil.traceOutput((Map<String, Object>)configResource.getValueMap()) + ", writeback config resource: " + writebackConfigResourcePath);
                }
                resettableConfigResourceInheritanceChain.reset();
                configData.add(new ConfigurationDataImpl(configMetadata, configResource, writebackConfigResource, this.applyPersistence((Iterator<Resource>)resettableConfigResourceInheritanceChain, true), resource, configName, this, this.configurationManagementSettings, this.configurationOverrideMultiplexer, this.configurationPersistenceStrategy, true, untransformedConfigResource.getName()));
            }
        }
        if (writebackConfigResourceCollectionParentPath == null) {
            String configBucketName;
            Iterator<String> iterator = this.configurationResourceResolverConfig.configBucketNames().iterator();
            while (iterator.hasNext() && (writebackConfigResourceCollectionParentPath = this.configurationResourceResolvingStrategy.getResourceCollectionParentPath(resource, configBucketName = iterator.next(), configName)) == null) {
            }
        }
        Object var8_13 = null;
        if (writebackConfigResourceCollectionParentPath != null && (writebackConfigResourceCollectionParent = resource.getResourceResolver().getResource(writebackConfigResourceCollectionParentPath)) != null) {
            for (String resourceName : this.configurationManagementSettings.getConfigCollectionPropertiesResourceNames()) {
                Resource propsResource = writebackConfigResourceCollectionParent.getChild(resourceName);
                if (propsResource == null) continue;
                ValueMap valueMap = propsResource.getValueMap();
                break;
            }
        }
        return new ConfigurationCollectionDataImpl(configName, configData, writebackConfigResourceCollectionParentPath, (Map<String, Object>)var8_15, this.configurationManagementSettings);
    }

    private Iterator<Resource> applyPersistence(Iterator<Resource> configResourceInheritanceChain, final boolean isCollection) {
        if (configResourceInheritanceChain == null) {
            return null;
        }
        return IteratorUtils.transformedIterator(configResourceInheritanceChain, (Transformer)new Transformer(){

            public Object transform(Object input) {
                if (isCollection) {
                    return ConfigurationManagerImpl.this.configurationPersistenceStrategy.getCollectionItemResource((Resource)input);
                }
                return ConfigurationManagerImpl.this.configurationPersistenceStrategy.getResource((Resource)input);
            }
        });
    }

    private Resource applyPersistenceAndInheritance(String contextPath, String configName, Iterator<Resource> configResourceInheritanceChain, boolean isCollection, ResourceResolver resourceResolver) {
        if (configResourceInheritanceChain == null) {
            return null;
        }
        Iterator<Resource> transformedConfigResources = this.applyPersistence(configResourceInheritanceChain, isCollection);
        Resource configResource = this.configurationInheritanceStrategy.getResource(transformedConfigResources);
        return this.configurationOverrideMultiplexer.overrideProperties(contextPath, configName, configResource, resourceResolver);
    }

    @Override
    public void persistConfiguration(Resource resource, String configName, ConfigurationPersistData data) {
        ConfigNameUtil.ensureValidConfigName(configName);
        String configResourcePath = this.configurationResourceResolvingStrategy.getResourcePath(resource, "sling:configs", configName);
        if (configResourcePath == null) {
            throw new ConfigurationPersistenceException("Unable to persist configuration: Configuration resolving strategy returned no path.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Persist configuration for context path {}, name '{}' to {}", new Object[]{resource.getPath(), configName, configResourcePath});
        }
        if (!this.configurationPersistenceStrategy.persistConfiguration(resource.getResourceResolver(), configResourcePath, data)) {
            throw new ConfigurationPersistenceException("Unable to persist configuration: No persistence strategy found.");
        }
    }

    @Override
    public void persistConfigurationCollection(Resource resource, String configName, ConfigurationCollectionPersistData data) {
        ConfigNameUtil.ensureValidConfigName(configName);
        String configResourceParentPath = this.configurationResourceResolvingStrategy.getResourceCollectionParentPath(resource, "sling:configs", configName);
        if (configResourceParentPath == null) {
            throw new ConfigurationPersistenceException("Unable to persist configuration collection: Configuration resolving strategy returned no parent path.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Persist configuration collection for context path {}, name '{}' to {}", new Object[]{resource.getPath(), configName, configResourceParentPath});
        }
        if (!this.configurationPersistenceStrategy.persistConfigurationCollection(resource.getResourceResolver(), configResourceParentPath, data)) {
            throw new ConfigurationPersistenceException("Unable to persist configuration: No persistence strategy found.");
        }
    }

    @Override
    public ConfigurationData newCollectionItem(Resource resource, String configName) {
        ConfigNameUtil.ensureValidConfigName(configName);
        ConfigurationMetadata configMetadata = this.getConfigurationMetadata(configName);
        if (configMetadata != null) {
            return new ConfigurationDataImpl(configMetadata, resource, configName, this, this.configurationManagementSettings, this.configurationOverrideMultiplexer, this.configurationPersistenceStrategy, true);
        }
        return null;
    }

    @Override
    public void deleteConfiguration(Resource resource, String configName) {
        ConfigNameUtil.ensureValidConfigName(configName);
        boolean foundAnyPath = false;
        for (String configBucketName : this.configurationResourceResolverConfig.configBucketNames()) {
            String configResourcePath = this.configurationResourceResolvingStrategy.getResourcePath(resource, configBucketName, configName);
            if (configResourcePath == null) continue;
            foundAnyPath = true;
            if (log.isDebugEnabled()) {
                log.debug("Delete configuration for context path {}, name '{}' from {}", new Object[]{resource.getPath(), configName, configResourcePath});
            }
            if (this.configurationPersistenceStrategy.deleteConfiguration(resource.getResourceResolver(), configResourcePath)) continue;
            throw new ConfigurationPersistenceException("Unable to delete configuration: No persistence strategy found.");
        }
        if (!foundAnyPath) {
            throw new ConfigurationPersistenceException("Unable to delete configuration: Configuration resolving strategy returned no path.");
        }
    }

    @Override
    public SortedSet<String> getConfigurationNames() {
        return this.configurationMetadataProvider.getConfigurationNames();
    }

    @Override
    public ConfigurationMetadata getConfigurationMetadata(String configName) {
        ConfigNameUtil.ensureValidConfigName(configName);
        ConfigurationMetadata metadata = this.configurationMetadataProvider.getConfigurationMetadata(configName);
        if (metadata != null) {
            log.trace("+ Configuration metadata found for: {}", (Object)configName);
            return metadata;
        }
        for (String partialConfigName : ConfigNameUtil.getAllPartialConfigNameVariations(configName)) {
            ConfigurationMetadata nestedConfigMetadata;
            ConfigurationMetadata partialConfigMetadata = this.getConfigurationMetadata(partialConfigName);
            if (partialConfigMetadata == null || (nestedConfigMetadata = this.getNestedConfigurationMetadata(partialConfigMetadata, configName, partialConfigName)) == null) continue;
            log.trace("+ Nested configuration metadata found for: {}", (Object)configName);
            return nestedConfigMetadata;
        }
        log.trace("- No configuration metadata found for: {}", (Object)configName);
        return null;
    }

    private ConfigurationMetadata getNestedConfigurationMetadata(ConfigurationMetadata configMetadata, String configName, String partialConfigName) {
        if (StringUtils.startsWith((CharSequence)configName, (CharSequence)(partialConfigName + "/"))) {
            LinkedHashSet<String> prefixesToRemove = new LinkedHashSet<String>();
            if (configMetadata.isCollection()) {
                String collectionItemName = StringUtils.substringBefore((String)StringUtils.substringAfter((String)configName, (String)(partialConfigName + "/")), (String)"/");
                for (String collectionParentConfigName : this.configurationPersistenceStrategy.getAllCollectionParentConfigNames(partialConfigName)) {
                    for (String collectionItemConfigName : this.configurationPersistenceStrategy.getAllCollectionItemConfigNames(collectionItemName)) {
                        prefixesToRemove.add(collectionParentConfigName + "/" + collectionItemConfigName + "/");
                    }
                }
            } else {
                for (String configNameItem : this.configurationPersistenceStrategy.getAllConfigNames(partialConfigName)) {
                    prefixesToRemove.add(configNameItem + "/");
                }
            }
            for (String prefixToRemove : prefixesToRemove) {
                String remainingConfigName = StringUtils.substringAfter((String)configName, (String)prefixToRemove);
                ConfigurationMetadata nestedConfigMetadata = this.getNestedConfigurationMetadataFromProperty(configMetadata, remainingConfigName);
                if (nestedConfigMetadata != null) {
                    return nestedConfigMetadata;
                }
                for (String partialRemainingConfigName : ConfigNameUtil.getAllPartialConfigNameVariations(remainingConfigName)) {
                    ConfigurationMetadata partialConfigMetadata = this.getNestedConfigurationMetadataFromProperty(configMetadata, partialRemainingConfigName);
                    if (partialConfigMetadata == null || (nestedConfigMetadata = this.getNestedConfigurationMetadata(partialConfigMetadata, remainingConfigName, partialRemainingConfigName)) == null) continue;
                    return nestedConfigMetadata;
                }
            }
        }
        return null;
    }

    private ConfigurationMetadata getNestedConfigurationMetadataFromProperty(ConfigurationMetadata partialConfigMetadata, String configName) {
        for (PropertyMetadata propertyMetadata : partialConfigMetadata.getPropertyMetadata().values()) {
            ConfigurationMetadata nestedConfigMetadata;
            if (!propertyMetadata.isNestedConfiguration() || !StringUtils.equals((CharSequence)configName, (CharSequence)(nestedConfigMetadata = propertyMetadata.getConfigurationMetadata()).getName())) continue;
            return nestedConfigMetadata;
        }
        return null;
    }

    @Override
    public String getPersistenceResourcePath(String configResourcePath) {
        return this.configurationPersistenceStrategy.getResourcePath(configResourcePath);
    }
}

