/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.tidb;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilderFactory;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.StorageModule;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.core.storage.management.UITemplateManagementDAO;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2BatchDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2EventQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2HistoryDeleteDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2MetadataQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2MetricsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2NetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2StorageDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2TopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2TopologyQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2UITemplateManagementDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql.MySQLAggregationQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql.MySQLAlarmQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql.MySQLLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql.MySQLTableInstaller;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql.MySQLTraceQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql.MysqlBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.tidb.TiDBHistoryDeleteDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.tidb.TiDBStorageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiDBStorageProvider
extends ModuleProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TiDBStorageProvider.class);
    private TiDBStorageConfig config = new TiDBStorageConfig();
    private JDBCHikariCPClient mysqlClient;

    public String name() {
        return "tidb";
    }

    public Class<? extends ModuleDefine> module() {
        return StorageModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException {
        this.registerServiceImplementation(StorageBuilderFactory.class, (Service)new StorageBuilderFactory.Default());
        this.mysqlClient = new JDBCHikariCPClient(this.config.getProperties());
        this.registerServiceImplementation(IBatchDAO.class, (Service)new H2BatchDAO(this.mysqlClient));
        this.registerServiceImplementation(StorageDAO.class, (Service)new H2StorageDAO(this.getManager(), this.mysqlClient, this.config.getMaxSizeOfArrayColumn(), this.config.getNumOfSearchableValuesPerTag()));
        this.registerServiceImplementation(INetworkAddressAliasDAO.class, (Service)new H2NetworkAddressAliasDAO(this.mysqlClient));
        this.registerServiceImplementation(ITopologyQueryDAO.class, (Service)new H2TopologyQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(IMetricsQueryDAO.class, (Service)new H2MetricsQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(ITraceQueryDAO.class, (Service)new MySQLTraceQueryDAO(this.getManager(), this.mysqlClient, this.config.getMaxSizeOfArrayColumn(), this.config.getNumOfSearchableValuesPerTag()));
        this.registerServiceImplementation(IBrowserLogQueryDAO.class, (Service)new MysqlBrowserLogQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(IMetadataQueryDAO.class, (Service)new H2MetadataQueryDAO(this.mysqlClient, this.config.getMetadataQueryMaxSize()));
        this.registerServiceImplementation(IAggregationQueryDAO.class, (Service)new MySQLAggregationQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(IAlarmQueryDAO.class, (Service)new MySQLAlarmQueryDAO(this.mysqlClient, this.getManager(), this.config.getMaxSizeOfArrayColumn(), this.config.getNumOfSearchableValuesPerTag()));
        this.registerServiceImplementation(IHistoryDeleteDAO.class, (Service)new H2HistoryDeleteDAO(this.mysqlClient));
        this.registerServiceImplementation(ITopNRecordsQueryDAO.class, (Service)new H2TopNRecordsQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(ILogQueryDAO.class, (Service)new MySQLLogQueryDAO(this.mysqlClient, this.getManager(), this.config.getMaxSizeOfArrayColumn(), this.config.getNumOfSearchableValuesPerTag()));
        this.registerServiceImplementation(IProfileTaskQueryDAO.class, (Service)new H2ProfileTaskQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(IProfileTaskLogQueryDAO.class, (Service)new H2ProfileTaskLogQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(IProfileThreadSnapshotQueryDAO.class, (Service)new H2ProfileThreadSnapshotQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(UITemplateManagementDAO.class, (Service)new H2UITemplateManagementDAO(this.mysqlClient));
        this.registerServiceImplementation(IHistoryDeleteDAO.class, (Service)new TiDBHistoryDeleteDAO(this.mysqlClient));
        this.registerServiceImplementation(IEventQueryDAO.class, (Service)new H2EventQueryDAO(this.mysqlClient));
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        ConfigService configService = (ConfigService)this.getManager().find("core").provider().getService(ConfigService.class);
        int numOfSearchableTags = configService.getSearchableTracesTags().split(",").length;
        if (numOfSearchableTags * this.config.getNumOfSearchableValuesPerTag() > this.config.getMaxSizeOfArrayColumn()) {
            throw new ModuleStartException("Size of searchableTracesTags[" + numOfSearchableTags + "] * numOfSearchableValuesPerTag[" + this.config.getNumOfSearchableValuesPerTag() + "] > maxSizeOfArrayColumn[" + this.config.getMaxSizeOfArrayColumn() + "]. Potential out of bound in the runtime.");
        }
        int numOfSearchableLogsTags = configService.getSearchableLogsTags().split(",").length;
        if (numOfSearchableLogsTags * this.config.getNumOfSearchableValuesPerTag() > this.config.getMaxSizeOfArrayColumn()) {
            throw new ModuleStartException("Size of searchableLogsTags[" + numOfSearchableLogsTags + "] * numOfSearchableValuesPerTag[" + this.config.getNumOfSearchableValuesPerTag() + "] > maxSizeOfArrayColumn[" + this.config.getMaxSizeOfArrayColumn() + "]. Potential out of bound in the runtime.");
        }
        int numOfSearchableAlarmTags = configService.getSearchableAlarmTags().split(",").length;
        if (numOfSearchableAlarmTags * this.config.getNumOfSearchableValuesPerTag() > this.config.getMaxSizeOfArrayColumn()) {
            throw new ModuleStartException("Size of searchableAlarmTags[" + numOfSearchableAlarmTags + "] * numOfSearchableValuesPerTag[" + this.config.getNumOfSearchableValuesPerTag() + "] > maxSizeOfArrayColumn[" + this.config.getMaxSizeOfArrayColumn() + "]. Potential out of bound in the runtime.");
        }
        try {
            this.mysqlClient.connect();
            MySQLTableInstaller installer = new MySQLTableInstaller((Client)this.mysqlClient, this.getManager(), this.config.getMaxSizeOfArrayColumn(), this.config.getNumOfSearchableValuesPerTag());
            ((ModelCreator)this.getManager().find("core").provider().getService(ModelCreator.class)).addModelListener((ModelCreator.CreatingListener)installer);
        }
        catch (StorageException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

